

Manuel de l'utilisateur d'aptitude


Version 0.4.11.8


Daniel Burrows

<dburrows@debian.org>

Copyright  2004-2006 Daniel Burrows

This manual is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This manual is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this manual; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA

--------------------------------------------------------------------------------
Table des matires



  Introduction


        Qu'est-ce qu'aptitude, au fait ?

        Qu'est-ce qu'un gestionnaire de paquets ?

        Qu'est-ce que le systme apt ?

        Comment se procure-t-on aptitude ?


              Paquets prcompils d'aptitude,  ce que 99% des utilisateurs
              devraient utiliser 

              Construire aptitude depuis les sources

              Assurer le suivi, et participer au developpement d'aptitude



  1. Notions pour commencer


        Utiliser aptitude


              Les bases d'aptitude

              Naviguer dans la liste des paquets d'aptitude

              Rechercher des paquets par leur nom

              Grer les paquets

              Mettre  jour la liste des paquets et installer des paquets


        Utiliser aptitude depuis la ligne de commande


  2. Guide de rfrence d'aptitude


        L'interface utilisateur d'aptitude


              Utiliser les menus

              Commandes du menu

              Travailler avec plusieurs vues

              Devenir administrateur ( root )


        Grer les paquets


              Grer la liste des paquets

              Accder aux informations des paquets

              Modifier l'tat d'un paquet

              Rsoudre les problmes de dpendance

              Tlcharger, installer et supprimer des paquets

              Qu'est-ce que la confiance en matire de gestion des paquets ?

              Grer les paquets automatiquement installs


        Motifs de recherche


              Searching for strings

              Shorthand for search terms

              Searches and Versions

              Explicit search targets

              Search Term Reference


        Personnalisation d'aptitude


              Personnaliser la liste des paquets

              Personnaliser les raccourcis clavier

              Personnaliser la couleur du texte et les styles

              Personnaliser la disposition de l'affichage

              Rfrence du fichier de configuration

              Thmes


        Jouer au dmineur


  3. FAQ d'aptitude

  4. Crdits

  I. Rfrence de la ligne de commande


        aptitude --; interface volue pour le gestionnaire de paquets

        aptitude-create-state-bundle --; bundle the current aptitude state

        aptitude-run-state-bundle --; unpack an aptitude state bundle and
        invoke aptitude on it


Liste des illustrations



  2.1. Commandes disponibles dans le menu Actions

  2.2. Commandes disponibles dans le menu Annuler

  2.3. Commandes disponibles dans le menu Paquet

  2.4. Commandes disponibles dans le menu Solveur

  2.5. Commandes disponibles dans le menu Rechercher

  2.6. Commandes disponibles dans le menu Options

  2.7. Commandes disponibles dans le menu Vues

  2.8. Commandes disponibles dans le menu Aide

  2.9. Valeurs de l'indicateur de  l'tat courant 

  2.10. Valeurs de l'indicateur  d'action 

  2.11. Syntax of the ?for term

  2.12. Styles personnalisables dans aptitude

Liste des tableaux



  2.1. Quick guide to search terms

Liste des exemples



  2.1. Use of the ?= term.

  2.2. Use of the ?bind term

  2.3. Use of the ?for term


Introduction

Table des matires



  Qu'est-ce qu'aptitude, au fait ?

  Qu'est-ce qu'un gestionnaire de paquets ?

  Qu'est-ce que le systme apt ?

  Comment se procure-t-on aptitude ?


        Paquets prcompils d'aptitude,  ce que 99% des utilisateurs devraient
        utiliser 

        Construire aptitude depuis les sources

        Assurer le suivi, et participer au developpement d'aptitude



   Matre, Emacs connat-il la nature du Bouddha ?  demanda le novice.      

   Pourquoi en serait-il autrement ? , rpondit le matre.  Il fait
  sacrment bien tout le reste . Quelques annes plus tard, le novice reut
  l'illumination.

                                                                 -- John Fouhy


Voici le manuel de l'utilisateur d'aptitude ! Cette introduction explique ce
qu'est aptitude et  quoi il sert. Pour accder aux informations sur la manire
de l'utiliser, allez directement au Chapitre 1, Notions_pour_commencer.


Qu'est-ce qu'aptitude, au fait ?

aptitude est un gestionnaire de paquets trs complet pour les systmes Debian
GNU/Linux ; il est bas sur la fameuse infrastructure de gestion de paquets apt.
aptitude fournit les fonctionnalits de dselect et d'apt-get, ainsi que beaucoup
d'autres, introuvables dans ces programmes.


Qu'est-ce qu'un gestionnaire de paquets ?

Un gestionnaire de paquets garde la trace des programmes installs sur votre
ordinateur. Il facilite l'installation de nouveaux programmes, la mise  jour ou
la suppression de ceux que vous aviez prcdemment installs. Comme le nom le
suggre, un gestionnaire de paquets traite des paquets : un paquet est un
ensemble de fichiers lis et qui peuvent tre installs ou supprims en bloc.

Gnralement, un paquet fournit un programme particulier. Par exemple, le client
de messagerie instantane gaim est contenu dans le paquet Debian du mme nom.
D'un autre ct, il est frquent qu'un programme se compose de plusieurs paquets
apparents. Par exemple, l'diteur d'image gimp n'est pas constitu que du
paquet gimp, mais aussi du paquet gimp-data ; de plus plusieurs paquets
optionnels supplmentaires (contenant des donnes diverses, de la documentation,
etc.) sont aussi disponibles. Il arrive aussi que plusieurs petits programmes
apparents soient fournis dans un unique paquet. Par exemple, le paquet
fileutils contient plusieurs commandes Unix usuelles telles que ls, cp, etc.

Certains paquets requirent d'autres paquets pour fonctionner.  l'intrieur de
Debian, les paquets peuvent dpendre, recommander, suggrer, casser,ou tre en
conflit ( conflict ) avec d'autres paquets.


* Si un paquet A dpend d'un paquet B, alors B est ncessaire au bon
  fonctionnement de A. Par exemple, le paquet gimp dpend du paquet gimp-data
  pour s'assurer que l'diteur de graphismes GIMP aura accs  ses fichiers de
  donnes.

* Si un paquet A recommande un autre paquet B, alors B ajoute au paquet A une
  fonctionnalit importante qui sera apprcie dans la plupart des cas. Par
  exemple, le paquet mozilla-browser recommande le paquet mozilla-psm qui ajoute
  la gestion des transferts de donnes scuriss au navigateur web Mozilla. Bien
  que mozilla-psm ne soit pas absolument ncessaire pour que Mozilla fonctionne,
  la plupart des utilisateurs veulent que Mozilla gre la transmission scurise
  de donnes confidentielles (tel que leur numro de carte bancaire).

* Si un paquet A suggre un autre paquet B, alors le paquet B fournit une
  fonctionnalit qui peut amliorer A sans qu'elle ne soit gnralement
  ncessaire. Par exemple, le paquet kmail suggre le paquet gnupg qui contient
  un logiciel de chiffrement que KMail peut utiliser.

* Si un paquet A est en conflit avec un autre paquet B, alors les deux paquets
  ne peuvent pas tre installs au mme moment. Par exemple, fb-music-hi est en
  conflit avec fb-music-low car ils fournissent tous deux des jeux de musiques
  de remplacement pour le jeu Frozen Bubble.


Le travail du gestionnaire de paquets est de prsenter une interface qui aide
l'utilisateur  grer l'ensemble des paquets installs sur son systme. aptitude
fournit une telle interface en tirant parti du systme de gestion de paquets
apt.


Qu'est-ce que le systme apt ?

Pouvoir capable d'installer et de supprimer des paquets, c'est formidable, mais
le programme basique charg de faire cela (connu sous le nom de dpkg) ne fait
que cela et rien de plus. C'est trs bien si vous tlchargez un ou deux paquets
  la main , mais cela devient vite fatiguant quand vous essayez de grer un
grand nombre de paquets. De plus, si un nouveau paquet intressant ncessite des
programmes que vous n'avez pas encore installs, vous devez tlcharger vous-
mmes les nouveaux paquets requis. Enfin, si vous dcidez par la suite de
supprimer ce paquet, les paquets additionnels vont rester sur votre systme et
occuper de la place sur vos disques  moins que vous ne les supprimiez vous-
mme.

Toutes ces oprations sont fastidieuses et la plupart des systmes de gestion de
paquets sont accompagns de programmes qui se chargent de tout cela  votre
place. apt est la base commune sur laquelle sont construits ces programmes : en
plus d'aptitude, des programmes comme synaptic et apt-watch utilisent apt.

apt fonctionne grce  une liste des paquets qui peuvent tre tlchargs depuis
Debian sur votre ordinateur. Cette liste est utilise pour trouver les paquets
qui ont besoin d'tre mis  jour et pour installer de nouveaux paquets. apt peut
aussi rsoudre automatiquement de nombreux problmes de dpendances : par
exemple, quand vous choisissez d'installer un paquet, il recherche tous les
paquets supplmentaires requis et les installe en mme temps.

Avec un gestionnaire de paquet bas sur apt, tel qu'aptitude, vous avez trois
oprations fondamentales : mettre  jour la liste des paquets disponibles en
tlchargeant de nouvelles listes depuis les serveurs Debian, slectionner quels
paquets doivent tre installs, mis  jour ou supprims, et enfin mettre 
excution votre slection en procdant rellement aux installations,
suppressions, etc.

Les gestionnaires de paquets bass sur apt lisent la liste des  sources 
(dpt de paquets Debian) dans le fichier /etc/apt/sources.list. La prsentation
du format et du contenu de ce fichier n'entre pas dans le cadre de ce document,
mais ils sont dcrits dans la page de manuel sources.list(5).


 Comment se procure-t-on aptitude ?

Si vous lisez ce document sans avoir install aptitude sur votre systme, cette
section explique comment vous sortir de cette mauvaise passe. Vous devriez aller
directement  la partie sur les paquets binaires.


Paquets prcompils d'aptitude,  ce que 99% des utilisateurs devraient
utiliser 

Un paquet prcompil, ou  binaire , est le moyen le plus courant et le plus
facile d'installer aptitude. Vous devriez uniquement tenter d'installer depuis
les sources si aucun paquet binaire n'est disponible pour une raison ou une
autre, ou si vous avez des besoins particuliers qui ne sont pas satisfaits par
les paquets binaires.

Si vous tes en train d'utiliser un systme Debian, excutez la commande
suivante en tant que root : apt-get install aptitude. Sinon, le fournisseur de
votre systme a d crer un paquet pour aptitude. Dans le doute, vous pouvez le
contacter pour d'avantage de conseils.


Construire aptitude depuis les sources

Vous pouvez aussi construire aptitude depuis les sources. Nanmoins, il est
probable que ce ne soit pas utile si apt est dj install sur votre systme. Si
ce n'est pas le cas vous pouvez installer aptitude depuis les sources en suivant
les tapes :


  1. Installer les programmes suivants :


     * Un compilateur C++, comme g++.

     * Les fichiers de dveloppement d'apt, habituellement disponibles dans le
       paquet nomm libapt-pkg-dev.

     * The libsigc++-2.0 library, available in the package libsigc++-2.0-dev or
       from http://libsigc.sourceforge.net.

     * The cwidget library, available in the package libcwidget-dev or from
       http://cwidget.alioth.debian.org.

     * The gettext program, which should be included with your Linux
       distribution.

     * A make tool, such as GNU make.

     * Enfin, tlcharger le code source le plus rcent d'aptitude, disponible
       sur http://packages.debian.org/unstable/admin/aptitude (faites dfiler
       l'cran jusqu'en bas et tlcharger le fichier  .orig.tar.gz ).



Une fois tous ces composants runis, ouvrez un terminal et excutez la
commande : tar zxf aptitude-0.4.11.8.tar.gz pour dsarchiver le code source. Une
fois les sources dsarchives, tapez cd aptitude-0.4.11.8 && ./configure && make
pour compiler aptitude. Si cela russit, assurez-vous que vous tes sous
l'utilisateur root (en utilisant, par exemple, su), tapez alors make install
pour installer aptitude sur votre ordinateur. Une fois aptitude correctement
install, taper aptitude  l'invite de la ligne de commande devrait lancer le
programme.


Assurer le suivi, et participer au developpement d'aptitude


Rcuprer l'arborescence des sources d'aptitude

Si vous souhaitez tester le tout dernier code source en date d'aptitude, vous
pouvez tlcharger le code source non encore publi d'aptitude en utilisant
Mercurial. Installez Mercurial (disponible  http://www.selenic.com/mercurial/
) et excutez la commande hg clone http://hg.debian.org/hg/aptitude/head
aptitude afin de rcuprer le code source le plus rcent.


 [Avertissement]  Avertissement

                  Le dptMercurial d'aptitude est un arbre de dveloppement
                  actif ; il est modifi au fur et  mesure des corrections de
                  bogues et des ajouts de fonctionnalits, sans qu'il ne soit
                  absolument garanti qu'il se compile ! Les rapports de bogues
                  sont les bienvenus, mais soyez conscient que vous utilisez du
                  code de dveloppement  vos risques et prils ![1]



Liste de diffusion

<aptitude-devel@lists.alioth.debian.org> est la principale liste de diffusion
concernant le developpement d'aptitude. Les archives de cette liste sont
accessibles ici http://lists.alioth.debian.org/pipermail/aptitude-devel/. Pour
s'y abonner, consultez la page Web http://lists.alioth.debian.org/mailman/
listinfo/aptitude-devel.


Proposer des correctifs (patches).

Dans l'absolu, les correctifs devraient tre soumis  la liste de diffusion
d'aptitude <aptitude-devel@lists.alioth.debian.org>. Mais si vous prfrez les
envoyer en priv, vous pouvez utiliser l'adresse de courriel
<aptitude@packages.debian.org> ou <dburrows@debian.org>. Une rapide description
des raisons qui ont motives ce correctif ainsi qu'une explication de son mode
de fonctionnement sont grandement apprcis.


Suivre les modifications dans l'arborescence de sources d'aptitude

L'arborescence des sources d'aptitude est rgulirement mis  jour avec de
nouvelles fonctionnalits, des corrections de bogues, et de nouveaux bogues. Ds
qu'un code source est disponible sur votre machine (voir la section prcdente),
vous pouvez vous dplacer dans le rpertoire (cd) et taper hg pull && hg update
afin de le mettre  jour avec les changements apparus sur le dpot principal.

Pour tre averti automatiquement lorsque des modifications ont t faites sur le
code de base d'aptitude inscrivez-vous au fil RSS disponible  http://
hg.debian.org/hg/aptitude/head?cl=tip;style=rss.


Construire aptitude  partir de l'arborescence de dveloppement.

To build aptitude from the Mercurial repository, you must have the programs
autoconf and automake installed. Type sh ./autogen.sh && ./configure to generate
the files needed to compile aptitude, then execute make and make install.



--------------------------------------------------------------------------------
[1]Bien sr, vous utilisez tous les logiciels libres  vos propres risques, mais
le risque induit par l'utilisation d'un arbre de dveloppement actif est encore
plus grand.


Chapitre 1. Notions pour commencer

Table des matires



  Utiliser aptitude


        Les bases d'aptitude

        Naviguer dans la liste des paquets d'aptitude

        Rechercher des paquets par leur nom

        Grer les paquets

        Mettre  jour la liste des paquets et installer des paquets


  Utiliser aptitude depuis la ligne de commande


  Un voyage de mille lieues commence toujours par un premier pas.  

                                                         -- Lao Tsu


aptitude est un programme assez gros avec de nombreuses fonctionnalits et il
peut tre un peu lourd pour les nouveaux utilisateurs qui veulent l'aborder. Ce
chapitre ne dcrit pas de faon exhaustive les fonctionnalits d'aptitude
(consultez Chapitre 2, Guide_de_rfrence_d'aptitude pour cela), mais il fournit
un aperu des fonctionnalits de base les plus utilises de ce programme.


Utiliser aptitude

Cette section dcrit comment utiliser l'interface graphique d'aptitude. Pour des
informations sur l'utilisation de l'interface d'aptitude en ligne de commande,
consultez la section intitule  Utiliser aptitude depuis la ligne de
commande .


Les bases d'aptitude

Pour lancer aptitude, ouvrez votre terminal prfr et tapez sur la ligne de
commande :

toto$ aptitude

Une fois que le cache est charg (ce qui peut prendre un peu de temps sur les
machines les plus lentes), l'cran principal d'aptitude apparat :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--- Installed Packages
--- Not Installed Packages
--- Obsolete and Locally Created Packages
--- Virtual Packages
--- Tasks






These packages are currently installed on your computer.








Comme vous pouvez le voir, l'cran principal d'aptitude est divis en plusieurs
parties. La ligne bleue en haut du terminal est la barre de menu, et les lignes
bleues juste au dessous contient des informations sur quelques commandes
importantes. La zone noire qui les suit contient la liste de tous les paquets
disponibles, classs par groupes de paquets. Le groupe actuellement slectionn
( Paquets installs ) est mis en vidence et sa description est indique dans
l'espace noir du bas.

Comme le suggrent les lignes en haut de l'cran, vous pouvez accder au menu
d'aptitude avec le raccourci clavier Contrle+t ; vous pouvez aussi cliquer avec
la souris sur un onglet du menu si votre systme gre ce mcanisme. Utilisez le
raccourci Contrle+t va ouvrir le menu Actions :

 Actions  Undo  Package  Search  Options  Views  Help
+-------------------------+  u: Update  g: Download/Install/Remove Pkgs
|Install/remove packages g|
|Update package list     u|
|Forget new packages     f|
|Clean package cache      |eated Packages
|Clean obsolete files     |
|Mark Upgradable         U|
|Play Minesweeper         |
|Become root              |
+-------------------------+
|Quit                    Q|
+-------------------------+
These packages are currently installed on your computer.









Perform all pending installs and removals

Utilisez les flches et Entre pour slectionner un onglet du menu (ou, si votre
systme le permet, cliquez sur celui-ci avec la souris) ; pour fermer le menu
sans rien slectionner, utilisez  nouveau le raccourci clavier Contrle+t. Le
menu actuellement surlign est expliqu en bas de l'cran. Si une option du menu
peut tre utilise via un raccourci clavier, celui-ci est affich dans le menu :
par exemple, la commande  Mettre  jour les listes de paquets  peut tre
lance en appuyant sur u.

 tout moment, appuyer sur ? vous permet d'afficher une liste des principaux
raccourcis clavier disponibles.


Naviguer dans la liste des paquets d'aptitude

La liste des paquets est l'interface principale d'aptitude. Quand aptitude
dmarre, la liste est organise suivant un certain nombre de groupes comme on
peut le voir sur la capture suivante :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--- Installed Packages
--- Not Installed Packages
--- Obsolete and Locally Created Packages
--- Virtual Packages
--- Tasks






These packages are currently installed on your computer.









 [Note]  Note

         Les groupes de paquets vides sont automatiquement cachs par aptitude,
         donc vous pourriez voir plus ou moins de groupes que ceux prsents sur
         cette capture.


Sur la capture prcdente, le premier groupe ( Paquets installs ) est
surlign pour indiquer qu'il est actuellement slectionn. Vous pouvez modifier
la slection avec les flches haut et bas. Notez que la description affiche en
bas change en consquence. Pour  dployer  un groupe, appuyez sur Entre quand
le groupe est slectionn :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--\ Installed Packages
  --- admin - Administrative utilities (install software, manage users, etc)
  --- base - The Debian base system
  --- devel - Utilities and programs for software development
  --- doc - Documentation and specialized programs for viewing documentation
  --- editors - Text editors and word processors
  --- electronics - Programs for working with circuits and electronics
  --- games - Games, toys, and fun programs
  --- gnome - The GNOME Desktop System
  --- graphics - Utilities to create, view, and edit graphics files

These packages are currently installed on your computer.








Comme vous pouvez le voir, le groupe  Paquets installs  a t dploy pour
faire apparatre son contenu : il contient un certain nombre de sous-groupes
sommairement dfinis par le type de programmes qu'ils contiennent. Dployer la
section  admin  en la slectionnant et en appuyant sur Entre affiche :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--\ Installed Packages
  --\ admin - Administrative utilities (install software, manage users, etc)
    --- main - The main Debian archive
  --- base - The Debian base system
  --- devel - Utilities and programs for software development
  --- doc - Documentation and specialized programs for viewing documentation
  --- editors - Text editors and word processors
  --- electronics - Programs for working with circuits and electronics
  --- games - Games, toys, and fun programs
  --- gnome - The GNOME Desktop System

Packages in the 'admin' section allow you to perform administrative tasks such
as installing software, managing users, configuring and monitoring your system,
examining network traffic, and so on.






Le groupe  admin  contient un unique sous-groupe, l'archive Debian  main .
Dployer ce groupe rvle quelques paquets !


 [Astuce]  Astuce

           Pour aller plus vite, vous pouvez utiliser la touche [ pour dployer
           d'un seul coup tous les sous-groupes d'un groupe donn. Slectionner
            Paquets installs  et appuyer sur [ fait immdiatement apparatre
           les paquets sur la capture suivante.


 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--\ Installed Packages
  --\ admin - Administrative utilities (install software, manage users, etc)
    --\ main - The main Debian archive
i     acpid                                                1.0.3-19   1.0.3-19
i     alien                                                8.44       8.44
i     anacron                                              2.3-9      2.3-9
i     apt-show-versions                                    0.07       0.07
i A   apt-utils                                            0.5.25     0.5.25
i     apt-watch                                            0.3.2-2    0.3.2-2
i     aptitude                                             0.2.14.1-2 0.2.14.1-2

The Debian distribution consists of packages from the 'main' section. Every
package in 'main' is Free Software.

For more information about what Debian considers to be Free Software, see
http://www.debian.org/social_contract#guidelines




En plus des touches de flches, vous pouvez naviguer  travers la liste de
paquets, page  page, en utilisant les touches Page prcdente et Page suivante.


 [Astuce]  Astuce

           Quand toutes les informations ne peuvent tre affiches dans la
           moiti basse de l'cran, les touches a et z peuvent tre utilises
           pour faire dfiler cette zone.



Rechercher des paquets par leur nom

Pour trouver rapidement un paquet dont vous connaissez le nom, appuyez sur /
pour ouvrir une bote de recherche :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
i     frozen-bubble                                        1.0.0-5    1.0.0-5
i A   frozen-bubble-data                                   1.0.0-5    1.0.0-5
i     geekcode                                             1.7.3-1    1.7.3-1
i     gfpoken                                              0.25-3     0.25-3
i     ggz-gnome-client                                     0.0.7-2    0.0.7-2
i     ggz-gtk-client                                       0.0.7-1    0.0.7-1
i     ggz-gtk-game-data                                    0.0.7-2    0.0.7-2
i +--------------------------------------------------------------------------+
i |Search for:                                                               |
i |froz                                                                      |
Po|                             [ Ok ]                             [ Cancel ]|
Fr+--------------------------------------------------------------------------+
attempt to shoot bubbles into groups of the same color to cause them to pop. It
features 100 single-player levels, a two-player mode, music and striking
graphics.

This game is widely rumored to be responsible for delaying the Woody release.

URL: http://www.frozen-bubble.org/

Comme vous pouvez le voir sur la capture prcdente, une recherche de froz
trouve le paquet frozen-bubble. Avec le langage de recherche volu d'aptitude,
dcrit dans la section intitule  Motifs de recherche , il est possible de
trouver des paquets en utilisant des critres plus ou moins complexes.


 [Astuce]  Astuce

           Vous pouvez rechercher en arrire dans la liste des paquets en
           appuyant sur \ et vous pouvez rpter la dernire recherche en
           appuyant sur n aprs avoir ferm la bote de recherche.


Parfois il est plus pratique de cacher tous les paquets  l'exception de ceux
qui correspondent  quelques critres particuliers. Pour ce faire, appuyez sur
l :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--- Installed Packages
--- Not Installed Packages
--- Obsolete and Locally Created Packages
--- Virtual Packages
--- Tasks


  +--------------------------------------------------------------------------+
  |Enter the new package tree limit:                                         |
  |apti                                                                      |
  |                             [ Ok ]                             [ Cancel ]|
Th+--------------------------------------------------------------------------+ a








Cette bote de dialogue fonctionne exactement comme la bote de recherche, sauf
qu'au lieu de mettre en vidence le paquet suivant qui correspond  ce que vous
tapez dans la bote de dialogue, il cache tous les paquets qui ne correspondent
pas. Par exemple, taper apti dans cette bote de dialogue et appuyer sur Entre
va cacher tous les paquets sauf ceux dont le nom contient  apti  :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--\ Installed Packages
  --\ admin - Administrative utilities (install software, manage users, etc)
    --\ main - The main Debian archive
i     aptitude                                             0.2.14.1-2 0.2.14.1-2
i A   synaptic                                             0.51-1     0.51-1
  --\ x11 - The X window system and related software
    --\ main - The main Debian archive
i     xfree86-driver-synaptics                             0.13.3-1   0.13.3-1
--- Not Installed Packages
--- Virtual Packages

These packages are currently installed on your computer.









Grer les paquets

Maintenant que vous savez vous dplacer dans la liste des paquets, il est temps
de commencer  utiliser aptitude pour installer ou supprimer des paquets. Dans
cette section, vous allez apprendre  slectionner les paquets  installer, 
supprimer ou  mettre  jour.


 [Astuce]  Astuce

           Vous ne pouvez changer la configuration globale de votre systme que
           sous l'utilisateur root. Si vous voulez vous familiariser avec
           aptitude, vous pouvez, sans danger, le lancer en tant qu'utilisateur
           normal avec l'assurance de ne pas pouvoir endommager votre systme.
           aptitude vous informera quand vous essaierez de faire quelque chose
           que seul l'utilisateur root peut faire ; si vous souhaitez continuer,
           il vous faudra donner le mot de passe de root.


Tous les changements sur un paquet se font en le mettant d'abord en surbrillance
dans la liste des paquets, puis en pressant la touche correspondant  l'action 
effectuer. Les touches d'actions de base[2] sont + pour installer ou mettre 
jour un paquet, - pour supprimer un paquet et = pour empcher un paquet d'tre
automatiquement mis  jour (on appelle cela geler un paquet). Ces actions ne
sont pas excutes immdiatement. aptitude va uniquement mettre  jour la liste
des paquets pour montrer les changements qui ont t demands.

Par exemple, dans la capture ci-dessous, le paquet kaffeine a t slectionn et
on a press +. Le paquet est maintenant mis en surbrillance en vert et la lettre
 i  est apparue  gauche de son nom pour indiquer qu'il sera install. De
plus, une estimation de l'espace qu'il va utiliser est affiche.

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1                  Will use 2925kB of disk space  DL Size:
1375kB
  --\ kde - The KDE Desktop System
    --\ main - The main Debian archive
p     bibletime-i18n                                        <none>     1.4.1-1
p     education-desktop-kde                                 <none>     0.771
p     junior-kde                                            <none>     1.4
piA   kaffeine                                      +2843kB <none>     0.4.3-1
pi    kaffeine-mozilla                              +81.9kB <none>     0.4.3-1
p     karamba                                               <none>     0.17-5
p     kde-devel                                             <none>     4:3.1.2

p     kde-devel-extras                                      <none>     4:3.1.2
The K Desktop Environment (development files)
A metapackage containing dependencies for the core development suite of KDE
including kdesdk, qt3-designer, and all core KDE -dev packages.








 [Astuce]  Astuce

            tout moment vous pouvez utiliser Annuler &#8594; Annuler
           (Contrle+u) pour  annuler  les changements faits sur un ou
           plusieurs paquets. C'est trs utile si une action a des consquences
           imprvues, et que vous souhaitez  revenir en arrire .


En plus des actions qui affectent des paquets individuels, une autre action
importante est disponible : taper U va tenter de mettre  jour tous les paquets
qui peuvent l'tre. Vous devriez utiliser cette commande rgulirement pour
maintenir votre systme  jour.


Grer les paquets casss

Parfois, changer l'tat d'un paquet fait apparatre ses relations de dpendances
comme non satisfaites. Des paquets avec des dpendances non satisfaites sont
dits casss. aptitude vous avertira quand cela arrive en expliquant pourquoi
cela est arriv. Par exemple voici ce qui arrive si vous tentez de supprimer
sound-juicer :

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.3.3       #Broken: 1   Will free 48.6MB of disk space
i A   nautilus                                             2.10.1-4   2.10.1-4
i     nautilus-cd-burner                                   2.10.2-1.1 2.10.2-1.1
i A   nautilus-data                                        2.10.1-4   2.10.1-4
i     netspeed                                             0.12.1-1   0.12.1-1
i A   oaf                                                  0.6.10-3   0.6.10-3
i     pybliographer                                        1.2.6.2-1  1.2.6.2-1
i     rhythmbox                                            0.8.8-13   0.8.8-13
i     shermans-aquarium                                    3.0.1-1    3.0.1-1
idA   sound-juicer                                 -1733kB 2.10.1-3   2.10.1-3
GNOME 2 CD Ripper
sound-juicer will be removed.


The following packages depend on sound-juicer and will be broken by its
removal:


  * gnome-desktop-environment depends on sound-juicer

[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

As you can see, aptitude displays three indicators that something has gone
wrong: first, the number of broken packages is displayed in the upper blue area;
second, the lower half of the display changes to describe broken packages that
are related to the currently highlighted package; third, a bar appears at the
bottom of the screen with a suggestion on how to solve the problem. To quickly
find broken packages in the package list, you can press b or search for ?broken.


 [Note]  Note

         Le texte [1(1)/...] indique l'avancement du solveur de dpendance
         d'aptitude. Le premier nombre est la solution que vous avez
         actuellement slectionne, et le second est le nombre de solutions
         qu'aptitude a dj trouves. La prsence du texte  ...  indique qu'il
         pourrait y avoir d'autres solutions que celles dj trouves. Si
         aptitude a l'assurance qu'il a trouv toutes les solutions possibles,
         le texte affich est alors [1/1].


Pour voir les autres solutions qui, selon aptitude, peuvent rsoudre ce
problme, appuyez sur e. Un cran similaire au suivant apparatra :

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    gstreamer0.8-cdparanoia                           [0.8.10-1 (unstable, now)]
    sound-juicer                                                [2.10.1-2 (now)]
















[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Ici, vous pouvez voir une autre solution en appuyant sur . ou retourner voir les
solutions que vous examiniez prcdemment en appuyant sur ,. Pour appliquer la
solution courante et retourner  la liste des paquets, appuyez sur !. Par
exemple, appuyer sur . pendant l'cran prcdent passe  la solution suivante :

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    sound-juicer                                      [2.10.1-3 (unstable, now)]
  --\ Downgrade the following packages:
    gstreamer0.8-cdparanoia          [0.8.11-1 unstable, now -> 0.8.8-3 testing]















[2(2)/...] Suggest 1 keep,1 downgrade
e: Examine  !: Apply  .: Next  ,: Previous

En plus des commandes de navigation, vous pouvez  rejeter  une solution en
appuyant sur r. Par exemple, la premire solution annule la suppression de
sound-juicer qui est justement l'action que nous tentions de faire ! En appuyant
sur r pendant la slection de l'item correspondant  cette action, on peut alors
faire en sorte qu'aptitude ne tente plus d'annuler la suppression de sound-
juicer.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
R   sound-juicer                                      [2.10.1-3 (unstable, now)]






GNOME 2 CD Ripper
gnome-desktop-environment depends upon sound-juicer
--\ The following actions will resolve this dependency:
  -> Remove gnome-desktop-environment [1:2.10.2.3 (unstable, testing, now)]
R -> Cancel the removal of sound-juicer
  -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]




[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Comme vous pouvez le voir, le choix correspondant  conserver sound-juicer  sa
version actuelle est devenu rouge et a t marqu avec  R  ce qui indique
qu'il a t rejet. Les solutions qui seront gnres aprs cela (c.--d.,
toutes les solutions que vous n'avez pas encore vues) excluront cette action.
Cependant les solutions qui incluent cette action et qui ont dj t vues
resteront disponibles.


 [Note]  Note

         Dans la capture d'cran ci-dessus, la description de sound-juicer est
         affiche au milieu de l'cran ; En dessous, les dpendances, qui ont
         impos de garder sound-juicer dans sa version actuelle, sont affiches,
         suivies de toutes les solutions connues par aptitude pour rsoudre
         cette dpendance.


Par exemple, si ce rejet est mis en &#339;uvre immdiatement aprs la
suppression de sound-juicer, appuyer sur . affichera la solution suivante, en
passant la solution qui annulait l'installation de sound-juicer et
l'installation de gstreamer0.8-cdparanoia dans une version antrieure.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Remove the following packages:
    gnome-desktop-environment              [1:2.10.2.3 (unstable, testing, now)]

















[2(2)/...] Suggest 1 removal
e: Examine  !: Apply  .: Next  ,: Previous

Les rejets sont appliqus uniquement aux nouvelles solutions, c'est--dire 
celles qui sont gnres quand vous appuyez sur . lorsque la dernire solution
gnre est affiche. Les solutions dj gnres contiendront toujours ces
rejets. Vous pouvez annuler un rejet  tout moment en slectionnant l'action
rejete, puis en appuyant sur r ; des solutions contenant cette action pourront
tre  nouveau gnres, ainsi que celles qui avaient t prcdemment
 oublies .

L'inverse du rejet d'une action est son approbation. Pour cela, il suffit de
slectionner cette action et d'appuyer sur a. Cela force le solveur  choisir,
autant que possible, cette action[3]. Comme le montre l'cran suivant, les
actions approuves sont mises en vert et marques avec  A  :

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Remove the following packages:
A   gnome-desktop-environment              [1:2.10.2.3 (unstable, testing, now)]

















[2(2)/...] Suggest 1 removal
e: Examine  !: Apply  .: Next  ,: Previous


 [Important]  Important

              Si vous ne rsolvez pas toutes les dpendances, aptitude utilisera
              automatiquement sa suggestion courante, lorsque vous validerez
              votre slection avec g. Nanmoins, il est difficile de rsoudre
              automatiquement des problmes de dpendances, et vous pourriez ne
              pas tre satisfait du rsultat, si bien qu'il est gnralement
              prfrable de vrifier les suggestions d'aptitude avant de mettre
               excution votre slection.



Mettre  jour la liste des paquets et installer des paquets

Arriv ici, vous connaissez assez aptitude pour rellement faire des
modifications sur votre systme.

Vous devriez priodiquement mettre  jour la liste des paquets disponibles
depuis les serveurs Debian, afin d'avoir connaissance des nouveaux paquets et
des nouvelles versions des paquets. Pour ce faire, appuyez sur u.  tout moment
pendant le tlchargement, presser q vous permettra de l'abandonner.

Une fois que vous avez une liste de paquets rcente, vous pouvez choisir les
paquets  mettre  jour,  installer ou  supprimer comme cela est dcrit dans
la section prcdente. Pour passer en revue les actions que vous avez demandes,
appuyez sur g une seule fois. Si vous installez le paquet kaffeine-mozilla
(comme dans l'exemple prcdent), l'cran suivant apparat :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1                  Will use 2925kB of disk space  DL Size:
1375kB
--\ Packages being automatically installed to satisfy dependencies

piA kaffeine                                        +2843kB <none>     0.4.3-1
--\ Packages to be installed
pi  kaffeine-mozilla                                +81.9kB <none>     0.4.3-1







These packages are being installed because they are required by another package
you have chosen for installation.

If you select a package, an explanation of its current state will appear in this
space.




Comme vous pouvez le voir, aptitude a dcid d'installer automatiquement
kaffeine car kaffeine-mozilla le requiert.  ce moment, vous avez le choix entre
continuer l'installation en appuyant sur g ou l'abandonner en appuyant sur q.


Utiliser aptitude depuis la ligne de commande

En plus de son interface  visuelle  dcrite dans la section prcdente,
aptitude peut tre utilis pour grer les paquets directement depuis la ligne de
commande de la mme manire que vous utiliseriez apt-get. Cette section couvre
les actions en ligne de commande les plus courantes d'aptitude. Pour plus
d'informations, consultez la rfrence pour la ligne de commande d'aptitude.

En gnral, une invocation d'aptitude sur la ligne de commande ressemble 
ceci :

aptitude action [arguments...]

action indique  aptitude l'action qu'il doit effectuer et les arguments
restants sont utiliss de faon spcifique  chaque action. Typiquement, ils
vont tre constitus de noms de paquets et d'options courtes[4].

Les actions les plus importantes sont :



  aptitude update

      Cette commande met  jour la liste des paquets comme si vous tiez entr
      dans l'interface graphique et aviez appuy sur u.


  aptitude safe-upgrade

      This command will upgrade as many packages as it can upgrade without
      removing existing packages.

      It is sometimes necessary to remove one package in order to upgrade
      another; this command is not able to upgrade packages in such situations.
      Use the full-upgrade command to upgrade those packages as well.


  aptitude full-upgrade

      Like safe-upgrade, this command will attempt to upgrade packages, but it
      is more aggressive about solving dependency problems: it will install and
      remove packages until all dependencies are satisfied. Because of the
      nature of this command, it is possible that it will do undesirable things,
      and so you should be careful when using it.


       [Note]  Note

               Pour des raisons historique, cette commande s'appelait 
               l'originedist-upgrade, et ce nom est toujours reconnu par
               aptitude.



  aptitude [ install | remove | purge ] pkg1 [pkg2...]

      Ces commandes installent, suppriment ou purgent[5] le paquet spcifi.
       Installer  un paquet qui est dj install mais qui peut tre mis 
      jour entranera sa mise  jour.


  aptitude search motif1 [motif2...]

      Cette commande recherche les paquets dont le nom contient un ou plusieurs
      des motifs donns et affiche le rsultat dans le terminal. Au del d'une
      simple chane de texte, chaque motif peut tre un motif de recherche comme
      dcrit dans la section intitule  Motifs de recherche .[6] Par exemple,
       aptitude search gnome kde  affichera tous les paquets dont le nom
      contient  gnome  ou  kde .


  aptitude show pqt1 [pqt2...]

      Afficher les informations sur chaque pqt sur le terminal.


Les commandes qui installent, mettent  jour ou suppriment des paquets acceptent
toutes le paramtre  -s , qui signifie  simuler . Quand  -s  est pass sur
la ligne de commande, le programme excute les actions qu'il devrait normalement
effectuer sans rellement tlcharger ou installer/supprimer aucun fichier.

aptitude prsentera parfois une invite comme celle-ci :

Les NOUVEAUX paquets suivants vont tre automatiquement installs :
  space-orbit-common
Les NOUVEAUX paquets suivants vont tre installs :
  space-orbit space-orbit-common
0 paquets mis  jour, 2 nouvellement installs, 0  enlever et 0 non mis  jour.
Il est ncessaire de tlcharger 3200ko d'archives. Aprs dpaquetage, 8413ko
seront utiliss.
Voulez-vous continuer ? [O/n/?]

En plus des options  Oui  et  Non  qui sont videntes, un certain nombre de
commandes sont disponibles et peuvent tre utilises pour modifier les
informations affiches  l'invite ou pour spcifier des options supplmentaires.
Par exemple, taper s affichera ou cachera l'information sur l'espace disque que
chaque paquet va utiliser :

Voulez-vous continuer ? [O/n/?] s

Les changements de taille seront affichs.

Les NOUVEAUX paquets suivants vont tre automatiquement installs :
  space-orbit-common <+8020kB>
Les NOUVEAUX paquets suivants vont tre installs :
  space-orbit <+393kB> space-orbit-common <+8020kB>
0 paquets mis  jour, 2 nouvellement installs, 0  enlever et 0 non mis  jour.
Il est ncessaire de tlcharger 3200ko d'archives. Aprs dpaquetage, 8413ko
seront utiliss.
Voulez-vous continuer ? [O/n/?]

De manire analogue, taper d affichera des informations sur les paquets
automatiquement installs ou supprims :

Les NOUVEAUX paquets suivants vont tre automatiquement installs :
  space-orbit-common (D: space-orbit)
Les NOUVEAUX paquets suivants vont tre installs :
  space-orbit space-orbit-common
0 paquets mis  jour, 2 nouvellement installs, 0  enlever et 0 non mis  jour.
Il est ncessaire de tlcharger 3200ko d'archives. Aprs dpaquetage, 8413ko
seront utiliss.

Cela indique que space-orbit-common est sur le point d'tre install parce que
space-orbit en dpend. Vous pouvez voir la liste complte des options possibles
en entrant ?  l'invite.

Si votre demande casse une dpendance d'une manire qui ne peut pas tre rsolue
simplement, aptitude vous demandera quoi faire :

The following packages are BROKEN:
  libsdl1.2debian
The following packages will be REMOVED:
  libsdl1.2debian-alsa
.
.
.
The following actions will resolve these dependencies:

Install the following packages:
libsdl1.2debian-all [1.2.12-1 (unstable)]

Score is 41

Accept this solution? [Y/n/q/?]

Taper y (ou simplement sur entre) validera la solution propose. Taper n
affichera la  meilleure  solution suivante :

Accept this solution? [Y/n/q/?] n
The following actions will resolve these dependencies:

Install the following packages:
libsdl1.2debian-esd [1.2.12-1 (unstable)]

Score is 19

Accept this solution? [Y/n/q/?]

Comme dans l'invite principale de la ligne de commande, vous pouvez effectuer
des actions supplmentaires, comme par exemple la modification de l'tat d'un
paquet depuis l'invite de rsolution des dpendances. Tapez ? pour afficher la
liste complte.

Typing q will abort the automatic resolver and allow you to resolve the
dependencies manually:

Accept this solution? [Y/n/q/?] q
aptitude failed to find a solution to these dependencies.  You can solve them
yourself by hand or type 'n' to quit.
The following packages have unmet dependencies:
  libsdl1.2debian: Depends: libsdl1.2debian-alsa (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-all (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-esd (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-arts (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-oss (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-nas (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-pulseaudio (= 1.2.12-1) but it is
not installable
Resolve these dependencies by hand? [N/+/-/_/:/?]

You can use any of the package manipulation commands to resolve the broken
dependencies (type ? for a full list of the available commands). Type n or press
enter to quit aptitude:

Resolve these dependencies by hand? [N/+/-/_/:/?] n
Abort.

Pour une documentation complte des caractristiques de la ligne de commande
d'aptitude, consultez la Rfrence de la ligne de commande.



--------------------------------------------------------------------------------
[2] Vous pouvez aussi utiliser le menu Paquet pour modifier l'tat d'un paquet.
Consultez la section intitule  Le menu Paquet  pour plus de dtails.

[3] Approuver une action est un peu diffrent de simplement imposer que toute
solution contienne l'action ; cela signifie qu' choisir entre une action
approuve et une qui ne l'est pas, il prendra la premire. S'il y a plusieurs
actions approuves, elles seront toutes susceptibles d'tre proposes dans la
solution.

[4]Une  option courte  est une lettre prcde d'un tiret, par exemple,  -
a ,  -v , etc.

[5]Purger un paquet supprime le paquet ainsi que tous ses fichiers de
configuration.

[6] En fait, c'est aussi vrai pour les commandes qui prennent des paquets en
argument, comme install ou show.


Chapitre 2. Guide de rfrence d'aptitude

Table des matires



  L'interface utilisateur d'aptitude


        Utiliser les menus

        Commandes du menu

        Travailler avec plusieurs vues

        Devenir administrateur ( root )


  Grer les paquets


        Grer la liste des paquets

        Accder aux informations des paquets

        Modifier l'tat d'un paquet

        Rsoudre les problmes de dpendance

        Tlcharger, installer et supprimer des paquets

        Qu'est-ce que la confiance en matire de gestion des paquets ?

        Grer les paquets automatiquement installs


  Motifs de recherche


        Searching for strings

        Shorthand for search terms

        Searches and Versions

        Explicit search targets

        Search Term Reference


  Personnalisation d'aptitude


        Personnaliser la liste des paquets

        Personnaliser les raccourcis clavier

        Personnaliser la couleur du texte et les styles

        Personnaliser la disposition de l'affichage

        Rfrence du fichier de configuration

        Thmes


  Jouer au dmineur


  Le Lapin Blanc mit ses lunettes.  O dois-je commencer votre Majest ?   
  demanda-t-il.

   Commence au commencement , rpondit gravement le Roi,  et continue
  jusqu' ce que tu arrives  la fin, alors arrte-toi. 

                                -- Lewis Carrol, Alice au pays des merveilles


aptitude est un programme imposant aux nombreuses possibilits et il est parfois
difficile de se rappeler comment faire telle chose ou mme de se rappeler si une
chose est possible. En effet, l'auteur reoit de nombreuses demandes d'ajout de
fonctionnalits qui sont dj prsentes mais difficiles  trouver.[7]

Dans une tentative pour combattre cette opacit, ce guide de rfrence dcrit
toutes les fonctionnalits et les paramtres de configuration d'aptitude. Pour
un guide plus abordable sur les fonctionnalits les plus importantes d'aptitude,
consultez Chapitre 1, Notions_pour_commencer.


 [Note]  Note

         Le comportement et l'apparence d'aptitude peuvent tre configurs de
         nombreuses faons. Ce manuel dcrit comment le programme fonctionne
         avec la configuration par dfaut. La description de la manire dont
         diffrentes configurations affectent son comportement est donne dans
         la section intitule  Personnalisation d'aptitude .



L'interface utilisateur d'aptitude

Cette section dcrit la partie de l'interface utilisateur d'aptitude qui ne
s'occupe pas de la gestion des paquets.


Utiliser les menus

La barre de menu en haut de l'cran liste les commandes les plus importantes
d'aptitude. Pour activer la barre de menu, utilisez le raccourci clavier
Control+t, vous pouvez alors vous y dplacer avec les touches de flches et
slectionner une entre du menu avec Entre.

Certaines entres du menu ont aussi des  cls d'accs rapide  : lettres ou
chiffres qui peuvent tre utiliss pour slectionner une entre alors que le
menu est actif. Ces cls d'accs rapide sont affiches avec une nuance de blanc
plus clair que le reste du menu.

En plus, certaines entres du menu ont des  raccourcis clavier  qui effectuent
la mme action que l'entre du menu mme lorsque le menu n'est pas actif. Ces
raccourcis sont indiqus  droite des entres du menu.

Dans la suite de ce manuel, les commandes du menu seront crites comme ceci :
Menu &#8594; Entre (key). Cela indique que vous devez utiliser l'Entre du menu
Menu et que la cl est le raccourci pour cette commande.


Commandes du menu


Le menu Actions

Figure 2.1. Commandes disponibles dans le menu Actions

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|                                      |Si un aperu d'installation n'est pas  |
|                                      |visible, en affiche un. Sinon lance un |
|Actions &#8594; Installer/enlever des |processus d'installation comme dcrit  |
|paquets (g)                           |dans la section intitule              |
|                                      | Tlcharger, installer et supprimer  |
|                                      |des paquets .                         |
|______________________________________|_______________________________________|
|Actions &#8594; Mettre  jour les     |Met  jour la liste des paquets.       |
|listes de paquets (u)                 |                                       |
|______________________________________|_______________________________________|
|                                      |Marque tous les paquets susceptibles de|
|Actions &#8594; Marquer comme tant   |l'tre,  l'exception de ceux qui sont |
|susceptible de mise  jour (U)        |gels ou interdits de mise  jour,     |
|                                      |comme devant tre mis  jour.          |
|______________________________________|_______________________________________|
|Actions &#8594; Oublier quels paquets |Oublie quels paquets sont  nouveaux  |
|sont nouveaux (f)                     |(c'est--dire vide l'arborescence      |
|                                      | Nouveaux paquets ).                 |
|______________________________________|_______________________________________|
|                                      |Annule toutes les installations, les   |
|Actions &#8594; Annuler les actions en|suppressions et les gels de paquets en |
|attente                               |attente. Cela revient  excuter sur   |
|                                      |l'ensemble des paquets la commande pour|
|                                      |les garder dans leur tat actuel.      |
|______________________________________|_______________________________________|
|Actions &#8594; Nettoyer le cache des |Supprime toutes les archives de paquets|
|paquets                               |qui ont t tlcharges par aptitude  |
|                                      |[a].                                   |
|______________________________________|_______________________________________|
|                                      |Supprime toutes les archives de paquets|
|                                      |qui ont t tlcharges par aptitude  |
|                                      |[a] et qui ne sont plus disponibles    |
|Actions &#8594; Enlever les fichiers  |dans les archives Debian. On peut      |
|prims                               |supposer que ce sont des paquets       |
|                                      |obsoltes et qui peuvent tre supprims|
|                                      |pour librer de l'espace disque sans   |
|                                      |que cela ne ncessite de               |
|                                      |tlchargements inutiles par ailleurs. |
|______________________________________|_______________________________________|
|                                      |Lance le dmineur, comme cela est      |
|Actions &#8594; Jouer au dmineur     |dcrit dans la section intitule       |
|                                      | Jouer au dmineur .                 |
|______________________________________|_______________________________________|
|                                      |Continue  travailler en tant          |
|Actions &#8594; Devenir administrateur|qu'utilisateur root. Voir la section   |
|                                      |intitule  Devenir administrateur     |
|                                      |( root ) .                          |
|______________________________________|_______________________________________|
|Actions &#8594; Quitter (Q)           |Quit aptitude, saving any changes to   |
|                                      |package states.                        |
|______________________________________|_______________________________________|
|[a] ou tout autre utilitaire apt.                                             |
|______________________________________________________________________________|




Le menu Annuler

Figure 2.2. Commandes disponibles dans le menu Annuler

 ______________________________________________________________________________
|Commande                            |Description                              |
|____________________________________|_________________________________________|
|                                    |Cancel the effect of the last change to a|
|                                    |package's state, up to the last time     |
|Annuler &#8594; Annuler (Contrle+u)|aptitude was started, the package list   |
|                                    |was updated, or an install run was       |
|                                    |performed.                               |
|____________________________________|_________________________________________|




Le menu Paquet

Figure 2.3. Commandes disponibles dans le menu Paquet

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|Paquet &#8594; Installer (+)          |Marque le paquet actuellement          |
|                                      |slectionn pour installation.         |
|______________________________________|_______________________________________|
|Paquet &#8594; Supprimer (-)          |Marque le paquet actuellement          |
|                                      |slectionn pour suppression.          |
|______________________________________|_______________________________________|
|Paquet &#8594; Purger (_)             |Marque le paquet actuellement          |
|                                      |slectionn pour purge.                |
|______________________________________|_______________________________________|
|                                      |Annule toute installation, mise  jour |
|Paquet &#8594; Garder (:)             |ou suppression prvue pour le paquet   |
|                                      |actuellement slectionn et retire tout|
|                                      |gel qui aurait t mis sur le paquet.  |
|______________________________________|_______________________________________|
|Paquet &#8594; Geler (=)              |Gle le paquet actuellement            |
|                                      |slectionn.                           |
|______________________________________|_______________________________________|
|                                      |Marque le paquet actuellement          |
|                                      |slectionn comme tant un paquet      |
|                                      | install automatiquement . Pour plus|
|Paquet &#8594; Marquer automatiquement|d'informations sur les paquets         |
|(M)                                   |installs manuellement et              |
|                                      |automatiquement, consultez la section  |
|                                      |intitule  Grer les paquets          |
|                                      |automatiquement installs .           |
|______________________________________|_______________________________________|
|                                      |Marque le paquet actuellement          |
|                                      |slectionn comme tant un paquet      |
|                                      | install manuellement . Pour plus   |
|Paquet &#8594; Marquer manuellement   |d'informations sur les paquets         |
|(m)                                   |installs manuellement et              |
|                                      |automatiquement, consultez la section  |
|                                      |intitule  Grer les paquets          |
|                                      |automatiquement installs .           |
|______________________________________|_______________________________________|
|                                      |Si un paquet qui peut tre mis  jour  |
|                                      |est slectionn, cela interdit sa mise |
|Paquet &#8594; Interdire la version   | jour vers la version actuellement    |
|(F)                                   |disponible uniquement. Si une version  |
|                                      |du paquet est slectionne, cela       |
|                                      |interdit au paquet d'tre mis  jour   |
|                                      |vers cette version.                    |
|______________________________________|_______________________________________|
|                                      |Affiche un cran contenant des         |
|                                      |informations sur le paquet actuellement|
|Paquet &#8594; Informations (entre)  |slectionn, comme les paquets dont il |
|                                      |dpend, les paquets qui en dpendent,  |
|                                      |et ses versions disponibles.           |
|______________________________________|_______________________________________|
|                                      |When browsing the package list, cycles |
|                                      |through the information that can be    |
|                                      |displayed in the information area (the |
|                                      |lower half of the display). The        |
|                                      |information area can display the long  |
|Package &#8594; Cycle Information (i) |description of the selected package    |
|                                      |(its default behavior), a summary of   |
|                                      |the dependencies related to the        |
|                                      |package, or an analysis of which other |
|                                      |packages require or suggest the        |
|                                      |selected package.                      |
|______________________________________|_______________________________________|
|                                      |Affiche la liste des modifications du  |
|                                      |paquet Debian actuellement slectionn.|
|Paquet &#8594; Liste des modifications|Pour voir les modifications d'une      |
|(C)                                   |version particulire, slectionnez     |
|                                      |cette version avant d'excuter cette   |
|                                      |commande.                              |
|______________________________________|_______________________________________|




Le menu Solveur

Figure 2.4. Commandes disponibles dans le menu Solveur

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|Solutions &#8594; Examiner la solution|Affiche une description dtaille de la|
|(e)                                   |suggestion actuelle.                   |
|______________________________________|_______________________________________|
|Solutions &#8594; Appliquer la        |Excute les actions actuellement       |
|solution (!)                          |suggres.                             |
|______________________________________|_______________________________________|
|Solutions &#8594; Solution suivante   |Slectionne la suggestion suivante.    |
|(.)                                   |                                       |
|______________________________________|_______________________________________|
|Solutions &#8594; Solution prcdente |Slectionne la suggestion prcdente.  |
|(,)                                   |                                       |
|______________________________________|_______________________________________|
|Solutions &#8594; Premire solution   |Slectionne la premire suggestion.    |
|(<)                                   |                                       |
|______________________________________|_______________________________________|
|                                      |Slectionne la suggestion la plus      |
|Solutions &#8594; Dernire solution   |rcente (voir la section intitule     |
|(>)                                   | Rsoudre les problmes de            |
|                                      |dpendance ).                         |
|______________________________________|_______________________________________|
|                                      |Lors de l'examen d'une solution,       |
|                                      |rejette l'action actuellement          |
|                                      |slectionne et passe  l'action       |
|Solutions &#8594; Marquer comme rejet|suivante (voir la section intitule    |
|(r)                                   | Rsoudre les problmes de            |
|                                      |dpendance ). Si l'action tait dans  |
|                                      |l'tat approuv, son approbation est   |
|                                      |annule.                               |
|______________________________________|_______________________________________|
|                                      |Lors de l'examen d'une solution,       |
|                                      |approuve l'action actuellement         |
|Solutions &#8594; Marquer comme retenu|slectionne et passe  l'action       |
|(a)                                   |suivante (voir la section intitule    |
|                                      | Rsoudre les problmes de            |
|                                      |dpendance ). Si l'action tait dans  |
|                                      |l'tat rejet, son rejet est annul.   |
|______________________________________|_______________________________________|
|                                      |Lors de l'examen d'une solution,       |
|                                      |affiche des informations dtailles sur|
|Solveur &#8594; Afficher la cible     |le paquet touch par l'action          |
|(entre)                              |actuellement slectionne (voir la     |
|                                      |section intitule  Rsoudre les       |
|                                      |problmes de dpendance ).            |
|______________________________________|_______________________________________|
|                                      |Reject (as if with Solutions &#8594;   |
|                                      |Marquer comme rejet (r)) all actions  |
|                                      |that would break a hold on a package or|
|                                      |install a forbidden version. These     |
|Resolver &#8594; Reject Breaking Holds|actions are rejected by default unless |
|                                      |Aptitude::ProblemResolver::Allow-Break-|
|                                      |Holds is set to true, but this menu    |
|                                      |item allows you to reject them manually|
|                                      |at any time.                           |
|______________________________________|_______________________________________|




Le menu Rechercher

Figure 2.5. Commandes disponibles dans le menu Rechercher

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|                                      |Recherche le paquet suivant dans la    |
|Rechercher &#8594; Rechercher (/)     |liste des paquets qui correspond au    |
|                                      |motif de recherche (voir la section    |
|                                      |intitule  Motifs de recherche ).    |
|______________________________________|_______________________________________|
|                                      |Recherche le paquet prcdent dans la  |
|Search &#8594; Rechercher en arrire  |liste des paquets qui correspond au    |
|(\)                                   |motif de recherche (voir la section    |
|                                      |intitule  Motifs de recherche ).    |
|______________________________________|_______________________________________|
|Rechercher &#8594; Rechercher        |Rpte la dernire recherche.          |
|nouveau (n)                           |                                       |
|______________________________________|_______________________________________|
|                                      |Rpeter la dernire commande, mais dans|
|Rechercher &#8594; Rechercher en      |le sens inverse. Si la dernire        |
|arrire (N)                           |commande Rechercher tait Rechercher   |
|                                      |vers le haut, alors cela excutera un  |
|                                      |Rechercher vers le bas, et vice versa. |
|______________________________________|_______________________________________|
|                                      |Filtre la liste de paquets en omettant |
|Rechercher &#8594; Affichage restreint|tous les paquets qui ne correspondent  |
|(l)                                   |pas au motif de recherche (voir la     |
|                                      |section intitule  Motifs de          |
|                                      |recherche ).                          |
|______________________________________|_______________________________________|
|                                      |Retire le filtrage de la liste de      |
|Rechercher &#8594; Affichage complet  |paquets (tous les paquets sont         |
|                                      |affichs).                             |
|______________________________________|_______________________________________|
|Rechercher &#8594; Rechercher les     |Find the next broken package. This is  |
|casss (b)                            |equivalent to searching for ?broken.   |
|______________________________________|_______________________________________|




Le menu Options

Figure 2.6. Commandes disponibles dans le menu Options

 ___________________________________________________________________________
|Commande                           |Description                            |
|___________________________________|_______________________________________|
|                                   |Open a new top-level view in which you |
|                                   |can modify aptitude's settings.        |
|                                   |Configuration options are displayed in |
|                                   |a tree similar to the tree of packages;|
|Options &#8594; Preferences        |to enable or disable an option, select |
|                                   |it and press Space or Enter.           |
|                                   |Configuration options are saved to     |
|                                   |~/.aptitude/config immediately upon    |
|                                   |being selected.                        |
|___________________________________|_______________________________________|
|Options &#8594; Revenir aux options|Revient aux options de configuration   |
|par dfaut                         |par dfaut.                            |
|___________________________________|_______________________________________|




Le menu Vues


 [Note]  Note

         Pour un aperu du fonctionnement des vues, voir la section intitule
          Travailler avec plusieurs vues .


Figure 2.7. Commandes disponibles dans le menu Vues

 _____________________________________________________________________________
|Commande                             |Description                            |
|_____________________________________|_______________________________________|
|Vues &#8594; Suivant (F6)            |Va  la vue active suivante.           |
|_____________________________________|_______________________________________|
|Vues &#8594; Prcdent (F7)          |Va  la prcdente vue active.         |
|_____________________________________|_______________________________________|
|Vues &#8594; Fermer (q)              |Ferme la vue actuelle.                 |
|_____________________________________|_______________________________________|
|Vues &#8594; Nouvelle vue des paquets|Cre une nouvelle vue de la liste des  |
|                                     |paquets.                               |
|_____________________________________|_______________________________________|
|                                     |Cre une vue qui affiche les paquets   |
|Vues &#8594; Voir les recommandations|qui ne sont pas installs et qu'un     |
|                                     |paquet install sur votre systme      |
|                                     |recommande.                            |
|_____________________________________|_______________________________________|
|Vues &#8594; Nouvelle liste des      |Cre une nouvelle vue de la liste des  |
|paquets                              |paquets dans laquelle les paquets ne   |
|                                     |sont pas tris.                        |
|_____________________________________|_______________________________________|
|                                     |Cre une nouvelle vue de la liste des  |
|Vues &#8594; Consultation par        |paquets dans laquelle les paquets sont |
| Debtags                           |rangs en fonction de leur entre      |
|                                     |debtags.                               |
|_____________________________________|_______________________________________|
|Vues &#8594; Consultation par        |Affiche la liste des paquets, organise|
|catgories                           |par catgorie.                         |
|_____________________________________|_______________________________________|
|                                     |D'autres entres du menu apparaissent. |
|Entres supplmentaires              |Il s'agit des vues actuellement        |
|                                     |actives. Pour atteindre directement une|
|                                     |vue, slectionnez-la dans ce menu.     |
|_____________________________________|_______________________________________|




Le menu Aide

Figure 2.8. Commandes disponibles dans le menu Aide

 _____________________________________________________________________________
|Commande                            |Description                             |
|____________________________________|________________________________________|
|Aide &#8594;  propos               |Affiche des informations de copyright.  |
|____________________________________|________________________________________|
|Aide &#8594; Aide (?)               |Affiche l'aide en ligne.                |
|____________________________________|________________________________________|
|Aide &#8594; Manuel Utilisateur     |Affiche le manuel de l'utilisateur (ce  |
|                                    |document).                              |
|____________________________________|________________________________________|
|Aide &#8594; FAQ                    |Affiche la FAQ d'aptitude.              |
|____________________________________|________________________________________|
|Aide &#8594; Liste des modifications|Affiche la liste des principales        |
|                                    |modifications apportes  aptitude.     |
|____________________________________|________________________________________|
|                                    |Affiche les termes de la licence sous   |
|Aide &#8594; Licence                |laquelle vous pouvez copier, modifier et|
|                                    |distribuer aptitude.                    |
|____________________________________|________________________________________|




Travailler avec plusieurs vues

aptitude vous permet de travailler avec plusieurs  vues   la fois. Une
 vue  (parfois appele  cran ) est simplement quelque chose qui apparat
dans une zone de l'cran en dessous de la barre de menu. La vue la plus courante
est la liste des paquets, la vue des tlchargements est aussi assez courante.

Quand plusieurs vues sont ouvertes en mme temps, une barre listant l'ensemble
des vues actives apparat en haut de l'cran. Par exemple, si on examine apt en
appuyant sur entre, puis qu'on examine libc6, l'cran ressemblera  ceci :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
         Packages                  apt info                  libc6 info
aptitude 0.3.1
i A  --\ libc6                                             2.3.2.ds1- 2.3.2.ds1-
  Description: GNU C Library: Shared libraries and Timezone data
    Contains the standard libraries that are used by nearly all programs on the
    system. This package includes shared versions of the standard C library and
    the standard math library, as well as many others. Timezone data is also
    included.
  Priority: required
  Section: base
  Maintainer: GNU Libc Maintainers <debian-glibc@lists.debian.org>
  Compressed size: 4901k
  Uncompressed size: 15.9M
  Source Package: glibc
  --\ Depends
    --- libdb1-compat
  --\ Suggests
    --- locales
    --- glibc-doc
  --\ Conflicts
GNU C Library: Shared libraries and Timezone data

Vous pouvez fermer la vue courante avec Vues &#8594; Fermer (q). Pour atteindre
les vues prcdentes et suivantes, utilisez Vues &#8594; Suivant (F6) et Vues
&#8594; Prcdent (F7) ou cliquez sur le nom de la vue en haut de l'cran. Vous
pouvez aussi trouver une liste de toutes les vues actives dans le menu Vues.

Comme ci-dessus, certaines commandes (par exemple, voir les informations d'un
paquet) vont crer automatiquement de nouvelles vues. Vous pouvez aussi demander
la cration d'une nouvelle vue avec Vues &#8594; Nouvelle vue des paquets ou
Vues &#8594; Consultation par catgories.


Devenir administrateur ( root )

Certaines actions, telles que la mise  jour de la liste des paquets, ne peuvent
tre ralises qu'en tant que root. Si vous n'tes pas root au moment de mettre
 jour la liste des paquets, aptitude va vous demander de le devenir :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--- Installed Packages
--- Not Installed Packages
--- Obsolete and Locally Created Packages
--- Virtual Packages
--- Tasks

  +-------------------------------------------------------------------------+
  |Updating the package lists requires administrative privileges, which     |
  |you currently do not have.  Would you like to change to the root account?|
  |                                                                         |
  |         [ Become root ]                  [ Don't become root ]          |
Th+-------------------------------------------------------------------------+








Si vous slectionnez  Devenir administrateur , aptitude va vous demander de
saisir le mot de passe de root. Une fois que vous l'aurez correctement saisi,
aptitude effectuera les actions qui ont ncessit les droits d'administration.
Vous resterez root aprs la fin de l'action.

Vous pouvez passer sous le compte root  tout moment en utilisant la commande
Actions &#8594; Devenir administrateur. Tous les changements que vous avez
apports  l'tat des paquets sont prservs (mais ils ne seront sauvegards
qu' la fermeture d'aptitude).


Grer les paquets

Cette section dcrit comment manipuler la liste des paquets, comment installer
de nouveaux paquets sur votre systme et comment supprimer de vieux paquets.


Grer la liste des paquets

Pour garder la liste des paquets  jour, il est recommand de la mettre  jour
rgulirement. Vous pouvez le faire grce  la commande Actions &#8594; Mettre 
jour les listes de paquets (u).


Accder aux informations des paquets

Les informations sur les paquets sont prsentes  plusieurs endroits : la liste
des paquets donne un aperu rapide de l'tat de chaque paquet et d'autres vues
sont aussi disponibles avec des informations dtailles sur chaque paquet.


La liste des paquets

La liste des paquets montre un rsum succinct de l'tat d'un paquet. Par
exemple, le paquet webmin pourrait avoir le rsum suivant :

piAU  webmin                                        +5837kB <aucun>    1.160-2

Les quatre caractres sur la gauche indiquent que le paquet n'est pas install
( p ), qu'il est sur le point d'tre install ( i ), qu'il a t install
automatiquement ( A ), et qu'il ne provient pas d'une source fiable ( U ). 
droite, on peut lire la version actuelle et la version la plus rcente
disponible, ainsi qu'une indication de l'espace supplmentaire que
l'installation va utiliser.


 [Astuce]  Astuce

           Vous pouvez personnaliser la manire d'afficher ce rsum. Consultez
           la section intitule  Personnaliser la manire d'afficher les
           paquets  pour plus de dtails.


Les quatre indicateurs d'tat sur la gauche de l'cran donnent les informations
de base sur l'tat d'un paquet. Le premier caractre indique l'tat courant du
paquet. Le second indique l'action qui sera entreprise sur le paquet. Le
troisime indique si le paquet a t automatiquement install (voir la section
intitule  Grer les paquets automatiquement installs ). Enfin, le quatrime
indique si le paquet est fiable (voir la section intitule  Qu'est-ce que la
confiance en matire de gestion des paquets ? ).

Les valeurs possibles pour l'indicateur de  l'tat courant  sont donnes dans
Figure 2.9,  Valeurs de l'indicateur de  l'tat courant   et les valeurs
possibles de l'indicateur  d'action  sont donnes dans Figure 2.10,  Valeurs
de l'indicateur  d'action  .

Figure 2.9. Valeurs de l'indicateur de  l'tat courant 


i - le paquet est install et toutes ses dpendances sont satisfaites.

c - le paquet a t supprim mais ses fichiers de configuration sont toujours
    prsents sur le systme.

p - le paquet et tous ses fichiers de configuration ont t supprims, ou le
    paquet n'a jamais t install.

v - le paquet est virtuel.

B - le paquet a des dpendances casses.

u - le paquet a t dpaquet mais pas configur.

C -  moiti configur : la configuration du paquet a t interrompue.

H -  moiti install : l'installation du paquet a t interrompue.




Figure 2.10. Valeurs de l'indicateur  d'action 


i - le paquet va tre install.

u - le paquet va tre mis  jour.

d - le paquet va tre supprim : il sera supprim mais ses fichiers de
    configuration resteront sur le systme.

p - le paquet va tre purg : lui et ses fichiers de configuration seront
    supprims.

h - le paquet est gel : il sera gard dans sa version actuelle, mme si une
    version plus rcente est disponible, jusqu' ce que le gel soit retir.

F - toute mise  jour du paquet est interdite.

r - le paquet va tre rinstall.

    le paquet est  cass  : certaines de ses dpendances ne sont pas
B - satisfaites. aptitude ne vous permettra pas d'installer, supprimer ou mettre
     jour quoique ce soit tant que des paquets sont casss.




De plus, si le terminal le permet, aptitude utilise des couleurs pour indiquer
l'tat d'un paquet. La distinction entre les tats se fait principalement grce
 la couleur de l'arrire plan :



  Noir
      Le paquet ne peut pas tre mise  jour (ou il ne sera pas install) et il
      n'a pas de problme de dpendance. Si le paquet est dj install, son nom
      est en surbrillance.


  Vert
      Le paquet est sur le point d'tre install.


  Bleu
      Le paquet est actuellement install et il va tre mis  jour.


  Magenta
      Le paquet est actuellement install, mais il va tre supprim.


  Blanc
      Le paquet est actuellement install et il est  gel  dans sa version
      courante : les mises  jour automatiques l'ignoreront.


  Rouge
      Le paquet est cass : certaines de ces dpendances ne sont pas
      satisfaites.


Enfin, la moiti infrieure de l'cran affiche la description longue. aptitude
tentera de dtecter si le paquet est impliqu dans des problmes de dpendances.
Si c'est le cas, des informations concernant ces problmes de dpendances y
seront affiches. Pour passer des informations de dpendances  la description
du paquet, et inversement, appuyez sur i.


Information dtaille d'un paquet

Appuyer sur Entre pendant qu'un paquet est en surbrillance affichera un cran
contenant les informations sur ce paquet :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
i A --\ apt                                                0.5.25     0.5.25
  Description: Advanced front-end for dpkg
    This is Debian's next generation front-end for the dpkg package manager. It
    provides the apt-get utility and APT dselect method that provides a simpler,
    safer way to install and upgrade packages.

    APT features complete installation ordering, multiple source capability and
    several other unique features, see the Users Guide in apt-doc.
  Essential: yes
  Priority: important
  Section: base
  Maintainer: APT Development Team <deity@lists.debian.org>
  Compressed size: 970k
  Uncompressed size: 2961k
  Source Package: apt
  --\ Depends
    --- libc6 (>= 2.3.2.ds1-4)
    --- libgcc1 (>= 1:3.3.3-1)
    --- libstdc++5 (>= 1:3.3.3-1)
  --\ Suggests
    --- aptitude | synaptic | gnome-apt | wajig
    --- dpkg-dev
    --\ apt-doc (UNSATISFIED)
p     0.6.25
p     0.5.25
  --\ Replaces
    --- libapt-pkg-doc (< 0.3.7)
    --- libapt-pkg-dev (< 0.3.7)
  --- Package names provided by apt
  --- Packages which depend on apt
  --\ Versions
p A 0.6.25
i A 0.5.25

On peut naviguer dans cet cran de manire similaire  la liste des paquets :
par exemple, dans la capture prcdente, l'arbre des dpendances sur apt-doc
fait apparatre les versions disponibles d'apt-doc qui peuvent satisfaire la
dpendance. Ces versions peuvent tre manipules de la mme manire que les
paquets : par exemple, pour installer la version 0.5.25 de apt-doc, il vous
suffit de la mettre en surbrillance et d'appuyer sur +.


 [Astuce]  Astuce

           Pour satisfaire rapidement une dpendance, slectionnez-la et appuyez
           sur +. aptitude tentera automatiquement de la satisfaire.


En plus des dpendances d'un paquet, vous pouvez voir le nom des paquets qu'il
fournit, les paquets qui dpendent de lui, ainsi que les versions disponibles du
paquet (en incluant tous les paquets qui le fournissent).

Comme d'habitude, vous pouvez quitter cet cran et retourner  la vue principale
en appuyant sur q. Par commodit, quelques autres crans d'information (qui
n'affichent que quelques informations courantes et cachent le reste) sont
disponibles : appuyez sur v pour voir les versions d'un paquet, d pour voir les
dpendances d'un paquet et r pour voir les  dpendances inverses  d'un paquet
(c'est--dire les paquets qui dpendent de ce paquet).


Modifier l'tat d'un paquet

Les commandes suivantes sont disponibles pour modifier l'tat des paquets. Ces
commandes prennent effet au prochain lancement d'un processus d'installation.
Jusque-l, toutes ces commandes peuvent tre annules en utilisant Annuler
&#8594; Annuler (Contrle+u).

Pour appliquer une commande  un paquet, il suffit de le slectionner dans une
liste de paquets et d'excuter la commande. Ces commandes peuvent aussi tre
appliques  un groupe de paquets en slectionnant l'en-tte du groupe (par
exemple :  Paquets pouvant tre mis  jour ) et en excutant la commande.

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|                                      |Marque le paquet courant pour          |
|                                      |installation.                          |
|                                      |                                       |
|Installation : Paquet &#8594;         |Si le paquet n'est pas install, il le |
|Installer (+)                         |sera. S'il est dj install, il sera  |
|                                      |mis  jour, si possible, et les        |
|                                      |ventuels marquages empchant sa mise |
|                                      |jour (p. ex. Gel) seront annuls.      |
|______________________________________|_______________________________________|
|                                      |Marque le paquet courant pour          |
|Suppression : Paquet &#8594; Supprimer|suppression.                           |
|(-)                                   |                                       |
|                                      |Si le paquet est install, il sera     |
|                                      |supprim.                              |
|______________________________________|_______________________________________|
|                                      |Marque le paquet courant pour purge.   |
|                                      |                                       |
|                                      |Si le paquet est install, il sera     |
|Purge : Paquet &#8594; Purger (_)     |supprim. De plus, s'il est dj       |
|                                      |supprim, tout fichier restant (comme  |
|                                      |les fichiers de configuration) li  ce|
|                                      |paquet sera supprim du systme.       |
|______________________________________|_______________________________________|
|                                      |Marque le paquet courant pour qu'il    |
|                                      |soit gard dans sa version actuelle.   |
|                                      |                                       |
|Garde : Paquet &#8594; Garder (:)     |Toute action qui tait prvue sur le   |
|                                      |paquet (installation, suppression ou   |
|                                      |mise  jour) est annule et tout gel   |
|                                      |persistant sur le paquet est retir.   |
|______________________________________|_______________________________________|
|                                      |Place un gel persistant sur le paquet. |
|                                      |                                       |
|                                      |Comme avec Garde, toute action prvue  |
|                                      |sur le paquet est annule. De plus, le |
|Gel : Paquet &#8594; Geler (=)        |paquet ne sera pas mis automatiquement |
|                                      | jour[a] jusqu' ce que le gel soit   |
|                                      |retir. Vous pouvez retirer le gel en  |
|                                      |excutant la commande Installation sur |
|                                      |le paquet.                             |
|______________________________________|_______________________________________|
|                                      |Le paquet ne sera pas automatiquement  |
|                                      |mis  jour[a] vers la version vers     |
|                                      |laquelle il peut actuellement l'tre.  |
|                                      |S'il est sur le point d'tre install, |
|                                      |sa mise  jour sera annule.           |
|                                      |                                       |
|                                      |Si vous lancez cette commande sur une  |
|                                      |version particulire d'un paquet, le   |
|Paquet &#8594; Interdire la version   |paquet ne sera pas mis  jour vers la  |
|(F)                                   |version slectionne. Remarquez qu'on  |
|                                      |ne peut interdire qu'une seule version |
|                                      | la fois.                             |
|                                      |                                       |
|                                      |Cette fonction est principalement      |
|                                      |fournie pour faciliter la vie des      |
|                                      |utilisateurs de la distribution        |
|                                      | unstable , afin qu'ils puissent     |
|                                      |viter certaines versions de paquet    |
|                                      |connues comme tant dfectueuses.      |
|______________________________________|_______________________________________|
|                                      |Rinstalle le paquet.                  |
|                                      |                                       |
|                                      |Remarquez que la marque de             |
|                                      |rinstallation ne sera pas sauvegarde |
|                                      |quand vous quitterez aptitude ou       |
|Rinstaller : appuyer sur L           |lancerez un processus d'installation   |
|                                      |pour des raisons techniques.           |
|                                      |(Brivement, les couches logicielles   |
|                                      |sous-jacentes (dpkg et apt) ne         |
|                                      |fournissent aucun moyen de savoir si   |
|                                      |une rinstallation a russi ou non).   |
|______________________________________|_______________________________________|
|                                      |Indique si le paquet doit tre trait  |
|                                      |comme ayant t automatiquement        |
|Paquet &#8594; Marquer automatiquement|install. Les paquets automatiquement  |
|(M), Paquet &#8594; Marquer           |installs sont supprims quand plus    |
|manuellement (m)                      |aucun paquet ne les requiert. Pour plus|
|                                      |d'informations, consultez la section   |
|                                      |intitule  Grer les paquets          |
|                                      |automatiquement installs .           |
|______________________________________|_______________________________________|
|[a] That is, it will be unaffected by Actions &#8594; Marquer comme tant     |
|susceptible de mise  jour (U) or the full-upgrade or safe-upgrade command-   |
|line actions.                                                                 |
|______________________________________________________________________________|

En plus de ces commandes qui affectent le paquet slectionn, il y a deux
commandes qui affectent un grand nombre de paquets d'un seul coup quelque soit
ce qui est slectionn. Actions &#8594; Oublier quels paquets sont nouveaux (f)
enlve l'tat  nouveau  de tous les paquets de la liste de paquets et Actions
&#8594; Marquer comme tant susceptible de mise  jour (U) marque tous les
paquets qui peuvent l'tre pour mise  jour,  l'exception des paquets qui sont
gels ou qui seraient mis  jour vers une version interdite.


 [Note]  Note

         Tout changement de l'tat des paquets est enregistr quand vous quittez
         aptitude, mettez  jour la liste des paquets ou lancez un processus
         d'installation. Si vous ne voulez pas enregistrer vos changements, vous
         pouvez toujours abandonner aptitude en pressant Ctrl-C.



Rsoudre les problmes de dpendance

Si un problme de dpendances survient, aptitude peut vous aider  la rsoudre.
Ds qu'un problme arrive, une barre rouge apparat en bas de l'cran avec un
rsum des suggestions d'aptitude pour le rsoudre. Par exemple, dans la capture
d'cran suivante, aptitude indique qu'il est possible de rsoudre le problme en
gardant deux paquets dans leur version actuelle.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.3.3       #Broken: 1   Will free 48.6MB of disk space
i A   nautilus                                             2.10.1-4   2.10.1-4
i     nautilus-cd-burner                                   2.10.2-1.1 2.10.2-1.1
i A   nautilus-data                                        2.10.1-4   2.10.1-4
i     netspeed                                             0.12.1-1   0.12.1-1
i A   oaf                                                  0.6.10-3   0.6.10-3
i     pybliographer                                        1.2.6.2-1  1.2.6.2-1
i     rhythmbox                                            0.8.8-13   0.8.8-13
i     shermans-aquarium                                    3.0.1-1    3.0.1-1
idA   sound-juicer                                 -1733kB 2.10.1-3   2.10.1-3
GNOME 2 CD Ripper
sound-juicer will be removed.


The following packages depend on sound-juicer and will be broken by its
removal:


  * gnome-desktop-environment depends on sound-juicer

[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Comme il est indiqu en bas de l'cran, vous pouvez voir d'autres solutions en
appuyant sur . et ,, appliquer la solution courante en appuyant sur ! et
examiner la solution plus en dtail en appuyant sur e. Quand vous examinez la
solution courante, un cran semblable au suivant apparat.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    gstreamer0.8-cdparanoia                           [0.8.10-1 (unstable, now)]
    sound-juicer                                                [2.10.1-2 (now)]
















[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Vous pouvez accder aux informations sur le paquet affect par une action en
appuyant simplement sur entre lorsque le paquet est slectionn. Pour obtenir
une explication dtaille sur les raisons d'un choix particulier, il suffit de
slectionner l'lment dans la liste. Dans la moiti basse de l'cran,
s'afficheront la dpendance qui a t rsolue par aptitude et tous les moyens
par lesquels la dpendance aurait pu tre rsolue.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
    sound-juicer                                      [2.10.1-3 (unstable, now)]






cdparanoia plugin for GStreamer
sound-juicer depends upon gstreamer0.8-cdparanoia
--\ The following actions will resolve this dependency:
  -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]
  -> Remove sound-juicer [2.10.1-3 (unstable, now)]
  -> Cancel the removal of gstreamer0.8-cdparanoia
  -> Downgrade gstreamer0.8-cdparanoia [0.8.11-1 (unstable, now) -> 0.8.8-3 (tes



[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Vous pouvez guider la rsolution de dpendances vers la solution de votre choix
en approuvant ou rejetant les actions lmentaires d'une solution. Si vous
approuvez une action, aptitude choisira, autant que possible, cette action en
ignorant les alternatives (s'il y a plusieurs actions approuves, elles seront
toutes choisies).  l'inverse, si vous rejetez une action, aptitude ne choisira
jamais cette action.

To reject an action, highlight it and press r; the rejection can be cancelled by
pressing r again. Similarly, select an action and press a to approve it. You can
undo either action by using Annuler &#8594; Annuler (Contrle+u) while the
resolver screen is active. If you cancel a rejection or an approval, any
solutions that were ignored will be available the next time that you generate a
new solution.


 [Note]  Note

         By default, the resolver rejects actions that change the state of held
         packages, or that install forbidden versions of packages. You can
         override these rejections, thus allowing the hold or forbidding to be
         automatically overridden, in the same way that you would override any
         other rejection. Setting the configuration option Aptitude::
         ProblemResolver::Allow-Break-Holds to true will disable this behavior,
         meaning that the resolver will always break holds (albeit at a penalty,
         see Aptitude::ProblemResolver::BreakHoldScore).


Les actions rejetes sont mises en rouge et marques avec un  R , et celles
approuves sont mises en vert et marques avec un  A . Comme vous pouvez le
voir dans la capture suivante o l'action de  conserver gstreamer0.8-cdparanoia
dans sa version actuelle  a t rejete et l'action de  conserver sound-juicer
dans sa version actuelle  approuve.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
R   gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
A   sound-juicer                                      [2.10.1-3 (unstable, now)]
















[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Les rejets et les approbations n'affectent que les solutions nouvellement
gnres. Il est possible de savoir si une nouvelle solution va tre gnre en
regardant l'indicateur en bas  gauche de l'cran. S'il y a un nombre entre
parenthses, celui-ci indique le nombre de solutions gnres. Et donc, si le
nombre hors des parenthses et celui  l'intrieur sont gaux (comme ci-dessus),
appuyer sur . va gnrer une nouvelle solution. S'il n'y a pas de nombre entre
parenthses (l'indicateur affiche, par exemple, [1/5]), alors il n'y a pas
d'autre solution  gnrer.  tout moment, vous pouvez slectionner la dernire
solution gnre en appuyant sur > et la premire avec <.


 [Important]  Important

              L'tat du systme de rsolution des problmes est mis  zro quand
              vous modifiez l'tat d'un paquet. Si vous marquez un paquet pour
              installation, pour mise  jour, pour suppression, etc., aptitude
              oubliera tous vos rejets et approbations, ainsi que toutes les
              solutions gnres jusque l.


En plus de la slection des actions dans la liste en haut de l'cran, vous
pouvez slectionner ces actions dans la liste du bas. Pour avoir accs  cette
seconde liste, vous pouvez soit cliquer dessus avec votre souris, soit appuyer
sur Tab. Enfin, en appuyant sur o, vous afficherez les dcisions tries. Cela
consiste en une liste des dpendances qui ont t rsolues et des actions qui
ont amen ce rsultat, comme le montre la capture suivante .

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ gnome-desktop-environment depends upon sound-juicer
    -> Cancel the removal of sound-juicer
  --\ sound-juicer depends upon gstreamer0.8-cdparanoia
    -> Cancel the removal of gstreamer0.8-cdparanoia





GNOME 2 CD Ripper
gnome-desktop-environment depends upon sound-juicer
--\ The following actions will resolve this dependency:
  -> Remove gnome-desktop-environment [1:2.10.2.3 (unstable, testing, now)]
  -> Cancel the removal of sound-juicer
  -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]




[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Appuyer  nouveau sur o quitte ce mode d'affichage.


Tlcharger, installer et supprimer des paquets

Changer l'tat des paquets comme dcrit dans la section prcdente n'affecte pas
rellement ce qui est install sur votre systme. De cette manire vous pouvez
ajuster l'tat des paquets sans affecter votre systme jusqu' ce que vous soyez
satisfait. Une fois que vous l'tes, vous pouvez les  appliquer  pour vraiment
installer et supprimer les paquets.[8]

Pour appliquer vos changements, utilisez la commande Actions &#8594; Installer/
enlever des paquets (g). Slectionner cette commande va afficher un aperu
dcrivant les changements qui seront effectus. Cet cran n'est qu'une liste de
paquets et vous pouvez manipuler les paquets (par exemple, annuler des
suppressions non dsires) de la mme manire que vous le feriez dans la liste
principale.

Quand vous tes prt, utilisez Vues &#8594; Fermer (q) pour annuler
l'installation ou Actions &#8594; Installer/enlever des paquets (g) pour la
lancer. aptitude tlchargera tous les fichiers ncessaires, puis vous demandera
s'il faut continuer le processus. Si vous validez par  Continuer , les
installations et suppressions vont dbuter.

Les paquets qui sont tlchargs par aptitude sont placs dans un rpertoire de
cache (habituellement /var/cache/apt/archives). Normalement, ils y sont laisss
ad infinitum. Pour supprimer tous les fichiers de ce rpertoire, utilisez
Actions &#8594; Nettoyer le cache des paquets, pour ne supprimer que les
fichiers qui ne peuvent plus tre tlchargs (c'est--dire les paquets
obsoltes), utilisez Actions &#8594; Enlever les fichiers prims.


Qu'est-ce que la confiance en matire de gestion des paquets ?

La possibilit pour apt d'accder  de nombreuses sources de paquets conduit 
un risque potentiel en matire de scurit. Supposons que vous ajoutiez une
archive publie par Jean-Kevin Lepirate  votre fichier sources.list afin
d'installer le paquet ubersuper de Jean-Kevin. Il est possible que l'archive de
Jean-Kevin contienne aussi ses propres versions  personnalises  de paquets
comme libc6 ou ssh... et ces versions vont voler vos informations personnelles
ou ouvrir des portes drobes sur votre systme ! Si ces paquets ont un numro
de version suprieur  ceux des paquets Debian lgitimes, apt les installera sur
votre systme  la prochaine mise  jour, sans se soucier de rien, permettant 
Jean-Kevin de faire sa sale besogne dans votre dos. Jean-Kevin pourrait aussi
modifier votre miroir des archives Debian et remplacer les logiciels lgitimes
par ses versions corrompues.

Heureusement, les nouvelles versions d'apt et d'aptitude, comme celle qui est
documente dans ce manuel, intgrent des mcanismes de protection pour contrer
ce genre d'attaque. apt utilise de puissants mcanismes de scurit bass sur le
clbre logiciel de chiffrement GPG pour vrifier que les paquets qui sont
distribus depuis les miroirs officiels Debian sont bien les mmes que ceux qui
ont t envoys par les responsables de paquets Debian. aptitude vous avertira
alors si vous tentez d'installer un paquet depuis une source non-Debian, ou si
vous tentez de mettre  jour un paquet provenant d'une source Debian vers une
version qui ne vient pas d'une source Debian.


 [Avertissement]  Avertissement

                  Les mcanismes de scurit d'apt fournissent une garantie
                  presque totale que le contenu de votre miroir est identique au
                  contenu de l'archive Debian principale. Nanmoins, ce n'est
                  pas une panace. Par exemple, il existe thoriquement de
                  nombreuses faons de mettre un paquet corrompu dans l'archive
                  Debian principale.

                  S'assurer que vous n'installez des logiciels que depuis des
                  sources fiables vous apportera un degr important de
                  protection contre les paquets malveillants, mais a ne peut
                  pas liminer tous les risques inhrents  l'installation de
                  logiciels.



Comprendre la confiance

apt permet  l'administrateur d'une archive de fournir une signature de l'index
de l'archive. Cette signature, qui (pour des raisons pratiques) ne peut pas tre
falsifie, indique que les fichiers lists dans l'index sont bien ceux que
l'administrateur avait l'intention de mettre dans l'archive : c'est--dire que
le contenu de l'archive n'a pas t corrompu depuis sa cration.[9] La signature
peut tre valide en vrifiant qu'elle correspond  la cl publique de
l'administrateur. La cl publique de l'archive Debian est distribu avec apt,
habituellement sur votre CD de Debian.

Quand aptitude tlcharge l'index d'une archive, il vrifie si l'index est bien
sign. S'il ne l'est pas, aptitude ne fera pas confiance aux paquets de cette
archive (voir plus bas pour savoir ce que cela signifie). S'il a une signature
mais que celle-ci est incorrecte ou ne peut tre vrifie, un avertissement sera
affich et aptitude refusera de faire confiance aux paquets de cette archive.

Plus tard, quand vous lancerez un processus d'installation, aptitude vrifiera
si les paquets viennent de sources fiables. Si un paquet douteux est sur le
point d'tre install, ou si un paquet est mis  jour d'une version fiable vers
une version non fiable, un avertissement est affich et vous avez la possibilit
d'interrompre le tlchargement :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.3.0                    Will use 831kB of disk space   DL Size: 30.4MB
--\ Packages to be upgraded
iu U wesnoth                                       -98.3kB 0.8.7-1    0.8.8-1.0w
iuAU wesnoth-data                                  +930kB  0.8.7-1    0.8.8-1.0w
+------------------------------------------------------------------------------+
|WARNING: untrusted versions of the following packages will be installed!     #|
|                                                                             #|
|Untrusted packages could compromise your system's security.  You should only #|
|proceed with the installation if you are certain that this is what you want  #|
|to do.                                                                       #|
|                                                                             #|
|  * wesnoth [version 0.8.8-1.0wesnoth.org]                                   #|
|  * wesnoth-data [version 0.8.8-1.0wesnoth.org]                              #|
|  * wesnoth-music [version 0.8.8-1.0wesnoth.org]                             #|
|         [ Really Continue ]                  [ Abort Installation ]          |
+------------------------------------------------------------------------------+
                                                                               #
                                                                               #
                                                                               #
                                                                               #
                                                                               #
                                                                               #


Faire confiance  d'autres cls

Il peut tre pratique de faire en sorte qu'apt fasse confiance  d'autres
archives, en plus de l'archive Debian principale. Pour chaque archive  laquelle
vous voulez faire confiance, vous devez rcuprer la cl publique utilise pour
signer l'index des paquets de cette archive. C'est habituellement un fichier
texte dont le nom fini par .asc. Il doit tre fourni par l'administrateur du
serveur ou tlchargeable depuis un serveur de cls publiques. Pour plus
d'information sur ce que sont les cls publiques et comment les rcuprer,
consultez la page web de GPG.

La liste des cls auxquelles apt fait confiance est stocke dans le fichier
porte-cls /etc/apt/trusted.gpg. Une fois que vous avez la cl GPG, vous pouvez
l'ajouter  ce fichier en excutant la commande gpg --no-default-keyring --
keyring /etc/apt/trusted.gpg --import nouvelleclef.asc. aptitude fera alors
confiance  toutes les archives signes avec la cl contenue dans
nouvelleclef.asc.


 [Avertissement]  Avertissement

                  Une fois que la cl d'une archive a t ajoute au porte-cls
                  d'apt, il lui sera accord autant de confiance qu'aux miroirs
                  Debian eux-mmes ! Vous ne devriez faire cela que si vous tes
                  absolument sr que la cl que vous ajoutez est la bonne et que
                  la personne qui dtient cette cl est  la fois fiable et
                  comptente.



Grer les paquets automatiquement installs

>Pour installer un paquet, il est souvent ncessaire d'en installer plusieurs
autres (pour satisfaire ses dpendances). Par exemple, si vous voulez installer
le paquet clanbomber, vous devez aussi installer le paquet libclanlib2. Lorsque
vous supprimez clanbomber, vous n'avez probablement plus besoin du paquet
libclanlib2. aptitude tentera de le dtecter et de supprimer automatiquement le
paquet libclanlib2.

Cela fonctionne ainsi : quand vous installez un paquet, aptitude va
automatiquement installer tout autre paquet dont il dpend. Ces paquets sont
marqus comme ayant t  automatiquement installs . aptitude va les
surveiller et les supprimer quand plus aucun paquet manuellement install n'en
dpendra [10]. Ils apparatront dans l'aperu comme des  paquets qui vont tre
supprims parce qu'ils ne sont plus utiliss .

Comme pour tout procd automatique, les choses peuvent potentiellement mal
tourner. Par exemple, mme si un paquet a t install automatiquement pour
commencer, il peut s'avrer utile par lui-mme. Vous pouvez retirer la marque
 automatique   tout moment en appuyant sur m et, si le paquet est dj marqu
 supprimer, vous pouvez annuler la suppression et retirer la marque
 automatique  avec Paquet &#8594; Installer (+).


Motifs de recherche

Quand vous recherchez un paquet ou restreignez l'affichage dans aptitude, la
chane que vous entrez est appele  motif de recherche . Bien que
l'utilisation premire des motifs de recherche soit de chercher le nom exact des
paquets, aptitude permet de crer des recherches bien plus labores. En plus de
l'interface visuelle, des oprations en ligne de commandes peuvent aussi
utiliser des motifs de recherche ; consultez Rfrence de la ligne de commande
pour plus de dtails.

A search pattern consists of one or more conditions (sometimes known as
 terms ); packages match the pattern if they match all of its terms. Terms
generally start with a question mark ( ? ), followed by the name of the match
term, which describes the search that the term performs: for instance, the term
?name matches package names, while the term ?version matches package versions.
Finally, any additional parameters to the search term are placed in parentheses
(see the documentation of individual terms for more information on this).


 [Note]  Note

         Text with no leading  ?  can also form a search pattern: aptitude
         will attempt to match it against package names. However, because  ? 
         is a regular expression metacharacter, aptitude will not recognize
         question marks as a terminator for these  bare  strings. For
         instance, the search pattern  apt?name(python)  will not search for
         packages whose name contains both  apt  and  python ; instead, it
         will search for packages whose name matches the regular expression
          apt?name(python) .



 [Avertissement]  Avertissement

                  The behavior of aptitude when given a search pattern without a
                  leading  ?  (or  ~ ) is provided as a convenience for
                  interactive use and may change in future releases; scripts
                  that invoke aptitude should explicitly name the search
                  strategy they want to use. That is, scripts should search for
                   ?name(coq)  or  ~ncoq  rather than  coq ).



Searching for strings

Many search terms take a string as a parameter and match it against one or more
fields of a package. Strings can be entered either with or without double quotes
( " ), so  ?name(scorch)  and  ?name("scorch")  will perform the same
search.

If you enter a  bare  string, one not surrounded by double quotes, then
aptitude will consider the string to have  ended  when it encounters the
closing parenthesis or the comma before a second argument to the search term.
[11] To remove the special meaning of these characters, place a tilde ( ~ )
directly before them. For instance, ?description(etc)) is a syntax error,
because the first ) ends the ?description term, and the second ) does not match
anything. In contrast, ?description(etc~)) matches any package whose description
contains the text  etc) . There are additional considerations if you are using
the shorthand notation for a term; see la section intitule  Shorthand for
search terms  for details.

La plupart des recherches textuelles (de noms de paquets, descriptions, etc.)
sont ralises en utilisant des expressions rationnelles o la casse des lettres
ne compte pas. Cela signifie que vous devez protger par une barre oblique
inverse ( backslash ) les caractres spciaux des expressions rationnelles[12]
dans vos recherches. Par exemple, pour rechercher  g++ , vous devrez utiliser
le motif  g\+\+ .


Shorthand for search terms

Some search terms can be written using  short  forms, which consist of a tilde
( ~ ) followed by a single character that identifies the term, and finally the
arguments (if any) to the term. For instance, the short form of ?name(aptitude)
is ~n aptitude.

When writing a term using its short form, tilde characters and  whitespace  -
- that is, space characters, tabs, and so on -- will break the term off and
start a new term. For instance,  ~mDaniel Burrows  will match any package
whose maintainer field contains  Daniel  and whose name contains  Burrows ,
while  ~i~napt  matches installed packages whose name contains apt. To include
whitespace characters in the search expression, you can either place a tilde in
front of it (as in Daniel~ Burrows) or place quotation marks around it (as in
"Debian Project" or even Debian" "Project). Inside a quoted string, the
backslash character ( \ ) can be used to cancel the special meaning of the
quotation mark: for instance, ~d"\"email" will match any package whose
description contains a quotation mark followed immediately by email. [13]


 [Note]  Note

         Question marks ( ? ) will not end the short form of a term, even if
         they are followed by the name of a search term. For instance,
          ~napt?priority(required)  will match all packages whose name matches
         the regular expression  apt?priority(required) . To combine a short
         query term with a search term specified by name, add one or more spaces
         between the two terms, as in  ~napt ?priority(required) , or place
         quotation marks around the text (if any) following the short form of a
         term, as in  ~n"apt"?priority(required) .


Tableau 2.1,  Quick guide to search terms  lists the short form of each search
term.


Searches and Versions

By default, a pattern matches a package if any version of the package matches
the pattern. However, some patterns will restrict their subterms to only match
against some versions of a package. For instance, the search term ?depends
(pattern) will select any package that depends on a package matching pattern.
However, pattern will only be checked against the versions of the package that
actually satisfy a dependency. This means that if foo depends on bar (>= 3.0)
and versions 2.0, 3.0, and 4.0 of bar are available, then in the search pattern
?depends(?version(2\.0)), only versions 3.0 and 4.0 will be tested against
?version(2\.0), and hence foo will not be found by this search.

It matters which versions are checked because, as in the example above, some
patterns will match one version but not another. For instance, the pattern
?installed will only match the version of the package (if any) that is currently
installed. Similarly, the pattern ?maintainer(maintainer) will only match
versions that have the given maintainer. Normally all versions of a package have
the same maintainer, but this is not always the case; in fact, any search
pattern that examines the fields of a package (other than its name, of course)
will behave this way, because all the fields of a package can change between
versions.


 [Note]  Note

         There is a subtle, but important, distinction between matching a
         pattern against a package, and matching it against all the versions of
         that package. When a pattern is matched against a package, each of its
         terms is matched against the package, and so each term will match if
         any version of the package matches. In contrast, when a pattern is
         matched against each version of a package, it will successfully match
         if it matches when all its subterms are matched against the same
         version of the package.

         For example: suppose that version 3.0-1 of the package aardvark is
         installed, but that version 4.0-1 is available. Then the search
         expression ?version(4\.0-1)?installed matches aardvark, because
         ?version(4\.0-1) matches against version 4.0-1 of aardvark, while
         ?installed matches against version 3.0-1. On the other hand, this
         expression does not match against all the versions of aardvark, because
         no single version is installed and also has a version number of 4.0-1.



Explicit search targets

Some particularly complex searches can be expressed in aptitude using explicit
targets. In normal search expressions, there is no way to refer to the package
or version that is currently being tested. For instance, suppose that you want
to search for all packages P that depend on a second package Q such that Q
recommends P. Clearly you need to start out with a ?depends(...) term. But the
term filling in the ... needs to somehow select packages that are identical to
the one being matched against ?depends. When describing the goal above, I dealt
with this by giving the packages names, calling them P and Q; terms with
explicit targets do exactly the same thing. [14]

An explicit target is introduced by the ?for term:

Figure 2.11. Syntax of the ?for term

?for variable:
pattern



This behaves exactly like pattern, but variable can be used within pattern to
refer to the package or version that pattern is being matched against. You can
use variable in two ways:


  1. The term ?= will match exactly the package or version indicated by the
     given variable. Specifically: if the corresponding ?for term is limited to
     a particular version, then ?= will match either that version (if ?= is
     limited) or the whole package; otherwise it will match any version of the
     package.

     See Exemple 2.1,   Use of the ?= term.   for an example of how to use ?=.

  2. The term ?bind(variable, pattern) will match any package or version if the
     value of variable matches against pattern.

     For ?-style terms, a shorthand form is available. The expression ?bind
     (variable, ?term[(args)]) can be replaced by ?variable:term(args).

     See Exemple 2.2,  Use of the ?bind term  for an example of how to use
     ?bind.



Search Term Reference

Tableau 2.1,  Quick guide to search terms  provides a brief summary of all the
search terms provided by aptitude. A full description of each term can be found
below.

Tableau 2.1. Quick guide to search terms

 __________________________________________________________________________
|Long form                |Short form          |Description                |
|_________________________|____________________|___________________________|
|                         |                    |Select the package bound to|
|?=variable               |                    |variable; see la section   |
|                         |                    |intitule  Explicit search|
|                         |                    |targets .                 |
|_________________________|____________________|___________________________|
|?not(pattern)            |!pattern            |Select any package that    |
|                         |                    |does not match pattern.    |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that have  |
|?action(action)          |~aaction            |been marked for the given  |
|                         |                    |action (e.g.,  install   |
|                         |                    |or  upgrade ).           |
|_________________________|____________________|___________________________|
|?all-versions(pattern)   |                    |Select packages whose      |
|                         |                    |versions all match pattern.|
|_________________________|____________________|___________________________|
|                         |                    |Select any package that    |
|?and(term1, term2)       |term1 term2         |matches both term1 and     |
|                         |                    |term2.                     |
|_________________________|____________________|___________________________|
|                         |                    |Select packages for which  |
|?any-version(pattern)    |                    |at least one version       |
|                         |                    |matches pattern.           |
|_________________________|____________________|___________________________|
|                         |                    |Select packages from the   |
|?archive(archive)        |~Aarchive           |given archive (such as     |
|                         |                    | unstable ).             |
|_________________________|____________________|___________________________|
|?automatic               |~M                  |Select packages that were  |
|                         |                    |automatically installed.   |
|_________________________|____________________|___________________________|
|                         |                    |Selects anything if        |
|                         |?variable:term-name[|variable matches pattern;  |
|?bind(variable, pattern) |(args)]             |see la section intitule   |
|                         |                    | Explicit search          |
|                         |                    |targets .                 |
|_________________________|____________________|___________________________|
|?broken                  |~b                  |Select packages that have a|
|                         |                    |broken dependency.         |
|_________________________|____________________|___________________________|
|                         |                    |Select package that have a |
|?broken-depType          |~BdepType           |broken dependency of the   |
|                         |                    |given depType.             |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that have a|
|?broken-depType(pattern) |~DB[depType:]pattern|broken dependency of the   |
|                         |                    |given depType matching     |
|                         |                    |pattern.                   |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that a     |
|?broken-reverse-depType  |~RBdepType:pattern  |package matching pattern   |
|(pattern)                |                    |declares a broken          |
|                         |                    |dependency of type depType.|
|_________________________|____________________|___________________________|
|                         |                    |Select packages that       |
|?conflicts(pattern)      |~Cpattern           |conflict with a package    |
|                         |                    |matching pattern.          |
|_________________________|____________________|___________________________|
|?config-files            |~c                  |Select packages that were  |
|                         |                    |removed but not purged.    |
|_________________________|____________________|___________________________|
|                         |                    |Match packages that declare|
|?depType(pattern)        |~D[depType:]pattern |a dependency of type       |
|                         |                    |depType on a package       |
|                         |                    |matching pattern.          |
|_________________________|____________________|___________________________|
|                         |                    |Select packages whose      |
|?description(description)|~ddescription       |description matches        |
|                         |                    |description.               |
|_________________________|____________________|___________________________|
|                         |                    |Select essential packages, |
|?essential               |~E                  |those with Essential: yes  |
|                         |                    |in their control files.    |
|_________________________|____________________|___________________________|
|?false                   |~F                  |Select no packages.        |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that match |
|                         |                    |pattern with variable bound|
|?for variable: pattern   |                    |to the package being       |
|                         |                    |matched; see la section    |
|                         |                    |intitule  Explicit search|
|                         |                    |targets .                 |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?garbage                 |~g                  |not required by any        |
|                         |                    |manually installed package.|
|_________________________|____________________|___________________________|
|?installed               |~i                  |Select installed packages. |
|_________________________|____________________|___________________________|
|?maintainer(maintainer)  |~mresponsable       |Select packages maintained |
|                         |                    |by maintainer.             |
|_________________________|____________________|___________________________|
|                         |                    |Select packages for which a|
|?narrow(filter, pattern) |~S filter pattern   |single version matches both|
|                         |                    |filter and pattern.        |
|_________________________|____________________|___________________________|
|?name(name)              |~nname, name        |Select packages with the   |
|                         |                    |given name.                |
|_________________________|____________________|___________________________|
|?new                     |~N                  |Select new packages.       |
|_________________________|____________________|___________________________|
|?obsolete                |~o                  |Match installed packages   |
|                         |                    |that cannot be downloaded. |
|_________________________|____________________|___________________________|
|?or(term1, term2)        |mot1 | mot2         |Select packages that match |
|                         |                    |term1, term2, or both.     |
|_________________________|____________________|___________________________|
|?origin(origin)          |~Oorigine           |Select packages with the   |
|                         |                    |given origin.              |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that       |
|?provides(pattern)       |~Ppattern           |provide a package matching |
|                         |                    |pattern.                   |
|_________________________|____________________|___________________________|
|?priority(priority)      |~ppriorit          |Select packages with the   |
|                         |                    |given priority.            |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?reverse-depType(pattern)|~R[depType:]pattern |the targets of a dependency|
|                         |                    |of type depType declared by|
|                         |                    |a package matching pattern.|
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?reverse-broken-depType  |                    |the targets of a broken    |
|(pattern)                |~RBdepType:pattern  |dependency of type depType |
|                         |                    |declared by a package      |
|                         |                    |matching pattern.          |
|_________________________|____________________|___________________________|
|?section(section)        |~ssection           |Select packages in the     |
|                         |                    |given section.             |
|_________________________|____________________|___________________________|
|                         |                    |Select packages whose      |
|?source-package(name)    |                    |source package name matches|
|                         |                    |the regular expression     |
|                         |                    |name.                      |
|_________________________|____________________|___________________________|
|                         |                    |Select packages whose      |
|?source-version(version) |                    |source version matches the |
|                         |                    |regular expression version.|
|_________________________|____________________|___________________________|
|?tag(tag)                |~Gmarqueur          |Select packages that have  |
|                         |                    |the given debtags tag.     |
|_________________________|____________________|___________________________|
|?true                    |~T                  |Select all packages.       |
|_________________________|____________________|___________________________|
|?task(task)              |~ttche             |Select packages that are in|
|                         |                    |the given task.            |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?upgradable              |~U                  |installed and can be       |
|                         |                    |upgraded.                  |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?user-tag                |                    |marked with a user-tag     |
|                         |                    |matching the regular       |
|                         |                    |expression user-tag.       |
|_________________________|____________________|___________________________|
|                         |                    |Select packages whose      |
|?version(version)        |~Vversion           |version matches version    |
|                         |                    |(special values: CURRENT,  |
|                         |                    |CANDIDATE, and TARGET).    |
|_________________________|____________________|___________________________|
|?virtual                 |~v                  |Select virtual packages.   |
|_________________________|____________________|___________________________|
|                         |                    |Select versions for which  |
|                         |                    |pattern matches any version|
|?widen(pattern)          |~Wpattern           |of the corresponding       |
|                         |                    |package, discarding local  |
|                         |                    |version restrictions.      |
|_________________________|____________________|___________________________|





  nom
      Est en correspondance avec les paquets dont le nom correspond 
      l'expression rationnelle nom. C'est le mode de recherche par  dfaut ,
      utilis pour les motifs qui ne commencent pas par ~.


       [Note]  Note

               To match packages whose names contain several different
               substrings, use the ?name term (described below); for instance,
                ?name(apti)?name(tude) .



  ?=variable
      Matches packages that correspond to the value of variable, which must be
      bound by an enclosing ?for. For instance, ?for x: ?depends( ?recommends
      ( ?=x ) ) will match any package x that depends on a package which
      recommends x.

      For instance, the following search expression matches packages that
      conflict with themselves:

      Exemple 2.1.  Use of the ?= term.

      ?for x: ?conflicts(?=x)


      See la section intitule  Explicit search targets  for more information.


  ?not(pattern), !pattern
      Matches packages which do not match the term pattern. For instance,  ?not
      (?broken)  selects packages that are not  broken .


       [Note]  Note

               Pour inclure un  !  dans une expression rationnelle, il doit
               tre  dspcialis  pour viter qu'aptitude ne considre qu'il
               effectue la ngation d'un mot. Pour ce faire, crivez  ~! .



  ?and(term1, term2), term1 term2
      Matches packages that match both term1 and term2.


  ?or(term1, term2), term1 | term2
      Correspond aux paquets qui correspondent soit  mot1, soit  mot2.


       [Note]  Note

               Pour inclure un  |  dans une expression rationnelle, il doit
               tre  dspcialis  pour viter qu'aptitude ne fasse un OU
               logique sur les mots. Pour ce faire, crivez  ~| .



  (pattern)
      Matches pattern. For instance,  opengl (perl|python)  matches any
      package whose name contains opengl, and also contains either perl or
      python.


  ?action(action), ~aaction
      Correspond avec les paquets sur lesquels l'action donne va tre
      effectue. Action peut tre  install ,  upgrade ,  downgrade ,
       remove ,  purge ,  hold  (si le paquet a t marqu  conserver),
      ou  keep  (si un paquet n'est pas modifi).

      Note that this only tests whether an action is actually queued up to be
      performed on a package, not whether it could be performed. Thus, for
      instance, ?action(upgrade) matches exactly those packages that you have
      already decided to upgrade, not packages which could be upgraded in the
      future (for that, use ?upgradable).


  ?all-versions(pattern)
      Matches any package whose versions all match the given expression. Each
      version of a package will be separately tested against pattern, and the
      package will match if all of its versions match. Packages without
      versions, such as virtual packages, will always be matched by this search
      term.

      This term may not be used in a context in which the versions to match
      against have already been narrowed, such as within ?depends or ?narrow.
      However, it may always be used within ?widen.


  ?any-version(pattern)
      Matches a package if any one of its versions matches the enclosed term.
      This is the dual to ?all-versions.

      This term may not be used in a context in which the versions to match
      against have already been narrowed, such as within ?depends or ?narrow.
      However, it may always be used within ?widen.


       [Note]  Note

               This term is closely related to ?narrow. In fact, ?any-version
               (term1 term2) is exactly the same as ?narrow(term1, term2).



  ?archive(archive), ~Aarchive
      Matches package versions which are available from an archive that matches
      the regular expression archive. For instance,  ?archive(testing) 
      matches any package available from the testing archive.


  ?automatic, ~M
      Correspond aux paquets qui ont t automatiquement installs.


   ?bind(variable, pattern), ?variable:term-name[(args)]
      Matches any package or version if the given pattern matches the package or
      version bound to variable, which must be defined in an enclosing ?for.

      For instance, the following search expression will match any package x
      such that x depends on a package y which in turn depends on a package z
      such that x also depends directly on z.

      Exemple 2.2. Use of the ?bind term

      ?for x: ?depends(?depends(?for z: ?x:depends(?=z)))


      See la section intitule  Explicit search targets  for more information.


  ?broken, ~b
      Correspond aux paquets qui sont  casss  : ils cassent, ou ont une
      dpendance, une pr-dpendance, ou un conflit non satisfait.


  ?broken-depType, ~BdepType
      Matches packages which have an unfulfilled ( broken ) dependency of the
      given depType. depType can be  depends ,  predepends ,  recommends ,
       suggests ,  breaks ,  conflicts , or  replaces .


  ?broken-depType(pattern), ~DB[depType:]pattern
      Matches packages with an unsatisfied dependency of type depType on a
      package matching pattern. depType may be any one of the dependency types
      listed in the documentation of ?broken-depType.


  ?conflicts(pattern), ~Cpattern
      Matches packages which conflict with a package matching the given pattern.
      For instance,  ?conflicts(?maintainer(dburrows@debian.org))  matches any
      package which conflicts with a package I maintain.


  ?config-files, ~c
      Correspond aux paquets qui ont t supprims mais dont les fichiers de
      configuration restent sur le systme (c'est--dire qu'ils ont t
      supprims, mais pas purgs).


  ?depType(patterm), ~D[depType:]pattern
      depType may be any one of the dependency types given in the documentation
      of ?broken-depType, as well as provides: for instance, ?depends(libpng3)
      will match any package that depends on libpng3. If the short form (~D) is
      used and depType is not present, it defaults to depends.

      If depType is  provides , matches packages that provide a package
      matching pattern (the equivalent of ?provides). Otherwise, matches
      packages which declare a dependency of type depType upon a package version
      which matches pattern.


  ?description(description), ~ddescription
      Correspond aux paquets dont la description correspond  l'expression
      rationnelle description.


  ?essential, ~E
      Correspond aux paquets Essentiels.


  ?false, ~F
      This term does not match any package. [15]


  ?for variable: pattern
      Matches pattern, but the given variable may be used inside pattern to
      refer to the package or package version this term to.

      You can use variable in two ways. To apply a ?-style term to the variable,
      write ?variable:term-name(args); for instance, ?x:depends(apt). In
      addition, the term ?=variable will select any package or version that
      matches the value of the given variable.

      For instance, the following term will match any package x that both
      depends and recommends a second package y.

      Exemple 2.3. Use of the ?for term

      ?for x: ?depends( ?for y: ?x:recommends( ?=y ) )


      See la section intitule  Explicit search targets  for more information.


  ?garbage, ~g
      Correspond aux paquets qui ne sont pas installs, ou qui ont t installs
      automatiquement mais desquels aucun paquet install ne dpend.


  ?installed, ~i
      Correspond aux paquets qui sont actuellement installs.

      Bien que par dfaut toutes les versions sont testes, ceci n'entre en
      correspondance qu'avec les paquets installs.


  ?maintainer(maintainer), ~mmaintainer
      Matches packages whose Maintainer field matches the regular expression
      maintainer. For instance,  ?maintainer(joeyh)  will find all packages
      maintained by Joey Hess.


   ?narrow(filter, pattern), ~S filter pattern
      This term  narrows  the search to package versions matching filter. In
      particular, it matches any package version which matches both filter and
      pattern. The string value of the match is the string value of pattern.


  ?name(name), ~nname
      Matches packages whose name matches the regular expression name. For
      instance, most of the packages that match  ?name(^lib)  are libraries of
      one sort or another.


  ?new, ~N
      Correspond aux paquets qui sont  nouveaux .


   ?obsolete, ~o
      Ce mot correspond  tout paquet install qui n'est disponible dans aucune
      version d'une quelconque archive. Ces paquets apparaissent dans
      l'interface visuel en tant que  Obsolete ou install localement 


  ?origin(origin), ~Oorigin
      Matches package versions whose origin matches the regular expression
      origin. For instance,  !?origin(debian)  will find any unofficial
      packages on your system (packages not from the Debian archive).


  ?provides(pattern), ~Ppattern
      Matches package versions which provide a package that matches the pattern.
      For instance,  ?provides(mail-transport-agent)  will match all the
      packages that provide  mail-transport-agent .


  ?priority(priority), ~ppriority
      Matches packages whose priority is priority; priority must be extra,
      important, optional, required, or standard. For instance,  ?priority
      (required)  matches packages whose priority is  required .


  ?reverse-depType(pattern), ~R[depType:]pattern
      depType may be either  provides  or one of the dependency types given in
      the documentation of ?broken-depType. If depType is not present, it
      defaults to depends.

      If depType is  provides , matches packages whose name is provided by a
      package version matching pattern. Otherwise, matches packages which a
      package version matching pattern declares a dependency of type depType
      upon.


  ?reverse-broken-depType(pattern), ?broken-reverse-depType(pattern), ~RB
  [depType:]pattern
      depType may be either  provides  or one of the dependency types given in
      the documentation of ?broken-depType. If depType is not present, it
      defaults to depends.

      Matches packages which a package version matching pattern declares an
      unsatisfied dependency of type depType upon.


   ?section(section), ~ssection
      Correspond aux paquets dont la section correspond  l'expression
      rationnelle section.


   ?source-package(name)
      Matches packages whose source package name matches the regular expression
      name.


   ?source-version(version)
      Matches packages whose source version matches the regular expression
      version.


  ?tag(tag), ~Gtag
      Matches packages whose Tag field matches the regular expression tag. For
      instance, the pattern ?tag(game::strategy) would match strategy games.

      Pour plus d'informations sur l'tiquetage et debtags, consultez http://
      debtags.alioth.debian.org.


   ?true, ~T
      This term matches any package. For instance,  ?installed?provides
      (?true)  matches installed packages which are provided by any package.


   ~ttche
      Correspond aux paquets qui font partie d'une tche dont le nom correspond
       l'expression rationnelle tche.


   ?upgradable, ~U
      Ce mot correspond  tout paquet install qui peut tre mis  jour.


   ?user-tag(tag)
      This term matches any package that is marked with a user-tag matching the
      regular expression tag.


   ?version(version), ~Vversion
      Matches any package version whose version number matches the regular
      expression version, with the exceptions noted below. For instance,
       ?version(debian)  matches packages whose version contains  debian .

      Les valeurs suivantes de version sont traites spcialement. Pour
      rechercher une version contenant ces valeurs, faites les prcder d'une
      barre oblique inverse ; par exemple, pour rechercher des paquets dont le
      numro de version contient  CURRENT , rechercher  \CURRENT .


      * CURRENT correspond  la version actuellement installe d'un paquet, s'il
        y en a une.

      * CANDIDATE correspond  la version, si elle existe, du paquet qui sera
        installe si vous appuyez sur + quand le paquet est slectionn ou si
        vous lancez aptitude install avec son nom.

      * TARGET correspond  la version d'un paquet dont l'installation est
        prvue, si elle existe.



   ?virtual, ~v
      Matches any package which is purely virtual: that is, its name is provided
      by a package or mentioned in a dependency, but no package of that name
      exists. For instance,  ?vortial!?provides(?true)  matches packages which
      are virtual and are not provided by any package: ie, packages which are
      depended upon but do not exist.


   ?widen(pattern), ~Wpattern
       Widens  the match: if the versions to match against have been limited
      by an enclosing term (such as ?depends), these limits are dropped. Thus,
      ?widen(pattern) matches a package version if pattern matches any version
      of that package.



Personnalisation d'aptitude


Personnaliser la liste des paquets

La liste de paquets peut tre normment personnalise : la manire d'afficher
les paquets, de les ranger, de les trier et mme l'organisation de l'affichage
sont toutes modifiables.


Personnaliser la manire d'afficher les paquets

Cette section dcrit la manire de configurer le contenu et le formatage de la
liste des paquets, de la ligne d'tat, et de la ligne d'en-tte.

Le format de chacune de ces zones est dfini par une  chane de format . Une
chane de format est une chane de texte contenant des commandes de format
dbutant par % comme %p, %S, etc. L'affichage correspondant est cr en
remplaant les commandes dbutant par % en fonction de leur signification
(donne ci-dessous).

Une commande de format (commenant par %) peut soit avoir une taille fixe et
dans ce cas elle est toujours remplace par la mme quantit de texte (avec
l'ajout d'espaces pour le complter si ncessaire), soit elle est  tirable 
ce qui signifie qu'elle prend tout l'espace laiss libre par les colonnes de
texte  taille fixe. S'il y a plusieurs colonnes tirables, l'espace
supplmentaire est divis quitablement entre les colonnes.

Toutes les commandes de format possdent une taille fixe et/ou tirable par
dfaut. La taille d'une commande de format peut tre modifie en insrant la
valeur de la taille voulue entre le signe pourcentage (%) et le caractre
identifiant le format. Par exemple, %20V produit une colonne version installable
des paquets d'une largeur de 20 caractres. Placer un point d'interrogation (?)
entre le signe % et le caractre identifiant la commande de format entrane la
variation de la largeur de base de la colonne en fonction de son contenu.
Remarquez, nanmoins, que les colonnes de ce type risque de ne plus s'aligner
verticalement.

Si vous souhaitez qu'une commande de format soit tirable, mme si elle possde
normalement une largeur fixe, placez un signe dise ( # ) immdiatement aprs
elle. Par exemple, pour afficher la version installable d'un paquet sans vous
soucier de sa longueur, utilisez la commande de format %V#. Vous pouvez aussi
mettre un # aprs autre chose qu'une commande de format ; aptitude va alors
 tirer  le texte qui prcde le # en insrant des espaces additionnelles
aprs lui.

En rsum, la syntaxe des commandes de format est :

%[largeur][?]code[#]

Les variables de configuration Aptitude::UI::Package-Display-Format, Aptitude::
UI::Package-Status-Format et Aptitude::UI::Package-Header-Format dfinissent les
formats par dfaut de la liste de paquets, de l'en-tte au-dessus de la liste de
paquets et de la ligne d'tat en dessous de la liste de paquets.

Les commandes de format (dbutant par %) suivantes sont disponibles :


 [Note]  Note

         Plusieurs des descriptions ci-dessous font rfrence  au paquet .
         Avec l'interface graphique, c'est soit le paquet qui est affich, soit
         le paquet actuellement slectionn. Dans la recherche avec l'interface
         en ligne de commande, c'est le paquet qui est affich.



Commande Nom                  Taille par dfaut tirable Description

                                                         Ce n'est pas vraiment
                                                         une commande de
                                                         format, cela insre
%%       % littral           1                 Non      simplement un signe
                                                         pourcentage dans
                                                         l'affichage 
                                                         l'endroit o elle est
                                                         place.

                                                         Dans certaines
                                                         circonstances, une
                                                         chane de format
                                                         d'affichage comportera
                                                         des  paramtres  :
                                                         par exemple, dans la
                                                         ligne de commande
         Remplacement de                                 search, les groupes
%#nombre paramtre            Variable          Non      correspondants  la
                                                         recherche sont
                                                         utiliss comme
                                                         paramtres lors de
                                                         l'affichage du
                                                         rsultat. Le code de
                                                         format sera remplac
                                                         par le paramtre
                                                         indiqu par nombre.

                                                         Caractre unique
                                                         rsumant l'action 
                                                         excuter sur le
%a       Marque d'action      1                 Non      paquet, comme dcrit
                                                         dans Figure 2.10,
                                                          Valeurs de
                                                         l'indicateur
                                                          d'action  .

                                                         Description plus
%A       Action               10                Non      lisible de l'action 
                                                         excuter sur le
                                                         paquet.

                                                         S'il n'y a pas de
                                                         paquet cass, cela ne
                                                         produit rien. Sinon,
%B       Comptage des casss  12                Non      cela produit une
                                                         chane telle que
                                                          Cass : 10 
                                                         indiquant le nombre de
                                                         paquets casss.

                                                         Caractre unique
                                                         rsumant l'tat actuel
         Marqueur d'tat                                 du paquet, comme
%c       actuel               1                 Non      dcrit dans
                                                         Figure 2.9,  Valeurs
                                                         de l'indicateur de
                                                          l'tat courant  .

                                                         Description plus
%C       tat actuel          11                Non      lisible de l'tat
                                                         actuel du paquet.

%d       Description          40                Oui      Description courte du
                                                         paquet.

%D       Taille du paquet     6                 Non      Taille de l'archive
                                                         contenant le paquet.

                                                         Nom d'hte de
%H       Nom d'hte           15                Non      l'ordinateur sur
                                                         lequel aptitude
                                                         fonctionne.

                                                         Affiche la priorit
                                                         maximale assigne  la
                                                         version du paquet.
         Priorit (Pin                                   Pour les paquets, cela
%i       priority)            4                 Non      affiche la priorit de
                                                         la version dans
                                                         laquelle le paquet est
                                                         forc d'tre install
                                                         (s'il y en a une).

                                                         Espace (estim) que
%I       Taille installe     6                 Non      prend le paquet sur le
                                                         disque.

%m       Responsable          30                Oui      Responsable du paquet.

                                                         Si le paquet a t
                                                         install
%M       Marquage automatique 1                 Non      automatiquement,
                                                         affiche  A , sinon
                                                         n'affiche rien.

                                                         Outputs the version of
%n       Version du programme Longueur de       Non      aptitude that is
                               0.4.11.8                running, currently
                                                          0.4.11.8 .

                              The length of the          Outputs the name of
%N       Nom du programme     name.             Non      the program; usually
                                                          aptitude .

                                                         Si aucun paquet ne
                                                         doit tre install,
                                                         n'affiche rien. Sinon,
                                                         affiche une chane
                                                         indiquant la taille
%o       Taille  tlcharger 15                Non      totale prise par les
                                                         paquets  installer
                                                         (c'est--dire une
                                                         estimation de ce qu'il
                                                         faut tlcharger) ;
                                                         par exemple,  28,5ko
                                                          tlcharger .

                                                         Affiche le nom du
                                                         paquet. Quand un
                                                         paquet est affich
%p       Nom du paquet        30                Oui      dans une arborescence,
                                                         le nom sera indent,
                                                         si possible, en
                                                         fonction de la
                                                         profondeur de l'arbre.

%P       Priorit             9                 Non      Affiche la priorit du
                                                         paquet.

                                                         Affiche le nombre
%r       Compteur des         2                 Non      approximatif de
         dpendances inverses                            paquets installs qui
                                                         dpendent du paquet.

                                                         Affiche la description
         Abrviation de la                               abrge de la priorit
%R       priorit             3                 Non      du paquet : par
                                                         exemple,  Important 
                                                         devient  Imp .

%s       Section              10                Non      Affiche la section du
                                                         paquet.

                                                         Si le paquet n'est pas
%S       Niveau de confiance  1                 Non      certifi par une
                                                         source de confiance,
                                                         affiche la lettre "U".

%t       Archive              10                Oui      Archive dans laquelle
                                                         se trouve le paquet.

                                                         Affiche  *  si le
%T       tiquet             1                 Non      paquet est tiquet,
                                                         rien sinon.[16]

                                                         Si l'action prvue
                                                         doit modifier l'espace
         Modification de                                 disque utilis, cela
%u       l'utilisation du     30                Non      indique le changement,
         disque                                          par exemple,
                                                          Utilisera 100,0Mo
                                                         d'espace disque. 

                                                         Affiche la version
                                                         actuellement installe
%v       Version actuelle     10                Non      du paquet, ou <aucun>
                                                         si le paquet n'est pas
                                                         actuellement install.

                                                         Affiche la version du
                                                         paquet qui serait
                                                         installe si Paquet
%V       Version installable  10                Non      &#8594; Installer (+)
                                                         tait excut sur le
                                                         paquet, ou <aucun> si
                                                         le paquet n'est pas
                                                         actuellement install.

                                                         Affiche l'espace
                                                         supplmentaire utilis
%Z       Changement de taille 7                 Non      ou l'espace libr par
                                                         l'installation, la
                                                         mise  jour ou la
                                                         suppression du paquet.



Personnaliser la hirarchie des paquets

La hirarchie des paquets est produite par une politique de regroupement : des
rgles dcrivant la manire de construire la hirarchie. La politique de
regroupement dcrit une  succession  de rgles. Chaque rgle peut retirer des
paquets, crer une sous-hirarchie dans laquelle on place des paquets ou encore
manipuler l'arborescence. Les variables de configuration Aptitude::UI::Default-
Grouping et Aptitude::UI::Default-Preview-Grouping dfinissent les politiques de
regroupement lors de la cration, respectivement, de nouvelles listes de paquets
et de nouveaux crans de prvisualisation. Vous pouvez dfinir la politique de
regroupement pour la liste de paquets actuelle en appuyant sur G.

La politique de regroupement est dcrite par une liste de rgles spares par
des virgules : rgle1,rgle2,.... Chaque rgle est constitue du nom de la
rgle, ventuellement suivi d'arguments : par exemple, versions ou section
(subdir). Le fait que des arguments soient requis et le nombre d'arguments
requis (ou permis) dpend du type de rgle.

Une rgle peut tre non terminale ou terminale. Une rgle non terminale va
traiter un paquet en produisant une partie de la hirarchie, puis en le passant
 la rgle suivante. Une rgle terminale, au contraire, va aussi traiter une
partie de l'arborescence (typiquement les entres correspondant au paquet), mais
ne passera pas le paquet  la rgle qui suit. Si aucune rgle terminale n'est
spcifie, aptitude va utiliser la rgle par dfaut qui cre les  entres de
paquet  standards.



  action

      Regroupe les paquets suivant l'action prvue sur ceux-ci. Les paquets qui
      ne peuvent tre mis  jour ou qui sont inchangs sont ignors. C'est le
      regroupement qui est utilis dans l'arborescence d'aperu d'installation.


  deps

      C'est une rgle terminale.

      Cre les entres de paquets standard qui peuvent tre dplies pour
      laisser apparatre les dpendances d'un paquet.


  filter(motif)

      N'inclut que les paquets dont au moins une version correspond  motif.

      Si motif est manquant, aucun paquet n'est cart. Ceci est une
      fonctionnalit de compatibilit ascendante et peut tre supprime dans le
      futur.


  firstchar

      Regroupe les paquets en fonction de la premire lettre de leur nom.


  hier

      Regroupe les paquets en fonction d'un fichier de donnes annexe qui dcrit
      une  hirarchie  de paquets.


  pattern(motif [=>
  titre][, ...])

      Une politique de regroupement personnalisable. Chaque version de chaque
      paquet est mise en correspondance avec les motifs donns. La premire
      correspondance trouve est utilise pour assigner un titre au paquet ; les
      paquets sont alors tris selon leur titre. Les chanes de la forme \N qui
      apparaissent dans le titre seront remplaces par le Nime rsultat de la
      recherche. Si titre est absent, sa valeur par dfaut est alors \1.

      For instance, pattern(?maintainer() => \1) will group packages according
      to their Maintainer field. The policy pattern(?maintainer()) will do the
      same thing, as the absent title defaults to \1.

      Instead of => title, an entry may end with ||. This indicates that
      packages matching the corresponding pattern will be inserted into the tree
      at the same level as the pattern grouping, rather than being placed in
      subtrees. For instance, pattern(?action(remove) => Packages Being Removed,
      ?true ||) will place packages that are being removed into a subtree, and
      place all the other packages at the current level. Any later grouping
      policies will apply to both sets of packages, of course.

      Consultez la section la section intitule  Motifs de recherche  pour
      plus d'information sur le format de motif.


  priority

      Regroupe les paquets en fonction de leur priorit.


  section[(mode[,passthrough])]

      Regroupe les paquets en fonction de leur champ Section.

      mode peut prendre les valeurs suivantes :



        none
            Group based on the whole Section field, so categories like  non-
            free/games  will be created. This is the default if no mode is
            specified.


        topdir
            Group based on the part of the Section field before the first /
            character; if this part of the Section is not recognized, or if
            there is no /, the first entry in the list Aptitude::Sections::Top-
            Sections will be used instead.


        subdir
            Group based on the part of the Section field after the first /
            character, if it is contained in the list Aptitude::Sections::Top-
            Sections. If not, or if there is no /, group based on the entire
            Section field instead.


        subdirs
            Group based on the part of the Section field after the first /
            character, if the portion of the field preceding it is contained in
            the list Aptitude::Sections::Top-Sections; if not, or if there is no
            /, the entire field will be used. If there are multiple / characters
            in the portion of the field that is used, a hierarchy of groups will
            be formed. For instance, if  games  is not a member of Aptitude::
            Sections::Top-Sections, then a package with a section of  games/
            arcade  will be placed under the top-level heading  games , in a
            sub-tree named  arcade .


      Si passthrough est prsent, les paquets qui, pour une raison ou une autre,
      ne possdent pas de vritable Section (par exemple, les paquets virtuels)
      sont passs directement au niveau de regroupement suivant sans tre placs
      en premier dans une sous-catgorie.


  status

      Trie les paquets dans les catgories suivantes :


      * Installs

      * Non installs

      * Mise  jour de scurit

      * Pouvant tre mis  jour

      * Obsoltes ou crs localement

      * Virtuels



  tag[(aspect)]

      Regroupe les paquets en fonction de l'information du champ Marqueur
      contenu dans les fichiers de paquets Debian. Si aspect est fourni, alors
      seuls les marqueurs correspondants  cet aspect seront affichs. Sinon,
      tous les paquets seront affichs au moins une fois (les paquets sans
      marqueur seront placs dans une liste spare de ceux qui en ont).

      Pour plus d'informations sur debtags, consultez le site http://
      debtags.alioth.debian.org.


  task

      Cre une arborescence appele  Tches  qui contient les tches
      disponibles (les informations sur les tches sont lues depuis debian-
      tasks.desc du paquet tasksel). La rgle suivant task va crer ses
      catgories comme des enfants de Tches.


  versions

      C'est une rgle terminale.

      Cre des entres de paquets standard qui peuvent tre dplies pour
      laisser apparatre les versions du paquet.



Personnaliser la manire de trier les paquets

Par dfaut, les paquets, dans la liste de paquets, sont tris par ordre
alphabtique. Nanmoins, il est souvent utile de les trier suivant d'autres
critres (par exemple, la taille du paquet), et aptitude vous autorise  le
faire en modifiant la politique de tri.

Comme la politique de regroupement dcrite dans la section prcdente, la
politique de tri est une liste spare par des virgules. Chaque entre de la
liste est le nom d'une rgle de tri ; si les paquets sont identiques selon la
premire rgle, la seconde tente de les trier, et ainsi de suite. Placer un
caractre tilde (~) avant la rgle inverse la signification habituelle de la
rgle. Par exemple, priority,~name va trier les paquets par priorit, et les
paquets de mme priorit seront placs dans l'ordre alphabtique inverse.

Pour changer la politique de tri d'une liste de paquets active, appuyez sur S.

Les rgles disponibles sont :



  installsize
      Trie les paquets selon l'estimation de la taille ncessaire 
      l'installation.


  name
      Trie les paquets selon leur nom.


  priority
      Trie les paquets selon leur priorit.


  version
      Trie les paquets selon leur version.



Personnaliser les raccourcis clavier

Les touches utilises pour lancer des commandes d'aptitude peuvent tre
personnalises dans le fichier de configuration. Chaque commande possde une
variable de configuration associe sous Aptitude::UI::Keybindings. Pour changer
la squence de touches lie  une commande, il suffit de modifier la variable
correspondant  la squence de touches. Par exemple, pour associer la touche s 
une recherche, mettez Aptitude::UI::Keybindings::Search   s . Vous pouvez
demander  ce que la touche Contrle soit aussi enfonc en plaant  C-  devant
la touche : par exemple mettre  C-s   la place de  s  va lier la recherche
 la recherche  Contrle+s au lieu de s. Enfin, vous pouvez lier une commande 
plusieurs squences de touches en une seule fois en les sparant par des
virgules : par exemple utiliser  s,C-s  aura pour consquence que s et
Contrle+s lanceront une recherche.

Les commandes suivantes peuvent tre lies  une squence de touches en
configurant les variables Aptitude::UI::Keybindings::commande, o commande est
le nom de la commande  lier :

 ______________________________________________________________________________
|Commande              |Valeur par dfaut|Description                          |
|______________________|_________________|_____________________________________|
|                      |                 |Si des paquets sont casss et        |
|ApplySolution         |!                |aptitude a suggr une solution au   |
|                      |                 |problme, applique immdiatement la  |
|                      |                 |solution.                            |
|______________________|_________________|_____________________________________|
|                      |                 |Se dplace au dbut de l'affichage   |
|Begin                 |home,C-a         |courant : au dbut de la liste ou   |
|                      |                 |gauche d'un champ de saisie de texte.|
|______________________|_________________|_____________________________________|
|                      |                 |Envoie un rapport de bogue contre le |
|BugReport             |B                |paquet couramment slectionn, en    |
|                      |                 |utilisant reportbug.                 |
|______________________|_________________|_____________________________________|
|                      |                 |Annule l'interaction courante. Par   |
|Cancel                |C-g,escape,C-[   |exemple, sort d'une bote de dialogue|
|                      |                 |ou du menu.                          |
|______________________|_________________|_____________________________________|
|                      |                 |Affiche le fichier changelog.Debian  |
|Changelog             |C                |du paquet actuellement slectionn ou|
|                      |                 |de la version du paquet.             |
|______________________|_________________|_____________________________________|
|                      |                 |Change la politique de regroupement  |
|ChangePkgTreeGrouping |G                |de la liste de paquets actuellement  |
|                      |                 |active.                              |
|______________________|_________________|_____________________________________|
|                      |                 |Change la restriction d'affichage de |
|ChangePkgTreeLimit    |l                |la liste de paquets actuellement     |
|                      |                 |active.                              |
|______________________|_________________|_____________________________________|
|ChangePkgTreeSorting  |S                |Change la politique de tri de la     |
|                      |                 |liste de paquets actuellement active.|
|______________________|_________________|_____________________________________|
|                      |                 |Marque le paquet actuellement        |
|ClearAuto             |m                |slectionn comme ayant t install |
|                      |                 |manuellement.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Replie toute l'arborescence          |
|CollapseAll           |]                |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Replie la racine de l'arborescence   |
|CollapseTree          |Aucune squence  |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Dans l'diteur de hirarchie garde en|
|Commit                |N                |mmoire l'emplacement hirarchique du|
|                      |                 |paquet actuel et passe au paquet     |
|                      |                 |suivant.                             |
|______________________|_________________|_____________________________________|
|                      |                 |Dans les botes de dialogue, c'est   |
|                      |                 |quivalent   Ok . Lors d'une      |
|Confirm               |enter            |interaction en ligne de commande avec|
|                      |                 |une question  choix multiples, cela |
|                      |                 |choisit l'option par dfaut.         |
|______________________|_________________|_____________________________________|
|Cycle                 |tab              |Change le focus clavier vers le      |
|                      |                 | widget  suivant.                  |
|______________________|_________________|_____________________________________|
|CycleNext             |f6               |Change vers la vue active suivante.  |
|______________________|_________________|_____________________________________|
|CycleOrder            |o                |Circule parmi des lments prdfinis|
|                      |                 |de l'affichage.                      |
|______________________|_________________|_____________________________________|
|CyclePrev             |f7               |Change vers la vue active prcdente.|
|______________________|_________________|_____________________________________|
|DelBOL                |C-u              |Supprime tout le texte entre le      |
|                      |                 |curseur et le dbut de la ligne.     |
|______________________|_________________|_____________________________________|
|DelBack               |backspace,C-h    |Supprime le caractre prcdent lors |
|                      |                 |de la saisie de texte.               |
|______________________|_________________|_____________________________________|
|DelEOL                |C-k              |Supprime tout le texte depuis le     |
|                      |                 |curseur jusqu' la fin de la ligne.  |
|______________________|_________________|_____________________________________|
|DelForward            |delete,C-d       |Supprime le caractre sous le curseur|
|                      |                 |lors de la saisie de texte.          |
|______________________|_________________|_____________________________________|
|Dependencies          |d                |Affiche les dpendances du paquet    |
|                      |                 |actuellement slectionn.            |
|______________________|_________________|_____________________________________|
|                      |                 |Dans la liste de paquets, alterne les|
|DescriptionCycle      |i                |vues disponibles dans la zone        |
|                      |                 |d'information.                       |
|______________________|_________________|_____________________________________|
|                      |                 |Dans la liste de paquets, descend    |
|DescriptionDown       |z                |d'une ligne dans la zone             |
|                      |                 |d'information.                       |
|______________________|_________________|_____________________________________|
|DescriptionUp         |a                |Dans la liste de paquets, monte d'une|
|                      |                 |ligne dans la zone d'information.    |
|______________________|_________________|_____________________________________|
|                      |                 |En dehors d'un aperu d'installation,|
|DoInstallRun          |g                |affiche cet aperu[a]. Dans un aperu|
|                      |                 |d'installation, lance un processus   |
|                      |                 |d'installation.                      |
|______________________|_________________|_____________________________________|
|                      |                 |Descend : par exemple, descend dans  |
|Down                  |down,j           |un affichage de texte, ou slectionne|
|                      |                 |l'entre suivante dans une liste.    |
|______________________|_________________|_____________________________________|
|DpkgReconfigure       |R                |Lance  dpkg-reconfigure  sur le    |
|                      |                 |paquet actuellement slectionn.     |
|______________________|_________________|_____________________________________|
|                      |                 |Si des paquets sont casss, crit    |
|DumpResolver          |*                |l'tat actuel du solveur de problme |
|                      |                 |dans un fichier (pour des raisons de |
|                      |                 |dbogage).                           |
|______________________|_________________|_____________________________________|
|EditHier              |E                |Ouvre l'diteur hirarchique.        |
|______________________|_________________|_____________________________________|
|                      |                 |Se dplace  la fin de l'affichage   |
|End                   |end,C-e          |courant :  la fin de la liste ou   |
|                      |                 |droite d'un champ de saisie de texte.|
|______________________|_________________|_____________________________________|
|                      |                 |Si des paquets sont casss et        |
|                      |                 |qu'aptitude a suggr une solution au|
|ExamineSolution       |e                |problme, affiche une bote de       |
|                      |                 |dialogue contenant une description   |
|                      |                 |dtaille de la solution.            |
|______________________|_________________|_____________________________________|
|                      |                 |Dploie toute l'arborescence         |
|ExpandAll             |[                |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Dploie la racine de l'arborescence  |
|ExpandTree            |Aucune squence  |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|FirstSolution         |<                |Slectionne la premire solution     |
|                      |                 |gnre par le solveur de problme.  |
|______________________|_________________|_____________________________________|
|                      |                 |Interdit  un paquet d'tre mis     |
|ForbidUpgrade         |F                |jour vers la version actuelle d'un   |
|                      |                 |paquet (ou une version particulire).|
|______________________|_________________|_____________________________________|
|                      |                 |Oublie quels paquets sont            |
|ForgetNewPackages     |f                | nouveaux  (ce qui implique que la |
|                      |                 |liste des  nouveaux  paquets       |
|                      |                 |devienne vide).                      |
|______________________|_________________|_____________________________________|
|Help                  |?                |Affiche l'aide en ligne  l'cran.   |
|______________________|_________________|_____________________________________|
|                      |                 |Dans un diteur comportant un        |
|HistoryNext           |down,C-n         |historique, descend dans             |
|                      |                 |l'historique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Dans un diteur comportant un        |
|HistoryPrev           |up,C-p           |historique, remonte dans             |
|                      |                 |l'historique.                        |
|______________________|_________________|_____________________________________|
|Hold                  |=                |Gle un paquet.                      |
|______________________|_________________|_____________________________________|
|Install               |+                |Marque un paquet pour installation.  |
|______________________|_________________|_____________________________________|
|                      |                 |Marque un unique paquet pour         |
|InstallSingle         |I                |installation. Tous les autres paquets|
|                      |                 |sont gards dans leur version        |
|                      |                 |actuelle.                            |
|______________________|_________________|_____________________________________|
|Keep                  |:                |Annule toute demande d'installation  |
|                      |                 |ou de suppression d'un paquet.       |
|______________________|_________________|_____________________________________|
|LastSolution          |<                |Slectionne la dernire solution     |
|                      |                 |gnre par le solveur de problme.  |
|______________________|_________________|_____________________________________|
|                      |                 |Se dplace vers la gauche : par      |
|                      |                 |exemple, se dplace vers la gauche   |
|Left                  |left,h           |dans la barre de menu, ou dplace le |
|                      |                 |curseur vers la gauche lors de la    |
|                      |                 |saisie de texte.                     |
|______________________|_________________|_____________________________________|
|                      |                 |Dans une liste hirarchique,         |
|                      |                 |slectionne l'enfant suivant l'entre|
|LevelDown             |J                |actuellement slectionne (l'entre  |
|                      |                 |suivante au mme niveau avec le mme |
|                      |                 |parent).                             |
|______________________|_________________|_____________________________________|
|                      |                 |Dans une liste hirarchique,         |
|                      |                 |slectionne l'enfant prcdent       |
|LevelUp               |K                |l'entre actuellement slectionne   |
|                      |                 |(l'entre prcdente au mme niveau  |
|                      |                 |avec le mme parent).                |
|______________________|_________________|_____________________________________|
|                      |                 |Tente de mettre  jour tous les      |
|MarkUpgradable        |U                |paquets qui ne sont pas bloqus ou   |
|                      |                 |interdits de mise  jour.            |
|______________________|_________________|_____________________________________|
|MineFlagSquare        |f                |Dans le dmineur, place ou enlve le |
|                      |                 |drapeau d'une case.                  |
|______________________|_________________|_____________________________________|
|MineLoadGame          |L                |Charge une partie de dmineur.       |
|______________________|_________________|_____________________________________|
|MineSaveGame          |S                |Sauvegarde une partie de dmineur.   |
|______________________|_________________|_____________________________________|
|MineSweepSquare       |Aucune squence  |Fait le mnage autour de la case     |
|                      |                 |actuelle dans le dmineur.           |
|______________________|_________________|_____________________________________|
|MineUncoverSquare     |Aucune squence  |Dcouvre la case actuelle dans le    |
|                      |                 |dmineur                             |
|______________________|_________________|_____________________________________|
|                      |                 |Dcouvre la case actuelle dans le    |
|MineUncoverSweepSquare|enter            |dmineur si elle est couverte, sinon |
|                      |                 |fait le mnage autour d'elle.        |
|______________________|_________________|_____________________________________|
|NextPage              |pagedown,C-f     |Va  la page suivante de l'affichage |
|                      |                 |courant.                             |
|______________________|_________________|_____________________________________|
|NextSolution          |.                |Va  la solution suivante du solveur |
|                      |                 |de dpendance.                       |
|______________________|_________________|_____________________________________|
|No                    |n[b]             |Slectionne la rponse  non  dans  |
|                      |                 |une bote de dialogue oui/non.       |
|______________________|_________________|_____________________________________|
|                      |                 |Slectionne le parent de l'entre    |
|Parent                |^                |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|PrevPage              |pageup,C-b       |Va  la page prcdente de           |
|                      |                 |l'affichage courant.                 |
|______________________|_________________|_____________________________________|
|PrevSolution          |,                |Revient  la solution prcdente du  |
|                      |                 |solveur de dpendance.               |
|______________________|_________________|_____________________________________|
|Purge                 |_                |Marque le paquet actuellement        |
|                      |                 |slectionn pour purge.              |
|______________________|_________________|_____________________________________|
|                      |                 |Active le bouton actuellement        |
|PushButton            |space,enter      |slectionn, ou modifie l'tat d'une |
|                      |                 |bote  cocher.                      |
|______________________|_________________|_____________________________________|
|Quit                  |q                |Ferme la vue actuelle.               |
|______________________|_________________|_____________________________________|
|QuitProgram           |Q                |Quitte le programme.                 |
|______________________|_________________|_____________________________________|
|                      |                 |Reject all resolver actions that     |
|RejectBreakHolds      |                 |would break a hold; equivalent to    |
|                      |                 |Resolver &#8594; Reject Breaking     |
|                      |                 |Holds.                               |
|______________________|_________________|_____________________________________|
|Refresh               |C-l              |Redessine la totalit de l'cran.    |
|______________________|_________________|_____________________________________|
|Remove                |-                |Marque un paquet pour suppression.   |
|______________________|_________________|_____________________________________|
|ReInstall             |L                |Marque le paquet actuellement        |
|                      |                 |slectionn pour rinstallation.     |
|______________________|_________________|_____________________________________|
|RepeatSearchBack      |N                |Rpte la dernire recherche, mais   |
|                      |                 |dans la direction oppose.           |
|______________________|_________________|_____________________________________|
|ReSearch              |n                |Rpte la dernire recherche.        |
|______________________|_________________|_____________________________________|
|ReverseDependencies   |r                |Affiche les paquets qui dpendent du |
|                      |                 |paquet actuellement slectionn.     |
|______________________|_________________|_____________________________________|
|                      |                 |Se dplace vers la droite : par      |
|                      |                 |exemple, se dplace vers la droite   |
|Right                 |right,l          |dans la barre de menu, ou dplace le |
|                      |                 |curseur vers la droite lors de la    |
|                      |                 |saisie de texte.                     |
|______________________|_________________|_____________________________________|
|SaveHier              |S                |Dans l'diteur de hirarchie,        |
|                      |                 |sauvegarde la hirarchie actuelle.   |
|______________________|_________________|_____________________________________|
|                      |                 |Active la fonction de  recherche   |
|Search                |/                |sur l'lment de l'interface         |
|                      |                 |actuellement actif.                  |
|______________________|_________________|_____________________________________|
|                      |                 |Active la fonction de  recherche    |
|SearchBack            |\                |arrire  sur l'lment de           |
|                      |                 |l'interface actuellement actif.      |
|______________________|_________________|_____________________________________|
|SearchBroken          |b                |Dans une arborescence de paquets,    |
|                      |                 |recherche le paquet cass suivant.   |
|______________________|_________________|_____________________________________|
|SetAuto               |M                |Marque le paquet courant comme ayant |
|                      |                 |t automatiquement install.        |
|______________________|_________________|_____________________________________|
|                      |                 |Dans une liste de paquets, dfinit si|
|ShowHideDescription   |D                |la zone d'information est visible ou |
|                      |                 |non.                                 |
|______________________|_________________|_____________________________________|
|                      |                 |Lors de l'affichage d'une solution,  |
|                      |                 |marque l'action actuellement         |
|SolutionActionApprove |a                |slectionne comme  approuve      |
|                      |                 |(elle sera, autant que possible,     |
|                      |                 |incluse dans les prochaines          |
|                      |                 |solutions).                          |
|______________________|_________________|_____________________________________|
|                      |                 |Lors de l'affichage d'une solution,  |
|                      |                 |marque l'action actuellement         |
|SolutionActionReject  |r                |slectionne comme  rejet  (les   |
|                      |                 |prochaines solutions ne la           |
|                      |                 |contiendront pas).                   |
|______________________|_________________|_____________________________________|
|                      |                 |Dploie ou rduit l'arborescence     |
|ToggleExpanded        |enter            |actuellement slectionne dans une   |
|                      |                 |liste hirarchique.                  |
|______________________|_________________|_____________________________________|
|ToggleMenuActive      |C-m,f10,C-space  |Active ou dsactive le menu          |
|                      |                 |principal.                           |
|______________________|_________________|_____________________________________|
|                      |                 |Cancels the last action, up to when  |
|Undo                  |C-_,C-u          |aptitude was started OR the last time|
|                      |                 |you update the package lists or      |
|                      |                 |installed packages.                  |
|______________________|_________________|_____________________________________|
|                      |                 |Monte : par exemple, dans un cran de|
|Up                    |up,k             |slection, va au texte prcdent, ou |
|                      |                 |dans une liste, va  l'entre        |
|                      |                 |prcdente.                          |
|______________________|_________________|_____________________________________|
|                      |                 |Met  jour la liste de paquets en    |
|UpdatePackageList     |u                |tlchargeant de nouvelles listes    |
|                      |                 |depuis Internet si ncessaire.       |
|______________________|_________________|_____________________________________|
|Versions              |v                |Affiche les versions disponibles du  |
|                      |                 |paquet actuellement slectionn.     |
|______________________|_________________|_____________________________________|
|                      |                 |Cette squence va slectionner le    |
|Yes                   |y [b]            |bouton  Oui  dans les botes de    |
|                      |                 |dialogue oui/non.                    |
|______________________|_________________|_____________________________________|
|[a]  moins que Aptitude::Display-Planned-Action soit  false  (faux).       |
|                                                                              |
|[b] Cette valeur par dfaut peut varier suivant la locale (c'est--dire la    |
|langue du systme).                                                           |
|______________________________________________________________________________|

En plus des touches de lettres, chiffres et ponctuations, les touches
 spciales  suivantes peuvent tre lies dans une squence :

 ____________________________________________________________________________
|Nom de la touche|Description                                                |
|________________|___________________________________________________________|
|a1              |Touche A1.                                                 |
|________________|___________________________________________________________|
|a3              |Touche A3.                                                 |
|________________|___________________________________________________________|
|b2              |Touche B2.                                                 |
|________________|___________________________________________________________|
|backspace       |Touche Retour Arrire.                                     |
|________________|___________________________________________________________|
|backtab         |Touche Tabulation Arrire.                                 |
|________________|___________________________________________________________|
|begin           |Touche Begin (pas Origine, c'est--dire  Home ).         |
|________________|___________________________________________________________|
|break           |Touche  break .                                          |
|________________|___________________________________________________________|
|c1              |Touche C1.                                                 |
|________________|___________________________________________________________|
|c3              |Touche C3.                                                 |
|________________|___________________________________________________________|
|cancel          |Touche Annuler ( Cancel ).                               |
|________________|___________________________________________________________|
|create          |Touche Cration ( Create ).                              |
|________________|___________________________________________________________|
|                |Virgule (,) -- notez que, comme les virgules sont utilises|
|comma           |pour lister les squences, c'est l'unique moyen de lier une|
|                |virgule dans une squence de touches.                      |
|________________|___________________________________________________________|
|command         |Touche Retour Arrire.                                     |
|________________|___________________________________________________________|
|copy            |Touche Copier.                                             |
|________________|___________________________________________________________|
|delete          |Touche Supprime.                                           |
|________________|___________________________________________________________|
|delete_line     |Touche  delete line .                                    |
|________________|___________________________________________________________|
|down            |Touche flche  bas .                                     |
|________________|___________________________________________________________|
|end             |Touche Fin.                                                |
|________________|___________________________________________________________|
|entry           |Touche Entre.                                             |
|________________|___________________________________________________________|
|exit            |Touche Sortie ( Exit ).                                  |
|________________|___________________________________________________________|
|f1, f2, ..., f10|Les touches F1  F10.                                      |
|________________|___________________________________________________________|
|find            |Touche Recherche.                                          |
|________________|___________________________________________________________|
|home            |Touche Origine.                                            |
|________________|___________________________________________________________|
|insert          |Touche Insrer.                                            |
|________________|___________________________________________________________|
|insert_exit     |Touche  insert exit .                                    |
|________________|___________________________________________________________|
|clear           |Touche  clear .                                          |
|________________|___________________________________________________________|
|clear_eol       |Touche  clear to end of line .                           |
|________________|___________________________________________________________|
|clear_eos       |Touche  clear to end of screen .                         |
|________________|___________________________________________________________|
|insert_line     |Touche  insert line .                                    |
|________________|___________________________________________________________|
|left            |Touche flche  gauche .                                  |
|________________|___________________________________________________________|
|mark            |Touche Mark.                                               |
|________________|___________________________________________________________|
|message         |Touche Message.                                            |
|________________|___________________________________________________________|
|move            |Touche Move.                                               |
|________________|___________________________________________________________|
|next            |Touche Suivant.                                            |
|________________|___________________________________________________________|
|open            |Touche Open.                                               |
|________________|___________________________________________________________|
|previous        |Touche Prcdent.                                          |
|________________|___________________________________________________________|
|print           |Touche Imprimer.                                           |
|________________|___________________________________________________________|
|redo            |Touche Refaire.                                            |
|________________|___________________________________________________________|
|reference       |Touche Rfrence.                                          |
|________________|___________________________________________________________|
|refresh         |Touche Refresh.                                            |
|________________|___________________________________________________________|
|replace         |Touche Replace.                                            |
|________________|___________________________________________________________|
|restart         |Touche Restart.                                            |
|________________|___________________________________________________________|
|resume          |Touche Resume.                                             |
|________________|___________________________________________________________|
|return          |Touche Retour.                                             |
|________________|___________________________________________________________|
|right           |Touche flche  droite .                                  |
|________________|___________________________________________________________|
|save            |Touche Save.                                               |
|________________|___________________________________________________________|
|scrollf         |Touche  scroll forward .                                 |
|________________|___________________________________________________________|
|scrollr         |Touche  scroll backward .                                |
|________________|___________________________________________________________|
|select          |Touche Select.                                             |
|________________|___________________________________________________________|
|suspend         |Touche Suspend.                                            |
|________________|___________________________________________________________|
|pagedown        |Touche  Page Suivante .                                  |
|________________|___________________________________________________________|
|pageup          |Touche  Page Prcdente .                                |
|________________|___________________________________________________________|
|space           |Touche Espace.                                             |
|________________|___________________________________________________________|
|tab             |Touche Tab.                                                |
|________________|___________________________________________________________|
|undo            |Touche Annuler.                                            |
|________________|___________________________________________________________|
|up              |Touche flche  haut .                                    |
|________________|___________________________________________________________|

In addition to binding keys globally, it is possible to change key bindings for
one particular part (or domain) of aptitude: for instance, to make Tab the
equivalent of the right arrow key in menu bars, set Aptitude::UI::Keybindings::
Menubar::Right to  tab,right . The following domains are available:

 _____________________________________________________________________________
|Domaine      |Description                                                    |
|_____________|_______________________________________________________________|
|EditLine     |Utilis par les botes de saisie de texte, comme le champ de   |
|             |saisie de la bote de dialogue de  recherche .               |
|_____________|_______________________________________________________________|
|Menu         |Utilis par les onglets de menus.                              |
|_____________|_______________________________________________________________|
|Menubar      |Utilis par la barre de menu du haut de l'cran.               |
|_____________|_______________________________________________________________|
|Minesweeper  |Utilis par le mode dmineur.                                  |
|_____________|_______________________________________________________________|
|             |Utilis par les questions  choix multiples qui apparaissent si|
|MinibufChoice|vous avez choisi de voir des questions apparatre dans la ligne|
|             |d'tat.                                                        |
|_____________|_______________________________________________________________|
|Pager        |Utilis pour afficher un fichier prsent sur le disque (par    |
|             |exemple, le fichier texte d'aide).                             |
|_____________|_______________________________________________________________|
|             |Utilis par les paquets, les arborescences de paquets, les     |
|PkgNode      |versions et les dpendances de paquets quand ils apparaissent  |
|             |dans des listes de paquets.                                    |
|_____________|_______________________________________________________________|
|PkgTree      |Utilis par les listes de paquets.                             |
|_____________|_______________________________________________________________|
|Table        |Utilis par les prsentations d'objets graphiques (par exemple,|
|             |les botes de dialogue).                                       |
|_____________|_______________________________________________________________|
|TextLayout   |Utilis par les affichages formats de texte, tels que les     |
|             |descriptions de paquets.                                       |
|_____________|_______________________________________________________________|
|Tree         |Utilis par tous les affichages d'arborescence (dont les listes|
|             |de paquets pour lesquelles PkgTree reste prpondrant).        |
|_____________|_______________________________________________________________|


Personnaliser la couleur du texte et les styles

Les couleurs et les styles visuels utiliss par aptitude pour l'affichage
peuvent tre personnalises. Chaque lment visuel a un  style  associ qui
dcrit les couleurs et caractristiques visuelles particulires qui sont
utilises pour l'afficher. Les styles prennent la forme d'une liste des
paramtres de couleurs et de caractristiques. Cette liste n'est pas
ncessairement exhaustive, si des couleurs ou caractristiques ne sont pas
spcifies explicitement, leur valeur est prise du contexte d'affichage
environnant. En fait, la plupart des lments visuels possdent un style
 vide  par dfaut.

Vous pouvez changer le contenu d'un style en crant un groupe de configuration
du mme nom dans le fichier de configuration d'apt ou d'aptitude. Par exemple,
le style  MenuBorder  est utilis pour dessiner la bordure autour des menus
droulants. Par dfaut, cette bordure est bleue sur blanc en gras. Mettre le
texte suivant dans le fichier de configuration va le changer en blanc sur cyan :

Aptitude::UI::Styles {
  MenuBorder {fg white; bg cyan; set bold;};
};

Comme vous pouvez le voir, un groupe de configuration de style consiste en une
squence d'instructions. Les catgories gnrales des instructions sont :



  fg couleur
      Utilise la couleur donne pour le texte actif. Une liste des couleurs
      acceptes par aptitude est disponible ci-dessous.


  bg couleur
      Utilise la couleur donne pour le texte inactif. Une liste des couleurs
      acceptes par aptitude est disponible ci-dessous.


  set attribut
      Active l'attribut de texte donn. Une liste des attributs de texte
      accepts par aptitude est disponible ci-dessous.


  clear attribut
      Dsactive l'attribut de texte donn. Une liste des attributs de texte
      accepts par aptitude est disponible ci-dessous.


  flip attribut
      Inverse l'tat de l'attribut de texte donn : s'il est activ dans
      l'lment environnant, il sera dsactiv et inversement. Une liste des
      attributs de texte accepts par aptitude est disponible ci-dessous.


Les couleurs disponibles sont black (noir), blue (bleu), cyan, green (vert),
magenta, red (rouge), white (blanc) et yellow (jaune) [17]. De plus vous pouvez
indiquer default  la place d'une couleur d'arrire plan pour utiliser la
couleur par dfaut du terminal. Cela peut tre la couleur par dfaut, une image,
ou mme la  transparence . Les styles qu'aptitude reconnat sont :



  blink
      Active le clignotement du texte.


  bold
      Rend la couleur du texte du premier plan (ou d'arrire plan si la vido
      inverse est active) plus claire.


  dim
      Peut entraner le texte  tre plus estomp sur certains terminaux. Aucun
      effet n'a t observ sur les terminaux Linux usuels.


  reverse
      Inverse les couleurs d'avant et arrire plan. Beaucoup d'lments visuels
      utilisent cet attribut pour faire des effets de surbrillance.


  standout
      Active le  meilleur mode de surbrillance du terminal . Dans les xterms,
      c'est comparable, mais pas totalement identique  la vido inverse. Le
      comportement des autres terminaux peut varier.


  underline
      Active le soulignement du texte.


Vous pouvez slectionner plusieurs de ces attributs en une fois en les sparant
par des virgules. Par exemple, vous pourriez utiliser set bold,standout;.


 [Note]  Note

         Comme signal ci-dessus, l'interprtation des styles et des attributs
         de texte est hautement dpendant du terminal. Il vous faudra
         certainement exprimenter un peu pour trouver ce que certains
         paramtrages font dans votre terminal.


Les styles suivants peuvent tre personnaliss dans aptitude :

Figure 2.12. Styles personnalisables dans aptitude

 ______________________________________________________________________________
|Style                     |Valeur par dfaut        |Description              |
|__________________________|_________________________|_________________________|
|Bullet                    |fg yellow; set bold;     |Style des puces dans les |
|                          |                         |listes  puces.          |
|__________________________|_________________________|_________________________|
|                          |                         |Style des nouvelles      |
|                          |                         |versions du paquet dans  |
|                          |                         |la vue affichant la liste|
|                          |                         |de modification du       |
|                          |                         |paquet. aptitude ne      |
|ChangelogNewerVersion     |set bold;                |mettra en surbrillance   |
|                          |                         |les nouvelles versions du|
|                          |                         |paquet que si vous avez  |
|                          |                         |le paquet libparse-      |
|                          |                         |debianchangelog-perl     |
|                          |                         |install.                |
|__________________________|_________________________|_________________________|
|Default                   |fg white; bg black;      |Style de base de l'cran.|
|__________________________|_________________________|_________________________|
|DepBroken                 |fg black; bg red;        |Style des dpendances non|
|                          |                         |satisfaites.             |
|__________________________|_________________________|_________________________|
|                          |                         |Style des entres de menu|
|DisabledMenuEntry         |fg black; bg blue; set   |qui sont dsactives et  |
|                          |dim;                     |qui ne peuvent pas tre  |
|                          |                         |utilises.               |
|__________________________|_________________________|_________________________|
|                          |                         |Style utilis pour       |
|                          |                         |indiquer qu'un fichier a |
|                          |                         |t  atteint , c'est--|
|DownloadHit               |fg black; bg green;      |dire, qu'il n'a pas      |
|                          |                         |chang depuis la dernire|
|                          |                         |fois qu'il a t         |
|                          |                         |tlcharg.              |
|__________________________|_________________________|_________________________|
|                          |                         |Style de la barre de     |
|DownloadProgress          |fg blue; bg yellow;      |progression d'un         |
|                          |                         |tlchargement.          |
|__________________________|_________________________|_________________________|
|                          |                         |Style d'une ligne        |
|                          |fg white; bg black; clear|ditable (par exemple la |
|EditLine                  |reverse;                 |zone d'entre dans la    |
|                          |                         |bote de dialogue de     |
|                          |                         |recherche).              |
|__________________________|_________________________|_________________________|
|Error                     |fg white; bg red; set    |Style des messages       |
|                          |bold;                    |d'erreur.                |
|__________________________|_________________________|_________________________|
|Header                    |fg white; bg blue; set   |Style du haut de l'cran.|
|                          |bold;                    |                         |
|__________________________|_________________________|_________________________|
|                          |fg white; bg blue; set   |Style du nom du menu     |
|HighlightedMenuBar        |bold,reverse;            |actuellement slectionn |
|                          |                         |dans la barre de menu.   |
|__________________________|_________________________|_________________________|
|                          |fg white; bg blue; set   |Style de choix           |
|HighlightedMenuEntry      |bold,reverse;            |actuellement slectionn |
|                          |                         |dans un menu.            |
|__________________________|_________________________|_________________________|
|                          |                         |Style de la bote de     |
|MediaChange               |fg yellow; bg red; set   |dialogue utilise pour   |
|                          |bold;                    |demander  l'utilisateur |
|                          |                         |d'insrer un autre CD.   |
|__________________________|_________________________|_________________________|
|MenuBar                   |fg white; bg blue; set   |Style de la barre de     |
|                          |bold;                    |menu.                    |
|__________________________|_________________________|_________________________|
|                          |fg white; bg blue; set   |Style de la bordure      |
|MenuBorder                |bold;                    |entourant un menu        |
|                          |                         |droulant.               |
|__________________________|_________________________|_________________________|
|MenuEntry                 |fg white; bg blue;       |Style de chaque entre   |
|                          |                         |d'un menu droulant.     |
|__________________________|_________________________|_________________________|
|MineBomb                  |fg red; set bold;        |Style des bombes dans le |
|                          |                         |dmineur.                |
|__________________________|_________________________|_________________________|
|MineBorder                |set bold;                |Style de la bordure d'un |
|                          |                         |tableau du dmineur.     |
|__________________________|_________________________|_________________________|
|MineFlag                  |fg red; set bold;        |Style des drapeaux dans  |
|                          |                         |le dmineur.             |
|__________________________|_________________________|_________________________|
|                          |                         |Style du nombre N dans le|
|MineNumberN               |Varis                   |dmineur. N est entre 0  |
|                          |                         |et 8.                    |
|__________________________|_________________________|_________________________|
|                          |                         |Couleur utilise pour    |
|MultiplexTab              |fg white; bg blue;       |afficher les  onglets  |
|                          |                         |autres que celui         |
|                          |                         |actuellement slectionn.|
|__________________________|_________________________|_________________________|
|                          |                         |Couleur utilise pour    |
|MultiplexTabHighlighted   |fg blue; bg white;       |afficher l' onglet     |
|                          |                         |actuellement slectionn.|
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgBroken                 |fg red; flip reverse;    |paquets qui ont des      |
|                          |                         |dpendances non          |
|                          |                         |satisfaites.             |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgBrokenHighlighted      |fg red;                  |paquets en surbrillance  |
|                          |                         |qui ont des dpendances  |
|                          |                         |non satisfaites.         |
|__________________________|_________________________|_________________________|
|                          |                         |Style des paquets qui ne |
|PkgNotInstalled           |                         |sont pas actuellement    |
|                          |                         |installs et qu'il n'est |
|                          |                         |pas prvu d'installer.   |
|__________________________|_________________________|_________________________|
|                          |                         |Style des paquets en     |
|                          |                         |surbrillance qui ne sont |
|PkgNotInstalledHighlighted|                         |pas actuellement         |
|                          |                         |installs et qu'il n'est |
|                          |                         |pas prvu d'installer.   |
|__________________________|_________________________|_________________________|
|                          |                         |Style des paquets qui    |
|                          |                         |sont actuellement        |
|PkgIsInstalled            |set bold;                |installs et sur lesquels|
|                          |                         |aucune action n'est      |
|                          |                         |prvu.                   |
|__________________________|_________________________|_________________________|
|                          |                         |Style des paquets en     |
|                          |                         |surbrillance qui sont    |
|PkgIsInstalledHighlighted |set bold; flip reverse;  |actuellement installs et|
|                          |                         |sur lesquels aucune      |
|                          |                         |action n'est prvu.      |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToDowngrade            |set bold;                |paquets, style des       |
|                          |                         |paquets qu'il est prvu  |
|                          |                         |de mettre  jour.        |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgToDowngradeHighlighted |set bold; flip reverse   |paquets en surbrillance  |
|                          |                         |qu'il est prvu de mettre|
|                          |                         | une version antrieure.|
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToHold                 |fg white; flip reverse;  |paquets, style des       |
|                          |                         |paquets qui sont gels.  |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToHoldHighlighted      |fg white;                |paquets, style des       |
|                          |                         |paquets en surbrillance  |
|                          |                         |qui sont gels.          |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgToInstall              |fg green; flip reverse;  |paquets qu'il est prvu  |
|                          |                         |d'installer (pas de      |
|                          |                         |mettre  jour) ou de     |
|                          |                         |rinstaller.             |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|                          |                         |paquets en surbrillance  |
|PkgToInstallHighlighted   |fg green;                |qu'il est prvu          |
|                          |                         |d'installer (pas de      |
|                          |                         |mettre  jour) ou de     |
|                          |                         |rinstaller.             |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgToRemove               |fg magenta; flip reverse;|paquets qu'il est prvu  |
|                          |                         |de supprimer ou de       |
|                          |                         |purger.                  |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgToRemoveHighlighted    |fg magenta;              |paquets en surbrillance  |
|                          |                         |qu'il est prvu de       |
|                          |                         |supprimer ou de purger.  |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToUpgrade              |fg cyan; flip reverse;   |paquets, style des       |
|                          |                         |paquets qu'il est prvu  |
|                          |                         |de mettre  jour.        |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToUpgradeHighlighted   |fg cyan;                 |paquets, style des       |
|                          |                         |paquets qu'il est prvu  |
|                          |                         |de mettre  jour.        |
|__________________________|_________________________|_________________________|
|                          |                         |Style de l'indicateur    |
|                          |                         |d'avancement tel que     |
|Progress                  |fg blue; bg yellow;      |celui qui apparat lors  |
|                          |                         |du chargement du cache   |
|                          |                         |des paquets.             |
|__________________________|_________________________|_________________________|
|                          |                         |Style des solutions      |
|SolutionActionApproved    |bg green;                |approuves dans une      |
|                          |                         |solution.                |
|__________________________|_________________________|_________________________|
|                          |                         |Style des solutions      |
|SolutionActionRejected    |bg red;                  |rejetes dans une        |
|                          |                         |solution.                |
|__________________________|_________________________|_________________________|
|Status                    |fg white; bg blue; set   |Style de la ligne d'tat |
|                          |bold;                    |en bas de l'cran.       |
|__________________________|_________________________|_________________________|
|                          |                         |Couleur de base de toutes|
|TreeBackground            |                         |les listes et arbres     |
|                          |                         |visuels.                 |
|__________________________|_________________________|_________________________|
|                          |                         |Couleur utilises pour   |
|TrustWarning              |fg red; bg black; set    |afficher les             |
|                          |bold;                    |avertissements concernant|
|                          |                         |les paquets de confiance.|
|__________________________|_________________________|_________________________|




Personnaliser la disposition de l'affichage

Il est possible de rordonner la liste des paquets d'aptitude en apportant les
modifications appropries au fichier de configuration.


lments d'affichage

La disposition est conserve dans le groupe de configuration Aptitude::UI::
Default-Package-View et consiste en une liste d'lments d'affichage :

Nom Type { Row
ligne; Column colonne;
Width largeur; Height
hauteur; options
supplmentaires... };

Cela cre un lment d'affichage nomm Nom dont le type est donn par Type. Les
options Row, Column, Width et Height doivent tre prsentes. Elles dterminent
o l'lment d'affichage est situ. Voyez ci-dessous pour une explication
dtaille sur la manire dont les lments d'affichage sont disposs.

Vous trouverez des exemples concernant la manire de modifier la disposition de
l'affichage en consultant la dfinition du thme par dfaut dans le fichier /
usr/share/aptitude/aptitude-defaults.

Les types d'lments d'affichage suivants sont disponibles :



  Description
      Cet lment d'affichage contient la  zone d'information  (typiquement
      une description du paquet actuellement slectionn).

      L'option PopUpDownKey donne le nom d'une commande clavier qui va montrer
      ou cacher l'lment d'affichage. Par exemple, mettre cette option 
      ShowHideDescription va donner  l'lment d'affichage actuel le mme
      comportement que celui par dfaut pour la zone d'information. L'option
      PopUpDownLinked donne le nom d'un autre lment d'affichage ; l'lment
      courant sera montr ou cach  chaque fois que l'autre lment le sera.


  MainWidget
      C'est une rfrence  l'lment d'affichage  principal  : typiquement
      c'est une liste de paquets. Une disposition d'affichage doit contenir
      exactement un lment MainWidget : pas un de plus, pas un de moins.


  Static
      Zone de l'cran qui affiche du texte ; elle peut contenir du code format
      tel que dcrit dans la section intitule  Personnaliser la manire
      d'afficher les paquets . Le texte  afficher peut tre donn dans
      l'option Columns, ou tre stock dans la variable spcifie par l'option
      ColumnsCfg. La couleur du texte est dtermine par le nom de la couleur
      pass  l'option Color.

      Les objets Static peuvent tre affichs et cachs de la mme manire que
      les objets Description en utilisant les options PopUpDownKey et
      PopUpDownLinked.



Placement des lments d'affichage

Les lments d'affichage sont disposs dans une  table . Le coin suprieur
gauche d'un lment est dans la cellule donne par les options Row et Column
(commenant habituellement  la ligne 0 et la colonne 0 bien que ce ne soit pas
obligatoire). La largeur d'un lment en cellule est donne par son option
Width, et sa hauteur est donne par son option Height.

Une fois que l'lment d'affichage est dispos et qu'il a reu une tendue
initiale  l'cran, il est possible qu'il reste de l'espace. S'il y a de
l'espace libre verticalement chaque ligne contenant un lment d'affichage dont
l'option RowExpand est  true se verra allouer une partie de l'espace libre. De
faon analogue, s'il y a de l'espace libre horizontalement, chaque colonne
contenant un lment d'affichage dont l'option ColExpand est  true se verra
allouer une partie de l'espace libre.

Dans le cas o il n'y a pas assez d'espace, chaque ligne ou colonne dont tous
les objets ont leurs options RowShrink ou ColShrink  true sera rtrcie. S'il
n'y en a pas assez, toutes les lignes et colonnes sont rduites pour s'ajuster 
l'espace disponible.

Si un lment d'affichage n'est pas agrandi, mais ses lignes ou colonnes le
sont, son alignement est dtermin par les options RowAlign et ColAlign. Les
configurer  Left (gauche), Right (droite), Top (haut), Bottom (bas), ou Center
(centr) va indiquer  aptitude o placer l'lment verticalement et
horizontalement.

Par exemple, le groupe de configuration suivant cre un lment statique nomm
 Header  qui est large de trois cellules et qui s'agrandit horizontalement
mais pas verticalement. Il a la mme couleur que les autres lignes d'en-tte et
utilise le format standard des lignes d'en-tte :

Header Static {
  Row 0;
  Column 0;
  Width 3;
  Height 1;

  ColExpand true;
  ColAlign Center;

  RowAlign Center;

  Color ScreenHeaderColor;
  ColumnsCfg HEADER;
};


Rfrence des options de la disposition de l'affichage

Les options suivantes sont disponibles pour les lments d'affichage :



  ColAlign alignement;
      Alignement doit tre Left (gauche), Right (droite), ou Center (centr). Si
      la ligne contenant l'lment d'affichage courant est plus large que
      l'lment lui-mme et que ColExpand est false, l'lment sera plac dans
      la ligne selon la valeur alignement.

      Si cette option est absente, la valeur par dfaut est Left.


  ColExpand true|false;
      Si cette option est mise  true (vrai), la colonne contenant l'lment
      d'affichage se verra allouer une partie de l'espace horizontal libre qui
      serait disponible.

      Si cette option est absente, la valeur par dfaut est false (faux).


  Color couleur;
      Cette option s'applique  l'lment Static. Couleur est le nom d'une
      couleur (par exemple, ScreenStatusColor) qui devrait tre utilis comme
      couleur par dfaut pour afficher l'lment d'affichage.

      Si cette option est absente, la valeur par dfaut est
      DefaultWidgetBackground.


  ColShrink true|false;
      Si cette option est mise  true sur chaque lment d'une colonne et qu'il
      n'y a pas assez d'espace horizontal, la colonne sera rtrcie autant qu'il
      faut pour rentrer dans l'espace disponible. Remarquez qu'une colonne peut
      tre rtrcie mme si ColShrink est false ; cela indique simplement
      qu'aptitude devrait essayer de rduire une colonne particulire avec les
      autres.

      Si cette option est absente, la valeur par dfaut est false (faux).


  Column colonne;
      Spcifie la colonne la plus  gauche pouvant contenir cet lment
      d'affichage.


  Columns format;
      Cette option s'applique aux lments d'affichage Static pour lesquels
      l'option ColumnsCfg n'est pas configure. Elle configure le contenu de
      l'affichage de la ligne d'tat. C'est une chane de format comme dcrit
      dans la section intitule  Personnaliser la manire d'afficher les
      paquets .


  ColumnsCfg HEADER|STATUS|nom;
      Cette option s'applique aux lments d'affichage Static. Il configure le
      format d'affichage de l'lment courant  la valeur d'une autre variable
      de configuration. Si c'est HEADER ou STATUS, les options, respectivement,
      Aptitude::UI::Package-Header-Format et Aptitude::UI::Package-Status-
      Format, sont utilises. Sinon l'option nom est utilise.

      Si cette option est absente, la valeur de l'option Columns est utilise
      pour contrler le contenu de l'lment statique.


  Height hauteur;
      Spcifie la hauteur de l'lment d'affichage courant.


  PopUpDownKey commande;
      Cette option s'applique aux lments d'affichage Description et Static.

      Commande est le nom d'une commande clavier (par exemple,
      ShowHideDescription). Quand cette squence de touches est presse,
      l'lment d'affichage est cach s'il est visible et affich s'il est
      cach.


  PopUpDownLinked lment;
      Cette option s'applique aux lments d'affichage Description et Static.

      lment est le nom d'un lment d'affichage. Quand lment est affich,
      l'lment courant sera affich lui aussi et quand lment est cach,
      l'lment courant sera cach lui aussi.


  Row ligne;
      Spcifie la ligne se trouvant place le plus haut et pouvant contenir cet
      lment d'affichage.


  RowAlign alignement;
      alignement doit tre Top (haut), Bottom (bas) ou Center (centr). Si la
      ligne contenant l'lment d'affichage courant est plus haute que l'lment
      lui-mme et que RowExpand est false, l'lment sera plac dans la ligne
      selon la valeur alignement.

      Si cette option est absente, la valeur de l'option est Top.


  RowExpand true|false;
      Si cette option est mise  true (vrai), la ligne contenant l'lment
      d'affichage se verra allouer une partie de l'espace horizontal libre qui
      serait disponible.

      Si cette option est absente, la valeur par dfaut est false (faux).


  RowShrink true|false;
      Si cette option est mise  true sur chaque lment d'une ligne, et s'il
      n'y a pas assez d'espace horizontal, la ligne sera rtrcie autant qu'il
      faut pour rentrer dans l'espace disponible. Remarquez qu'une ligne peut
      tre rtrcie mme si RowShrink est false ; cela indique simplement
      qu'aptitude devrait essayer de rduire une ligne particulire avec les
      autres.

      Si cette option est absente, la valeur par dfaut est false (faux).


  Visible true|false;
      Configur  false (faux), cet lment d'affichage sera initialement cach.
      Ce n'est probablement utile que combin avec PopUpDownKey et/ou
      PopUpDownLinked.

      Si cette option est absente, la valeur de l'option est true.


  Width largeur;
      Spcifie la largeur de l'lment d'affichage courant.



Rfrence du fichier de configuration


Format du fichier de configuration

Basiquement, le fichier de configuration d'aptitude est une liste de couples
d'options et de leurs valeurs. Chaque ligne du fichier devrait avoir la forme
 Option Valeur;  : par exemple, dans le fichier de configuration, la ligne
suivante met l'option Aptitude::Theme   Dselect .

Aptitude::Theme "Dselect";

Une option peut  contenir  d'autres options si elles sont crites entre
accolades places entre l'option et le point-virgule qui la suit, comme ceci :

Aptitude::UI {
  Package-Status-Format "";
  Package-Display-Format "";
};

Une option qui contient d'autres options est parfois appele groupe. En fait, le
deux-points doubl, qui apparat dans les noms d'options est une manire
simplifie pour indiquer l'inclusion : l'option Aptitude::UI::Default-Grouping
est contenu dans le groupe Aptitude::UI, qui est lui-mme dans le groupe
Aptitude. Ainsi, si vous le souhaitez, vous pourriez configurer cette option 
"" comme cela :

Aptitude {
  UI {
    Default-Grouping "";
  };
};

Pour plus d'informations sur le format du fichier de configuration, consultez la
page de manuel apt.conf(5).


Emplacement des fichiers de configuration

La configuration d'aptitude est lue, dans l'ordre, depuis les sources
suivantes :


  1. Le fichier de configuration de l'utilisateur, ~/.aptitude/config. Ce
     fichier est cras lorsque l'utilisateur modifie la configuration dans le
     menu Options.

  2. Le fichier de configuration du systme, /etc/apt/apt.conf.

  3. Les valeurs par dfaut conserves dans /usr/share/aptitude/aptitude-
     defaults.

  4. Default values built into aptitude.


Quand une option est value, ces sources sont consultes dans l'ordre, et la
premire qui fournit une valeur pour l'option est utilise. Par exemple,
configurer une option dans /etc/apt/apt.conf va craser la valeur par dfaut
d'aptitude pour cette option, mais cela n'crasera pas la configuration de
l'utilisateur dans ~/.aptitude/config.


Options de configuration disponibles

Les options de configuration suivantes sont utilises par aptitude. Notez que ce
ne sont pas les seules options de configuration disponibles ; les options
utilises par le systme apt sous-jacent ne sont pas listes ici. Consultez les
pages de manuel apt(8) et apt.conf(5) pour les informations sur les options
d'apt.

Option:Apt::Install-Recommends

Valeur par dfaut:true

Description: Si cette option est mise  true et si Aptitude::Auto-Install est
aussi  true, installer un nouveau paquet induira l'installation de tous les
paquets qu'il recommande. De plus, si cette option est  true, alors aptitude ne
considrera pas les paquets comme inutiliss (et donc ne le retirera pas
automatiquement) tant qu'un paquet les recommande. Pour plus d'information,
consultez la section intitule  Grer les paquets automatiquement installs .

Option:Aptitude::Allow-Null-Upgrade

Valeur par dfaut:false

Description: Normalement, si vous essayez de dmarrer un processus
d'installation alors qu'aucune action n'est prvue, aptitude affiche un
avertissement et revient  la liste des paquets. Si cette option est true,
aptitude affichera l'aperu d'installation, mme s'il y a des paquets pouvant
tre mis  jour, plutt qu'afficher un rappel concernant la commande Actions
&#8594; Marquer comme tant susceptible de mise  jour (U).

Option:Aptitude::Always-Use-Safe-Resolver

Valeur par dfaut:false

Description: If this option is true, aptitude's command-line actions will always
use a  safe  dependency resolver, as if --safe-resolver had been passed on the
command line.

Option:Aptitude::Autoclean-After-Update

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude fera le mnage parmi les
fichiers obsoltes (consultez Actions &#8594; Enlever les fichiers prims) 
chaque mise  jour de la liste des paquets.

Option:Aptitude::Auto-Install

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude essaiera automatiquement
de satisfaire les dpendances d'un paquet quand vous le slectionnez pour
installation.

Option:Aptitude::Auto-Fix-Broken

Valeur par dfaut:true

Description: Si cette option est mise  false, aptitude demandera la permission
avant de tenter de corriger un paquet cass.

Option:Aptitude::Auto-Upgrade

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude marquera automatiquement
tous les paquets pouvant tre mis  jour pour qu'ils le soient au dmarrage du
programme, comme si vous aviez excut la commande Actions &#8594; Marquer comme
tant susceptible de mise  jour (U).

Option:Aptitude::CmdLine::Always-Prompt

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est   true , aptitude
demandera toujours confirmation avant de commencer  installer ou supprimer des
paquets, mme si la confirmation aurait normalement t saute. C'est quivalent
 l'option -P de la ligne de commande.

Option:Aptitude::CmdLine::Assume-Yes

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est   true , aptitude
agira comme si l'utilisateur rpondait  oui   chaque invite, causant le saut
de la plupart des questions. C'est quivalent  l'option -y de la ligne de
commande.

Option:Aptitude::CmdLine::Disable-Columns

Valeur par dfaut:false

Description: If this option is enabled, the results of command-line searches
(performed via aptitude search) will not be formatted into fixed-width columns
or truncated to the screen width. This is equivalent to the --disable-columns
command-line option.

Option:Aptitude::CmdLine::Download-Only

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est   true , aptitude
tlchargera les paquets sans les installer. C'est quivalent  l'option -d de
la ligne de commande.

Option:Aptitude::CmdLine::Fix-Broken

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est   true , aptitude
sera plus agressif lorsqu'il tentera de corriger les dpendances de paquets
casss. C'est quivalent  l'option -f de la ligne de commande.

Option:Aptitude::CmdLine::Ignore-Trust-Violations

Valeur par dfaut:false

Description: In command-line mode, causes aptitude to ignore the installation of
untrusted packages. This is a synonym for Apt::Get::AllowUnauthenticated.

Option:Aptitude::CmdLine::Package-Display-Format

Valeur par dfaut:%c%a%M %p# - %d#

Description: C'est une chane de format, tel que dcrit dans la section
intitule  Personnaliser la manire d'afficher les paquets , qui est utilise
pour afficher le rsultat d'une recherche en ligne de commande. C'est quivalent
 l'option -F de la ligne de commande.

Option:Aptitude::CmdLine::Package-Display-Width

Valeur par dfaut:

Description: Cette option donne la largeur en caractres avec laquelle les
rsultats des recherches en ligne de commande doivent tre formates. Une chane
vide (la valeur par dfaut, c'est--dire "") indique que les rsultats des
recherches sont formats pour la taille du terminal actuel ou pour un affichage
de 80 colonnes si la taille ne peut pas tre dtermine.

Option:Aptitude::CmdLine::Request-Strictness

Valeur par dfaut:10000

Description: En mode ligne de commande, si des problmes de dpendances sont
rencontrs, aptitude ajoutera cette valeur au score, donn par le solveur de
dpendances, de toute action que vous demandez explicitement.

Option:Aptitude::CmdLine::Resolver-Debug

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est  true, aptitude
affichera normment d'informations pendant les tentatives de rsolutions de
dpendances casses. Comme le nom le suggre, c'est option est principalement
destine  aider au dbogage du solveur de problme.

Option:Aptitude::CmdLine::Resolver-Dump

Valeur par dfaut:

Description: En mode ligne de commande, s'il est ncessaire de rsoudre des
dpendances casses et que cette option contient le nom d'un fichier dans lequel
il est possible d'crire, l'tat du solveur est crit dans ce fichier avant
d'entreprendre toute rsolution.

Option:Aptitude::CmdLine::Resolver-Show-Steps

Valeur par dfaut:false

Description: Quand cette option est  true, une solution en dpendance sera
affiche comme une suite de dpendances individuelles. Par exemple,  wesnoth
depends upon wesnoth-data (= 1.2.4-1) -> installing wesnoth-data 1.2.4-1
(unstable) .

Option:Aptitude::CmdLine::Safe-Upgrade::No-New-Installs

Valeur par dfaut:false

Description: In command-line mode, if this option is true, the safe-upgrade
command will not attempt to resolve dependencies by installing new packages. If
upgrading package A would require package B to be newly installed, package A
will not be upgraded. This corresponds to the command-line option --no-new-
installs.

Option:Aptitude::CmdLine::Show-Deps

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est   true , aptitude
affichera un rsum des dpendances (s'il y en a) lies  l'tat d'un paquet.
C'est quivalent  l'option -D de la ligne de commande.

Option:Aptitude::CmdLine::Show-Size-Changes

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est   true , aptitude
affichera les changements attendus de l'espace disque utilis par chaque paquet.
C'est quivalent  l'option -Z de la ligne de commande.

Option:Aptitude::CmdLine::Show-Versions

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est   true , aptitude
affichera la version d'un paquet qui est sur le point d'tre install ou
supprim. C'est quivalent  l'option -V de la ligne de commande.

Option:Aptitude::CmdLine::Show-Why

Valeur par dfaut:false

Description: In command-line mode, if this option is true, aptitude will display
the manually installed packages that require each automatically installed
package, or the manually installed packages that cause a conflict with each
automatically removed package. This is equivalent to the -W command-line option
and displays the same information you can access via aptitude why or by pressing
i in a package list.

Option:Aptitude::Safe-Resolver::No-New-Installs

Valeur par dfaut:false

Description: If this option is true, then when the  safe  dependency resolver
has been activated via --safe-resolver, the resolver will not be allowed to
install packages that are not currently installed. This is similar to Aptitude::
CmdLine::Safe-Upgrade::No-New-Installs, but applies only to command-line actions
other than safe-upgrade.

Option:Aptitude::Safe-Resolver::No-New-Upgrades

Valeur par dfaut:false

Description: If this option is enabled, then when the  safe  dependency
resolver has been activated via --safe-resolver, the resolver will not be
allowed to resolve dependencies by upgrading packages.

Option:Aptitude::CmdLine::Simulate

Valeur par dfaut:false

Description: This option is deprecated; use Aptitude::Simulate instead. In
command-line mode, causes aptitude to just display the actions that would be
performed (rather than actually performing them); in the visual interface,
causes aptitude to start in read-only mode regardless of whether you are root or
not. This is equivalent to the -s command-line option.

Option:Aptitude::CmdLine::Verbose

Valeur par dfaut:0

Description: Cette option contrle le niveau de verbosit du mode ligne de
commande d'aptitude. Chaque occurrence de l'option -v sur la ligne de commande
ajoute 1  cette valeur.

Option:Aptitude::CmdLine::Visual-Preview

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude va entrer dans le mode
graphique pour afficher l'aperu du processus d'installation et pour tlcharger
les paquets.

Option:Aptitude::Debtags-Binary

Valeur par dfaut:/usr/bin/debtags

Description: The absolute path to the debtags command. If configured with libept
support, aptitude will invoke this program whenever the package lists are
updated, passing it the arguments listed in Aptitude::Debtags-Update-Options.

Option:Aptitude::Debtags-Update-Options

Valeur par dfaut:--local

Description: Additional options to pass to debtags update when invoking it after
the package lists are updated. These are split at whitespace; single and double-
quoted strings are recognized, so setting this to  --vocabulary='/file with a
space  will store the debtags vocabulary in  /file with a space .

Option:Aptitude::Delete-Unused

Valeur par dfaut:true

Description: Si cette option est mise  true, les paquets automatiquement
installs qui ne sont plus ncessaires seront automatiquement supprims. Pour
plus d'informations, consultez la section intitule  Grer les paquets
automatiquement installs .

Option:Aptitude::Delete-Unused-Pattern

Valeur par dfaut:

Description: Obsolte, alias pour Aptitude::Keep-Unused-Pattern. Si Aptitude::
Keep-Unused-Pattern n'est pas paramtre ou paramtre avec une chane vide, la
valeur de cette option de configuration va la supplanter. Sinon Aptitude::
Delete-Unused-Pattern est ignore.

Option:Aptitude::Display-Planned-Action

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude affichera un aperu
d'installation avant de rellement excuter les actions que vous avez demandes.

Option:Aptitude::Forget-New-On-Install

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude videra la liste des
nouveaux paquets  chaque fois que vous installez, mettez  jour ou supprimez
des paquets, comme si vous aviez excut la commande Actions &#8594; Oublier
quels paquets sont nouveaux (f).

Option:Aptitude::Forget-New-On-Update

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude videra la liste des
nouveaux paquets  chaque fois que la liste des paquets est mise  jour, comme
si vous aviez excut la commande Actions &#8594; Oublier quels paquets sont
nouveaux (f).

Option:Aptitude::Get-Root-Command

Valeur par dfaut:su:/usr/bin/su

Description: Cette option dfinit la commande externe qu'aptitude utilisera pour
devenir l'utilisateur root (consultez la section intitule  Devenir
administrateur ( root ) ). Cette option est de la forme protocole:commande.
protocole doit tre soit su ou sudo; Elle dtermine comment aptitude utilise le
programme quand il veut obtenir les privilges du root. Si le protocol est
su,alors commande -c arguments sera utilise pour devenir root. Dans le cas
contraire, aptitude utilise commande arguments. Le premier mot de commande est
le nom du programme qui doit tre utilis, les mots restant sont traits en tant
qu'arguments de ce programme.

Option:Aptitude::Ignore-Recommends-Important

Valeur par dfaut:false

Description: In previous versions of aptitude, the setting Aptitude::Recommends-
Important caused recommendations to be installed automatically, the same way
that Apt::Install-Recommends does today. If this option is set to false and
Aptitude::Recommends-Important is also set to false, aptitude will set Apt::
Install-Recommends to false and set Aptitude::Ignore-Recommends-Important to
true on startup.

Option:Aptitude::Ignore-Old-Tmp

Valeur par dfaut:false

Description: Les anciennes versions d'aptitude craient un rpertoire
~/.aptitude/.tmp qui n'est plus ncessaire. Si ce rpertoire existe et
Aptitude::Ignore-Old-Tmp est  true, aptitude vous demandera s'il faut le
supprimer. Cette option est automatiquement mis  true aprs que vous ayez
rpondu. D'un autre ct, si ce rpertoire n'existe pas, cette option est mise 
false et vous en seriez averti si ce rpertoire venait  rapparatre.

Option:Aptitude::Keep-Recommends

Valeur par dfaut:false

Description: If this option is true, then aptitude will not consider packages to
be unused (and thus will not automatically remove them) as long as any installed
package recommends them, even if Apt::Install-Recommends is false. For more
information, see la section intitule  Grer les paquets automatiquement
installs .

Option:Aptitude::Keep-Suggests

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude ne considrera pas les
paquets comme inutiliss (et donc ne les retirera pas automatiquement) tant
qu'un paquet install les suggre. Pour plus d'informations, consultez la
section intitule  Grer les paquets automatiquement installs .

Option:Aptitude::Keep-Unused-Pattern

Valeur par dfaut:

Description: Si Aptitude::Delete-Unused est  true, seul les paquets inutiliss
qui ne correspondent pas  ce motif (voir la section intitule  Motifs de
recherche ) seront supprims. Si cette option est configure avec une chane
vide (valeur par dfaut), tous les paquets inutiliss sont supprims.

Option:Aptitude::LockFile

Valeur par dfaut:/var/lock/aptitude

Description: A file that will be fcntl-locked to ensure that at most one
aptitude process can modify the cache at once. In normal circumstances, you
should never need to modify this; it may be useful for debugging. Note: if
aptitude complains that it cannot acquire a lock, this is not because the lock
file needs to be deleted. fcntl locks are managed by the kernel and will be
destroyed when the program holding them terminates; failure to acquire the lock
means that another running program is using it!

Option:Aptitude::Log

Valeur par dfaut:/var/log/aptitude

Description: Si cette option est une chane non vide, aptitude journalisera les
installations, suppressions et mises  jour de paquets qu'il effectue. Si la
valeur de Aptitude::Log commence par le caractre  | , le reste de cette
valeur est utilis comme nom d'une commande  travers laquelle le journal est
envoy : par exemple, |mail -s 'Aptitude install run' root enverra le journal au
compte root. Pour journaliser dans plusieurs fichiers ou commandes, vous pouvez
configurer cette option sous la forme d'une liste de cibles pour la
journalisation.

Option:Aptitude::Parse-Description-Bullets

Valeur par dfaut:true

Description: Si cette option est active, aptitude essaiera de dtecter
automatiquement les items d'une liste dans les descriptions de paquets. Cela
amliore gnralement l'affichage des descriptions, mais le formatage des
descriptions d'anciens paquets pourrait tre moins bon quand cette option est 
true plutt qu' false.

Option:Aptitude::Pkg-Display-Limit

Valeur par dfaut:

Description: Filtre par dfaut s'appliquant  la liste des paquets ; consultez
la section intitule  Motifs de recherche  pour plus de dtails sur son
format.

Option:Aptitude::ProblemResolver::Allow-Break-Holds

Valeur par dfaut:false

Description: If this option is set to true, the problem resolver will consider
breaking package holds or installing forbidden versions in order to resolve a
dependency. If it is set to false, these actions will be rejected by default,
although you can always enable them manually (see la section intitule
 Rsoudre les problmes de dpendance ).

Option:Aptitude::ProblemResolver::BreakHoldScore

Valeur par dfaut:-300

Description: How much to reward or penalize solutions that change the state of a
held package or install a forbidden version. Note that unless Aptitude::
ProblemResolver::Allow-Break-Holds is set to true, the resolver will never break
a hold or install a forbidden version unless it has explicit permission from the
user.

Option:Aptitude::ProblemResolver::BrokenScore

Valeur par dfaut:-100

Description: Nombre de points ajout ou retranch aux solutions potentielles en
se basant sur le nombre de dpendances qu'ils cassent. Pour chaque dpendance
casse par une solution possible, ce nombre de points est ajout  son score ;
Gnralement, il s'agit de points ngatifs.

Option:Aptitude::ProblemResolver::Discard-Null-Solution

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude ne suggrera jamais
d'annuler toutes les actions que vous aviez prvues pour rsoudre un problme de
dpendances.

Option:Aptitude::ProblemResolver::EssentialRemoveScore

Valeur par dfaut:-100000

Description: Nombre de points ajout ou retir au score des solutions supprimant
un paquet  essentiel .

Option:Aptitude::ProblemResolver::ExtraScore

Valeur par dfaut:-1

Description: Ce nombre de points sera ajout au score de toute version d'un
paquet dont la priorit est  extra .

Option:Aptitude::ProblemResolver::FullReplacementScore

Valeur par dfaut:500

Description: Removing a package and installing another package that fully
replaces it (i.e., conflicts with it, replaces it, and provides it) is assigned
this score.

Option:Aptitude::ProblemResolver::ImportantScore

Valeur par dfaut:5

Description: Ce nombre de points sera ajout au score de toute version d'un
paquet dont la priorit est  important .

Option:Aptitude::ProblemResolver::Infinity

Valeur par dfaut:1000000

Description: Score  maximum , surnomm infini, pour les solutions
potentielles : si un ensemble d'actions  un score pire que -infini, il sera
cart immdiatement.

Option:Aptitude::ProblemResolver::InstallScore

Valeur par dfaut:-20

Description: Nombre de points que le solveur de problme devrait donner 
l'installation d'un paquet, s'il n'est pas dj prvu de l'installer.

Option:Aptitude::ProblemResolver::KeepScore

Valeur par dfaut:0

Description: Nombre de points que le solveur devrait donner pour garder un
paquet dans son tat actuel, s'il n'est pas dj prvu de garder ce paquet dans
son tat courant.

Option:Aptitude::ProblemResolver::Max-Successors

Valeur par dfaut:0

Description: Quand de nouvelles solutions sont gnres, cette valeur contrle
le temps que durera cette procdure de gnration. Les successeurs sont gnrs
par lot, et ds qu'au moins un et au plus le maximum de noeuds successeurs ont
t gnres, la gnration de n&#339;ud s'arrte. Augmenter cette valeur peut
amliorer le score des premires solutions, mais cela peut aussi faire durer
plus longtemps chaque  tape .

Option:Aptitude::ProblemResolver::NonDefaultScore

Valeur par dfaut:-40

Description: Nombre de points que le solveur de problme devrait donner 
l'installation d'une version d'un paquet autre que celle par dfaut (une qui
n'est ni la version actuelle, ni la  version candidate ).

Option:Aptitude::ProblemResolver::OptionalScore

Valeur par dfaut:1

Description: Ce nombre de points sera ajout au score de toute version d'un
paquet dont la priorit est  optionnel .

Option:Aptitude::ProblemResolver::PreserveAutoScore

Valeur par dfaut:0

Description: Nombre de points que le solveur de problme devrait donner  la
prservation des installations et suppressions automatiques.

Option:Aptitude::ProblemResolver::PreserveManualScore

Valeur par dfaut:60

Description: Nombre de points que le solveur de problme devrait donner  la
prservation des actions explicitement slectionnes par l'utilisateur.

Option:Aptitude::ProblemResolver::RemoveScore

Valeur par dfaut:-300

Description: Nombre de points que le solveur de problme devrait donner  la
suppression d'un paquet s'il n'est pas dj marqu pour suppression.

Option:Aptitude::ProblemResolver::RequiredScore

Valeur par dfaut:4

Description: Ce nombre de points sera ajout au score de toute version d'un
paquet dont la priorit est  requis .

Option:Aptitude::ProblemResolver::ResolutionScore

Valeur par dfaut:50

Description: En dehors de tout autre facteur, les solutions potentielles qui
rsolvent toutes les dpendances non satisfaites sont rcompenses par ce bonus.

Option:Aptitude::ProblemResolver::StandardScore

Valeur par dfaut:3

Description: Ce nombre de points sera ajout au score de toute version d'un
paquet dont la priorit est  standard .

Option:Aptitude::ProblemResolver::StepLimit

Valeur par dfaut:5000

Description: The maximum number of  steps  which should be performed by the
problem resolver on each attempt to find a solution to a dependency problem.
Decreasing this number will make aptitude  give up  sooner; increasing it will
permit the search for a solution to consume much more time and memory before it
is aborted. Setting StepLimit to 0 will disable the problem resolver entirely.
The default value is large enough to accomodate commonly encountered situations,
while preventing aptitude from  blowing up  if an overly complicated problem
is encountered. (note: this applies only to command-line searches; in the visual
interface, the resolver will continue working until it reaches a solution)

Option:Aptitude::ProblemResolver::StepScore

Valeur par dfaut:70

Description: Nombre de points ajout ou retranch aux solutions potentielles en
se basant sur leur longueur. Pour chaque action comprise dans une solution, ce
nombre de points est ajout  son score ; Plus cette valeur est grande, plus
l'algorithme essaye de favoriser le premier choix plutt que de s'orienter vers
une alternative. Cela permettra d'obtenir plus rapidement une solution, mais qui
risque d'tre de qualit moindre  ce qu'elle aurait pu tre.

Option:Aptitude::ProblemResolver::Trace-Directory

Valeur par dfaut:

Description: If this value is set, then each time the problem resolver produces
a solution, a stripped-down version of the package state sufficient to reproduce
that solution is written to the given file. If Aptitude::ProblemResolver::Trace-
File is also set, the same information will also be written to the trace file.
Trace directories are more transparent than trace files, and are more suitable
for, e.g., including in source trees as test cases.

Option:Aptitude::ProblemResolver::Trace-File

Valeur par dfaut:

Description: If this value is set, then each time the problem resolver produces
a solution, a stripped-down version of the package state sufficient to reproduce
that solution is written to the given file. If Aptitude::ProblemResolver::Trace-
Directory is also set, the same information will also be written to the trace
directory. A trace file is simply a compressed archive of a trace directory; it
will take less space than the trace directory and is suitable for transmission
over a network.

Option:Aptitude::ProblemResolver::UndoFullReplacementScore

Valeur par dfaut:-500

Description: Installing a package and removing another package that fully
replaces it (i.e., conflicts with it, replaces it, and provides it) is assigned
this score.

Option:Aptitude::ProblemResolver::UnfixedSoftScore

Valeur par dfaut:-200

Description: Nombre de points ajout ou retranch aux solutions potentielles qui
laissent une recommandation (champ  Recommande ) non satisfaite. Il est
gnralement plus petit que  RemoveScore , car sinon aptitude pourrait
supprimer des paquets plutt que de laisser leurs recommandations non
satisfaites. Consultez la section intitule  Rsoudre les problmes de
dpendance  pour plus de dtails.

Option:Aptitude::ProblemResolver::UpgradeScore

Valeur par dfaut:0

Description: Quel nombre de points le solveur de problme devrait donner  la
monte (ou la descente) en version vers la version candidate du paquet, s'il
n'est pas dj prvu de le mettre  jour.

Option:Aptitude::ProblemResolver::WaitSteps

Valeur par dfaut:50

Description: Le nombre d'tapes  effectuer par le solveur au premier plan avant
de replacer la rsolution en tche de fond. L'interface d'aptitude est fig
pendant le calcul, diminuer cette valeur rend le programme plus ractif, mais
peut entraner l'apparition inutile de l'indicateur d'avancement.

Option:Aptitude::Purge-Unused

Valeur par dfaut:false

Description: Si cette option est mise  true et si Aptitude::Delete-Unused est
aussi  true, les paquets qui ne sont plus utiliss seront purg du systme, en
supprimant leurs fichiers de configuration et peut-tre des donnes importantes.
Pour plus d'informations sur les paquets considrs comme  inutilis ,
consultez la section intitule  Grer les paquets automatiquement installs .
CETTE OPTION PEUT ENTRANER DES PERTES DE DONNES ! NE L'ACTIVEZ QUE SI VOUS
SAVEZ CE QUE VOUS FAITES !

Option:Aptitude::Recommends-Important

Valeur par dfaut:true

Description: This is an obsolete configuration option that has been superseded
by Apt::Install-Recommends. On startup, aptitude will copy Aptitude::Recommends-
Important (if it exists) to Apt::Install-Recommends and then clear Aptitude::
Recommends-Important in your user configuration file.

Option:Aptitude::Sections::Top-Sections

Valeur par dfaut:"main"; "contrib"; "non-free"; "non-US";

Description: A configuration group whose elements are the names of the top-level
archive sections. The  topdir ,  subdir , and  subdirs  grouping policies
use this list to interpret Section fields: if the first path element of a
package's Section is not contained in this list, or if its Section has only one
element, then the package will be grouped using the first member of this list as
its first path element. For example, if the first member of Top-Sections is
 main , then a package whose Section is  games  will be treated as if its
Section field were  games/arcade .

Option:Aptitude::Sections::Descriptions

Valeur par dfaut:See $prefix/share/aptitude/section-descriptions

Description: This option is a group whose members define the descriptions
displayed for each section when using the  section  package hierarchy grouping
policy. Descriptions are assigned to section trees based on the last component
of the name: for instance, a member of this group named  games  will be used
to describe the Sections  games ,  non-free/games , and  non-free/desktop/
games . Within the text of section descriptions, the string  \n  will be
replaced by a line-break, and the string  ''  will be replaced by a double-
quote character.

Option:Aptitude::Simulate

Valeur par dfaut:false

Description: In command-line mode, causes aptitude to just display the actions
that would be performed (rather than actually performing them); in the visual
interface, causes aptitude to start in read-only mode regardless of whether you
are root or not. This is equivalent to the -s command-line option.

Option:Aptitude::Spin-Interval

Valeur par dfaut:500

Description: Nombre de millisecondes d'attente entre la mise  jour du
 spinner  qui apparat pendant le fonctionnement du solveur.

Option:Aptitude::Suggests-Important

Valeur par dfaut:false

Description: This is an obsolete option; use Aptitude::Keep-Suggests instead.
Setting this option to true has the same effect as setting Aptitude::Keep-
Suggests to true.

Option:Aptitude::Suppress-Read-Only-Warning

Valeur par dfaut:false

Description: If this option is false, aptitude will display a warning the first
time that you attempt to modify package states while aptitude is in read-only
mode.

Option:Aptitude::Theme

Valeur par dfaut:

Description: Thme qu'aptitude doit utiliser. Consultez la section intitule
 Thmes  pour plus d'informations.

Option:Aptitude::Track-Dselect-State

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude essaiera de dtecter si
un changement a t apport  l'tat du paquet par l'utilisation de dselect ou
dpkg : par exemple, si vous supprimez un paquet avec dpkg, aptitude n'essaiera
pas de le rinstaller. Notez que cela peut ne pas toujours fonctionner
parfaitement.

Option:Aptitude::UI::Advance-On-Action

Valeur par dfaut:false

Description: Si cette option est mise  true, changer l'tat d'un paquet (par
exemple, le marquer pour installation) basculera la mise en surbrillance vers le
prochain paquet dans le groupe courant.

Option:Aptitude::UI::Auto-Show-Reasons

Valeur par dfaut:true

Description: Si cette option est mise  true, slectionner un paquet qui est
cass, ou qui semble avoir cass d'autres paquets, va entraner l'affichage dans
la zone d'information des raisons expliquant pourquoi ce paquet est cass.

Option:Aptitude::UI::Default-Grouping

Valeur par dfaut:filter(missing),status,section(subdirs,passthrough),section
(topdir)

Description: Configure la politique de regroupement par dfaut utilise pour la
liste des paquets. Consultez la section intitule  Personnaliser la hirarchie
des paquets  pour des informations supplmentaires sur les politiques de
regroupement.

Option:Aptitude::UI::Default-Package-View

Valeur par dfaut:

Description: Cette option est un groupe dont les membres dfinissent l'apparence
par dfaut de l'affichage d'aptitude. Consultez la section intitule
 Personnaliser la disposition de l'affichage  pour plus d'informations.

Option:Aptitude::UI::Default-Preview-Grouping

Valeur par dfaut:action

Description: Configure la politique de regroupement par dfaut utilise pour les
crans d'aperu. Consultez la section intitule  Personnaliser la hirarchie
des paquets  pour des informations supplmentaires sur les politiques de
regroupement.

Option:Aptitude::UI::Default-Sorting

Valeur par dfaut:name

Description: Configure la politique de tri par dfaut des vues de paquets.
Consultez la section intitule  Personnaliser la manire de trier les paquets 
pour plus d'informations.

Option:Aptitude::UI::Description-Visible-By-Default

Valeur par dfaut:true

Description: Quand une liste de paquets est affiche pour la premire fois, la
zone d'information (qui contient gnralement la description longue du paquet
courant) sera visible si cette option est mise  true et cache si elle est 
false.

Option:Aptitude::UI::Exit-On-Last-Close

Valeur par dfaut:true

Description: Si cette option est mise  true, fermer toutes les vues actives
quittera aptitude. Sinon, aptitude ne quittera pas avant que vous excutiez la
commande Actions &#8594; Quitter (Q). Consultezla section intitule  Travailler
avec plusieurs vues  pour plus d'informations.

Option:Aptitude::UI::Fill-Text

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude formatera les lignes pour
qu'elles occupent exactement la largeur de l'cran.

Option:Aptitude::UI::HelpBar

Valeur par dfaut:true

Description: Si cette option est mise  true, une ligne d'information sur les
raccourcis clavier importants est affiche en haut de l'cran.

Option:Aptitude::UI::Incremental-Search

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude effectuera des recherches
 incrmentales  : pendant que vous tapez le motif de recherche, il cherchera
le paquet suivant qui correspond  ce que vous avez tap jusque l.

Option:Aptitude::UI::InfoAreaTabs

Valeur par dfaut:false

Description: If this option is true, aptitude will display tabs at the top of
the information area (the pane at the bottom of the screen) describing the
different modes the area can be set to.

Option:Aptitude::UI::Keybindings

Valeur par dfaut:

Description: C'est un groupe de configuration dont les membres dfinissent les
relations entre squences de touches et commandes dans aptitude. Pour plus
d'informations, consultez la section intitule  Personnaliser les raccourcis
clavier .

Option:Aptitude::UI::Menubar-Autohide

Valeur par dfaut:false

Description: Si cette option est mise  true, la barre de menu sera cache
lorsqu'elle ne sera pas utilise.

Option:Aptitude::UI::Minibuf-Download-Bar

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude utilisera un mcanisme
plus discret pour afficher l'avancement des tlchargements : une barre en bas
de l'cran apparatra pour afficher l'tat actuel du tlchargement. Lorsqu'un
tlchargement est actif, appuyer sur q l'annulera.

Option:Aptitude::UI::Minibuf-Prompts

Valeur par dfaut:false

Description: Si cette option est mise  true, certaines questions (comme les
questions oui/non ou  choix multiples) seront affiches en bas de l'cran
plutt que dans une bote de dialogue.

Option:Aptitude::UI::New-Package-Commands

Valeur par dfaut:true

Description: Si cette option est mise  false, des commandes comme Paquet
&#8594; Installer (+) auront le comportement dpass qu'elles avaient dans
d'anciennes versions d'aptitude.

Option:Aptitude::UI::Package-Display-Format

Valeur par dfaut:%c%a%M %p %Z %v %V

Description: Cette option contrle la chane de format utilise pour afficher
les paquets dans les listes de paquets. Pour plus d'informations sur les chanes
de format, consultez la section intitule  Personnaliser la manire d'afficher
les paquets .

Option:Aptitude::UI::Package-Header-Format

Valeur par dfaut:%N %n #%B %u %o

Description: Cette option contrle la chane de format utilise pour afficher la
ligne d'en-tte de la liste des paquets (c'est--dire la ligne qui apparat
entre la liste de paquets et la barre de menu). Pour plus d'informations sur les
chanes de format, consultez la section intitule  Personnaliser la manire
d'afficher les paquets .

Option:Aptitude::UI::Package-Status-Format

Valeur par dfaut:%d

Description: Cette option contrle la chane de format utilise pour afficher la
ligne d'tat de la liste des paquets (c'est--dire la ligne qui apparat entre
la liste de paquets et la zone d'information). Pour plus d'informations sur les
chanes de format, consultez la section intitule  Personnaliser la manire
d'afficher les paquets .

Option:Aptitude::UI::Pause-After-Download

Valeur par dfaut:OnlyIfError

Description: Si cette option est  true, aprs avoir fini de tlcharger les
paquets, aptitude affichera un message demandant si vous souhaitez continuer
l'installation. Si cette option est  OnlyIfError, un message ne sera affich
qu'en cas d'chec du tlchargement. Si cette option est  false, aptitude
enchanera immdiatement avec l'cran suivant  la fin du tlchargement.

Option:Aptitude::Preview-Limit

Valeur par dfaut:

Description: Filtre par dfaut appliqu  l'cran de prvisualisation. Consultez
la section intitule  Motifs de recherche  pour des dtails sur son format.

Option:Aptitude::UI::Prompt-On-Exit

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude affichera une demande de
confirmation avant de quitter.

Option:Aptitude::UI::Styles

Valeur par dfaut:

Description: Ceci est le groupe de configuration dont le contenu dfinit quels
styles textuels aptitude utilise pour afficher l'information. Pour plus
d'informations, consultez la section intitule  Personnaliser la couleur du
texte et les styles .

Option:Aptitude::UI::ViewTabs

Valeur par dfaut:true

Description: Si cette option est mise  false, aptitude n'affichera pas le
bandeau listant les vues actuellement actives en haut de l'cran.

Option:Aptitude::Warn-Not-Root

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude dtectera quand vous avez
besoin des privilges d'administration et vous demandera si vous souhaitez
passer sous le compte administrateur (root) si vous ne l'tes pas dj.
Consultez la section intitule  Devenir administrateur ( root )  pour plus
d'informations.

Option:DebTags::Vocabulary

Valeur par dfaut:/usr/share/debtags/vocabulary

Description: Emplacement du fichier de vocabulaire de debtags utilis pour
charger les mtadonnes des marqueurs du paquet.

Option:Dir::Aptitude::state

Valeur par dfaut:/var/lib/aptitude

Description: Rpertoire dans lequel les informations d'tat persistant
d'aptitude sont conserves.

Option:Quiet

Valeur par dfaut:0

Description: Cette option contrle le niveau de silence de la ligne de commande.
La paramtrer  un niveau plus important dsactive d'avantage les indicateurs
d'avancement.


Thmes

Dans aptitude, un thme est juste un ensemble d'options de configuration. Les
thmes sont utiliss pour venir recouvrir les valeurs par dfaut de certaines
options. Si une option n'est pas configure dans le fichier de configuration du
systme ou dans votre fichier de configuration personnel, aptitude utilisera les
valeurs des options provenant du thme actuel, s'il y en a un de disponible,
avant d'utiliser les valeurs par dfaut standard.

Un thme est simplement un groupe nomm sous Aptitude::Themes dont chacune des
options de configuration recouvrira l'option correspondante de la configuration
globale. Par exemple, si le thme Dselect est slectionn, l'option Aptitude::
Themes::Dselect::Aptitude::UI::Package-Display-Format recouvrira la valeur par
dfaut de l'option Aptitude::UI::Package-Display-Format.

Pour slectionner un thme, donner le nom du thme comme valeur de l'option de
configuration d'Aptitude::Theme. Par exemple :

Aptitude::Theme Vertical-Split;

Les thmes suivants sont fournis avec aptitude dans /usr/share/aptitude/
aptitude-defaults :



  Dselect
      Ce thme donne  aptitude une apparence et un comportement proche du
      vnrable gestionnaire de paquet dselect :

       Actions  Undo  Package  Search  Options  Views  Help
      f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
      --\ Installed Packages
        --\ Priority required
          --\ base - The Debian base system
      c   base  base-file 3.0.16      3.0.16      Debian base system
      miscellaneous fil
      c   base  base-pass 3.5.7       3.5.7       Debian base system master
      password a
      c   base  bash      2.05b-15    2.05b-15    The GNU Bourne Again SHell
      c   base  bsdutils  1:2.12-7    1:2.12-7    Basic utilities from 4.4BSD-
      Lite
      c   base  coreutils 5.0.91-2    5.0.91-2    The GNU core utilities
      c   base  debianuti 2.8.3       2.8.3       Miscellaneous utilities
      specific to
      c   base  diff      2.8.1-6     2.8.1-6     File comparison utilities
      base-files                      installed ; none
      required
      This package contains the basic filesystem hierarchy of a Debian system,
      and
      several important miscellaneous files, such as /etc/debian_version,
      /etc/host.conf, /etc/issue, /etc/motd, /etc/profile, /etc/nsswitch.conf,
      and
      others, and the text of several common licenses in use on Debian systems.







  Vertical-Split
      Ce thme arrange l'affichage de manire  ce que la description du paquet
      actuel s'affiche  droite de la liste des paquets plutt qu'en-dessous de
      cette liste. Ce thme est utile avec des terminaux trs larges, et peut-
      tre aussi lors de l'dition de la hirarchie des paquets intgre.

       Actions  Undo  Package  Search  Options  Views  Help
      f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
      aptitude 0.2.14.1
      --\ Installed Packages                  Modern computers support the
      Advanced  #
        --\ admin - Administrative utilities  Configuration and Power Interface
          --\ main - The main Debian archive  (ACPI) to allow intelligent power
      i   acpid         1.0.3-19   1.0.3-19   management on your system and to
      query
      i   alien         8.44       8.44       battery and configuration status.
      i   anacron       2.3-9      2.3-9
      i   apt-show-vers 0.07       0.07       ACPID is a completely flexible,
      totally
      i A apt-utils     0.5.25     0.5.25     extensible daemon for delivering
      ACPI
      i   apt-watch     0.3.2-2    0.3.2-2    events. It listens on a file
      i   aptitude      0.2.14.1-2 0.2.14.1-2 (/proc/acpi/event) and when an
      event
      i   at            3.1.8-11   3.1.8-11   occurs, executes programs to
      handle the
      i   auto-apt      0.3.20     0.3.20     event. The programs it executes
      are
      i   cron          3.0pl1-83  3.0pl1-83  configured through a set of
      i   debconf       1.4.29     1.4.29     configuration files, which can be
      i   debconf-i18n  1.4.29     1.4.29     dropped into place by packages or
      by
      i A debootstrap   0.2.39     0.2.39     the admin.
      i A deborphan     1.7.3      1.7.3
      i   debtags       0.16       0.16       In order to use this package you
      need a
      i A defoma        0.11.8     0.11.8     recent Kernel (=>2.4.7). This can
      be
      i   discover      2.0.4-5    2.0.4-5    one including the patches on
      Utilities for using ACPI power management



Jouer au dmineur

Au cas o vous seriez fatigu d'installer et supprimer des paquets, aptitude
inclut une version du jeu classique  dmineur . Pour le lancer, slectionner
Actions &#8594; Jouer au dmineur. Le plateau initial du dmineur apparatra
alors :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                              10/10 mines  13 seconds





                                   +--------+
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   +--------+





 l'intrieur du rectangle qui apparat  l'cran sont caches dix mines. Votre
but est de dterminer, grce  votre intuition, votre logique et la chance, o
ces mines se trouvent sans en faire exploser une seule ! Pour ce faire, vous
devez dcouvrir toutes les cases qui ne contiennent pas de mines. Ce faisant,
vous allez obtenir des informations importantes concernant les cases qui
contiennent des mines. Attention tout de mme, dcouvrir une case qui contient
une mine la fera exploser, mettant fin au jeu immdiatement !

Pour dcouvrir une case (et savoir si une mine y est cache), slectionnez la
case avec les flches et appuyer sur Entre :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                             10/10 mines  387 seconds





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |    1...|
                                   | 1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Comme vous pouvez le voir, une partie de la zone cache (vide) du plateau a t
rvle dans cette capture d'cran. Les cases contenant un . sont les cases qui
ne sont adjacentes  aucune mine. Les chiffres dans les autres cases indiquent
combien de mines il y a dans les cases adjacentes.

Si vous pensez savoir o une mine se trouve, vous pouvez placer un drapeau sur
celle-ci. Pour faire cela, slectionner la case suspecte et appuyer sur f. Par
exemple, dans la capture suivante, j'ai dcid que la case sur la partie gauche
de l'cran avait l'air suspecte...

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                              9/10 mines  961 seconds





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |    1...|
                                   |F1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Comme vous pouvez le voir, un F est apparu sur la case slectionne. Il n'est
plus possible de dcouvrir cette case, mme accidentellement, jusqu' ce que le
drapeau soit enlev (en appuyant  nouveau sur f). Une fois que vous avez plac
un drapeau sur toutes les mines qui sont  ct d'une case (par exemple, les
cases avec un 1  ct du drapeau au dessus), pour pouvez  faire le mnage 
autour de la case. Ce n'est qu'une facilit pour dcouvrir toutes les cases
adjacentes ( l'exception de celles contenant un drapeau, bien sr). Par
exemple, faisons le mnage autour du 1 ci-dessus :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                              9/10 mines  2290
seconds





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |221 1...|
                                   |F1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Heureusement, ma supposition sur l'emplacement de cette mine tait bon. Si
j'avais eu tort, j'aurais perdu immdiatement :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                   Minesweeper    Lost in 2388
seconds





                                   +--------+
                                   |^2......|
                                   |^2111...|
                                   |221^1...|
                                   |^1111...|
                                   |11...111|
                                   |...113^ |
                                   |1122* ^ |
                                   | ^ ^   ^|
                                   +--------+





Quand vous avez perdu, l'emplacement de toutes les mines est rvl : les mines
non exploses sont indiques par un accent circonflexe (^), et celle sur
laquelle vous avez  march  est indique par une astrisque (*).



--------------------------------------------------------------------------------
[7]J'ai plaisir  dire que le nombre de ces requtes a fortement diminu juste
aprs la premire parution de ce guide. Esprons qu'il y ait un lien entre ces
deux vnements.

[8]Cela est parfois appel  processus d'installation , mme s'il se peut que
vous mettiez  jour ou supprimiez des paquets en plus d'en installer.

[9]Comme indiqu plus haut, cela n'indique pas que les paquets dans l'archive
sont srs ou non malveillants ; il montre simplement qu'ils sont d'origine.

[10] More precisely: they will be removed when there is no path via Depends,
PreDepends, or Recommends to them from a manually installed package. If
Aptitude::Keep-Suggests is true, a Suggests relationship is also enough to keep
a package installed.

[11] aptitude will only treat the comma as special if there is a second
argument, so (for instance)  ?name(apt,itude)  searches for the string
 apt,itude  in the Name field of packages.

While this behavior is well-defined, it may be surprising; I recommend using
quoted strings for any pattern that contains characters that could have a
special meaning.

[12] Les caractres spciaux des expressions rationnelles sont  + ,  - ,
 . ,  ( ,  ) ,  | ,  [ ,  ] ,  ^ ,  $  et  ? . Remarquez que
certains de ceux-ci sont aussi des caractres spciaux d'aptitude, donc si vous
voulez, par exemple, taper un  |  littral, il vous faudra, le dspcialiser
deux fois comme cela :  \~| .

[13] Les squences d'chappement \\, \n et \t sont galement disponibles.

[14] Astute readers will note that this is essentially a way to explicitly name
the variable in the &#955;-terms corresponding to the term. A typical term would
have the form  &#955; x . name-equals(x, pattern) ; giving this an explicit
target makes x visible in the search language.

[15] This is provided largely for symmetry with ?true.

[16]Actuellement l'tiquetage n'est pas gr, cette commande est destine  un
usage futur.

[17] Sur certains terminaux, un arrire plan  yellow  (jaune) s'affichera en
brun.


Chapitre 3. FAQ d'aptitude


   Quel... est ton nom ?                                                     

   Arthur, roi des Anglais. 

   Quelle... est ta qute ? 

   Je cherche le Saint Graal ! 

   Quelle... est la vitesse d'une hirondelle  vide ? 

   Qu'est-ce que vous voulez dire ? Une hirondelle d'Afrique ou d'Europe ? 

   Euh ? Je ... je n'sais pa--AAAAAAAS ! 

                                                   -- Monty Python, sacr Graal




  3.1. Comment puis-je trouver un paquet par son nom exact ?

  3.2. Comment puis-je trouver les paquets casss ?

  3.3. Je veux slectionner du texte avec la souris, pourquoi aptitude ne me
  laisse-t-il pas faire ?


3.1. Comment puis-je trouver un paquet par son nom exact ?

     Comme signal dans la section intitule  Motifs de recherche , quand vous
     recherchez un paquet par son nom, le texte que vous tapez est en fait une
     expression rationnelle. Donc, le motif de recherche  ^nom$  correspondra
     uniquement au paquet nomm nom.

     Par exemple, vous pouvez rechercher apt (mais pas aptitude ou synaptic) en
     tapant ^apt$. Vous pouvez rechercher g++ (mais pas g++-2.95 ou g++-3.0) en
     tapant ^g\+\+$.

3.2. Comment puis-je trouver les paquets casss ?

     Utiliser la commande Rechercher &#8594; Rechercher les casss (b).

3.3. Je veux slectionner du texte avec la souris, pourquoi aptitude ne me
     laisse-t-il pas faire ?

     Normally, you cannot select text in an xterm while a program running in
     that terminal (such as aptitude) is using the mouse. However, you can
     override this behavior and perform a selection by holding the Shift key
     down while you click on the terminal.



Chapitre 4. Crdits


  Personne ne se rappelle du chanteur. La chanson reste.  

                      -- Terry Pratchett, Le dernier hros


Cette section garde le souvenir des personnes qui ont contribu  aptitude un
jour ou l'autre.


 [Note]  Note

         Cette section est pour le moment plutt incomplte et sera
         vraisemblablement mise  jour et tendue au fur et  mesure (en
         particulier, il manque de nombreux crdits pour les traducteurs du fait
         du grand nombre des sources de traduction[18]). Si vous pensez avoir
         votre place dans cette liste, veuillez envoyez un courriel (en anglais)
          <dburrows@debian.org> en expliquant pourquoi.


Traduction et internationalisation



  Traduction brsilienne
      Andre Luis Lopes, Gustavo Silva


  Traduction chinoise
      Carlos Z.F. Liu


  Traduction tchque
      Miroslav Kure


  Traduction danoise
      Morten Brix Pedersen, Morten Bo Johansen


  Traduction nerlandaise
      Luk Claes


  Traduction finnoise
      Jaakko Kangasharju


  Traduction franaise
      Martin Quinson, Jean-Luc Coulon


  Traduction allemande
      Sebastian Schaffert, Erich Schubert, Sebastian Kapfer, Jens Seidel


  Traduction italienne
      Danilo Piazzalunga


  Traduction japonaise
      Yasuo Eto, Noritada Kobayashi


  Traduction lituanienne
      Darius &#381;itkevicius


  Traduction polonaise
      Michal Politowski


  Traduction portugaise
      Nuno Snica, Miguel Figueiredo


  Traduction norvgienne
      Hvard Korsvoll


  Traduction espagnole
      Jordi Malloch, Ruben Porras


  Traduction sudoise
      Daniel Nylander


  Correctif initial d'internationalisation (i18n)
      Masato Taruishi


  Maintenance et tri de l'i18n
      Christian Perrier


Documentation



  Manuel de l'utilisateur
      Daniel Burrows


Programmation



  Conception et mise en &#339;uvre du programme
      Daniel Burrows


  Gestion du champ Cass pour dpkg.
      Ian Jackson, Michael Vogt




--------------------------------------------------------------------------------
[18] Il devrait tre possible de crer une liste assez complte des
contributeurs de l'internationalisation en se basant sur le ChangeLog, les
rfrences au systme de gestion des bogues Debian et les versions de
l'historique d'aptitude, mais cela demanderait un norme investissement en temps
qui n'est pas possible actuellement.



Rfrence de la ligne de commande

--------------------------------------------------------------------------------
Table des matires



  aptitude --; interface volue pour le gestionnaire de paquets

  aptitude-create-state-bundle --; bundle the current aptitude state

  aptitude-run-state-bundle --; unpack an aptitude state bundle and invoke
  aptitude on it


Nom

aptitude --; interface volue pour le gestionnaire de paquets


Synopsis

aptitude [options...] { autoclean | clean | forget-new | keep-all | update |
safe-upgrade }

aptitude [options...] { changelog | full-upgrade | download | forbid-version |
hold | install | keep-all | markauto | purge | reinstall | remove | show |
unhold | unmarkauto | build-dep | build-depends } packages...

aptitude extract-cache-subset output-directory packages...

aptitude [options...] search motifs...

aptitude [options...] { add-user-tag | remove-user-tag } tag packages...

aptitude [options...] { why | why-not } patterns... package

aptitude [-S fname] [ -u | -i ]

aptitude help


Description

aptitude est une interface en mode texte pour le gestionnaire de paquets de
Debian GNU/Linux.

Elle permet  l'utilisateur de connatre la liste des paquets et de raliser des
tches d'administration comme l'installation, la mise  jour ou l'effacement de
paquets. Ces tches peuvent tre ralises en mode  interactif  ou  partir de
la  ligne de commande .


Commandes en ligne de commande

Le premier argument qui ne commence pas par un tiret ( - ) sera considr
comme tant la commande que le programme doit raliser. Si aucune commande n'est
donne, aptitude dmarrera en mode interactif.

Commandes disponibles :



  install
      Install one or more packages. The packages should be listed after the
       install  command; if a package name contains a tilde character ( ~ )
      or a question mark ( ? ), it will be treated as a search pattern and
      every package matching the pattern will be installed (see the section
       Search Patterns  in the aptitude reference manual).

      Pour slectionner une version prcise d'un paquet, ajoutez  =version  au
      nom du paquet : par exemple,  aptitude install apt=0.3.1 . De la mme
      faon, pour choisir un paquet d'une archive prcise, ajoutez  /archive 
      au nom du paquet : par exemple,  aptitude install apt/experimental .

       Tous les paquets lists sur la ligne de commande ne doivent pas
      ncessairement tre install. Vous pouvez dire  aptitude d'agir
      diffremment avec un paquet en suffixant un  attribut de surcharge  au
      nom du paquet. Par exemple, aptitude remove wesnoth+ installera wesnoth au
      lieu de le supprimer. Les attributs de surcharge suivants sont
      disponibles :



        paquet+
            Installe paquet.


        paquet+M
            Installe paquet et le marque comme install automatiquement (notez
            que si aucun autre paquet ne dpend de paquet, cela entranera sa
            suppression immdiate).


        paquet-
            Supprime paquet.


        paquet_
            Purge paquet : supprime le paquet ainsi que tous ses fichiers de
            configuration.


        paquet=
            Marque paquet comme tant  conserver : annule toute action
            d'installation, de mise  jour ou de suppression, et empche ce
            paquet d'tre mis  jour automatiquement dans le futur.


        paquet:
            Garde paquet  sa version actuelle : annule toute action
            d'installation, de mise  jour ou de suppression. Contrairement 
             hold  (voir ci-dessus), cela n'empche pas ce paquet d'tre mis 
            jour automatiquement dans le futur.


        paquet&M
            Marque paquet comme ayant t install automatiquement.


        paquet&m
            Marque paquet comme ayant t install manuellement.


      Cas particulier,  install  sans autre argument rsoudra les commandes en
      suspens ou diffres.


       [Note]  Note

               Une fois que vous avez appuy sur Y  l'invite de confirmation
               finale, la commande  install  modifie les informations
               enregistres sur les actions qu'aptitude doit raliser. De ce
               fait, si vous lancez la commande  aptitude install toto titi 
               puis que vous arrtiez l'installation alors qu'aptitude a dj
               commenc  tlcharger et installer des paquets, vous devrez
               lancer  aptitude remove toto titi  pour l'annuler.



  remove, purge, hold, unhold, keep, reinstall
      These commands are the same as  install , but apply the named action to
      all packages given on the command line for which it is not overridden. The
      difference between hold and keep is that hold will cause a package to be
      ignored by future safe-upgrade or full-upgrade commands, while keep merely
      cancels any scheduled actions on the package. unhold will allow a package
      to be upgraded by future safe-upgrade or full-upgrade commands, without
      otherwise altering its state.

      Par exemple,  aptitude remove '~ndeity'  supprimera tous les paquets
      dont le nom contient  deity ).


  markauto, unmarkauto
      Indique que les paquets ont t respectivement installs automatiquement,
      ou  la main. Vous pouvez choisir les paquets grce  la syntaxe vue plus
      haut, et mme indiquer les commandes  raliser. Par exemple,  aptitude
      markauto '~slibs'  marquera tous les paquets de la section  libs  comme
      ayant t installs automatiquement.

      Pour plus d'informations sur les paquets installs automatiquement,
      consultez la section  Grer les paquets automatiquement installs  dans
      le manuel de rfrence d'aptitude.


  build-depends, build-dep
      Satisfy the build-dependencies of a package. Each package name may be a
      source package, in which case the build dependencies of that source
      package are installed; otherwise, binary packages are found in the same
      way as for the  install  command, and the build-dependencies of the
      source packages that build those binary packages are satisfied.

      If the command-line parameter --arch-only is present, only architecture-
      dependent build dependencies (i.e., not Build-Depends-Indep or Build-
      Conflicts-Indep) will be obeyed.


  forbid-version
      Empche la mise  jour vers une version prcise d'un paquet. Cette option
      interdit  aptitude la mise  jour automatique vers cette version, mais
      permettra le passage aux versions suivantes. Par dfaut, aptitude choisira
      la version vers laquelle ce paquet aurait normalement d tre mis  jour.
      Vous pouvez modifier ce choix en ajoutant  =version  au nom du paquet :
      par exemple,  aptitude forbid-version vim=1.2.3.broken-4 .

      Cette commande est pratique pour viter les versions bogues des paquets
      sans avoir  dfinir ou supprimer des gels  la main. Si vous dcidez
      finalement d'installer la version que vous aviez interdite, la commande
       install  mettra fin  l'interdiction.


  update
      Met  jour la liste des paquets disponibles sur les serveurs matres.
      (C'est l'quivalent de  apt-get update ).


  safe-upgrade
      Upgrades installed packages to their most recent version. Installed
      packages will not be removed unless they are unused (see the section
       Managing Automatically Installed Packages  in the aptitude reference
      manual). Packages which are not currently installed may be installed to
      resolve dependencies unless the --no-new-installs command-line option is
      supplied.

      It is sometimes necessary to remove one package in order to upgrade
      another; this command is not able to upgrade packages in such situations.
      Use the full-upgrade command to upgrade as many packages as possible.


  full-upgrade
      Upgrades installed packages to their most recent version, removing or
      installing packages as necessary. This command is less conservative than
      safe-upgrade and thus more likely to perform unwanted actions. However, it
      is capable of upgrading packages that safe-upgrade cannot upgrade.


       [Note]  Note

               Cette commande s'appellait dist-upgrade pour des raisons
               historiques, aptitude la reconnait toujours. dist-upgrade est un
               synonyme de full-upgrade.



  keep-all
      Annule toutes les actions prvues sur des paquets. Tout paquet dont l'tat
      indique une action prvue d'installation, de suppression ou de mise  jour
      verra son tat remis  zro.


  forget-new
      Ignore les  nouveaux  paquets (quivaut  presser  f  en mode
      interactif).


  search
      Recherche les paquets qui correspondent  un ou plusieurs motifs donns
      sur la ligne de commande. Tous les paquets correspondant aux expressions
      demandes seront affichs. Par exemple,  aptitude search '~N' edit 
      affichera tous les  nouveaux  paquets et ceux dont le nom contient
       edit . Les expressions de recherche sont expliques en dtail dans
       Motifs de recherche  dans le manuel de rfrence d'aptitude.

      A moins d'avoir invoqu l'option -F, la sortie de la commande aptitude
      search ressemblera  quelque chose comme ceci :

      i   apt                             - Advanced front-end for dpkg

      pi  apt-build                       - frontend to apt to build, optimize
      and in
      cp  apt-file                        - APT package searching utility -
      - command-
      ihA raptor-utils                    - Raptor RDF Parser utilities

      Les rsultats sont prsents ligne par ligne. Le premier caractre de
      chaque ligne indique l'tat courant du paquet : les tats les plus
      courants sont p qui signifie qu'aucune trace du paquet n'est prsente sur
      le systme, c qui signifie que le paquet  t supprim mais que ses
      fichiers de configuration sont toujours prsent sur le systme, i qui
      signifie que le paquet est install et v qui signifie que le paquet est
      virtuel. Le second caractre indique l'action prvue (s'il y en a une, un
      espace sinon) sur le paquet. Les actions les plus courantes sont : i pour
      les paquets sur le point  installer, d pour ceux  supprimer et p pour
      ceux  purger (c--d,  supprimer ainsi que ses fichiers de
      configuration). Si le dernier caractre est un A, le paquet a t install
      automatiquement.

      Pour une liste complte des tats et actions possibles, consultez la
      section  Accder aux informations des paquets  dans le manuel de
      rfrence d'aptitude.


  show
      Displays detailed information about one or more packages, listed following
      the search command. If a package name contains a tilde character ( ~ )
      or a question mark ( ? ), it will be treated as a search pattern and all
      matching packages will be displayed (see the section  Search Patterns 
      in the aptitude reference manual).

      Si le niveau de verbosit est au moins 1 (c'est--dire que l'option -v est
      prsente sur la ligne de commande), les informations sur toutes les
      versions du paquets sont affiches. Sinon, seules les informations sur la
       version installable  sont affiches (la version qui serait tlcharge
      par  aptitude install ).

      Vous pouvez afficher les informations d'une version particulire d'un
      paquet en suffixant =version au nom du paquet ; vous pouvez galement
      afficher les informations sur une version d'une archive particulire en
      suffixant /archive au nom du paquet. Si un des ces arguments est prsent,
      seule la version demande sera affiche, quelque soit le niveau de
      verbosit.

      Si le niveau de verbosit est au moins 1, les champs architecture, taille
      compresse, nom de fichier et somme md5 du paquet sont affichs. Si le
      niveau de verbosit est au moins 2, la ou les versions slectionnes
      seront affiches une fois pour chacune des archives dans lesquelles elles
      sont trouves.


  add-user-tag, remove-user-tag
      Adds a user tag to or removes a user tag from the selected group of
      packages. If a package name contains a tilde ( ~ ) or question mark
      ( ? ), it is treated as a search pattern and the tag is added to or
      removed from all the packages that match the pattern (see the section
       Search Patterns  in the aptitude reference manual).

      User tags are arbitrary strings associated with a package. They can be
      used with the ?user-tag(tag) search term, which will select all the
      packages that have a user tag matching tag.


  why, why-not
      Explains the reason that a particular package should or cannot be
      installed on the system.

      Cette commande cherche les paquets qui dpendent ou sont en conflit avec
      ce paquet. Il affiche la suite de dpendances qui s'enchainent jusqu'au
      paquet vis, et une note indique l'tat de chacun des paquets de la suite
      de dpendances.

      $ aptitude why kdepim
      i   nautilus-data Recommends nautilus
      i A nautilus      Recommends desktop-base (>= 0.2)
      i A desktop-base  Suggests   gnome | kde | xfce4 | wmaker
      p   kde           Depends    kdepim (>= 4:3.4.3)

      The command why finds a dependency chain that installs the package named
      on the command line, as above. Note that the dependency that aptitude
      produced in this case is only a suggestion. This is because no package
      currently installed on this computer depends on or recommends the kdepim
      package; if a stronger dependency were available, aptitude would have
      displayed it.

      A contrario, why-not cherche la chane de dpendances qui conduit au
      conflit avec le paquet cibl.

      $ aptitude why-not textopo
      i   ocaml-core          Depends   ocamlweb
      i A ocamlweb            Depends   tetex-extra | texlive-latex-extra
      i A texlive-latex-extra Conflicts textopo

      If one or more patterns are present, then aptitude will begin its search
      at these patterns; that is, the first package in the chain it prints will
      be a package matching the pattern in question. The patterns are considered
      to be package names unless they contain a tilde character ( ~ ) or a
      question mark ( ? ), in which case they are treated as search patterns
      (see the section  Search Patterns  in the aptitude reference manual).

      If no patterns are present, then aptitude will search for dependency
      chains beginning at manually installed packages. This effectively shows
      the packages that have caused or would cause a given package to be
      installed.


       [Note]  Note

               aptitude why ne ralise par une recherche complte de
               dpendances. Il n'affiche que les relations directes entre
               paquet. Par exemple, si A a besoin de B, que C a besoin de D, et
               que B et C sont en conflit,  aptitude why-not D  ne trouvera
               pas la rponse  A dpend de BB, B est en conflit avec C, et D
               dpend de C .


      Aptitude n'affiche par dfaut que les chanes de dpendances  most
      installed, strongest, tightest, shortest . Dans ce cas, il cherche une
      chane qui ne contient que les paquets qui sont installs ou qui seront
      installs. Il recherche les dpendances les plus fortes possibles dans ce
      cadre, et recherche les chanes qui vitent les dpendances ORed et
      Provides, et il recherche la chane de dpendance la plus courte qui
      respecte ces contraintes. Ces rgles sont appliques de faon de moins en
      moins stricte jusqu' ce qu'une correspondance soit trouve.

      Si le niveau du mode verbeux est  1 ou plus, alors toutes les
      explications qu'aptitude trouvera seront affiches, dans l'ordre de
      pertinence dcroissante. Si le niveau de mode verbeux est de 2 ou plus, un
      trs important niveau d'information de dbogage sera affich sur la sortie
      standard.

      Cette commande renvoie un 0 si elle russit, 1 si aucune explication n'a
      t trouve, et -1 si une erreur apparat.


  clean
      Supprime tous les paquets .deb tlchargs et enregistrs dans le
      rpertoire cache (normalement /var/cache/apt/archives).


  autoclean
      Supprime tout paquet enregistr dans le cache et qui n'est plus propos au
      tlchargement. Cela vous permet d'empcher que le cache ne grossisse
      dmesurment avec le temps, sans avoir  le vider compltement.


  changelog
      Tlcharge et affiche le journal des modifications pour chaque paquet
      source ou binaires.

      Par dfaut, le journal correspondant  la version qui serait install par
       aptitude install  est tlcharg. Vous pouvez slectionner une version
      particulire d'un paquet en suffixant =version au nom du paquet ; vous
      pouvez galement slectionner la version d'une archive particulire en
      suffixant /archive au nom du paquet.


  download
      Downloads the .deb file for the given package to the current directory. If
      a package name contains a tilde character ( ~ ) or a question mark
      ( ? ), it will be treated as a search pattern and all the matching
      packages will be downloaded (see the section  Search Patterns  in the
      aptitude reference manual).

      Par dfaut, le fichier correspondant  la version qui serait install par
       aptitude install  est tlcharg. Vous pouvez slectionner une version
      particulire d'un paquet en suffixant =version au nom du paquet ; vous
      pouvez galement slectionner la version d'une archive particulire en
      suffixant /archive au nom du paquet.


  extract-cache-subset
      Extract a subset of the package cache to the specified directory. If no
      packages are listed, the entire package cache is copied; otherwise only
      the entries corresponding to the named packages are copied. Each package
      name may be a search pattern, and all the packages matching that pattern
      will be selected (see the section  Search Patterns  in the aptitude
      reference manual). Any existing package lists in the output directory will
      be overwritten.

      Dependencies in binary package stanzas will be rewritten to remove
      references to packages not in the selected set.


  help
      Affiche un bref rsum des commandes et options disponibles.



Options

Les options qui suivent peuvent tre utilises afin de modifier le comportement
des commandes ci-dessus. Remarquez que les commandes ne vont pas toutes ragir 
chaque option (en effet, certaines options n'ont aucun sens pour certaines
commandes).



  --add-user-tag tag
      For full-upgrade, forbid-version, hold, install, keep-all, markauto,
      unmarkauto, purge, reinstall, remove, unhold, and unmarkauto: add the user
      tag tag to all packages that are installed, removed, or upgraded by this
      command as if with the add-user-tag command.


  --add-user-tag-to tag,pattern
      For full-upgrade, forbid-version, hold, install, keep-all, markauto,
      unmarkauto, purge, reinstall, remove, unhold, and unmarkauto: add the user
      tag tag to all packages that match pattern as if with the add-user-tag
      command. The pattern is a search pattern as described in the section
       Search Patterns  in the aptitude reference manual.

      For instance, aptitude safe-upgrade --add-user-tag-to "new-
      installs,?action(install) will add the tag new-installs to all the
      packages installed by the safe-upgrade command.


  --allow-new-upgrades
      When the safe resolver is being used (i.e., --safe-resolver was passed or
      Aptitude::Always-Use-Safe-Resolver is set to true), allow the dependency
      resolver to install upgrades for packages even if Aptitude::Safe-
      Resolver::No-New-Upgrades is set.


  --allow-new-installs
      Allow the safe-upgrade command to install new packages; when the safe
      resolver is being used (i.e., --safe-resolver was passed or Aptitude::
      Always-Use-Safe-Resolver is set to true), allow the dependency resolver to
      install new packages. This option takes effect even if Aptitude::Safe-
      Resolver::No-New-Installs is true.


  --allow-untrusted
      Install packages from untrusted sources without prompting. You should only
      use this if you know what you are doing, as it could easily compromise
      your system's security.


  --disable-columns
      This option causes aptitude search to output its results without any
      special formatting. In particular: normally aptitude will add whitespace
      or truncate search results in an attempt to fit its results into vertical
       columns . With this flag, each line will be formed by replacing any
      format escapes in the format string with the correponding text; column
      widths will be ignored.

      For instance, the first few lines of output from  aptitude search -F '%p
      %V' --disable-columns libedataserver  might be:

      disksearch 1.2.1-3
      hp-search-mac 0.1.3
      libbsearch-ruby 1.5-5
      libbsearch-ruby1.8 1.5-5
      libclass-dbi-abstractsearch-perl 0.07-2
      libdbix-fulltextsearch-perl 0.73-10

      As in the above example, --disable-columns is often useful in combination
      with a custom display format set using the command-line option -F.

      This corresponds to the configuration option Aptitude::CmdLine::Disable-
      Columns.


  -D, --show-deps
      For commands that will install or remove packages (install, full-upgrade,
      etc), show brief explanations of automatic installations and removals.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Deps.


  -d, --download-only
      N'installe ni ne supprime aucun paquet. Tlcharge simplement les paquets
      ncessaires dans le cache.

      Directive du fichier de configuration : Aptitude::CmdLine::Download-Only.


   -F format, --display-format format
      Dfinit le format qui sera utilis pour afficher les rsultats de la
      commande search. Par exemple,  %p %V %v  affichera le nom du paquet,
      suivi du numro de la version installe, ainsi que les versions
      disponibles. Pour plus d'informations, consultez la section
       Personnaliser la manire d'afficher les paquets  dans le manuel de
      rfrence d'aptitude.

      The command-line option --disable-columns is often useful in combination
      with -F.

      Directive du fichier de configuration : Aptitude::CmdLine::Package-
      Display-Format.


  -f
      Essaye tmrairement de rsoudre les dpendances des paquets casss, mme
      si cela implique d'ignorer des actions demandes sur la ligne de commande.

      Directive du fichier de configuration : Aptitude::CmdLine::Fix-Broken.


  --full-resolver
      When package dependency problems are encountered, use the default  full 
      resolver to solve them. Unlike the  safe  resolver activated by --safe-
      resolver, the full resolver will happily remove packages to fulfill
      dependencies. It can resolve more situations than the safe algorithm, but
      its solutions are more likely to be undesirable.

      This option can be used to force the use of the full resolver even when
      Aptitude::Always-Use-Safe-Resolver is true. The safe-upgrade command never
      uses the full resolver and does not accept the --full-resolver option.


  -h, --help
      Affiche un court message d'aide. Identique  l'action help.


  --no-new-upgrades
      When the safe resolver is being used (i.e., --safe-resolver was passed or
      Aptitude::Always-Use-Safe-Resolver is set to true), allow the dependency
      resolver to install new packages even if Aptitude::Safe-Resolver::No-New-
      Installs is set.


   --no-new-installs
      Prevent safe-upgrade from installing any new packages; when the safe
      resolver is being used (i.e., --safe-resolver was passed or Aptitude::
      Always-Use-Safe-Resolver is set to true), forbid the dependency resolver
      from installing new packages. This option takes effect even if Aptitude::
      Safe-Resolver::No-New-Installs is true.

      This mimics the historical behavior of apt-get upgrade.

      This corresponds to the configuration option Aptitude::CmdLine::Safe-
      Upgrade::No-New-Installs.


  --purge-unused
      Purge les paquets dont aucun autre paquet install ne dpend. Cela revient
       mettre le paramtre  -o Aptitude::Purge-Unused=true  sur la ligne de
      commande.


  -P, --prompt
      Affiche toujours une invite de commande, mme si aucune autre commande que
      celles explicitement demandes n'est entreprise.

      Directive du fichier de configuration : Aptitude::CmdLine::Always-Prompt.


  -R, --without-recommends
      Ne gre pas les recommandations de dpendances lors de l'installation de
      nouveaux paquets (prioritaire sur les rglages de /etc/apt/apt.conf and
      ~/.aptitude/config). Les paquets installs prcdemment pour ces mme
      raisons de recommandation ne seront pas supprims.

      This corresponds to the pair of configuration options Apt::Install-
      Recommends and Aptitude::Keep-Recommends.


  -r, --with-recommends
      Traite les suggestions ou les recommandations en tant que dpendances lors
      de l'installation des nouveaux paquets. (Prioritaire sur les rglages de /
      etc/apt.conf et ~/.aptitude/config).

      This corresponds to the configuration option Apt::Install-Recommends


  -s, --simulate
      En mode ligne de commande, affiche la liste des actions qui seraient
      ralises, mais ne les lance pas rellement. Il n'est pas ncessaire
      d'avoir les privilges d'administration. Dans l'interface visuelle, ouvre
      toujours le cache en mode lecture seule que vous soyez administrateur ou
      non.

      Directive du fichier de configuration : Aptitude::Simulate.


  --remove-user-tag tag
      For full-upgrade, forbid-version, hold, install, keep-all, markauto,
      unmarkauto, purge, reinstall, remove, unhold, and unmarkauto: remove the
      user tag tag from all packages that are installed, removed, or upgraded by
      this command as if with the add-user-tag command.


  --remove-user-tag-from tag,pattern
      For full-upgrade, forbid-version, hold, install, keep-all, markauto,
      unmarkauto, purge, reinstall, remove, unhold, and unmarkauto: remove the
      user tag tag from all packages that match pattern as if with the remove-
      user-tag command. The pattern is a search pattern as described in the
      section  Search Patterns  in the aptitude reference manual.

      For instance, aptitude safe-upgrade --remove-user-tag-from "not-
      upgraded,?action(upgrade)" will remove the not-upgraded tag from all
      packages that the safe-upgrade command is able to upgrade.


  --safe-resolver
      When package dependency problems are encountered, use a  safe  algorithm
      to solve them. This resolver attempts to preserve as many of your choices
      as possible; it will never remove a package or install a version of a
      package other than the package's default candidate version. It is the same
      algorithm used in safe-upgrade; indeed, aptitude --safe-resolver full-
      upgrade is equivalent to aptitude safe-upgrade. Because safe-upgrade
      always uses the safe resolver, it does not accept the --safe-resolver
      flag.

      This option is equivalent to setting the configuration variable Aptitude::
      Always-Use-Safe-Resolver to true.


  --schedule-only
      Pour les commandes qui modifient l'tat des paquets, programme les actions
       faire pour plus tard, mais ne les fait pas. Vous pouvez excuter les
      actions programmes en lanant aptitude install sans paramtre. Cela
      revient  faire la slection correspondante en mode visuel, puis  quitter
      aptitude normalement.

      Par exemple, aptitude --schedule-only install evolution va programmer
      l'installation future du paquet evolution.


  -t version, --target-release version
      Dfinit la version  partir de laquelle les paquets devront tre
      installs. Par exemple,  aptitude -t exprimental ...  installera les
      paquets de la distribution exprimentale, si rien d'autre n'est prcis.
      Pour les actions de la ligne de commandes  changelog ,  download  et
       show , cela revient  suffixer /version au nom de chaque paquet cit
      sur la ligne de commandes. Pour les autres commandes, cela modifiera la
      version installe par dfaut selon les rgles dcrites dans
      apt_preferences(5).

      Directive du fichier de configuration : APT::Default-Release.


  -O ordre, --sort ordre
      Dfinit l'ordre dans lequel le rsultat de la commande search doit tre
      affich. Par exemple,  installsize  triera les paquets dans l'ordre
      croissant de la taille de leur installation. Pour plus d'informations,
      consultez le chapitre  Personnaliser la manire de trier les paquets 
      dans le manuel de rfrence d'aptitude.


  -o clef=valeur
      Dfinit une option du fichier de configuration  la vole. Utilisez par
      exemple -o Aptitude::Log=/tmp/mes-logs afin de consigner (logs) les
      vnements d'aptitude dans le fichier /tmp/mes-logs. Pour plus
      d'informations sur les options du fichier de configuration, consultez le
      chapitre  Rfrence du fichier de configuration  dans le manuel de
      rfrence d'aptitude.


  -q[=n], --quiet[=n]
      Enlve tous les indicateurs d'avancement et rend ainsi la sortie
      journalisable. Cette option peut tre passe plusieurs fois pour rendre le
      programme de plus en plus silencieux, mais contrairement  apt-get,
      aptitude n'ajoute pas implicitement -y quand -q est passe plus d'une
      fois.

      Le paramtre optionnel =n peut tre utilis pour configurer directement le
      taux de silence (par exemple, pour surcharger un paramtrage dans /etc/
      apt/apt.conf) ; le programme agit alors comme si -q lui avait t passe
      exactement n fois.


  -V, --show-versions
      Indique quelle version du paquet sera installe.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Versions.


  -W, --show-why
      In the preview displayed before packages are installed or removed, show
      which manually installed package requires each automatically installed
      package. For instance:

      $ aptitude --show-why install mediawiki
      ...
      The following NEW packages will be installed:
        libapache2-mod-php5{a} (for mediawiki)  mediawiki  php5{a} (for
      mediawiki)
        php5-cli{a} (for mediawiki)  php5-common{a} (for mediawiki)
        php5-mysql{a} (for mediawiki)

      When combined with -v or a non-zero value for Aptitude::CmdLine::Verbose,
      this displays the entire chain of dependencies that lead each package to
      be installed. For instance:

      $ aptitude -v --show-why install libdb4.2-dev
      The following NEW packages will be installed:
        libdb4.2{a} (libdb4.2-dev D: libdb4.2)  libdb4.2-dev
      The following packages will be REMOVED:
        libdb4.4-dev{a} (libdb4.2-dev C: libdb-dev P<- libdb-dev)

      This option will also describe why packages are being removed, as shown
      above. In this example, libdb4.2-dev conflicts with libdb-dev, which is
      provided by libdb-dev.

      This argument corresponds to the configuration option Aptitude::CmdLine::
      Show-Why and displays the same information that is computed by aptitude
      why and aptitude why-not.


  -v, --verbose
      Force quelques commandes (show par exemple)  afficher des informations
      supplmentaires. Peut tre invoqu plusieurs fois afin d'obtenir des
      informations de plus en plus compltes.

      Directive du fichier de configuration : Aptitude::CmdLine::Verbose.


  --version
      Affiche la version et quelques informations sur l'environnement de
      compilation d'aptitude.


  --visual-preview
      Lance l'interface visuelle et affiche l'cran d'accueil, plutt que
      d'afficher l'habituelle invite de commande en ligne.


  -w largeur, --width largeur
      Dfinit la largeur utilise pour l'affichage du rsultat de la commande
      search. (Par dfaut, c'est la largeur du terminal).

      Directive du fichier de configuration : Aptitude::CmdLine::Package-
      Display-Width


  -y, --assume-yes
      Rpond  oui   toute question de type oui/non. En fait, cette option
      supprime l'invite (le prompt) qui apparat quand on installe, met  jour
      ou supprime des paquets. N'affecte pas les rponses aux questions
      particulirement dangereuses, telles que la suppression des paquets
      essentiels. A priorit sur -P.

      Directive du fichier de configuration : Aptitude::CmdLine::Assume-Yes.


  -Z
      Affiche l'espace disque qui sera utilis ou libr par chacun des paquets
       installer, mettre  jour ou supprimer.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Size-
      Changes.


Les options suivantes s'appliquent au mode visuel du programme. Toutefois, elles
ne sont utilises qu'en interne. Normalement, vous n'en aurez pas besoin.



  -S nom-fichier
      Charge les informations supplmentaires  partir de nom-fichier plutt
      qu' partir du fichier standard.


  -u
      Lance la mise  jour de la liste des paquets ds le dmarrage du
      programme. On ne peut pas se servir en mme temps de cette option et de -
      i.


  -i
      Affiche l'cran de tlchargement au dmarrage du programme (quivalent au
      lancement du programme, puis  l'appui sur  g ). On ne peut pas se
      servir en mme temps de cette option et de -u.



Variables d'environnement



  HOME
      Si $HOME/.aptitude existe, aptitude stockera son fichier de configuration
      dans $HOME/.aptitude/config. Sinon, il recherchera le rpertoire personnel
      de l'utilisateur courant, grce  getpwuid(2) pour y placer son fichier de
      configuration.


  PAGER
      Quand cette variable d'environnement est paramtre, aptitude l'utilisera
      pour afficher les journaux de modification  l'invocation de  aptitude
      changelog . La valeur par dfaut est more.


  TMP
      Quand TMPDIR n'est pas paramtre, aptitude stockera ses fichiers
      temporaires dans TMP si cette dernire variable est paramtre. Sinon, il
      les stockera dans /tmp.


  TMPDIR
      aptitude stockera ses fichiers temporaires dans le rpertoire spcifi par
      cette variable d'environnement. Si TMPDIR n'est pas paramtre, alors TMP
      est utilise. Si cette dernire ne l'est pas non plus, alors aptitude
      utilise /tmp.



Files



  /var/lib/aptitude/pkgstates
      The file in which stored package states and some package flags are stored.




  /etc/apt/apt.conf, /etc/apt/apt.conf.d/*, ~/.aptitude/config
      The configuration files for aptitude. ~/.aptitude/config overrides /etc/
      apt/apt.conf. See apt.conf(5) for documentation of the format and contents
      of these files.



Voir aussi

apt-get(8), apt(8), /usr/share/doc/aptitude/html/lang/index.html du paquet
aptitude-doc-lang

--------------------------------------------------------------------------------

Nom

aptitude-create-state-bundle --; bundle the current aptitude state


Synopsis

aptitude-create-state-bundle [options...] output-file


Description

aptitude-create-state-bundle produces a compressed archive storing the files
that are required to replicate the current package archive state. The following
files and directories are included in the bundle:


* $HOME/.aptitude

* /var/lib/aptitude

* /var/lib/apt

* /var/cache/apt/*.bin

* /etc/apt

* /var/lib/dpkg/status


The output of this program can be used as an argument to aptitude-run-state-
bundle(1).


Options



  --force-bzip2
      Override the autodetection of which compression algorithm to use. By
      default, aptitude-create-state-bundle uses bzip2(1) if it is available,
      and gzip(1) otherwise. Passing this option forces the use of bzip2 even if
      it doesn't appear to be available.


  --force-gzip
      Override the autodetection of which compression algorithm to use. By
      default, aptitude-create-state-bundle uses bzip2(1) if it is available,
      and gzip(1) otherwise. Passing this option forces the use of gzip even if
      bzip2 is available.


  --help
      Print a brief usage message, then exit.


  --print-inputs
      Display a list of the files and directories that will be included in the
      bundle.



File Format

The bundle file is simply a tar(1) file compressed with bzip2(1) or gzip(1),
with each of the input directory trees rooted at  . .


Voir aussi

aptitude-run-state-bundle(1), aptitude(8), apt(8)

--------------------------------------------------------------------------------

Nom

aptitude-run-state-bundle --; unpack an aptitude state bundle and invoke
aptitude on it


Synopsis

aptitude-run-state-bundle [options...] input-file [program-arguments...]


Description

aptitude-run-state-bundle unpacks the given aptitude state bundle created by
aptitude-create-state-bundle(1) to a temporary directory, invokes program on it
with the supplied arguments, and removes the temporary directory afterwards. If
program is not supplied, it defaults to aptitude(8).


Options

The following options may occur on the command-line before the input file.
Options following the input file are presumed to be arguments to aptitude.



  --append-args
      Place the options that give the location of the state bundle at the end of
      the command line when invoking program, rather than at the beginning (the
      default is to place options at the beginning).


  --help
      Display a brief usage summary.


  --prepend-args
      Place the options that give the location of the state bundle at the
      beginning of the command line when invoking program, overriding any
      previous --append-args (the default is to place options at the beginning).


  --no-clean
      Do not remove the unpacked state directory after running aptitude. You
      might want to use this if, for instance, you are debugging a problem that
      appears when aptitude's state file is modified. When aptitude finishes
      running, the name of the state directory will be printed so that you can
      access it in the future.

      This option is enabled automatically by --statedir.


  --really-clean
      Delete the state directory after running aptitude, even if --no-clean or -
      -statedir was supplied.


  --statedir
      Instead of treating the input file as a state bundle, treat it as an
      unpacked state bundle. For instance, you can use this to access the state
      directory that was created by a prior run with --no-clean.


  --unpack
      Unpack the input file to a temporary directory, but don't actually run
      aptitude.



Voir aussi

aptitude-create-state-bundle(1), aptitude(8), apt(8)

