#! /usr/bin/env python

import gobject
import gtk
import commands
import string
from xpm import PB

class BattStat():
    def __init__(self):
        self.i = 5
        self.statusIcon = gtk.StatusIcon()
        self.statusIcon.connect('activate', self.on_activate)
        gobject.timeout_add(30000, self.chkbatt)
        self.pbs = PB()
        self.chkbatt()
        gobject.timeout_add(30000, self.chkbatt)

    def on_activate(self, si):
        self.clicked_icon()

    def chkbatt(self):
        btRem=commands.getoutput("battery-status | cut -d' ' -f4")
        if string.find(btRem,'%') > 0:
          ibtRem = int(round(float(string.replace(btRem,'%','')) / 20,0))
          self.i = ibtRem
        else:
          self.i = 5
        print 'battery level: ' + str(self.i) + '/5 (' + btRem + ')'
        pb = gtk.gdk.pixbuf_new_from_xpm_data(self.pbs.get_pixbuf(self.i))
        self.statusIcon.set_from_pixbuf(pb)
        if not self.i:
            self.statusIcon.set_blinking(True)
            self.let_them_know()
        # self.i -= 1
        return self.i >= 0

    def clicked_icon(self):
        btRem=commands.getoutput("battery-status | cut -d' ' -f4")
        if string.find(btRem,'%') > 0:
          ibtRem = int(round(float(string.replace(btRem,'%','')) / 20,0))
          self.i = ibtRem
        else:
          self.i = 5
        str1='Battery level: ' + str(self.i) + '/5 \n' \
        +'(Actual value: ' + btRem + ')'
        w = gtk.Window()
        w.set_title('Battery Status')
        w.connect('destroy', self.on_ok_clicked, w)
        w.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)

        l1 = gtk.Label(str1)
        #l2 = gtk.Label(str2)
        hboxu = gtk.HBox(True, 0)
        hboxu.pack_start(l1, False, False, 10)
        #hboxu.pack_start(l2, False, False, 10)

        b = gtk.Button('OK', gtk.STOCK_OK)
        b.connect('clicked', self.on_ok_clicked, w)
        bq = gtk.Button('Quit', gtk.STOCK_QUIT)
        bq.connect('clicked', gtk.main_quit)
        hboxd = gtk.HBox(True, 0)
        hboxd.pack_start(b, False, False, 0)
        hboxd.pack_start(bq, False, False, 0)

        vbox = gtk.VBox(False, 0)
        vbox.pack_start(hboxu, False, False, 20)
        vbox.pack_start(hboxd, False, False, 20)
        w.add(vbox)

        w.show_all() 

    def let_them_know(self):
        w = gtk.Window()
        w.set_title('Battery Warning')
        w.connect('destroy', self.on_ok_clicked, w)
        w.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)

        str1 = 'Battery is empty!'
        str2 = ''
        l1 = gtk.Label(str1)
        l2 = gtk.Label(str2)
        hboxu = gtk.HBox(True, 0)
        hboxu.pack_start(l1, False, False, 10)
        hboxu.pack_start(l2, False, False, 10)

        b = gtk.Button('OK', gtk.STOCK_OK)
        b.connect('clicked', self.on_ok_clicked, w)
        hboxd = gtk.HBox(True, 0)
        hboxd.pack_start(b, False, False, 0)

        vbox = gtk.VBox(False, 0)
        vbox.pack_start(hboxu, False, False, 20)
        vbox.pack_start(hboxd, False, False, 20)
        w.add(vbox)

        w.show_all() 

    def on_ok_clicked(self, button, window):
        window.hide()

#gStatusIcon.connect('activate', on_si_activate)

#def drain():
#    global gI, gPB, gStatusIcon
#    pb = gtk.gdk.pixbuf_new_from_xpm_data(gPB.get_pixbuf(gI))
#    gStatusIcon.set_from_pixbuf(pb)
#    gI -= 1
#    return gI >= 0

#drain()
#gobject.timeout_add(3000, drain)

#pbs = PB()
#pb = gtk.gdk.pixbuf_new_from_xpm_data(pbs.get_pixbuf(5))
#si.set_from_stock(gtk.STOCK_FIND)
#si.set_from_file(bs[5]+'.xpm')
#si.set_from_pixbuf(pb)
#si.set_blinking(True)

if __name__ == "__main__":
    tbd = BattStat()
    gtk.main()
