/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.crypto.CryptoPermissions;
import javax.crypto.JarVerifier;
import sun.security.jca.GetInstance;

final class JceSecurity {
    static final SecureRandom RANDOM = new SecureRandom();
    private static CryptoPermissions defaultPolicy = null;
    private static CryptoPermissions exemptPolicy = null;
    private static final Map verificationResults = new IdentityHashMap();
    private static final Map verifyingProviders = new IdentityHashMap();
    private static final boolean isRestricted = false;
    private static final Object PROVIDER_VERIFIED = Boolean.TRUE;
    private static final URL NULL_URL;
    private static final Map codeBaseCacheRef;

    private JceSecurity() {
    }

    static GetInstance.Instance getInstance(String type, Class clazz, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider.Service s = GetInstance.getService(type, algorithm, provider);
        Exception ve = JceSecurity.getVerificationResult(s.getProvider());
        if (ve != null) {
            String msg = "JCE cannot authenticate the provider " + provider;
            throw (NoSuchProviderException)new NoSuchProviderException(msg).initCause(ve);
        }
        return GetInstance.getInstance(s, clazz);
    }

    static GetInstance.Instance getInstance(String type, Class clazz, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service s = GetInstance.getService(type, algorithm, provider);
        Exception ve = JceSecurity.getVerificationResult(provider);
        if (ve != null) {
            String msg = "JCE cannot authenticate the provider " + provider.getName();
            throw new SecurityException(msg, ve);
        }
        return GetInstance.getInstance(s, clazz);
    }

    static GetInstance.Instance getInstance(String type, Class clazz, String algorithm) throws NoSuchAlgorithmException {
        List<Provider.Service> services = GetInstance.getServices(type, algorithm);
        NoSuchAlgorithmException failure = null;
        for (Provider.Service s : services) {
            if (!JceSecurity.canUseProvider(s.getProvider())) continue;
            try {
                GetInstance.Instance instance = GetInstance.getInstance(s, clazz);
                return instance;
            }
            catch (NoSuchAlgorithmException e) {
                failure = e;
            }
        }
        throw new NoSuchAlgorithmException("Algorithm " + algorithm + " not available", failure);
    }

    static CryptoPermissions verifyExemptJar(URL codeBase) throws Exception {
        JarVerifier jv = new JarVerifier(codeBase, true);
        jv.verify();
        return jv.getPermissions();
    }

    static void verifyProviderJar(URL codeBase) throws Exception {
        JarVerifier jv = new JarVerifier(codeBase, false);
        jv.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Exception getVerificationResult(Provider p) {
        Object o = verificationResults.get(p);
        if (o == PROVIDER_VERIFIED) {
            return null;
        }
        if (o != null) {
            return (Exception)o;
        }
        if (verifyingProviders.get(p) != null) {
            return new NoSuchProviderException("Recursion during verification");
        }
        try {
            verifyingProviders.put(p, Boolean.FALSE);
            URL providerURL = JceSecurity.getCodeBase(p.getClass());
            JceSecurity.verifyProviderJar(providerURL);
            verificationResults.put(p, PROVIDER_VERIFIED);
            Exception exception = null;
            return exception;
        }
        catch (Exception e) {
            verificationResults.put(p, e);
            Exception exception = e;
            return exception;
        }
        finally {
            verifyingProviders.remove(p);
        }
    }

    static boolean canUseProvider(Provider p) {
        return JceSecurity.getVerificationResult(p) == null;
    }

    static URL getCodeBase(final Class clazz) {
        URL url = (URL)codeBaseCacheRef.get(clazz);
        if (url == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CodeSource cs;
                    ProtectionDomain pd = clazz.getProtectionDomain();
                    if (pd != null && (cs = pd.getCodeSource()) != null) {
                        return cs.getLocation();
                    }
                    return NULL_URL;
                }
            });
            codeBaseCacheRef.put(clazz, url);
        }
        return url == NULL_URL ? null : url;
    }

    static CryptoPermissions getDefaultPolicy() {
        return defaultPolicy;
    }

    static CryptoPermissions getExemptPolicy() {
        return exemptPolicy;
    }

    static boolean isRestricted() {
        return false;
    }

    static {
        try {
            NULL_URL = new URL("http://null.sun.com/");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        codeBaseCacheRef = new WeakHashMap();
    }
}

