/*
 * Decompiled with CFR 0.152.
 */
package com.sun.inputmethods.internal.thaiim;

import com.sun.inputmethods.internal.thaiim.ThaiInputMethod;
import com.sun.inputmethods.internal.thaiim.ThaiInputMethodImpl;
import java.awt.Image;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodDescriptor;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ThaiInputMethodDescriptor
implements InputMethodDescriptor {
    static final Locale THAI = new Locale("th");

    public Locale[] getAvailableLocales() {
        return new Locale[]{THAI};
    }

    public boolean hasDynamicLocaleList() {
        return false;
    }

    public synchronized String getInputMethodDisplayName(Locale inputLocale, Locale displayLanguage) {
        try {
            ResourceBundle resources = ResourceBundle.getBundle("com.sun.inputmethods.internal.thaiim.resources.DisplayNames", displayLanguage);
            return resources.getString("DisplayName.Thai");
        }
        catch (MissingResourceException mre) {
            return "Thai Input Method";
        }
    }

    public Image getInputMethodIcon(Locale inputLocale) {
        return null;
    }

    public InputMethod createInputMethod() throws Exception {
        ThaiInputMethodImpl impl = new ThaiInputMethodImpl();
        return new ThaiInputMethod(THAI, impl);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

