/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

final class RSAClientKeyExchange
extends HandshakeMessage {
    private static final String PROP_NAME = "com.sun.net.ssl.rsaPreMasterSecretFix";
    private static final boolean rsaPreMasterSecretFix = Debug.getBooleanProperty("com.sun.net.ssl.rsaPreMasterSecretFix", false);
    private ProtocolVersion protocolVersion;
    SecretKey preMaster;
    private byte[] encrypted;

    int messageType() {
        return 16;
    }

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion maxVersion, SecureRandom generator, PublicKey publicKey) throws IOException {
        byte minor;
        byte major;
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Public key not of type RSA");
        }
        this.protocolVersion = protocolVersion;
        if (rsaPreMasterSecretFix) {
            major = maxVersion.major;
            minor = maxVersion.minor;
        } else {
            major = protocolVersion.major;
            minor = protocolVersion.minor;
        }
        try {
            KeyGenerator kg = JsseJce.getKeyGenerator("SunTlsRsaPremasterSecret");
            kg.init(new TlsRsaPremasterSecretParameterSpec(major, minor));
            this.preMaster = kg.generateKey();
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(3, (Key)publicKey, generator);
            this.encrypted = cipher.wrap(this.preMaster);
        }
        catch (GeneralSecurityException e) {
            throw (SSLKeyException)new SSLKeyException("RSA premaster secret error").initCause(e);
        }
    }

    RSAClientKeyExchange(ProtocolVersion currentVersion, HandshakeInStream input, int messageSize, PrivateKey privateKey) throws IOException {
        if (!privateKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Private key not of type RSA");
        }
        this.protocolVersion = currentVersion;
        if (currentVersion.v >= ProtocolVersion.TLS10.v) {
            this.encrypted = input.getBytes16();
        } else {
            this.encrypted = new byte[messageSize];
            if (input.read(this.encrypted) != messageSize) {
                throw new SSLProtocolException("SSL: read PreMasterSecret: short read");
            }
        }
        try {
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(4, privateKey);
            this.preMaster = (SecretKey)cipher.unwrap(this.encrypted, "TlsRsaPremasterSecret", 3);
        }
        catch (Exception e) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Error decrypting premaster secret:");
                e.printStackTrace(System.out);
                System.out.println("Generating random secret");
            }
            this.preMaster = RSAClientKeyExchange.generateDummySecret(currentVersion);
        }
    }

    static SecretKey generateDummySecret(ProtocolVersion version) {
        try {
            KeyGenerator kg = JsseJce.getKeyGenerator("SunTlsRsaPremasterSecret");
            kg.init(new TlsRsaPremasterSecretParameterSpec(version.major, version.minor));
            return kg.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not generate dummy secret", e);
        }
    }

    int messageLength() {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            return this.encrypted.length + 2;
        }
        return this.encrypted.length;
    }

    void send(HandshakeOutStream s) throws IOException {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            s.putBytes16(this.encrypted);
        } else {
            s.write(this.encrypted);
        }
    }

    void print(PrintStream s) throws IOException {
        s.println("*** ClientKeyExchange, RSA PreMasterSecret, " + this.protocolVersion);
    }
}

