/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.UtilSystemException;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersion;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;

public abstract class InputStreamHook
extends ObjectInputStream {
    static final OMGSystemException omgWrapper = OMGSystemException.get("rpc.encoding");
    static final UtilSystemException utilWrapper = UtilSystemException.get("rpc.encoding");
    protected ReadObjectState readObjectState = DEFAULT_STATE;
    protected static final ReadObjectState DEFAULT_STATE = new DefaultState();
    protected static final ReadObjectState IN_READ_OBJECT_OPT_DATA = new InReadObjectOptionalDataState();
    protected static final ReadObjectState IN_READ_OBJECT_NO_MORE_OPT_DATA = new InReadObjectNoMoreOptionalDataState();
    protected static final ReadObjectState IN_READ_OBJECT_DEFAULTS_SENT = new InReadObjectDefaultsSentState();
    protected static final ReadObjectState NO_READ_OBJECT_DEFAULTS_SENT = new NoReadObjectDefaultsSentState();
    protected static final ReadObjectState IN_READ_OBJECT_REMOTE_NOT_CUSTOM_MARSHALED = new InReadObjectRemoteDidNotUseWriteObjectState();
    protected static final ReadObjectState IN_READ_OBJECT_PAST_DEFAULTS_REMOTE_NOT_CUSTOM = new InReadObjectPastDefaultsRemoteDidNotUseWOState();

    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        this.readObjectState.beginDefaultReadObject(this);
        this.defaultReadObjectDelegate();
        this.readObjectState.endDefaultReadObject(this);
    }

    public abstract void defaultReadObjectDelegate();

    abstract void readFields(Map var1) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException;

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        HashMap hashMap = new HashMap();
        this.readFields(hashMap);
        this.readObjectState.endDefaultReadObject(this);
        return new HookGetFields(hashMap);
    }

    protected void setState(ReadObjectState readObjectState) {
        this.readObjectState = readObjectState;
    }

    protected abstract byte getStreamFormatVersion();

    protected abstract InputStream getOrbStream();

    protected void throwOptionalDataIncompatibleException() {
        throw omgWrapper.rmiiiopOptionalDataIncompatible2();
    }

    protected static class NoReadObjectDefaultsSentState
    extends ReadObjectState {
        protected NoReadObjectDefaultsSentState() {
        }

        public void endUnmarshalCustomValue(InputStreamHook inputStreamHook) throws IOException {
            if (inputStreamHook.getStreamFormatVersion() == 2) {
                ((ValueInputStream)((Object)inputStreamHook.getOrbStream())).start_value();
                ((ValueInputStream)((Object)inputStreamHook.getOrbStream())).end_value();
            }
            inputStreamHook.setState(DEFAULT_STATE);
        }
    }

    protected static class InReadObjectNoMoreOptionalDataState
    extends InReadObjectOptionalDataState {
        protected InReadObjectNoMoreOptionalDataState() {
        }

        public void readData(InputStreamHook inputStreamHook) throws IOException {
            inputStreamHook.throwOptionalDataIncompatibleException();
        }
    }

    protected static class InReadObjectOptionalDataState
    extends ReadObjectState {
        protected InReadObjectOptionalDataState() {
        }

        public void beginUnmarshalCustomValue(InputStreamHook inputStreamHook, boolean bl, boolean bl2) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        public void endUnmarshalCustomValue(InputStreamHook inputStreamHook) throws IOException {
            if (inputStreamHook.getStreamFormatVersion() == 2) {
                ((ValueInputStream)((Object)inputStreamHook.getOrbStream())).end_value();
            }
            inputStreamHook.setState(DEFAULT_STATE);
        }

        public void beginDefaultReadObject(InputStreamHook inputStreamHook) throws IOException {
            throw new StreamCorruptedException("Default data not sent or already read/passed");
        }
    }

    protected static class InReadObjectDefaultsSentState
    extends ReadObjectState {
        protected InReadObjectDefaultsSentState() {
        }

        public void beginUnmarshalCustomValue(InputStreamHook inputStreamHook, boolean bl, boolean bl2) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        public void endUnmarshalCustomValue(InputStreamHook inputStreamHook) {
            if (inputStreamHook.getStreamFormatVersion() == 2) {
                ((ValueInputStream)((Object)inputStreamHook.getOrbStream())).start_value();
                ((ValueInputStream)((Object)inputStreamHook.getOrbStream())).end_value();
            }
            inputStreamHook.setState(DEFAULT_STATE);
        }

        public void endDefaultReadObject(InputStreamHook inputStreamHook) throws IOException {
            if (inputStreamHook.getStreamFormatVersion() == 2) {
                ((ValueInputStream)((Object)inputStreamHook.getOrbStream())).start_value();
            }
            inputStreamHook.setState(IN_READ_OBJECT_OPT_DATA);
        }

        public void readData(InputStreamHook inputStreamHook) throws IOException {
            org.omg.CORBA.ORB oRB = inputStreamHook.getOrbStream().orb();
            if (oRB == null || !(oRB instanceof ORB)) {
                throw new StreamCorruptedException("Default data must be read first");
            }
            ORBVersion oRBVersion = ((ORB)oRB).getORBVersion();
            if (ORBVersionFactory.getPEORB().compareTo(oRBVersion) <= 0 || oRBVersion.equals(ORBVersionFactory.getFOREIGN())) {
                throw new StreamCorruptedException("Default data must be read first");
            }
        }
    }

    protected static class InReadObjectPastDefaultsRemoteDidNotUseWOState
    extends ReadObjectState {
        protected InReadObjectPastDefaultsRemoteDidNotUseWOState() {
        }

        public void beginUnmarshalCustomValue(InputStreamHook inputStreamHook, boolean bl, boolean bl2) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        public void beginDefaultReadObject(InputStreamHook inputStreamHook) throws IOException {
            throw new StreamCorruptedException("Default data already read");
        }

        public void readData(InputStreamHook inputStreamHook) {
            inputStreamHook.throwOptionalDataIncompatibleException();
        }
    }

    protected static class InReadObjectRemoteDidNotUseWriteObjectState
    extends ReadObjectState {
        protected InReadObjectRemoteDidNotUseWriteObjectState() {
        }

        public void beginUnmarshalCustomValue(InputStreamHook inputStreamHook, boolean bl, boolean bl2) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        public void endDefaultReadObject(InputStreamHook inputStreamHook) {
            inputStreamHook.setState(IN_READ_OBJECT_PAST_DEFAULTS_REMOTE_NOT_CUSTOM);
        }

        public void readData(InputStreamHook inputStreamHook) {
            inputStreamHook.throwOptionalDataIncompatibleException();
        }
    }

    protected static class DefaultState
    extends ReadObjectState {
        protected DefaultState() {
        }

        public void beginUnmarshalCustomValue(InputStreamHook inputStreamHook, boolean bl, boolean bl2) throws IOException {
            if (bl2) {
                if (bl) {
                    inputStreamHook.setState(IN_READ_OBJECT_DEFAULTS_SENT);
                } else {
                    try {
                        if (inputStreamHook.getStreamFormatVersion() == 2) {
                            ((ValueInputStream)((Object)inputStreamHook.getOrbStream())).start_value();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    inputStreamHook.setState(IN_READ_OBJECT_OPT_DATA);
                }
            } else if (bl) {
                inputStreamHook.setState(NO_READ_OBJECT_DEFAULTS_SENT);
            } else {
                throw new StreamCorruptedException("No default data sent");
            }
        }
    }

    protected static class ReadObjectState {
        protected ReadObjectState() {
        }

        public void beginUnmarshalCustomValue(InputStreamHook inputStreamHook, boolean bl, boolean bl2) throws IOException {
        }

        public void endUnmarshalCustomValue(InputStreamHook inputStreamHook) throws IOException {
        }

        public void beginDefaultReadObject(InputStreamHook inputStreamHook) throws IOException {
        }

        public void endDefaultReadObject(InputStreamHook inputStreamHook) throws IOException {
        }

        public void readData(InputStreamHook inputStreamHook) throws IOException {
        }
    }

    private class HookGetFields
    extends ObjectInputStream.GetField {
        private Map fields = null;

        HookGetFields(Map map) {
            this.fields = map;
        }

        public ObjectStreamClass getObjectStreamClass() {
            return null;
        }

        public boolean defaulted(String string) throws IOException, IllegalArgumentException {
            return !this.fields.containsKey(string);
        }

        public boolean get(String string, boolean bl) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return bl;
            }
            return (Boolean)this.fields.get(string);
        }

        public char get(String string, char c) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return c;
            }
            return ((Character)this.fields.get(string)).charValue();
        }

        public byte get(String string, byte by) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return by;
            }
            return (Byte)this.fields.get(string);
        }

        public short get(String string, short s) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return s;
            }
            return (Short)this.fields.get(string);
        }

        public int get(String string, int n) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return n;
            }
            return (Integer)this.fields.get(string);
        }

        public long get(String string, long l) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return l;
            }
            return (Long)this.fields.get(string);
        }

        public float get(String string, float f) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return f;
            }
            return ((Float)this.fields.get(string)).floatValue();
        }

        public double get(String string, double d) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return d;
            }
            return (Double)this.fields.get(string);
        }

        public Object get(String string, Object object) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return object;
            }
            return this.fields.get(string);
        }

        public String toString() {
            return this.fields.toString();
        }
    }
}

