/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import com.sun.jndi.toolkit.dir.AttrFilter;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;

public final class LazySearchEnumerationImpl
implements NamingEnumeration {
    private NamingEnumeration candidates;
    private SearchResult nextMatch = null;
    private SearchControls cons;
    private AttrFilter filter;
    private Context context;
    private Hashtable env;
    private boolean useFactory = true;

    public LazySearchEnumerationImpl(NamingEnumeration candidates, AttrFilter filter, SearchControls cons) throws NamingException {
        this.candidates = candidates;
        this.filter = filter;
        this.cons = cons == null ? new SearchControls() : cons;
    }

    public LazySearchEnumerationImpl(NamingEnumeration candidates, AttrFilter filter, SearchControls cons, Context ctx, Hashtable env, boolean useFactory) throws NamingException {
        this.candidates = candidates;
        this.filter = filter;
        this.env = env;
        this.context = ctx;
        this.useFactory = useFactory;
        this.cons = cons == null ? new SearchControls() : cons;
    }

    public LazySearchEnumerationImpl(NamingEnumeration candidates, AttrFilter filter, SearchControls cons, Context ctx, Hashtable env) throws NamingException {
        this(candidates, filter, cons, ctx, env, true);
    }

    public boolean hasMore() throws NamingException {
        return this.findNextMatch(false) != null;
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException e) {
            return false;
        }
    }

    public Object nextElement() {
        try {
            return this.findNextMatch(true);
        }
        catch (NamingException e) {
            throw new NoSuchElementException(e.toString());
        }
    }

    public Object next() throws NamingException {
        return this.findNextMatch(true);
    }

    public void close() throws NamingException {
        if (this.candidates != null) {
            this.candidates.close();
        }
    }

    private SearchResult findNextMatch(boolean remove) throws NamingException {
        if (this.nextMatch != null) {
            SearchResult answer = this.nextMatch;
            if (remove) {
                this.nextMatch = null;
            }
            return answer;
        }
        while (this.candidates.hasMore()) {
            Attributes targetAttrs;
            Binding next = (Binding)this.candidates.next();
            Object obj = next.getObject();
            if (!(obj instanceof DirContext) || !this.filter.check(targetAttrs = ((DirContext)obj).getAttributes(""))) continue;
            if (!this.cons.getReturningObjFlag()) {
                obj = null;
            } else if (this.useFactory) {
                try {
                    CompositeName nm = this.context != null ? new CompositeName(next.getName()) : null;
                    obj = DirectoryManager.getObjectInstance(obj, nm, this.context, this.env, targetAttrs);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException e2 = new NamingException("problem generating object using object factory");
                    e2.setRootCause(e);
                    throw e2;
                }
            }
            SearchResult answer = new SearchResult(next.getName(), next.getClassName(), obj, SearchFilter.selectAttributes(targetAttrs, this.cons.getReturningAttributes()), true);
            if (!remove) {
                this.nextMatch = answer;
            }
            return answer;
        }
        return null;
    }
}

