/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurityManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JDK13Services {
    private static final long DEFAULT_CACHING_PERIOD = 60000L;
    private static final String PROPERTIES_FILENAME = "sound.properties";
    private static Map providersCacheMap = new HashMap();
    private static long cachingPeriod = 60000L;
    private static Properties properties;

    private JDK13Services() {
    }

    public static void setCachingPeriod(int seconds) {
        cachingPeriod = (long)seconds * 1000L;
    }

    public static synchronized List getProviders(Class serviceClass) {
        ProviderCache cache = (ProviderCache)providersCacheMap.get(serviceClass);
        if (cache == null) {
            cache = new ProviderCache();
            providersCacheMap.put(serviceClass, cache);
        }
        if (cache.providers == null || System.currentTimeMillis() > cache.lastUpdate + cachingPeriod) {
            cache.providers = Collections.unmodifiableList(JSSecurityManager.getProviders(serviceClass));
            cache.lastUpdate = System.currentTimeMillis();
        }
        return cache.providers;
    }

    public static synchronized String getDefaultProviderClassName(Class typeClass) {
        int hashpos;
        String value = null;
        String defaultProviderSpec = JDK13Services.getDefaultProvider(typeClass);
        if (defaultProviderSpec != null && (hashpos = defaultProviderSpec.indexOf(35)) != 0) {
            value = hashpos > 0 ? defaultProviderSpec.substring(0, hashpos) : defaultProviderSpec;
        }
        return value;
    }

    public static synchronized String getDefaultInstanceName(Class typeClass) {
        int hashpos;
        String value = null;
        String defaultProviderSpec = JDK13Services.getDefaultProvider(typeClass);
        if (defaultProviderSpec != null && (hashpos = defaultProviderSpec.indexOf(35)) >= 0 && hashpos < defaultProviderSpec.length() - 1) {
            value = defaultProviderSpec.substring(hashpos + 1);
        }
        return value;
    }

    private static synchronized String getDefaultProvider(Class typeClass) {
        String propertyName = typeClass.getName();
        String value = JSSecurityManager.getProperty(propertyName);
        if (value == null) {
            value = JDK13Services.getProperties().getProperty(propertyName);
        }
        if ("".equals(value)) {
            value = null;
        }
        return value;
    }

    private static synchronized Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
            JSSecurityManager.loadProperties(properties, PROPERTIES_FILENAME);
        }
        return properties;
    }

    private static class ProviderCache {
        public long lastUpdate;
        public List providers;

        private ProviderCache() {
        }
    }
}

