/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;

public class SoftAudioPusher
implements Runnable {
    private volatile boolean active = false;
    private SourceDataLine sourceDataLine = null;
    private Thread audiothread;
    private AudioInputStream ais;
    private byte[] buffer;

    public SoftAudioPusher(SourceDataLine sourceDataLine, AudioInputStream ais, int workbuffersizer) {
        this.ais = ais;
        this.buffer = new byte[workbuffersizer];
        this.sourceDataLine = sourceDataLine;
    }

    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.audiothread = new Thread(this);
        this.audiothread.setPriority(10);
        this.audiothread.start();
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        try {
            this.audiothread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        byte[] buffer = this.buffer;
        AudioInputStream ais = this.ais;
        SourceDataLine sourceDataLine = this.sourceDataLine;
        try {
            int count;
            while (this.active && (count = ais.read(buffer)) >= 0) {
                sourceDataLine.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            this.active = false;
        }
    }
}

