/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftAudioProcessor;
import java.util.Arrays;

public class SoftReverb
implements SoftAudioProcessor {
    private float roomsize;
    private float damp;
    private float gain = 1.0f;
    private Delay delay;
    private Comb[] combL;
    private Comb[] combR;
    private AllPass[] allpassL;
    private AllPass[] allpassR;
    private float[] input;
    private float[] outR;
    private float[] outL;
    private boolean mix = true;
    private SoftAudioBuffer inputA;
    private SoftAudioBuffer left;
    private SoftAudioBuffer right;
    private boolean dirty = true;
    private float dirty_roomsize;
    private float dirty_damp;
    private float dirty_predelay;
    private float dirty_gain;
    private float controlrate;
    private float samplerate;
    private double silentcounter = 1000.0;

    public void init(float samplerate, float controlrate) {
        this.controlrate = controlrate;
        this.samplerate = samplerate;
        double freqscale = (double)samplerate / 44100.0;
        int stereospread = 23;
        this.delay = new Delay();
        this.combL = new Comb[8];
        this.combR = new Comb[8];
        this.combL[0] = new Comb((int)(freqscale * 1116.0));
        this.combR[0] = new Comb((int)(freqscale * (double)(1116 + stereospread)));
        this.combL[1] = new Comb((int)(freqscale * 1188.0));
        this.combR[1] = new Comb((int)(freqscale * (double)(1188 + stereospread)));
        this.combL[2] = new Comb((int)(freqscale * 1277.0));
        this.combR[2] = new Comb((int)(freqscale * (double)(1277 + stereospread)));
        this.combL[3] = new Comb((int)(freqscale * 1356.0));
        this.combR[3] = new Comb((int)(freqscale * (double)(1356 + stereospread)));
        this.combL[4] = new Comb((int)(freqscale * 1422.0));
        this.combR[4] = new Comb((int)(freqscale * (double)(1422 + stereospread)));
        this.combL[5] = new Comb((int)(freqscale * 1491.0));
        this.combR[5] = new Comb((int)(freqscale * (double)(1491 + stereospread)));
        this.combL[6] = new Comb((int)(freqscale * 1557.0));
        this.combR[6] = new Comb((int)(freqscale * (double)(1557 + stereospread)));
        this.combL[7] = new Comb((int)(freqscale * 1617.0));
        this.combR[7] = new Comb((int)(freqscale * (double)(1617 + stereospread)));
        this.allpassL = new AllPass[4];
        this.allpassR = new AllPass[4];
        this.allpassL[0] = new AllPass((int)(freqscale * 556.0));
        this.allpassR[0] = new AllPass((int)(freqscale * (double)(556 + stereospread)));
        this.allpassL[1] = new AllPass((int)(freqscale * 441.0));
        this.allpassR[1] = new AllPass((int)(freqscale * (double)(441 + stereospread)));
        this.allpassL[2] = new AllPass((int)(freqscale * 341.0));
        this.allpassR[2] = new AllPass((int)(freqscale * (double)(341 + stereospread)));
        this.allpassL[3] = new AllPass((int)(freqscale * 225.0));
        this.allpassR[3] = new AllPass((int)(freqscale * (double)(225 + stereospread)));
        for (int i = 0; i < this.allpassL.length; ++i) {
            this.allpassL[i].setFeedBack(0.5f);
            this.allpassR[i].setFeedBack(0.5f);
        }
        this.globalParameterControlChange(new int[]{129}, 0L, 4L);
    }

    public void setInput(int pin, SoftAudioBuffer input) {
        if (pin == 0) {
            this.inputA = input;
        }
    }

    public void setOutput(int pin, SoftAudioBuffer output) {
        if (pin == 0) {
            this.left = output;
        }
        if (pin == 1) {
            this.right = output;
        }
    }

    public void setMixMode(boolean mix) {
        this.mix = mix;
    }

    public void processAudio() {
        int i;
        if (this.inputA.isSilent()) {
            this.silentcounter += (double)(1.0f / this.controlrate);
            if (this.silentcounter > 60.0) {
                if (!this.mix) {
                    this.left.clear();
                    this.right.clear();
                }
                return;
            }
        } else {
            this.silentcounter = 0.0;
        }
        float[] inputA = this.inputA.array();
        float[] left = this.left.array();
        float[] right = this.right == null ? null : this.right.array();
        int numsamples = inputA.length;
        if (this.input == null || this.input.length < numsamples) {
            this.input = new float[numsamples];
        }
        float again = this.gain * 0.018f / 2.0f;
        for (i = 0; i < numsamples; ++i) {
            this.input[i] = inputA[i] * again;
        }
        this.delay.processReplace(this.input, this.input);
        if (right != null) {
            if (this.outR == null || this.outR.length < numsamples) {
                this.outR = new float[numsamples];
            }
            Arrays.fill(this.outR, 0.0f);
            for (i = 0; i < this.combR.length; ++i) {
                this.combR[i].processMix(this.input, this.outR);
            }
            for (i = 0; i < this.allpassL.length; ++i) {
                this.allpassR[i].processReplace(this.outR, this.outR);
            }
            if (this.mix) {
                for (i = 0; i < numsamples; ++i) {
                    int n = i;
                    right[n] = right[n] + this.outR[i];
                }
            } else {
                for (i = 0; i < numsamples; ++i) {
                    right[i] = this.outR[i];
                }
            }
        }
        if (this.outL == null || this.outL.length < numsamples) {
            this.outL = new float[numsamples];
        }
        Arrays.fill(this.outL, 0.0f);
        for (i = 0; i < this.combL.length; ++i) {
            this.combL[i].processMix(this.input, this.outL);
        }
        for (i = 0; i < this.allpassL.length; ++i) {
            this.allpassL[i].processReplace(this.outL, this.outL);
        }
        if (this.mix) {
            for (i = 0; i < numsamples; ++i) {
                int n = i;
                left[n] = left[n] + this.outL[i];
            }
        } else {
            for (i = 0; i < numsamples; ++i) {
                left[i] = this.outL[i];
            }
        }
    }

    public void globalParameterControlChange(int[] slothpath, long param, long value) {
        if (slothpath.length == 1 && slothpath[0] == 129) {
            if (param == 0L) {
                if (value == 0L) {
                    this.dirty_roomsize = 1.1f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 4.0f;
                    this.dirty = true;
                }
                if (value == 1L) {
                    this.dirty_roomsize = 1.3f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 3.0f;
                    this.dirty = true;
                }
                if (value == 2L) {
                    this.dirty_roomsize = 1.5f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 2.0f;
                    this.dirty = true;
                }
                if (value == 3L) {
                    this.dirty_roomsize = 1.8f;
                    this.dirty_damp = 24000.0f;
                    this.dirty_predelay = 0.02f;
                    this.dirty_gain = 1.5f;
                    this.dirty = true;
                }
                if (value == 4L) {
                    this.dirty_roomsize = 1.8f;
                    this.dirty_damp = 24000.0f;
                    this.dirty_predelay = 0.03f;
                    this.dirty_gain = 1.5f;
                    this.dirty = true;
                }
                if (value == 8L) {
                    this.dirty_roomsize = 1.3f;
                    this.dirty_damp = 2500.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 6.0f;
                    this.dirty = true;
                }
            } else if (param == 1L) {
                this.dirty_roomsize = (float)Math.exp((double)(value - 40L) * 0.025);
                this.dirty = true;
            }
        }
    }

    public void processControlLogic() {
        if (this.dirty) {
            this.dirty = false;
            this.setRoomSize(this.dirty_roomsize);
            this.setDamp(this.dirty_damp);
            this.setPreDelay(this.dirty_predelay);
            this.setGain(this.dirty_gain);
        }
    }

    public void setRoomSize(float value) {
        this.roomsize = 1.0f - 0.17f / value;
        for (int i = 0; i < 8; ++i) {
            this.combL[i].feedback = this.roomsize;
            this.combR[i].feedback = this.roomsize;
        }
    }

    public void setPreDelay(float value) {
        this.delay.setDelay((int)(value * this.samplerate));
    }

    public void setGain(float gain) {
        this.gain = gain;
    }

    public void setDamp(float value) {
        double x = (double)(value / this.samplerate) * (Math.PI * 2);
        double cx = 2.0 - Math.cos(x);
        this.damp = (float)(cx - Math.sqrt(cx * cx - 1.0));
        if (this.damp > 1.0f) {
            this.damp = 1.0f;
        }
        if (this.damp < 0.0f) {
            this.damp = 0.0f;
        }
        for (int i = 0; i < 8; ++i) {
            this.combL[i].setDamp(this.damp);
            this.combR[i].setDamp(this.damp);
        }
    }

    private static class Comb {
        private float[] delaybuffer;
        private int delaybuffersize;
        private int rovepos = 0;
        private float feedback;
        private float filtertemp = 0.0f;
        private float filtercoeff1 = 0.0f;
        private float filtercoeff2 = 1.0f;
        int ucount = 0;

        public Comb(int size) {
            this.delaybuffer = new float[size];
            this.delaybuffersize = size;
        }

        public void setFeedBack(float feedback) {
            this.feedback = feedback;
        }

        public void processMix(float[] in, float[] out) {
            int i;
            int len = in.length;
            float filtercoeff2 = this.filtercoeff2 * this.feedback;
            for (i = 0; i < len; ++i) {
                float delayout = this.delaybuffer[this.rovepos];
                this.filtertemp = delayout * filtercoeff2 + this.filtertemp * this.filtercoeff1;
                int n = i;
                out[n] = out[n] + delayout;
                this.delaybuffer[this.rovepos] = in[i] + this.filtertemp;
                if (++this.rovepos != this.delaybuffersize) continue;
                this.rovepos = 0;
            }
            ++this.ucount;
            if (this.ucount == 10) {
                this.ucount = 0;
                if ((double)this.filtertemp > 0.0 && (double)this.filtertemp < 1.0E-10 || (double)this.filtertemp < 0.0 && (double)this.filtertemp > -1.0E-10) {
                    this.filtertemp = 0.0f;
                }
                for (i = 0; i < this.delaybuffer.length; ++i) {
                    double v = this.delaybuffer[i];
                    if (!(v > 0.0 && v < 1.0E-10) && (!(v < 0.0) || !(v > -1.0E-10))) continue;
                    this.delaybuffer[i] = 0.0f;
                }
            }
        }

        public void setDamp(float val) {
            this.filtercoeff1 = val;
            this.filtercoeff2 = 1.0f - this.filtercoeff1;
        }
    }

    private static class AllPass {
        private float[] delaybuffer;
        private int delaybuffersize;
        private int rovepos = 0;
        private float feedback;
        int ucount = 0;

        public AllPass(int size) {
            this.delaybuffer = new float[size];
            this.delaybuffersize = size;
        }

        public void setFeedBack(float feedback) {
            this.feedback = feedback;
        }

        public void processReplace(float[] in, float[] out) {
            int i;
            int len = in.length;
            for (i = 0; i < len; ++i) {
                float delayout = this.delaybuffer[this.rovepos];
                float input = in[i];
                out[i] = -input + delayout;
                this.delaybuffer[this.rovepos] = input + delayout * this.feedback;
                if (++this.rovepos != this.delaybuffersize) continue;
                this.rovepos = 0;
            }
            ++this.ucount;
            if (this.ucount == 10) {
                this.ucount = 0;
                for (i = 0; i < this.delaybuffer.length; ++i) {
                    double v = this.delaybuffer[i];
                    if (!(v > 0.0 && v < 1.0E-10) && (!(v < 0.0) || !(v > -1.0E-10))) continue;
                    this.delaybuffer[i] = 0.0f;
                }
            }
        }
    }

    private static class Delay {
        private float[] delaybuffer = null;
        private int rovepos = 0;

        public void setDelay(int delay) {
            this.delaybuffer = (float[])(delay == 0 ? null : new float[delay]);
            this.rovepos = 0;
        }

        public void processReplace(float[] in, float[] out) {
            float[] delaybuffer = this.delaybuffer;
            if (delaybuffer == null) {
                return;
            }
            int len = in.length;
            int rnlen = delaybuffer.length;
            int rovepos = this.rovepos;
            for (int i = 0; i < len; ++i) {
                float x = in[i];
                out[i] = delaybuffer[rovepos];
                delaybuffer[rovepos] = x;
                if (++rovepos != rnlen) continue;
                rovepos = 0;
            }
            this.rovepos = rovepos;
        }
    }
}

