/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.RIFFWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.spi.AudioFileWriter;

public class WaveFloatFileWriter
extends AudioFileWriter {
    public AudioFileFormat.Type[] getAudioFileTypes() {
        return new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};
    }

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        if (!stream.getFormat().getEncoding().equals(AudioFloatConverter.PCM_FLOAT)) {
            return new AudioFileFormat.Type[0];
        }
        return new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};
    }

    private void checkFormat(AudioFileFormat.Type type, AudioInputStream stream) {
        if (!AudioFileFormat.Type.WAVE.equals(type)) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (!stream.getFormat().getEncoding().equals(AudioFloatConverter.PCM_FLOAT)) {
            throw new IllegalArgumentException("File format " + stream.getFormat() + " not supported.");
        }
    }

    public void write(AudioInputStream stream, RIFFWriter writer) throws IOException {
        int len;
        RIFFWriter fmt_chunk = writer.writeChunk("fmt ");
        AudioFormat format = stream.getFormat();
        fmt_chunk.writeUnsignedShort(3);
        fmt_chunk.writeUnsignedShort(format.getChannels());
        fmt_chunk.writeUnsignedInt((int)format.getSampleRate());
        fmt_chunk.writeUnsignedInt((int)format.getFrameRate() * format.getFrameSize());
        fmt_chunk.writeUnsignedShort(format.getFrameSize());
        fmt_chunk.writeUnsignedShort(format.getSampleSizeInBits());
        fmt_chunk.close();
        RIFFWriter data_chunk = writer.writeChunk("data");
        byte[] buff = new byte[1024];
        while ((len = stream.read(buff, 0, buff.length)) != -1) {
            data_chunk.write(buff, 0, len);
        }
        data_chunk.close();
    }

    private AudioInputStream toLittleEndian(AudioInputStream ais) {
        AudioFormat format = ais.getFormat();
        AudioFormat targetFormat = new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), format.getFrameRate(), false);
        return AudioSystem.getAudioInputStream(targetFormat, ais);
    }

    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        this.checkFormat(fileType, stream);
        if (stream.getFormat().isBigEndian()) {
            stream = this.toLittleEndian(stream);
        }
        RIFFWriter writer = new RIFFWriter(new NoCloseOutputStream(out), "WAVE");
        this.write(stream, writer);
        int fpointer = (int)writer.getFilePointer();
        writer.close();
        return fpointer;
    }

    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        this.checkFormat(fileType, stream);
        if (stream.getFormat().isBigEndian()) {
            stream = this.toLittleEndian(stream);
        }
        RIFFWriter writer = new RIFFWriter(out, "WAVE");
        this.write(stream, writer);
        int fpointer = (int)writer.getFilePointer();
        writer.close();
        return fpointer;
    }

    private static class NoCloseOutputStream
    extends OutputStream {
        OutputStream out;

        public NoCloseOutputStream(OutputStream out) {
            this.out = out;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }
    }
}

