/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.BindingIDFactory;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.encoding.SOAPBindingCodec;
import com.sun.xml.internal.ws.encoding.XMLHTTPBindingCodec;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.BindingType;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingID {
    public static final SOAPHTTPImpl X_SOAP12_HTTP = new SOAPHTTPImpl(SOAPVersion.SOAP_12, "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/", true);
    public static final SOAPHTTPImpl SOAP12_HTTP = new SOAPHTTPImpl(SOAPVersion.SOAP_12, "http://www.w3.org/2003/05/soap/bindings/HTTP/", false);
    public static final SOAPHTTPImpl SOAP11_HTTP = new SOAPHTTPImpl(SOAPVersion.SOAP_11, "http://schemas.xmlsoap.org/wsdl/soap/http", true);
    public static final SOAPHTTPImpl SOAP12_HTTP_MTOM = new SOAPHTTPImpl(SOAPVersion.SOAP_12, "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true", false, true);
    public static final SOAPHTTPImpl SOAP11_HTTP_MTOM = new SOAPHTTPImpl(SOAPVersion.SOAP_11, "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true", true, true);
    public static final BindingID XML_HTTP = new Impl(SOAPVersion.SOAP_11, "http://www.w3.org/2004/08/wsdl/http", false){

        public Codec createEncoder(WSBinding wSBinding) {
            return new XMLHTTPBindingCodec();
        }
    };

    @NotNull
    public final WSBinding createBinding() {
        return BindingImpl.create(this);
    }

    @NotNull
    public final WSBinding createBinding(WebServiceFeature ... webServiceFeatureArray) {
        return BindingImpl.create(this, webServiceFeatureArray);
    }

    @NotNull
    public final WSBinding createBinding(WSFeatureList wSFeatureList) {
        return this.createBinding(wSFeatureList.toArray());
    }

    public abstract SOAPVersion getSOAPVersion();

    @NotNull
    public abstract Codec createEncoder(@NotNull WSBinding var1);

    public abstract String toString();

    public WebServiceFeatureList createBuiltinFeatureList() {
        return new WebServiceFeatureList();
    }

    public boolean canGenerateWSDL() {
        return false;
    }

    public String getParameter(String string, String string2) {
        return string2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BindingID)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @NotNull
    public static BindingID parse(String string) {
        if (string.equals(XML_HTTP.toString())) {
            return XML_HTTP;
        }
        if (BindingID.belongsTo(string, SOAP11_HTTP.toString())) {
            return BindingID.customize(string, SOAP11_HTTP);
        }
        if (BindingID.belongsTo(string, SOAP12_HTTP.toString())) {
            return BindingID.customize(string, SOAP12_HTTP);
        }
        if (BindingID.belongsTo(string, "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/")) {
            return BindingID.customize(string, X_SOAP12_HTTP);
        }
        for (BindingIDFactory bindingIDFactory : ServiceFinder.find(BindingIDFactory.class)) {
            BindingID bindingID = bindingIDFactory.parse(string);
            if (bindingID == null) continue;
            return bindingID;
        }
        throw new WebServiceException("Wrong binding ID: " + string);
    }

    private static boolean belongsTo(String string, String string2) {
        return string.equals(string2) || string.startsWith(string2 + '?');
    }

    private static SOAPHTTPImpl customize(String string, SOAPHTTPImpl sOAPHTTPImpl) {
        if (string.equals(sOAPHTTPImpl.toString())) {
            return sOAPHTTPImpl;
        }
        SOAPHTTPImpl sOAPHTTPImpl2 = new SOAPHTTPImpl(sOAPHTTPImpl.getSOAPVersion(), string, sOAPHTTPImpl.canGenerateWSDL());
        try {
            if (string.indexOf(63) == -1) {
                return sOAPHTTPImpl2;
            }
            String string2 = URLDecoder.decode(string.substring(string.indexOf(63) + 1), "UTF-8");
            for (String string3 : string2.split("&")) {
                int n = string3.indexOf(61);
                if (n < 0) {
                    throw new WebServiceException("Malformed binding ID (no '=' in " + string3 + ")");
                }
                sOAPHTTPImpl2.parameters.put(string3.substring(0, n), string3.substring(n + 1));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        return sOAPHTTPImpl2;
    }

    @NotNull
    public static BindingID parse(Class<?> clazz) {
        String string;
        BindingType bindingType = clazz.getAnnotation(BindingType.class);
        if (bindingType != null && (string = bindingType.value()).length() > 0) {
            return BindingID.parse(string);
        }
        return SOAP11_HTTP;
    }

    private static final class SOAPHTTPImpl
    extends Impl
    implements Cloneable {
        Map<String, String> parameters = new HashMap<String, String>();
        static final String MTOM_PARAM = "mtom";
        Boolean mtomSetting = null;

        public SOAPHTTPImpl(SOAPVersion sOAPVersion, String string, boolean bl) {
            super(sOAPVersion, string, bl);
        }

        public SOAPHTTPImpl(SOAPVersion sOAPVersion, String string, boolean bl, boolean bl2) {
            this(sOAPVersion, string, bl);
            String string2 = bl2 ? "true" : "false";
            this.parameters.put(MTOM_PARAM, string2);
            this.mtomSetting = bl2;
        }

        @NotNull
        public Codec createEncoder(WSBinding wSBinding) {
            return new SOAPBindingCodec(wSBinding);
        }

        private Boolean isMTOMEnabled() {
            String string = this.parameters.get(MTOM_PARAM);
            return string == null ? null : Boolean.valueOf(string);
        }

        public WebServiceFeatureList createBuiltinFeatureList() {
            WebServiceFeatureList webServiceFeatureList = super.createBuiltinFeatureList();
            Boolean bl = this.isMTOMEnabled();
            if (bl != null) {
                webServiceFeatureList.add(new MTOMFeature(bl));
            }
            return webServiceFeatureList;
        }

        public String getParameter(String string, String string2) {
            if (this.parameters.get(string) == null) {
                return super.getParameter(string, string2);
            }
            return this.parameters.get(string);
        }
    }

    private static abstract class Impl
    extends BindingID {
        final SOAPVersion version;
        private final String lexical;
        private final boolean canGenerateWSDL;

        public Impl(SOAPVersion sOAPVersion, String string, boolean bl) {
            this.version = sOAPVersion;
            this.lexical = string;
            this.canGenerateWSDL = bl;
        }

        public SOAPVersion getSOAPVersion() {
            return this.version;
        }

        public String toString() {
            return this.lexical;
        }

        @Deprecated
        public boolean canGenerateWSDL() {
            return this.canGenerateWSDL;
        }
    }
}

