/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.LogicalMessageContextImpl;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import com.sun.xml.internal.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.internal.ws.handler.XMLHandlerProcessor;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.MessageContext;

public class ServerLogicalHandlerTube
extends HandlerTube {
    private WSBinding binding;
    private List<LogicalHandler> logicalHandlers;

    public ServerLogicalHandlerTube(WSBinding wSBinding, WSDLPort wSDLPort, Tube tube) {
        super(tube, wSDLPort);
        this.binding = wSBinding;
        this.setUpProcessorOnce();
    }

    public ServerLogicalHandlerTube(WSBinding wSBinding, Tube tube, HandlerTube handlerTube) {
        super(tube, handlerTube);
        this.binding = wSBinding;
        this.setUpProcessorOnce();
    }

    private ServerLogicalHandlerTube(ServerLogicalHandlerTube serverLogicalHandlerTube, TubeCloner tubeCloner) {
        super(serverLogicalHandlerTube, tubeCloner);
        this.binding = serverLogicalHandlerTube.binding;
        this.setUpProcessorOnce();
    }

    boolean isHandlerChainEmpty() {
        return this.logicalHandlers.isEmpty();
    }

    public void close(MessageContext messageContext) {
        if (this.binding.getSOAPVersion() == null && this.processor != null) {
            this.closeLogicalHandlers(messageContext);
        }
    }

    public void closeCall(MessageContext messageContext) {
        this.closeLogicalHandlers(messageContext);
    }

    private void closeLogicalHandlers(MessageContext messageContext) {
        if (this.processor == null) {
            return;
        }
        if (this.remedyActionTaken) {
            this.processor.closeHandlers(messageContext, this.processor.getIndex(), this.logicalHandlers.size() - 1);
            this.processor.setIndex(-1);
            this.remedyActionTaken = false;
        } else {
            this.processor.closeHandlers(messageContext, 0, this.logicalHandlers.size() - 1);
        }
    }

    public AbstractFilterTubeImpl copy(TubeCloner tubeCloner) {
        return new ServerLogicalHandlerTube(this, tubeCloner);
    }

    private void setUpProcessorOnce() {
        this.logicalHandlers = new ArrayList<LogicalHandler>();
        List<LogicalHandler> list = ((BindingImpl)this.binding).getHandlerConfig().getLogicalHandlers();
        if (!list.isEmpty()) {
            this.logicalHandlers.addAll(list);
            this.processor = this.binding.getSOAPVersion() == null ? new XMLHandlerProcessor(this, this.binding, this.logicalHandlers) : new SOAPHandlerProcessor(false, this, this.binding, this.logicalHandlers);
        }
    }

    void setUpProcessor() {
    }

    MessageUpdatableContext getContext(Packet packet) {
        return new LogicalMessageContextImpl(this.binding, packet);
    }

    boolean callHandlersOnRequest(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        boolean bl2;
        try {
            bl2 = this.processor.callHandlersRequest(HandlerProcessor.Direction.INBOUND, messageUpdatableContext, !bl);
        }
        catch (RuntimeException runtimeException) {
            this.remedyActionTaken = true;
            throw runtimeException;
        }
        if (!bl2) {
            this.remedyActionTaken = true;
        }
        return bl2;
    }

    void callHandlersOnResponse(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        Map map = (Map)messageUpdatableContext.get("javax.xml.ws.binding.attachments.outbound");
        AttachmentSet attachmentSet = this.packet.getMessage().getAttachments();
        for (String string : map.keySet()) {
            DataHandlerAttachment dataHandlerAttachment = new DataHandlerAttachment(string, (DataHandler)map.get(string));
            attachmentSet.add(dataHandlerAttachment);
        }
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.OUTBOUND, messageUpdatableContext, bl);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }
}

