/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class RescaleOp
implements BufferedImageOp,
RasterOp {
    float[] scaleFactors;
    float[] offsets;
    int length = 0;
    RenderingHints hints;
    private int srcNbits;
    private int dstNbits;

    public RescaleOp(float[] scaleFactors, float[] offsets, RenderingHints hints) {
        this.length = scaleFactors.length;
        if (this.length > offsets.length) {
            this.length = offsets.length;
        }
        this.scaleFactors = new float[this.length];
        this.offsets = new float[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.scaleFactors[i] = scaleFactors[i];
            this.offsets[i] = offsets[i];
        }
        this.hints = hints;
    }

    public RescaleOp(float scaleFactor, float offset, RenderingHints hints) {
        this.length = 1;
        this.scaleFactors = new float[1];
        this.offsets = new float[1];
        this.scaleFactors[0] = scaleFactor;
        this.offsets[0] = offset;
        this.hints = hints;
    }

    public final float[] getScaleFactors(float[] scaleFactors) {
        if (scaleFactors == null) {
            return (float[])this.scaleFactors.clone();
        }
        System.arraycopy(this.scaleFactors, 0, scaleFactors, 0, Math.min(this.scaleFactors.length, scaleFactors.length));
        return scaleFactors;
    }

    public final float[] getOffsets(float[] offsets) {
        if (offsets == null) {
            return (float[])this.offsets.clone();
        }
        System.arraycopy(this.offsets, 0, offsets, 0, Math.min(this.offsets.length, offsets.length));
        return offsets;
    }

    public final int getNumFactors() {
        return this.length;
    }

    private ByteLookupTable createByteLut(float[] scale, float[] off, int nBands, int nElems) {
        byte[][] lutData = new byte[scale.length][nElems];
        for (int band = 0; band < scale.length; ++band) {
            float bandScale = scale[band];
            float bandOff = off[band];
            byte[] bandLutData = lutData[band];
            for (int i = 0; i < nElems; ++i) {
                int val = (int)((float)i * bandScale + bandOff);
                if ((val & 0xFFFFFF00) != 0) {
                    val = val < 0 ? 0 : 255;
                }
                bandLutData[i] = (byte)val;
            }
        }
        return new ByteLookupTable(0, lutData);
    }

    private ShortLookupTable createShortLut(float[] scale, float[] off, int nBands, int nElems) {
        short[][] lutData = new short[scale.length][nElems];
        for (int band = 0; band < scale.length; ++band) {
            float bandScale = scale[band];
            float bandOff = off[band];
            short[] bandLutData = lutData[band];
            for (int i = 0; i < nElems; ++i) {
                int val = (int)((float)i * bandScale + bandOff);
                if ((val & 0xFFFF0000) != 0) {
                    val = val < 0 ? 0 : 65535;
                }
                bandLutData[i] = (short)val;
            }
        }
        return new ShortLookupTable(0, lutData);
    }

    private boolean canUseLookup(Raster src, Raster dst) {
        int datatype = src.getDataBuffer().getDataType();
        if (datatype != 0 && datatype != 1) {
            return false;
        }
        SampleModel dstSM = dst.getSampleModel();
        this.dstNbits = dstSM.getSampleSize(0);
        if (this.dstNbits != 8 && this.dstNbits != 16) {
            return false;
        }
        for (int i = 1; i < src.getNumBands(); ++i) {
            int bandSize = dstSM.getSampleSize(i);
            if (bandSize == this.dstNbits) continue;
            return false;
        }
        SampleModel srcSM = src.getSampleModel();
        this.srcNbits = srcSM.getSampleSize(0);
        if (this.srcNbits > 16) {
            return false;
        }
        for (int i = 1; i < src.getNumBands(); ++i) {
            int bandSize = srcSM.getSampleSize(i);
            if (bandSize == this.srcNbits) continue;
            return false;
        }
        return true;
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        ColorModel dstCM;
        ColorModel srcCM = src.getColorModel();
        int numBands = srcCM.getNumColorComponents();
        if (srcCM instanceof IndexColorModel) {
            throw new IllegalArgumentException("Rescaling cannot be performed on an indexed image");
        }
        if (this.length != 1 && this.length != numBands && this.length != srcCM.getNumComponents()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of color or color/alpha  components");
        }
        boolean needToConvert = false;
        if (this.length > numBands && srcCM.hasAlpha()) {
            this.length = numBands + 1;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
            dstCM = srcCM;
        } else {
            if (width != dst.getWidth()) {
                throw new IllegalArgumentException("Src width (" + width + ") not equal to dst width (" + dst.getWidth() + ")");
            }
            if (height != dst.getHeight()) {
                throw new IllegalArgumentException("Src height (" + height + ") not equal to dst height (" + dst.getHeight() + ")");
            }
            dstCM = dst.getColorModel();
            if (srcCM.getColorSpace().getType() != dstCM.getColorSpace().getType()) {
                needToConvert = true;
                dst = this.createCompatibleDestImage(src, null);
            }
        }
        BufferedImage origDst = dst;
        if (ImagingLib.filter(this, src, dst) == null) {
            int dstNumBands;
            WritableRaster srcRaster = src.getRaster();
            WritableRaster dstRaster = dst.getRaster();
            if (srcCM.hasAlpha() && (numBands - 1 == this.length || this.length == 1)) {
                int minx = srcRaster.getMinX();
                int miny = srcRaster.getMinY();
                int[] bands = new int[numBands - 1];
                for (int i = 0; i < numBands - 1; ++i) {
                    bands[i] = i;
                }
                srcRaster = srcRaster.createWritableChild(minx, miny, srcRaster.getWidth(), srcRaster.getHeight(), minx, miny, bands);
            }
            if (dstCM.hasAlpha() && ((dstNumBands = dstRaster.getNumBands()) - 1 == this.length || this.length == 1)) {
                int minx = dstRaster.getMinX();
                int miny = dstRaster.getMinY();
                int[] bands = new int[numBands - 1];
                for (int i = 0; i < numBands - 1; ++i) {
                    bands[i] = i;
                }
                dstRaster = dstRaster.createWritableChild(minx, miny, dstRaster.getWidth(), dstRaster.getHeight(), minx, miny, bands);
            }
            this.filter(srcRaster, dstRaster);
        }
        if (needToConvert) {
            ColorConvertOp ccop = new ColorConvertOp(this.hints);
            ccop.filter(dst, origDst);
        }
        return origDst;
    }

    public final WritableRaster filter(Raster src, WritableRaster dst) {
        int numBands = src.getNumBands();
        int width = src.getWidth();
        int height = src.getHeight();
        int[] srcPix = null;
        int step = 0;
        int tidx = 0;
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else {
            if (height != dst.getHeight() || width != dst.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (numBands != dst.getNumBands()) {
                throw new IllegalArgumentException("Number of bands in src " + numBands + " does not equal number of bands in dest " + dst.getNumBands());
            }
        }
        if (this.length != 1 && this.length != src.getNumBands()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of bands in the src raster");
        }
        if (ImagingLib.filter(this, src, dst) != null) {
            return dst;
        }
        if (this.canUseLookup(src, dst)) {
            int srcNgray = 1 << this.srcNbits;
            int dstNgray = 1 << this.dstNbits;
            if (dstNgray == 256) {
                ByteLookupTable lut = this.createByteLut(this.scaleFactors, this.offsets, numBands, srcNgray);
                LookupOp op = new LookupOp(lut, this.hints);
                op.filter(src, dst);
            } else {
                ShortLookupTable lut = this.createShortLut(this.scaleFactors, this.offsets, numBands, srcNgray);
                LookupOp op = new LookupOp(lut, this.hints);
                op.filter(src, dst);
            }
        } else {
            if (this.length > 1) {
                step = 1;
            }
            int sminX = src.getMinX();
            int sY = src.getMinY();
            int dminX = dst.getMinX();
            int dY = dst.getMinY();
            int[] dstMax = new int[numBands];
            int[] dstMask = new int[numBands];
            SampleModel dstSM = dst.getSampleModel();
            for (int z = 0; z < numBands; ++z) {
                int nbits = dstSM.getSampleSize(z);
                dstMax[z] = (1 << nbits) - 1;
                dstMask[z] = ~dstMax[z];
            }
            int y = 0;
            while (y < height) {
                int dX = dminX;
                int sX = sminX;
                int x = 0;
                while (x < width) {
                    srcPix = src.getPixel(sX, sY, srcPix);
                    tidx = 0;
                    int z = 0;
                    while (z < numBands) {
                        int val = (int)((float)srcPix[z] * this.scaleFactors[tidx] + this.offsets[tidx]);
                        if ((val & dstMask[z]) != 0) {
                            val = val < 0 ? 0 : dstMax[z];
                        }
                        srcPix[z] = val;
                        ++z;
                        tidx += step;
                    }
                    dst.setPixel(dX, dY, srcPix);
                    ++x;
                    ++sX;
                    ++dX;
                }
                ++y;
                ++sY;
                ++dY;
            }
        }
        return dst;
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        BufferedImage image;
        if (destCM == null) {
            ColorModel cm = src.getColorModel();
            image = new BufferedImage(cm, src.getRaster().createCompatibleWritableRaster(), cm.isAlphaPremultiplied(), null);
        } else {
            int w = src.getWidth();
            int h = src.getHeight();
            image = new BufferedImage(destCM, destCM.createCompatibleWritableRaster(w, h), destCM.isAlphaPremultiplied(), null);
        }
        return image;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
    }

    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }
}

