/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityManager {
    @Deprecated
    protected boolean inCheck;
    private boolean initialized = false;
    private static ThreadGroup rootGroup = SecurityManager.getRootGroup();
    private static boolean packageAccessValid = false;
    private static String[] packageAccess;
    private static final Object packageAccessLock;
    private static boolean packageDefinitionValid;
    private static String[] packageDefinition;
    private static final Object packageDefinitionLock;

    private boolean hasAllPermission() {
        try {
            this.checkPermission(SecurityConstants.ALL_PERMISSION);
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    @Deprecated
    public boolean getInCheck() {
        return this.inCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityManager() {
        Class<SecurityManager> clazz = SecurityManager.class;
        synchronized (SecurityManager.class) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("createSecurityManager"));
            }
            this.initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected native Class[] getClassContext();

    @Deprecated
    protected ClassLoader currentClassLoader() {
        ClassLoader cl = this.currentClassLoader0();
        if (cl != null && this.hasAllPermission()) {
            cl = null;
        }
        return cl;
    }

    private native ClassLoader currentClassLoader0();

    @Deprecated
    protected Class<?> currentLoadedClass() {
        Class c = this.currentLoadedClass0();
        if (c != null && this.hasAllPermission()) {
            c = null;
        }
        return c;
    }

    @Deprecated
    protected native int classDepth(String var1);

    @Deprecated
    protected int classLoaderDepth() {
        int depth = this.classLoaderDepth0();
        if (depth != -1) {
            depth = this.hasAllPermission() ? -1 : --depth;
        }
        return depth;
    }

    private native int classLoaderDepth0();

    @Deprecated
    protected boolean inClass(String name) {
        return this.classDepth(name) >= 0;
    }

    @Deprecated
    protected boolean inClassLoader() {
        return this.currentClassLoader() != null;
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public void checkPermission(Permission perm) {
        AccessController.checkPermission(perm);
    }

    public void checkPermission(Permission perm, Object context) {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException();
        }
        ((AccessControlContext)context).checkPermission(perm);
    }

    public void checkCreateClassLoader() {
        this.checkPermission(SecurityConstants.CREATE_CLASSLOADER_PERMISSION);
    }

    private static ThreadGroup getRootGroup() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public void checkAccess(Thread t) {
        if (t == null) {
            throw new NullPointerException("thread can't be null");
        }
        if (t.getThreadGroup() == rootGroup) {
            this.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    public void checkAccess(ThreadGroup g) {
        if (g == null) {
            throw new NullPointerException("thread group can't be null");
        }
        if (g == rootGroup) {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
    }

    public void checkExit(int status) {
        this.checkPermission(new RuntimePermission("exitVM." + status));
    }

    public void checkExec(String cmd) {
        File f = new File(cmd);
        if (f.isAbsolute()) {
            this.checkPermission(new FilePermission(cmd, "execute"));
        } else {
            this.checkPermission(new FilePermission("<<ALL FILES>>", "execute"));
        }
    }

    public void checkLink(String lib) {
        if (lib == null) {
            throw new NullPointerException("library can't be null");
        }
        this.checkPermission(new RuntimePermission("loadLibrary." + lib));
    }

    public void checkRead(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
    }

    public void checkRead(String file) {
        this.checkPermission(new FilePermission(file, "read"));
    }

    public void checkRead(String file, Object context) {
        this.checkPermission(new FilePermission(file, "read"), context);
    }

    public void checkWrite(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
    }

    public void checkWrite(String file) {
        this.checkPermission(new FilePermission(file, "write"));
    }

    public void checkDelete(String file) {
        this.checkPermission(new FilePermission(file, "delete"));
    }

    public void checkConnect(String host, int port) {
        if (host == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!host.startsWith("[") && host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        if (port == -1) {
            this.checkPermission(new SocketPermission(host, "resolve"));
        } else {
            this.checkPermission(new SocketPermission(host + ":" + port, "connect"));
        }
    }

    public void checkConnect(String host, int port, Object context) {
        if (host == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!host.startsWith("[") && host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        if (port == -1) {
            this.checkPermission(new SocketPermission(host, "resolve"), context);
        } else {
            this.checkPermission(new SocketPermission(host + ":" + port, "connect"), context);
        }
    }

    public void checkListen(int port) {
        if (port == 0) {
            this.checkPermission(SecurityConstants.LOCAL_LISTEN_PERMISSION);
        } else {
            this.checkPermission(new SocketPermission("localhost:" + port, "listen"));
        }
    }

    public void checkAccept(String host, int port) {
        if (host == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!host.startsWith("[") && host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        this.checkPermission(new SocketPermission(host + ":" + port, "accept"));
    }

    public void checkMulticast(InetAddress maddr) {
        String host = maddr.getHostAddress();
        if (!host.startsWith("[") && host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        this.checkPermission(new SocketPermission(host, "connect,accept"));
    }

    @Deprecated
    public void checkMulticast(InetAddress maddr, byte ttl) {
        String host = maddr.getHostAddress();
        if (!host.startsWith("[") && host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        this.checkPermission(new SocketPermission(host, "connect,accept"));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(new PropertyPermission("*", "read,write"));
    }

    public void checkPropertyAccess(String key) {
        this.checkPermission(new PropertyPermission(key, "read"));
    }

    public boolean checkTopLevelWindow(Object window) {
        if (window == null) {
            throw new NullPointerException("window can't be null");
        }
        try {
            this.checkPermission(SecurityConstants.TOPLEVEL_WINDOW_PERMISSION);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void checkPrintJobAccess() {
        this.checkPermission(new RuntimePermission("queuePrintJob"));
    }

    public void checkSystemClipboardAccess() {
        this.checkPermission(SecurityConstants.ACCESS_CLIPBOARD_PERMISSION);
    }

    public void checkAwtEventQueueAccess() {
        this.checkPermission(SecurityConstants.CHECK_AWT_EVENTQUEUE_PERMISSION);
    }

    private static String[] getPackages(String p) {
        StringTokenizer tok;
        int n;
        String[] packages = null;
        if (p != null && !p.equals("") && (n = (tok = new StringTokenizer(p, ",")).countTokens()) > 0) {
            packages = new String[n];
            int i = 0;
            while (tok.hasMoreElements()) {
                String s = tok.nextToken().trim();
                packages[i++] = s;
            }
        }
        if (packages == null) {
            packages = new String[]{};
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPackageAccess(String pkg) {
        String[] pkgs;
        if (pkg == null) {
            throw new NullPointerException("package name can't be null");
        }
        Object object = packageAccessLock;
        synchronized (object) {
            if (!packageAccessValid) {
                String tmpPropertyStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty("package.access");
                    }
                });
                packageAccess = SecurityManager.getPackages(tmpPropertyStr);
                packageAccessValid = true;
            }
            pkgs = packageAccess;
        }
        for (int i = 0; i < pkgs.length; ++i) {
            if (!pkg.startsWith(pkgs[i]) && !pkgs[i].equals(pkg + ".")) continue;
            this.checkPermission(new RuntimePermission("accessClassInPackage." + pkg));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPackageDefinition(String pkg) {
        String[] pkgs;
        if (pkg == null) {
            throw new NullPointerException("package name can't be null");
        }
        Object object = packageDefinitionLock;
        synchronized (object) {
            if (!packageDefinitionValid) {
                String tmpPropertyStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty("package.definition");
                    }
                });
                packageDefinition = SecurityManager.getPackages(tmpPropertyStr);
                packageDefinitionValid = true;
            }
            pkgs = packageDefinition;
        }
        for (int i = 0; i < pkgs.length; ++i) {
            if (!pkg.startsWith(pkgs[i]) && !pkgs[i].equals(pkg + ".")) continue;
            this.checkPermission(new RuntimePermission("defineClassInPackage." + pkg));
            break;
        }
    }

    public void checkSetFactory() {
        this.checkPermission(new RuntimePermission("setFactory"));
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        Class[] stack;
        if (clazz == null) {
            throw new NullPointerException("class can't be null");
        }
        if (which != 0 && ((stack = this.getClassContext()).length < 4 || stack[3].getClassLoader() != clazz.getClassLoader())) {
            this.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
        }
    }

    public void checkSecurityAccess(String target) {
        this.checkPermission(new SecurityPermission(target));
    }

    private native Class currentLoadedClass0();

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    static {
        packageAccessLock = new Object();
        packageDefinitionValid = false;
        packageDefinitionLock = new Object();
    }
}

