/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferRL;
import java.nio.ByteOrder;
import java.nio.CharBuffer;

class ByteBufferAsCharBufferL
extends CharBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsCharBufferL(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 1, bb.remaining() >> 1);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.offset = pos;
    }

    ByteBufferAsCharBufferL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.offset = off;
    }

    public CharBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 1) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsCharBufferL(this.bb, -1, 0, rem, rem, off);
    }

    public CharBuffer duplicate() {
        return new ByteBufferAsCharBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public CharBuffer asReadOnlyBuffer() {
        return new ByteBufferAsCharBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return (i << 1) + this.offset;
    }

    public char get() {
        return Bits.getCharL(this.bb, this.ix(this.nextGetIndex()));
    }

    public char get(int i) {
        return Bits.getCharL(this.bb, this.ix(this.checkIndex(i)));
    }

    public CharBuffer put(char x) {
        Bits.putCharL(this.bb, this.ix(this.nextPutIndex()), x);
        return this;
    }

    public CharBuffer put(int i, char x) {
        Bits.putCharL(this.bb, this.ix(this.checkIndex(i)), x);
        return this;
    }

    public CharBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 1);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return false;
    }

    public String toString(int start, int end) {
        if (end > this.limit() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        if (start < 0 || end > len || start > end) {
            throw new IndexOutOfBoundsException();
        }
        int sublen = end - start;
        int off = this.offset + (pos + start << 1);
        assert (off >= 0);
        return new ByteBufferAsCharBufferL(this.bb, -1, 0, sublen, sublen, off);
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

