/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsDoubleBufferRL;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

class ByteBufferAsDoubleBufferL
extends DoubleBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsDoubleBufferL(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 3, bb.remaining() >> 3);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.offset = pos;
    }

    ByteBufferAsDoubleBufferL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.offset = off;
    }

    public DoubleBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 3) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsDoubleBufferL(this.bb, -1, 0, rem, rem, off);
    }

    public DoubleBuffer duplicate() {
        return new ByteBufferAsDoubleBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return new ByteBufferAsDoubleBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return (i << 3) + this.offset;
    }

    public double get() {
        return Bits.getDoubleL(this.bb, this.ix(this.nextGetIndex()));
    }

    public double get(int i) {
        return Bits.getDoubleL(this.bb, this.ix(this.checkIndex(i)));
    }

    public DoubleBuffer put(double x) {
        Bits.putDoubleL(this.bb, this.ix(this.nextPutIndex()), x);
        return this;
    }

    public DoubleBuffer put(int i, double x) {
        Bits.putDoubleL(this.bb, this.ix(this.checkIndex(i)), x);
        return this;
    }

    public DoubleBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 3);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

