/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsFloatBufferRB;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

class ByteBufferAsFloatBufferB
extends FloatBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsFloatBufferB(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 2, bb.remaining() >> 2);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.offset = pos;
    }

    ByteBufferAsFloatBufferB(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.offset = off;
    }

    public FloatBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 2) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsFloatBufferB(this.bb, -1, 0, rem, rem, off);
    }

    public FloatBuffer duplicate() {
        return new ByteBufferAsFloatBufferB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new ByteBufferAsFloatBufferRB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return (i << 2) + this.offset;
    }

    public float get() {
        return Bits.getFloatB(this.bb, this.ix(this.nextGetIndex()));
    }

    public float get(int i) {
        return Bits.getFloatB(this.bb, this.ix(this.checkIndex(i)));
    }

    public FloatBuffer put(float x) {
        Bits.putFloatB(this.bb, this.ix(this.nextPutIndex()), x);
        return this;
    }

    public FloatBuffer put(int i, float x) {
        Bits.putFloatB(this.bb, this.ix(this.checkIndex(i)), x);
        return this;
    }

    public FloatBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 2);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

