/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectCharBufferRU;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectCharBufferU
extends CharBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectCharBufferU(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.viewedBuffer = db;
    }

    public CharBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 1;
        assert (off >= 0);
        return new DirectCharBufferU(this, -1, 0, rem, rem, off);
    }

    public CharBuffer duplicate() {
        return new DirectCharBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public CharBuffer asReadOnlyBuffer() {
        return new DirectCharBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + (long)(i << 1);
    }

    public char get() {
        return unsafe.getChar(this.ix(this.nextGetIndex()));
    }

    public char get(int i) {
        return unsafe.getChar(this.ix(this.checkIndex(i)));
    }

    public CharBuffer get(char[] dst, int offset, int length) {
        if (length << 1 > 6) {
            int rem;
            DirectCharBufferU.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToCharArray(this.ix(pos), dst, offset << 1, length << 1);
            } else {
                Bits.copyToByteArray(this.ix(pos), dst, offset << 1, length << 1);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    public CharBuffer put(char x) {
        unsafe.putChar(this.ix(this.nextPutIndex()), x);
        return this;
    }

    public CharBuffer put(int i, char x) {
        unsafe.putChar(this.ix(this.checkIndex(i)), x);
        return this;
    }

    public CharBuffer put(CharBuffer src) {
        if (src instanceof DirectCharBufferU) {
            int rem;
            if (src == this) {
                throw new IllegalArgumentException();
            }
            DirectCharBufferU sb = (DirectCharBufferU)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), srem << 1);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    public CharBuffer put(char[] src, int offset, int length) {
        if (length << 1 > 6) {
            int rem;
            DirectCharBufferU.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromCharArray(src, offset << 1, this.ix(pos), length << 1);
            } else {
                Bits.copyFromByteArray(src, offset << 1, this.ix(pos), length << 1);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    public CharBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), rem << 1);
        this.position(rem);
        this.limit(this.capacity());
        this.clearMark();
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String toString(int start, int end) {
        if (end > this.limit() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        if (start < 0 || end > len || start > end) {
            throw new IndexOutOfBoundsException();
        }
        int sublen = end - start;
        int off = pos + start << 1;
        assert (off >= 0);
        return new DirectCharBufferU(this, -1, 0, sublen, sublen, off);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

