/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;

public class MBeanNotificationInfo
extends MBeanFeatureInfo
implements Cloneable {
    static final long serialVersionUID = -3888371564530107064L;
    private static final String[] NO_TYPES = new String[0];
    static final MBeanNotificationInfo[] NO_NOTIFICATIONS = new MBeanNotificationInfo[0];
    private final String[] types;
    private final transient boolean arrayGettersSafe;

    public MBeanNotificationInfo(String[] notifTypes, String name, String description) {
        this(notifTypes, name, description, null);
    }

    public MBeanNotificationInfo(String[] notifTypes, String name, String description, Descriptor descriptor) {
        super(name, description, descriptor);
        if (notifTypes == null) {
            notifTypes = NO_TYPES;
        }
        this.types = notifTypes;
        this.arrayGettersSafe = MBeanInfo.arrayGettersSafe(this.getClass(), MBeanNotificationInfo.class);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String[] getNotifTypes() {
        if (this.types.length == 0) {
            return NO_TYPES;
        }
        return (String[])this.types.clone();
    }

    private String[] fastGetNotifTypes() {
        if (this.arrayGettersSafe) {
            return this.types;
        }
        return this.getNotifTypes();
    }

    public String toString() {
        return this.getClass().getName() + "[" + "description=" + this.getDescription() + ", " + "name=" + this.getName() + ", " + "notifTypes=" + Arrays.asList(this.fastGetNotifTypes()) + ", " + "descriptor=" + this.getDescriptor() + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MBeanNotificationInfo)) {
            return false;
        }
        MBeanNotificationInfo p = (MBeanNotificationInfo)o;
        return p.getName().equals(this.getName()) && p.getDescription().equals(this.getDescription()) && ((Object)p.getDescriptor()).equals(this.getDescriptor()) && Arrays.equals(p.fastGetNotifTypes(), this.fastGetNotifTypes());
    }

    public int hashCode() {
        int hash = this.getName().hashCode();
        for (int i = 0; i < this.types.length; ++i) {
            hash ^= this.types[i].hashCode();
        }
        return hash;
    }
}

