/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationEmitter {
    private String mbeanServerId;
    private final NotificationBroadcasterSupport broadcaster;
    private static long oldStamp = 0L;
    private final long stamp = MBeanServerDelegate.getStamp();
    private long sequenceNumber = 1L;
    private static final MBeanNotificationInfo[] notifsInfo;
    public static final ObjectName DELEGATE_NAME;

    public MBeanServerDelegate() {
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    public synchronized String getMBeanServerId() {
        if (this.mbeanServerId == null) {
            String localHost;
            try {
                localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                localHost = "localhost";
            }
            this.mbeanServerId = localHost + "_" + this.stamp;
        }
        return this.mbeanServerId;
    }

    public String getSpecificationName() {
        return "Java Management Extensions";
    }

    public String getSpecificationVersion() {
        return "1.4";
    }

    public String getSpecificationVendor() {
        return "Sun Microsystems";
    }

    public String getImplementationName() {
        return "JMX";
    }

    public String getImplementationVersion() {
        try {
            return System.getProperty("java.runtime.version");
        }
        catch (SecurityException e) {
            return "";
        }
    }

    public String getImplementationVendor() {
        return "Sun Microsystems";
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        int len = notifsInfo.length;
        MBeanNotificationInfo[] infos = new MBeanNotificationInfo[len];
        System.arraycopy(notifsInfo, 0, infos, 0, len);
        return infos;
    }

    public synchronized void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public synchronized void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    public synchronized void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification notification) {
        if (notification.getSequenceNumber() < 1L) {
            MBeanServerDelegate mBeanServerDelegate = this;
            synchronized (mBeanServerDelegate) {
                notification.setSequenceNumber(this.sequenceNumber++);
            }
        }
        this.broadcaster.sendNotification(notification);
    }

    private static synchronized long getStamp() {
        long s = System.currentTimeMillis();
        if (oldStamp >= s) {
            s = oldStamp + 1L;
        }
        oldStamp = s;
        return s;
    }

    static {
        String[] types = new String[]{"JMX.mbean.unregistered", "JMX.mbean.registered"};
        notifsInfo = new MBeanNotificationInfo[1];
        MBeanServerDelegate.notifsInfo[0] = new MBeanNotificationInfo(types, "javax.management.MBeanServerNotification", "Notifications sent by the MBeanServerDelegate MBean");
        try {
            DELEGATE_NAME = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            throw new Error("Can't initialize delegate name", e);
        }
    }
}

