/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.remote.util.EnvHelp;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;
import javax.management.openmbean.CompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private String observedAttribute;
    private long granularityPeriod = 10000L;
    private boolean isActive = false;
    private final AtomicLong sequenceNumber = new AtomicLong();
    private boolean isComplexTypeAttribute = false;
    private String firstAttribute;
    private final List<String> remainingAttributes = new CopyOnWriteArrayList<String>();
    private AccessControlContext acc;
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("Scheduler"));
    private static final int maximumPoolSize;
    private static final ExecutorService executor;
    private final MonitorTask monitorTask = new MonitorTask();
    private Future<?> monitorFuture;
    private final SchedulerTask schedulerTask = new SchedulerTask(this.monitorTask);
    private ScheduledFuture<?> schedulerFuture;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    @Deprecated
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    @Deprecated
    protected String dbgTag = Monitor.class.getName();
    final List<ObservedObject> observedObjects = new CopyOnWriteArrayList<ObservedObject>();
    static final int THRESHOLD_ERROR_NOTIFIED = 16;
    static final Integer INTEGER_ZERO;

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "preRegister(MBeanServer, ObjectName)", "initialize the reference on the MBean server");
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "preDeregister()", "stop the monitor");
        this.stop();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public abstract void start();

    @Override
    public abstract void stop();

    @Override
    @Deprecated
    public synchronized ObjectName getObservedObject() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return this.observedObjects.get(0).getObservedObject();
    }

    @Override
    @Deprecated
    public synchronized void setObservedObject(ObjectName object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Null observed object");
        }
        if (this.observedObjects.size() == 1 && this.containsObservedObject(object)) {
            return;
        }
        this.observedObjects.clear();
        this.addObservedObject(object);
    }

    @Override
    public synchronized void addObservedObject(ObjectName object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Null observed object");
        }
        if (this.containsObservedObject(object)) {
            return;
        }
        ObservedObject o = this.createObservedObject(object);
        o.setAlreadyNotified(0);
        o.setDerivedGauge(null);
        o.setDerivedGaugeTimeStamp(System.currentTimeMillis());
        this.observedObjects.add(o);
        this.createAlreadyNotified();
    }

    @Override
    public synchronized void removeObservedObject(ObjectName object) {
        if (object == null) {
            return;
        }
        ObservedObject o = this.getObservedObject(object);
        if (o != null) {
            this.observedObjects.remove(o);
            this.createAlreadyNotified();
        }
    }

    @Override
    public synchronized boolean containsObservedObject(ObjectName object) {
        return this.getObservedObject(object) != null;
    }

    @Override
    public synchronized ObjectName[] getObservedObjects() {
        ObjectName[] names = new ObjectName[this.observedObjects.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.observedObjects.get(i).getObservedObject();
        }
        return names;
    }

    @Override
    public synchronized String getObservedAttribute() {
        return this.observedAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObservedAttribute(String attribute) throws IllegalArgumentException {
        if (attribute == null) {
            throw new IllegalArgumentException("Null observed attribute");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.observedAttribute != null && this.observedAttribute.equals(attribute)) {
                return;
            }
            this.observedAttribute = attribute;
            this.cleanupIsComplexTypeAttribute();
            int index = 0;
            for (ObservedObject o : this.observedObjects) {
                this.resetAlreadyNotified(o, index++, 6);
            }
        }
    }

    @Override
    public synchronized long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    @Override
    public synchronized void setGranularityPeriod(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("Nonpositive granularity period");
        }
        if (this.granularityPeriod == period) {
            return;
        }
        this.granularityPeriod = period;
        if (this.isActive()) {
            this.cleanupFutures();
            this.schedulerFuture = scheduler.schedule(this.schedulerTask, period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStart() {
        JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "doStart()", "start the monitor");
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.isActive()) {
                JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "doStart()", "the monitor is already active");
                return;
            }
            this.isActive = true;
            this.cleanupIsComplexTypeAttribute();
            this.acc = AccessController.getContext();
            this.cleanupFutures();
            this.schedulerFuture = scheduler.schedule(this.schedulerTask, this.getGranularityPeriod(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop() {
        JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "doStop()", "stop the monitor");
        Monitor monitor = this;
        synchronized (monitor) {
            if (!this.isActive()) {
                JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "doStop()", "the monitor is not active");
                return;
            }
            this.isActive = false;
            this.cleanupFutures();
            this.acc = null;
            this.cleanupIsComplexTypeAttribute();
        }
    }

    synchronized Object getDerivedGauge(ObjectName object) {
        ObservedObject o = this.getObservedObject(object);
        return o == null ? null : o.getDerivedGauge();
    }

    synchronized long getDerivedGaugeTimeStamp(ObjectName object) {
        ObservedObject o = this.getObservedObject(object);
        return o == null ? 0L : o.getDerivedGaugeTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getAttribute(MBeanServerConnection mbsc, ObjectName object, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String fa;
        MBeanInfo mbi;
        boolean lookupMBeanInfo;
        Monitor monitor = this;
        synchronized (monitor) {
            if (!this.isActive()) {
                throw new IllegalArgumentException("The monitor has been stopped");
            }
            if (!attribute.equals(this.getObservedAttribute())) {
                throw new IllegalArgumentException("The observed attribute has been changed");
            }
            lookupMBeanInfo = this.firstAttribute == null && attribute.indexOf(46) != -1;
        }
        if (lookupMBeanInfo) {
            try {
                mbi = mbsc.getMBeanInfo(object);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            mbi = null;
        }
        Monitor monitor2 = this;
        synchronized (monitor2) {
            if (!this.isActive()) {
                throw new IllegalArgumentException("The monitor has been stopped");
            }
            if (!attribute.equals(this.getObservedAttribute())) {
                throw new IllegalArgumentException("The observed attribute has been changed");
            }
            if (this.firstAttribute == null) {
                if (attribute.indexOf(46) != -1) {
                    MBeanAttributeInfo[] mbaiArray;
                    for (MBeanAttributeInfo mbai : mbaiArray = mbi.getAttributes()) {
                        if (!attribute.equals(mbai.getName())) continue;
                        this.firstAttribute = attribute;
                        break;
                    }
                    if (this.firstAttribute == null) {
                        String[] tokens = attribute.split("\\.", -1);
                        this.firstAttribute = tokens[0];
                        for (int i = 1; i < tokens.length; ++i) {
                            this.remainingAttributes.add(tokens[i]);
                        }
                        this.isComplexTypeAttribute = true;
                    }
                } else {
                    this.firstAttribute = attribute;
                }
            }
            fa = this.firstAttribute;
        }
        return mbsc.getAttribute(object, fa);
    }

    Comparable<?> getComparableFromAttribute(ObjectName object, String attribute, Object value) throws AttributeNotFoundException {
        if (this.isComplexTypeAttribute) {
            Object v = value;
            for (String attr : this.remainingAttributes) {
                v = this.introspect(object, attr, v);
            }
            return (Comparable)v;
        }
        return (Comparable)value;
    }

    Object introspect(ObjectName object, String attribute, Object value) throws AttributeNotFoundException {
        try {
            PropertyDescriptor[] pds;
            if (value.getClass().isArray() && attribute.equals("length")) {
                return Array.getLength(value);
            }
            if (value instanceof CompositeData) {
                return ((CompositeData)value).get(attribute);
            }
            BeanInfo bi = Introspector.getBeanInfo(value.getClass());
            for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                if (!pd.getName().equals(attribute)) continue;
                return pd.getReadMethod().invoke(value, new Object[0]);
            }
            throw new AttributeNotFoundException("Could not find the getter method for the property " + attribute + " using the Java Beans introspector");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw EnvHelp.initCause(new AttributeNotFoundException(e.getMessage()), e);
        }
    }

    boolean isComparableTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        return true;
    }

    String buildErrorNotification(ObjectName object, String attribute, Comparable<?> value) {
        return null;
    }

    void onErrorNotification(MonitorNotification notification) {
    }

    Comparable<?> getDerivedGaugeFromComparable(ObjectName object, String attribute, Comparable<?> value) {
        return value;
    }

    MonitorNotification buildAlarmNotification(ObjectName object, String attribute, Comparable<?> value) {
        return null;
    }

    boolean isThresholdTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        return true;
    }

    static Class<? extends Number> classForType(NumericalType type) {
        switch (type) {
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        throw new IllegalArgumentException("Unsupported numerical type");
    }

    static boolean isValidForType(Object value, Class<? extends Number> c) {
        return value == INTEGER_ZERO || c.isInstance(value);
    }

    synchronized ObservedObject getObservedObject(ObjectName object) {
        for (ObservedObject o : this.observedObjects) {
            if (!o.getObservedObject().equals(object)) continue;
            return o;
        }
        return null;
    }

    ObservedObject createObservedObject(ObjectName object) {
        return new ObservedObject(object);
    }

    synchronized void createAlreadyNotified() {
        this.elementCount = this.observedObjects.size();
        this.alreadyNotifieds = new int[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            this.alreadyNotifieds[i] = this.observedObjects.get(i).getAlreadyNotified();
        }
        this.updateDeprecatedAlreadyNotified();
    }

    synchronized void updateDeprecatedAlreadyNotified() {
        this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
    }

    synchronized void updateAlreadyNotified(ObservedObject o, int index) {
        this.alreadyNotifieds[index] = o.getAlreadyNotified();
        if (index == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized boolean isAlreadyNotified(ObservedObject o, int mask) {
        return (o.getAlreadyNotified() & mask) != 0;
    }

    synchronized void setAlreadyNotified(ObservedObject o, int index, int mask, int[] an) {
        int i = this.computeAlreadyNotifiedIndex(o, index, an);
        if (i == -1) {
            return;
        }
        o.setAlreadyNotified(o.getAlreadyNotified() | mask);
        this.updateAlreadyNotified(o, i);
    }

    synchronized void resetAlreadyNotified(ObservedObject o, int index, int mask) {
        o.setAlreadyNotified(o.getAlreadyNotified() & ~mask);
        this.updateAlreadyNotified(o, index);
    }

    synchronized void resetAllAlreadyNotified(ObservedObject o, int index, int[] an) {
        int i = this.computeAlreadyNotifiedIndex(o, index, an);
        if (i == -1) {
            return;
        }
        o.setAlreadyNotified(0);
        this.updateAlreadyNotified(o, index);
    }

    synchronized int computeAlreadyNotifiedIndex(ObservedObject o, int index, int[] an) {
        if (an == this.alreadyNotifieds) {
            return index;
        }
        return this.observedObjects.indexOf(o);
    }

    private void sendNotification(String type, long timeStamp, String msg, Object derGauge, Object trigger, ObjectName object, boolean onError) {
        if (!this.isActive()) {
            return;
        }
        if (JmxProperties.MONITOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "sendNotification", "send notification: \n\tNotification observed object = " + object + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + derGauge);
        }
        long seqno = this.sequenceNumber.getAndIncrement();
        MonitorNotification mn = new MonitorNotification(type, this, seqno, timeStamp, msg, object, this.observedAttribute, derGauge, trigger);
        if (onError) {
            this.onErrorNotification(mn);
        }
        this.sendNotification(mn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor(ObservedObject o, int index, int[] an) {
        String attribute = null;
        String notifType = null;
        String msg = null;
        Comparable<?> derGauge = null;
        Object trigger = null;
        ObjectName object = null;
        Comparable<?> value = null;
        Notification alarm = null;
        if (!this.isActive()) {
            return;
        }
        Monitor monitor = this;
        synchronized (monitor) {
            object = o.getObservedObject();
            attribute = this.getObservedAttribute();
            if (object == null || attribute == null) {
                return;
            }
        }
        Object attributeValue = null;
        try {
            attributeValue = this.getAttribute(this.server, object, attribute);
            if (attributeValue == null) {
                if (this.isAlreadyNotified(o, 4)) {
                    return;
                }
                notifType = "jmx.monitor.error.type";
                this.setAlreadyNotified(o, index, 4, an);
                msg = "The observed attribute value is null.";
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            }
        }
        catch (NullPointerException np_ex) {
            if (this.isAlreadyNotified(o, 8)) {
                return;
            }
            notifType = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(o, index, 8, an);
            msg = "The monitor must be registered in the MBean server or an MBeanServerConnection must be explicitly supplied.";
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", np_ex.toString());
        }
        catch (InstanceNotFoundException inf_ex) {
            if (this.isAlreadyNotified(o, 1)) {
                return;
            }
            notifType = "jmx.monitor.error.mbean";
            this.setAlreadyNotified(o, index, 1, an);
            msg = "The observed object must be accessible in the MBeanServerConnection.";
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", inf_ex.toString());
        }
        catch (AttributeNotFoundException anf_ex) {
            if (this.isAlreadyNotified(o, 2)) {
                return;
            }
            notifType = "jmx.monitor.error.attribute";
            this.setAlreadyNotified(o, index, 2, an);
            msg = "The observed attribute must be accessible in the observed object.";
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", anf_ex.toString());
        }
        catch (MBeanException mb_ex) {
            if (this.isAlreadyNotified(o, 8)) {
                return;
            }
            notifType = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(o, index, 8, an);
            msg = mb_ex.getMessage() == null ? "" : mb_ex.getMessage();
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", mb_ex.toString());
        }
        catch (ReflectionException ref_ex) {
            if (this.isAlreadyNotified(o, 8)) {
                return;
            }
            notifType = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(o, index, 8, an);
            msg = ref_ex.getMessage() == null ? "" : ref_ex.getMessage();
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", ref_ex.toString());
        }
        catch (IOException io_ex) {
            if (this.isAlreadyNotified(o, 8)) {
                return;
            }
            notifType = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(o, index, 8, an);
            msg = io_ex.getMessage() == null ? "" : io_ex.getMessage();
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", io_ex.toString());
        }
        catch (RuntimeException rt_ex) {
            if (this.isAlreadyNotified(o, 8)) {
                return;
            }
            notifType = "jmx.monitor.error.runtime";
            this.setAlreadyNotified(o, index, 8, an);
            msg = rt_ex.getMessage() == null ? "" : rt_ex.getMessage();
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", rt_ex.toString());
        }
        Monitor monitor2 = this;
        synchronized (monitor2) {
            if (!this.isActive()) {
                return;
            }
            if (!attribute.equals(this.getObservedAttribute())) {
                return;
            }
            if (msg == null) {
                try {
                    value = this.getComparableFromAttribute(object, attribute, attributeValue);
                }
                catch (ClassCastException e) {
                    if (this.isAlreadyNotified(o, 4)) {
                        return;
                    }
                    notifType = "jmx.monitor.error.type";
                    this.setAlreadyNotified(o, index, 4, an);
                    msg = "The observed attribute value does not implement the Comparable interface.";
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", e.toString());
                }
                catch (AttributeNotFoundException e) {
                    if (this.isAlreadyNotified(o, 2)) {
                        return;
                    }
                    notifType = "jmx.monitor.error.attribute";
                    this.setAlreadyNotified(o, index, 2, an);
                    msg = "The observed attribute must be accessible in the observed object.";
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", e.toString());
                }
                catch (RuntimeException e) {
                    if (this.isAlreadyNotified(o, 8)) {
                        return;
                    }
                    notifType = "jmx.monitor.error.runtime";
                    this.setAlreadyNotified(o, index, 8, an);
                    msg = e.getMessage() == null ? "" : e.getMessage();
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", e.toString());
                }
            }
            if (msg == null && !this.isComparableTypeValid(object, attribute, value)) {
                if (this.isAlreadyNotified(o, 4)) {
                    return;
                }
                notifType = "jmx.monitor.error.type";
                this.setAlreadyNotified(o, index, 4, an);
                msg = "The observed attribute type is not valid.";
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            }
            if (msg == null && !this.isThresholdTypeValid(object, attribute, value)) {
                if (this.isAlreadyNotified(o, 16)) {
                    return;
                }
                notifType = "jmx.monitor.error.threshold";
                this.setAlreadyNotified(o, index, 16, an);
                msg = "The threshold type is not valid.";
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            }
            if (msg == null && (msg = this.buildErrorNotification(object, attribute, value)) != null) {
                if (this.isAlreadyNotified(o, 8)) {
                    return;
                }
                notifType = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(o, index, 8, an);
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, Monitor.class.getName(), "monitor", msg);
            }
            if (msg == null) {
                this.resetAllAlreadyNotified(o, index, an);
                derGauge = this.getDerivedGaugeFromComparable(object, attribute, value);
                o.setDerivedGauge(derGauge);
                o.setDerivedGaugeTimeStamp(System.currentTimeMillis());
                alarm = this.buildAlarmNotification(object, attribute, derGauge);
            }
        }
        if (msg != null) {
            this.sendNotification(notifType, System.currentTimeMillis(), msg, derGauge, trigger, object, true);
        }
        if (alarm != null && alarm.getType() != null) {
            this.sendNotification(alarm.getType(), System.currentTimeMillis(), alarm.getMessage(), derGauge, ((MonitorNotification)alarm).getTrigger(), object, false);
        }
    }

    private synchronized void cleanupFutures() {
        if (this.schedulerFuture != null) {
            this.schedulerFuture.cancel(false);
            this.schedulerFuture = null;
        }
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(false);
            this.monitorFuture = null;
        }
    }

    private synchronized void cleanupIsComplexTypeAttribute() {
        this.firstAttribute = null;
        this.remainingAttributes.clear();
        this.isComplexTypeAttribute = false;
    }

    static {
        String maximumPoolSizeSysProp = "jmx.x.monitor.maximum.pool.size";
        String maximumPoolSizeStr = AccessController.doPrivileged(new GetPropertyAction("jmx.x.monitor.maximum.pool.size"));
        if (maximumPoolSizeStr == null || maximumPoolSizeStr.trim().length() == 0) {
            maximumPoolSize = 10;
        } else {
            int maximumPoolSizeTmp = 10;
            try {
                maximumPoolSizeTmp = Integer.parseInt(maximumPoolSizeStr);
            }
            catch (NumberFormatException e) {
                if (JmxProperties.MONITOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "<static initializer>", "Wrong value for jmx.x.monitor.maximum.pool.size system property", e);
                    JmxProperties.MONITOR_LOGGER.logp(Level.FINER, Monitor.class.getName(), "<static initializer>", "jmx.x.monitor.maximum.pool.size defaults to 10");
                }
                maximumPoolSizeTmp = 10;
            }
            maximumPoolSize = maximumPoolSizeTmp < 1 ? 1 : maximumPoolSizeTmp;
        }
        executor = new ThreadPoolExecutor(maximumPoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("Executor"));
        ((ThreadPoolExecutor)executor).allowCoreThreadTimeOut(true);
        INTEGER_ZERO = new Integer(0);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final String nameSuffix = "]";

        public DaemonThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "JMX Monitor " + poolName + " Pool [Thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement() + "]", 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private class MonitorTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ScheduledFuture sf;
            Monitor monitor = Monitor.this;
            synchronized (monitor) {
                sf = Monitor.this.schedulerFuture;
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (Monitor.this.isActive()) {
                        int[] an = Monitor.this.alreadyNotifieds;
                        int index = 0;
                        for (ObservedObject o : Monitor.this.observedObjects) {
                            if (!Monitor.this.isActive()) continue;
                            Monitor.this.monitor(o, index++, an);
                        }
                    }
                    return null;
                }
            }, Monitor.this.acc);
            monitor = Monitor.this;
            synchronized (monitor) {
                if (Monitor.this.isActive() && Monitor.this.schedulerFuture == sf) {
                    Monitor.this.monitorFuture = null;
                    Monitor.this.schedulerFuture = scheduler.schedule(Monitor.this.schedulerTask, Monitor.this.getGranularityPeriod(), TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private class SchedulerTask
    implements Runnable {
        private Runnable task = null;

        public SchedulerTask(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Monitor monitor = Monitor.this;
            synchronized (monitor) {
                Monitor.this.monitorFuture = executor.submit(this.task);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NumericalType {
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE;

    }

    static class ObservedObject {
        private final ObjectName observedObject;
        private int alreadyNotified;
        private Object derivedGauge;
        private long derivedGaugeTimeStamp;

        public ObservedObject(ObjectName observedObject) {
            this.observedObject = observedObject;
        }

        public final ObjectName getObservedObject() {
            return this.observedObject;
        }

        public final synchronized int getAlreadyNotified() {
            return this.alreadyNotified;
        }

        public final synchronized void setAlreadyNotified(int alreadyNotified) {
            this.alreadyNotified = alreadyNotified;
        }

        public final synchronized Object getDerivedGauge() {
            return this.derivedGauge;
        }

        public final synchronized void setDerivedGauge(Object derivedGauge) {
            this.derivedGauge = derivedGauge;
        }

        public final synchronized long getDerivedGaugeTimeStamp() {
            return this.derivedGaugeTimeStamp;
        }

        public final synchronized void setDerivedGaugeTimeStamp(long derivedGaugeTimeStamp) {
            this.derivedGaugeTimeStamp = derivedGaugeTimeStamp;
        }
    }
}

