/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;

public class InformationDesc {
    public static final Object ONE_LINE = "oneline";
    public static final Object SHORT = "short";
    public static final Object TOOLTIP = "tooltip";
    public static final Object DEFAULT = "default";
    private Locale[] locales;
    private List info;
    private JNLPFile jnlpFile;

    public InformationDesc(JNLPFile jnlpFile, Locale[] locales) {
        this.jnlpFile = jnlpFile;
        this.locales = locales;
    }

    public String getTitle() {
        return (String)this.getItem("title");
    }

    public String getVendor() {
        return (String)this.getItem("vendor");
    }

    public URL getHomepage() {
        return (URL)this.getItem("homepage");
    }

    public String getDescription() {
        String result = this.getDescription(DEFAULT);
        if (result == null) {
            result = this.getDescription(ONE_LINE);
        }
        if (result == null) {
            result = this.getDescription(SHORT);
        }
        if (result == null) {
            result = this.getDescription(TOOLTIP);
        }
        return result;
    }

    public String getDescription(Object kind) {
        String result = (String)this.getItem("description-" + kind);
        if (result == null) {
            return (String)this.getItem("description-" + DEFAULT);
        }
        return result;
    }

    public IconDesc[] getIcons(Object kind) {
        List icons = this.getItems("icon-" + kind);
        return icons.toArray(new IconDesc[icons.size()]);
    }

    public URL getIconLocation(Object kind, int width, int height) {
        IconDesc[] icons = this.getIcons(kind);
        if (icons.length == 0) {
            return null;
        }
        IconDesc best = null;
        int i = 0;
        while (i < icons.length) {
            if (icons[i].getWidth() >= width && icons[i].getHeight() >= height) {
                if (best == null) {
                    best = icons[i];
                }
                if (icons[i].getWidth() <= best.getWidth() && icons[i].getHeight() <= best.getHeight()) {
                    best = icons[i];
                }
            }
            ++i;
        }
        if (best == null) {
            best = icons[0];
        }
        return best.getLocation();
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public JNLPFile getJNLPFile() {
        return this.jnlpFile;
    }

    public boolean isOfflineAllowed() {
        return this.getItem("offline-allowed") != null;
    }

    public boolean isSharingAllowed() {
        return this.getItem("sharing-allowed") != null;
    }

    protected Object getItem(Object key) {
        List items = this.getItems(key);
        if (items.size() == 0) {
            return null;
        }
        return items.get(items.size() - 1);
    }

    protected List getItems(Object key) {
        if (this.info == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.info.size()) {
            if (this.info.get(i).equals(key)) {
                result.add(this.info.get(i + 1));
            }
            i += 2;
        }
        return result;
    }

    protected void addItem(String key, Object value) {
        if (this.info == null) {
            this.info = new ArrayList();
        }
        this.info.add(key);
        this.info.add(value);
    }
}

