/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;

public class PluginBridge
extends JNLPFile {
    Version specVersion = new Version("1.0");
    Version fileVersion = new Version("1.1");
    String name;
    String[] jars;
    Hashtable atts;

    public PluginBridge(URL codebase, URL documentBase, String jar2, String main, int width, int height, Hashtable atts) throws Exception {
        this.codeBase = codebase;
        this.sourceLocation = documentBase;
        if (jar2 != null) {
            System.err.println("Jar string: " + jar2);
            this.jars = jar2.split(",");
            System.err.println("jars length: " + this.jars.length);
        }
        this.atts = atts;
        this.name = (String)atts.get("name");
        this.name = this.name == null ? "Applet" : String.valueOf(this.name) + " applet";
        if (main.endsWith(".class")) {
            main = main.substring(0, main.length() - 6);
        }
        this.launchType = new AppletDesc(this.name, main, documentBase, width, height, atts);
        this.security = main.endsWith(".class") ? new SecurityDesc(this, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost()) : null;
    }

    public String getTitle() {
        return this.name;
    }

    public InformationDesc getInformation(Locale locale) {
        return new InformationDesc(this, new Locale[]{locale}){

            protected List getItems(Object key) {
                ArrayList result = new ArrayList();
                return result;
            }
        };
    }

    public ResourcesDesc getResources(Locale locale, String os, String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            public List getResources(Class launchType) {
                ArrayList<JARDesc> result = new ArrayList<JARDesc>();
                result.addAll(PluginBridge.this.sharedResources.getResources(launchType));
                try {
                    if (launchType.equals(JARDesc.class) && PluginBridge.this.jars != null) {
                        int i = 0;
                        while (i < PluginBridge.this.jars.length) {
                            result.add(new JARDesc(new URL(PluginBridge.this.codeBase, PluginBridge.this.jars[i]), null, null, false, true, false));
                            ++i;
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                return result;
            }

            public JARDesc[] getJARs() {
                List resources = this.getResources(JARDesc.class);
                ArrayList<JARDesc> jars = new ArrayList<JARDesc>();
                int i = 0;
                while (i < resources.size()) {
                    Object resource = resources.get(i);
                    if (resource instanceof JARDesc) {
                        jars.add((JARDesc)resource);
                    }
                    ++i;
                }
                Object[] objectArray = jars.toArray();
                JARDesc[] jarArray = new JARDesc[objectArray.length];
                int i2 = 0;
                while (i2 < objectArray.length) {
                    jarArray[i2] = (JARDesc)objectArray[i2];
                    ++i2;
                }
                return jarArray;
            }

            public void addResource(Object resource) {
                PluginBridge.this.sharedResources.addResource(resource);
            }
        };
    }

    public boolean isApplet() {
        return true;
    }

    public boolean isApplication() {
        return false;
    }

    public boolean isComponent() {
        return false;
    }

    public boolean isInstaller() {
        return false;
    }
}

