/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.PackageDesc;
import net.sourceforge.jnlp.PropertyDesc;

public class ResourcesDesc {
    private Locale[] locales;
    private String[] os;
    private String[] arch;
    private JNLPFile jnlpFile;
    private List resources = new ArrayList();

    public ResourcesDesc(JNLPFile jnlpFile, Locale[] locales, String[] os, String[] arch) {
        this.jnlpFile = jnlpFile;
        this.locales = locales;
        this.os = os;
        this.arch = arch;
    }

    public JREDesc[] getJREs() {
        List resources = this.getResources(JREDesc.class);
        return resources.toArray(new JREDesc[resources.size()]);
    }

    public JARDesc getMainJAR() {
        JARDesc[] jars = this.getJARs();
        int i = 0;
        while (i < jars.length) {
            if (jars[i].isMain()) {
                return jars[i];
            }
            ++i;
        }
        if (jars.length > 0) {
            return jars[0];
        }
        return null;
    }

    public JARDesc[] getJARs() {
        List resources = this.getResources(JARDesc.class);
        return resources.toArray(new JARDesc[resources.size()]);
    }

    public JARDesc[] getJARs(String partName) {
        List resources = this.getResources(JARDesc.class);
        int i = resources.size();
        while (i-- > 0) {
            JARDesc jar2 = (JARDesc)resources.get(i);
            if (jar2.getPart().equals(partName)) continue;
            resources.remove(i);
        }
        return resources.toArray(new JARDesc[resources.size()]);
    }

    public ExtensionDesc[] getExtensions() {
        List resources = this.getResources(ExtensionDesc.class);
        return resources.toArray(new ExtensionDesc[resources.size()]);
    }

    public PackageDesc[] getPackages() {
        List resources = this.getResources(PackageDesc.class);
        return resources.toArray(new PackageDesc[resources.size()]);
    }

    public PackageDesc[] getPackages(String className) {
        List resources = this.getResources(PackageDesc.class);
        int i = resources.size();
        while (i-- > 0) {
            PackageDesc pk = (PackageDesc)resources.get(i);
            if (pk.matches(className)) continue;
            resources.remove(i);
        }
        return resources.toArray(new PackageDesc[resources.size()]);
    }

    public PropertyDesc[] getProperties() {
        List resources = this.getResources(PropertyDesc.class);
        return resources.toArray(new PropertyDesc[resources.size()]);
    }

    public Map getPropertiesMap() {
        Properties properties = new Properties();
        List resources = this.getResources(PropertyDesc.class);
        int i = 0;
        while (i < resources.size()) {
            PropertyDesc prop = (PropertyDesc)resources.get(i);
            properties.put(prop.getKey(), prop.getValue());
            ++i;
        }
        return properties;
    }

    public String[] getOS() {
        return this.os;
    }

    public String[] getArch() {
        return this.arch;
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public JNLPFile getJNLPFile() {
        return this.jnlpFile;
    }

    public List getResources(Class type) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.resources.size()) {
            if (type.isAssignableFrom(this.resources.get(i).getClass())) {
                result.add(this.resources.get(i));
            }
            ++i;
        }
        return result;
    }

    public void addResource(Object resource) {
        if (resource == null) {
            throw new IllegalArgumentException("null resource");
        }
        this.resources.add(resource);
    }
}

