/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Version {
    private static String seperators = ".-_";
    private static String emptyString = new String("<EMPTY>");
    private String versionString;

    public Version(String versions) {
        this.versionString = versions;
    }

    public boolean isVersionId() {
        return -1 == this.versionString.indexOf(" ");
    }

    public boolean matches(String version) {
        return this.matches(new Version(version));
    }

    public boolean matches(Version version) {
        List versionStrings = version.getVersionStrings();
        int i = 0;
        while (i < versionStrings.size()) {
            if (!this.matchesSingle((String)versionStrings.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matchesAny(String version) {
        return this.matches(new Version(version));
    }

    public boolean matchesAny(Version version) {
        List versionStrings = version.getVersionStrings();
        int i = 0;
        while (i < versionStrings.size()) {
            if (this.matchesSingle((String)versionStrings.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matchesSingle(String version) {
        List versionStrings = this.getVersionStrings();
        int i = 0;
        while (i < versionStrings.size()) {
            if (this.matches(version, (String)versionStrings.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matches(String subversion, String version) {
        List subparts = this.getParts(subversion);
        List parts = this.getParts(version);
        int maxLength = Math.max(subversion.length(), version.length());
        if (version.endsWith("*")) {
            maxLength = parts.size();
        }
        this.normalize(new List[]{subparts, parts}, maxLength);
        if (this.equal(subparts, parts)) {
            return true;
        }
        return version.endsWith("+") && this.greater(subparts, parts);
    }

    protected boolean equal(List parts1, List parts2) {
        int i = 0;
        while (i < parts1.size()) {
            if (this.compare((String)parts1.get(i), (String)parts2.get(i)) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean greater(List parts1, List parts2) {
        int i = 0;
        while (i < parts1.size()) {
            if (this.compare((String)parts1.get(i), (String)parts2.get(i)) > 0) {
                return true;
            }
            if (this.compare((String)parts1.get(i), (String)parts2.get(i)) < 0) {
                return false;
            }
            ++i;
        }
        return false;
    }

    protected int compare(String part1, String part2) {
        Integer number1 = new Integer(0);
        Integer number2 = new Integer(0);
        try {
            if (part1 != emptyString) {
                number1 = Integer.valueOf(part1);
            }
            if (part2 != emptyString) {
                number2 = Integer.valueOf(part2);
            }
            return number1.compareTo(number2);
        }
        catch (NumberFormatException numberFormatException) {
            if (part1 == emptyString) {
                part1 = "";
            }
            if (part2 == emptyString) {
                part2 = "";
            }
            return part1.compareTo(part2);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void normalize(List[] versions, int maxLength) {
        length = 0;
        i = 0;
        while (i < versions.length) {
            length = Math.max(length, versions[i].size());
            ++i;
        }
        if (length > maxLength) {
            length = maxLength;
        }
        i = 0;
        ** GOTO lbl20
        {
            versions[i].remove(versions[i].size() - 1);
            do {
                if (versions[i].size() > length) continue block1;
                while (versions[i].size() < length) {
                    versions[i].add(Version.emptyString);
                }
                ++i;
lbl20:
                // 2 sources

            } while (i < versions.length);
        }
    }

    protected List getVersionStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.versionString, " ");
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken());
        }
        return strings;
    }

    protected List getParts(String oneVersion) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(oneVersion, String.valueOf(seperators) + "+*");
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken());
        }
        return strings;
    }

    public String toString() {
        return this.versionString;
    }
}

