/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.ArrayList;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class CacheUtil {
    private static String R(String key, Object param) {
        return JNLPRuntime.getMessage(key, new Object[]{param});
    }

    public static boolean urlEquals(URL u1, URL u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return CacheUtil.compare(u1.getProtocol(), u2.getProtocol(), true) && CacheUtil.compare(u1.getHost(), u2.getHost(), true) && CacheUtil.compare(u1.getPath(), u2.getPath(), false) && CacheUtil.compare(u1.getQuery(), u2.getQuery(), false) && CacheUtil.compare(u1.getRef(), u2.getRef(), false);
    }

    public static URL getCachedResource(URL location, Version version, UpdatePolicy policy) {
        ResourceTracker rt = new ResourceTracker();
        rt.addResource(location, version, policy);
        try {
            File f = rt.getCacheFile(location);
            return f.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return location;
        }
    }

    private static boolean compare(String s1, String s2, boolean ignore) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (ignore) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static Permission getReadPermission(URL location, Version version) {
        if (CacheUtil.isCacheable(location, version)) {
            File file = CacheUtil.getCacheFile(location, version);
            return new FilePermission(file.getPath(), "read");
        }
        try {
            return location.openConnection().getPermission();
        }
        catch (IOException ioe) {
            if (JNLPRuntime.isDebug()) {
                ioe.printStackTrace();
            }
            return null;
        }
    }

    public static boolean isCurrent(URL source, Version version, URLConnection connection) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(CacheUtil.R("CNotCacheable", source));
        }
        try {
            if (connection == null) {
                connection = source.openConnection();
            }
            connection.connect();
            CacheEntry entry = new CacheEntry(source, version);
            boolean result = entry.isCurrent(connection);
            if (JNLPRuntime.isDebug()) {
                System.out.println("isCurrent: " + source + " = " + result);
            }
            return result;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            return CacheUtil.isCached(source, version);
        }
    }

    public static boolean isCached(URL source, Version version) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(CacheUtil.R("CNotCacheable", source));
        }
        CacheEntry entry = new CacheEntry(source, version);
        boolean result = entry.isCached();
        if (JNLPRuntime.isDebug()) {
            System.out.println("isCached: " + source + " = " + result);
        }
        return result;
    }

    public static boolean isCacheable(URL source, Version version) {
        if (source == null) {
            return false;
        }
        if (source.getProtocol().equals("file")) {
            return false;
        }
        return !source.getProtocol().equals("jar");
    }

    public static File getCacheFile(URL source, Version version) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(CacheUtil.R("CNotCacheable", source));
        }
        try {
            File localFile = CacheUtil.urlToPath(source, "cache");
            localFile.getParentFile().mkdirs();
            return localFile;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static OutputStream getOutputStream(URL source, Version version) throws IOException {
        File localFile = CacheUtil.getCacheFile(source, version);
        FileOutputStream out = new FileOutputStream(localFile);
        return new BufferedOutputStream(out);
    }

    public static void streamCopy(InputStream is, OutputStream os) throws IOException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        if (!(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        try {
            int c;
            byte[] b = new byte[4096];
            while ((c = is.read(b, 0, b.length)) != -1) {
                os.write(b, 0, c);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static File urlToPath(URL location, String subdir) {
        StringBuffer path = new StringBuffer();
        if (subdir != null) {
            path.append(subdir);
            path.append(File.separatorChar);
        }
        path.append(location.getProtocol());
        path.append(File.separatorChar);
        path.append(location.getHost());
        path.append(File.separatorChar);
        path.append(location.getPath().replace('/', File.separatorChar));
        return new File(JNLPRuntime.getBaseDir(), CacheUtil.fixPath(path.toString()));
    }

    private static String fixPath(String path) {
        char[] badChars = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        int i = 0;
        while (i < badChars.length) {
            if (badChars[i] != File.separatorChar && -1 != path.indexOf(badChars[i])) {
                path = path.replace(badChars[i], 'X');
            }
            ++i;
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    public static void waitForResources(ApplicationInstance app, ResourceTracker tracker, URL[] resources, String title) {
        block16: {
            indicator = JNLPRuntime.getDefaultDownloadIndicator();
            listener = null;
            if (indicator != null) break block16;
            tracker.waitForResources(resources, 0L);
            while (true) {
                if (listener != null) {
                    indicator.disposeListener(listener);
                }
                return;
            }
        }
        try {
            try {
                if (tracker.waitForResources(resources, indicator.getInitialDelay())) ** continue;
                urlList = new ArrayList<URL>();
                i = 0;
                while (i < resources.length) {
                    if (!tracker.checkResource(resources[i])) {
                        urlList.add(resources[i]);
                    }
                    ++i;
                }
                undownloaded = urlList.toArray(new URL[urlList.size()]);
                listener = indicator.getListener(app, title, undownloaded);
                do {
                    read = 0L;
                    total = 0L;
                    i = 0;
                    while (i < undownloaded.length) {
                        total += tracker.getTotalSize(undownloaded[i]);
                        read += tracker.getAmountRead(undownloaded[i]);
                        ++i;
                    }
                    percent = (int)(100L * read / Math.max(1L, total));
                    i = 0;
                    while (i < undownloaded.length) {
                        listener.progress(undownloaded[i], "version", tracker.getAmountRead(undownloaded[i]), tracker.getTotalSize(undownloaded[i]), percent);
                        ++i;
                    }
                } while (!tracker.waitForResources(resources, indicator.getUpdateRate()));
                i = 0;
                while (i < undownloaded.length) {
                    listener.progress(undownloaded[i], "version", tracker.getTotalSize(undownloaded[i]), tracker.getTotalSize(undownloaded[i]), 100);
                    ++i;
                }
            }
            catch (InterruptedException ex) {
                if (JNLPRuntime.isDebug()) {
                    ex.printStackTrace();
                }
                if (listener == null) ** GOTO lbl60
                indicator.disposeListener(listener);
            }
        }
        catch (Throwable var14_15) {
            if (listener != null) {
                indicator.disposeListener(listener);
            }
            throw var14_15;
        }
        if (listener != null) {
            indicator.disposeListener(listener);
        }
lbl60:
        // 5 sources

    }
}

