/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.AppletAudioClip;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.WeakList;

public class AppletEnvironment
implements AppletContext,
AppletStub {
    private JNLPFile file;
    private AppletInstance appletInstance;
    private Applet applet;
    private Map parameters;
    private Container cont;
    private WeakList weakClips = new WeakList();
    private boolean appletStarted = false;
    private boolean destroyed = false;

    public AppletEnvironment(JNLPFile file, AppletInstance appletInstance, Container cont) {
        this.file = file;
        this.appletInstance = appletInstance;
        this.applet = appletInstance.getApplet();
        this.parameters = file.getApplet().getParameters();
        this.cont = cont;
    }

    public AppletEnvironment(JNLPFile file, final AppletInstance appletInstance) {
        this(file, appletInstance, null);
        Frame frame = new Frame(String.valueOf(file.getApplet().getName()) + " - Applet");
        frame.setResizable(false);
        appletInstance.addWindow(frame);
        WindowAdapter closer = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                appletInstance.destroy();
                System.exit(0);
            }
        };
        frame.addWindowListener(closer);
        this.cont = frame;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Illegal applet stub/context access: applet destroyed.");
        }
    }

    public void destroy() {
        this.destroyed = true;
        List clips = this.weakClips.hardList();
        int i = 0;
        while (i < clips.size()) {
            ((AppletAudioClip)clips.get(i)).dispose();
            ++i;
        }
    }

    public Container getAppletFrame() {
        return this.cont;
    }

    public void startApplet() {
        block9: {
            this.checkDestroyed();
            if (this.appletStarted) {
                return;
            }
            this.appletStarted = true;
            try {
                AppletDesc appletDesc = this.file.getApplet();
                if (this.cont instanceof AppletStub) {
                    this.applet.setStub((AppletStub)((Object)this.cont));
                } else {
                    this.applet.setStub(this);
                }
                this.cont.setLayout(new BorderLayout());
                this.cont.add("Center", this.applet);
                this.cont.validate();
                if (this.cont instanceof Frame) {
                    Frame frame = (Frame)this.cont;
                    frame.pack();
                    Insets insets = frame.getInsets();
                    frame.setSize(appletDesc.getWidth() + insets.left + insets.right, appletDesc.getHeight() + insets.top + insets.bottom);
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            AppletEnvironment.this.cont.setVisible(true);
                            AppletEnvironment.this.applet.init();
                            AppletEnvironment.this.applet.start();
                            AppletEnvironment.this.cont.invalidate();
                            AppletEnvironment.this.cont.validate();
                            AppletEnvironment.this.cont.repaint();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            catch (Exception ex) {
                if (!JNLPRuntime.isDebug()) break block9;
                ex.printStackTrace();
            }
        }
    }

    public Applet getApplet(String name) {
        this.checkDestroyed();
        if (name != null && name.equals(this.file.getApplet().getName())) {
            return this.applet;
        }
        return null;
    }

    public Enumeration getApplets() {
        this.checkDestroyed();
        return Collections.enumeration((Collection)Arrays.asList(this.applet));
    }

    public AudioClip getAudioClip(URL location) {
        this.checkDestroyed();
        AppletAudioClip clip = new AppletAudioClip(location);
        this.weakClips.add(clip);
        this.weakClips.trimToSize();
        return clip;
    }

    public Image getImage(URL location) {
        this.checkDestroyed();
        Image image = new ImageIcon(location).getImage();
        return image;
    }

    public void showDocument(URL uRL) {
        this.checkDestroyed();
    }

    public void showDocument(URL uRL, String str) {
        this.checkDestroyed();
    }

    public void showStatus(String str) {
        this.checkDestroyed();
    }

    public void setStream(String key, InputStream stream) {
        this.checkDestroyed();
    }

    public InputStream getStream(String key) {
        this.checkDestroyed();
        return null;
    }

    public Iterator getStreamKeys() {
        this.checkDestroyed();
        return null;
    }

    public void appletResize(int width, int height) {
        this.checkDestroyed();
        if (this.cont instanceof Frame) {
            Frame frame = (Frame)this.cont;
            Insets insets = frame.getInsets();
            frame.setSize(width + insets.left + insets.right, height + insets.top + insets.bottom);
        }
    }

    public AppletContext getAppletContext() {
        this.checkDestroyed();
        return this;
    }

    public URL getCodeBase() {
        this.checkDestroyed();
        return this.file.getCodeBase();
    }

    public URL getDocumentBase() {
        this.checkDestroyed();
        return this.file.getApplet().getDocumentBase();
    }

    public String getParameter(String name) {
        this.checkDestroyed();
        String s = (String)this.parameters.get(name);
        if (s != null) {
            return s;
        }
        return (String)this.parameters.get(name.toLowerCase());
    }

    public boolean isActive() {
        this.checkDestroyed();
        return true;
    }
}

