/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Window;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.event.EventListenerList;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.event.ApplicationEvent;
import net.sourceforge.jnlp.event.ApplicationListener;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.WeakList;

public class ApplicationInstance {
    private JNLPFile file;
    private ThreadGroup group;
    private ClassLoader loader;
    private boolean stopped = false;
    private WeakList weakWindows = new WeakList();
    private EventListenerList listeners = new EventListenerList();
    private boolean isSigned = false;

    public ApplicationInstance(JNLPFile file, ThreadGroup group, ClassLoader loader) {
        this.file = file;
        this.group = group;
        this.loader = loader;
        this.isSigned = ((JNLPClassLoader)loader).getSigning();
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.listeners.add(ApplicationListener.class, listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.listeners.remove(ApplicationListener.class, listener);
    }

    protected void fireDestroyed() {
        Object[] list = this.listeners.getListenerList();
        ApplicationEvent event = null;
        int i = list.length - 1;
        while (i > 0) {
            if (event == null) {
                event = new ApplicationEvent(this);
            }
            ((ApplicationListener)list[i]).applicationDestroyed(event);
            i -= 2;
        }
    }

    public void initialize() {
        this.installEnvironment();
    }

    public void finalize() {
        this.destroy();
    }

    void installEnvironment() {
        final PropertyDesc[] props = this.file.getResources().getProperties();
        PrivilegedAction installProps = new PrivilegedAction(){

            public Object run() {
                int i = 0;
                while (i < props.length) {
                    System.setProperty(props[i].getKey(), props[i].getValue());
                    ++i;
                }
                return null;
            }
        };
        AccessController.doPrivileged(installProps);
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    public String getTitle() {
        return this.file.getTitle();
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    public void destroy() {
        if (this.stopped) {
            return;
        }
        try {
            int i = 0;
            while (i < this.weakWindows.size()) {
                Window w = (Window)this.weakWindows.get(i);
                if (w != null) {
                    w.dispose();
                }
                ++i;
            }
            this.weakWindows.clear();
            Thread[] threads = new Thread[this.group.activeCount() * 2];
            int nthreads = this.group.enumerate(threads);
            int i2 = 0;
            while (i2 < nthreads) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Interrupt thread: " + threads[i2]);
                }
                threads[i2].interrupt();
                ++i2;
            }
            Thread.currentThread();
            Thread.yield();
            nthreads = this.group.enumerate(threads);
            i2 = 0;
            while (i2 < nthreads) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Stop thread: " + threads[i2]);
                }
                threads[i2].stop();
                ++i2;
            }
        }
        finally {
            this.stopped = true;
            this.fireDestroyed();
        }
    }

    public ThreadGroup getThreadGroup() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.group;
    }

    public ClassLoader getClassLoader() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.loader;
    }

    protected void addWindow(Window window) {
        this.weakWindows.add(window);
        this.weakWindows.trimToSize();
    }

    public boolean isSigned() {
        return this.isSigned;
    }
}

