/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityDialogUI;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import sun.misc.Launcher;

public class AccessWarningPane
extends SecurityDialogUI {
    JCheckBox alwaysAllow;
    Object[] extras;

    public AccessWarningPane(JComponent x) {
        super(x);
    }

    public AccessWarningPane(JComponent x, Object[] extras) {
        super(x);
        this.extras = extras;
    }

    protected void installComponents() {
        SecurityWarningDialog.AccessType type = ((SecurityWarningDialog)this.optionPane).getType();
        JNLPFile file = ((SecurityWarningDialog)this.optionPane).getFile();
        String name = "";
        String publisher = "";
        String from = "";
        try {
            name = file.getInformation().getTitle();
        }
        catch (Exception exception) {}
        try {
            publisher = file.getInformation().getVendor();
        }
        catch (Exception exception) {}
        try {
            from = file.getInformation().getHomepage().toString();
        }
        catch (Exception exception) {}
        String topLabelText = "";
        switch (type) {
            case READ_FILE: {
                topLabelText = AccessWarningPane.R("SFileReadAccess");
                break;
            }
            case WRITE_FILE: {
                topLabelText = AccessWarningPane.R("SFileWriteAccess");
                break;
            }
            case CLIPBOARD_READ: {
                topLabelText = AccessWarningPane.R("SClipboardReadAccess");
                break;
            }
            case CLIPBOARD_WRITE: {
                topLabelText = AccessWarningPane.R("SClipboardWriteAccess");
                break;
            }
            case PRINTER: {
                topLabelText = AccessWarningPane.R("SPrinterAccess");
                break;
            }
            case NETWORK: {
                topLabelText = this.extras != null && this.extras.length >= 0 ? AccessWarningPane.R("SNetworkAccess", this.extras[0]) : AccessWarningPane.R("SNetworkAccess", "(address here)");
            }
        }
        ImageIcon icon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/warning.png"));
        JLabel topLabel = new JLabel(this.htmlWrap(topLabelText), icon, 2);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(400, 60));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel nameLabel = new JLabel("Name:   " + name);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel publisherLabel = new JLabel("Publisher: " + publisher);
        publisherLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel fromLabel = new JLabel("From:   " + from);
        fromLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.alwaysAllow = new JCheckBox("Always allow this action");
        this.alwaysAllow.setEnabled(false);
        JPanel infoPanel = new JPanel(new GridLayout(4, 1));
        infoPanel.add(nameLabel);
        infoPanel.add(publisherLabel);
        infoPanel.add(fromLabel);
        infoPanel.add(this.alwaysAllow);
        infoPanel.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton run = new JButton("Allow");
        JButton cancel = new JButton("Cancel");
        run.addActionListener(this.createButtonActionListener(0));
        run.addActionListener(new CheckBoxListener());
        cancel.addActionListener(this.createButtonActionListener(1));
        this.initialFocusComponent = cancel;
        buttonPanel.add(run);
        buttonPanel.add(cancel);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        main.add(topPanel);
        main.add(infoPanel);
        main.add(buttonPanel);
        this.optionPane.add((Component)main, "Center");
    }

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    private static String R(String key, Object param) {
        return JNLPRuntime.getMessage(key, new Object[]{param});
    }

    protected String htmlWrap(String s) {
        return "<html>" + s + "</html>";
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AccessWarningPane.this.alwaysAllow != null) {
                AccessWarningPane.this.alwaysAllow.isSelected();
            }
        }
    }
}

