/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.OptionPaneUI;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityWarningDialog;

public abstract class SecurityDialogUI
extends OptionPaneUI {
    protected JOptionPane optionPane;
    Component initialFocusComponent;
    private PropertyChangeListener propertyChangeListener;
    private Handler handler;

    public SecurityDialogUI(JComponent x) {
        this.optionPane = (JOptionPane)x;
    }

    public void installUI(JComponent c) {
        if (((SecurityWarningDialog)c).isInitialized()) {
            this.setSystemLookAndFeel();
            this.optionPane = (JOptionPane)c;
            this.optionPane.setLayout(new BorderLayout());
            this.installComponents();
            this.installListeners();
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.getHandler();
        if (this.propertyChangeListener != null) {
            this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallComponents() {
        this.initialFocusComponent = null;
        this.optionPane.removeAll();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public void selectInitialValue(JOptionPane op) {
        JRootPane root;
        if (this.initialFocusComponent != null) {
            this.initialFocusComponent.requestFocus();
        }
        if (this.initialFocusComponent instanceof JButton && (root = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
            root.setDefaultButton((JButton)this.initialFocusComponent);
        }
    }

    public boolean containsCustomComponents(JOptionPane op) {
        return false;
    }

    protected ActionListener createButtonActionListener(int buttonIndex) {
        return new ButtonActionListener(buttonIndex);
    }

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    private String htmlWrap(String s) {
        return "<html>" + s + "</html>";
    }

    private void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
    }

    protected abstract void installComponents();

    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int buttonIndex) {
            this.buttonIndex = buttonIndex;
        }

        public void actionPerformed(ActionEvent e) {
            if (SecurityDialogUI.this.optionPane != null) {
                SecurityDialogUI.this.optionPane.setValue(new Integer(this.buttonIndex));
            }
        }
    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == SecurityDialogUI.this.optionPane) {
                String changeName = e.getPropertyName();
                if (changeName == "options" || changeName == "initialValue" || changeName == "icon" || changeName == "messageType" || changeName == "optionType" || changeName == "message" || changeName == "selectionValues" || changeName == "initialSelectionValue" || changeName == "wantsInput") {
                    SecurityDialogUI.this.uninstallComponents();
                    SecurityDialogUI.this.installComponents();
                    SecurityDialogUI.this.optionPane.validate();
                } else if (changeName == "componentOrientation") {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JOptionPane op = (JOptionPane)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        op.applyComponentOrientation(o);
                    }
                }
            }
        }
    }
}

