/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import javax.jnlp.ClipboardService;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.services.ServiceUtil;

class XClipboardService
implements ClipboardService {
    protected XClipboardService() {
    }

    public Transferable getContents() {
        if (ServiceUtil.checkAccess(SecurityWarningDialog.AccessType.CLIPBOARD_READ, new Object[0])) {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return (Transferable)ServiceUtil.createPrivilegedProxy(Transferable.class, t);
        }
        return null;
    }

    public void setContents(Transferable contents) {
        if (ServiceUtil.checkAccess(SecurityWarningDialog.AccessType.CLIPBOARD_WRITE, new Object[0])) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        }
    }
}

