/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.services.XFileContents;

class XPersistenceService
implements PersistenceService {
    protected XPersistenceService() {
    }

    protected void checkLocation(URL location) throws MalformedURLException {
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app == null) {
            throw new MalformedURLException("Cannot determine the current application.");
        }
        URL source = app.getJNLPFile().getCodeBase();
        if (!source.getHost().equalsIgnoreCase(location.getHost())) {
            throw new MalformedURLException("Cannot access data from a different host.");
        }
        String requestPath = location.getFile();
        requestPath = -1 != requestPath.lastIndexOf("/") ? requestPath.substring(0, requestPath.lastIndexOf("/")) : "";
        if (JNLPRuntime.isDebug()) {
            System.out.println("codebase path: " + source.getFile());
            System.out.println("request path: " + requestPath);
        }
        if (!source.getFile().startsWith(requestPath)) {
            throw new MalformedURLException("Cannot access data below source URL path.");
        }
    }

    protected File toCacheFile(URL location) throws MalformedURLException {
        return CacheUtil.urlToPath(location, "pcache");
    }

    public long create(URL location, long maxsize) throws MalformedURLException, IOException {
        this.checkLocation(location);
        File file = this.toCacheFile(location);
        file.getParentFile().mkdirs();
        if (!file.createNewFile()) {
            throw new IOException("File already exists.");
        }
        return maxsize;
    }

    public void delete(URL location) throws MalformedURLException, IOException {
        this.checkLocation(location);
        this.toCacheFile(location).delete();
    }

    public FileContents get(URL location) throws MalformedURLException, IOException, FileNotFoundException {
        this.checkLocation(location);
        File file = this.toCacheFile(location);
        if (!file.exists()) {
            throw new FileNotFoundException("Persistence store for " + location.toString() + " is not found.");
        }
        file.getParentFile().mkdirs();
        return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(file));
    }

    public String[] getNames(URL location) throws MalformedURLException, IOException {
        this.checkLocation(location);
        File file = this.toCacheFile(location);
        if (!file.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        File[] entries = file.listFiles();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isFile()) {
                result.add(entries[i].getName());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public int getTag(URL location) throws MalformedURLException, IOException {
        this.checkLocation(location);
        if (this.toCacheFile(location).exists()) {
            return 0;
        }
        return 0;
    }

    public void setTag(URL location, int tag) throws MalformedURLException, IOException {
        this.checkLocation(location);
    }
}

