/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.jnlp.PrintService;
import javax.swing.JOptionPane;

public class XPrintService
implements PrintService {
    private PrinterJob pj = PrinterJob.getPrinterJob();

    public PageFormat getDefaultPage() {
        if (this.pj != null) {
            return this.pj.defaultPage();
        }
        this.showWarning();
        return new PageFormat();
    }

    public PageFormat showPageFormatDialog(PageFormat page) {
        if (this.pj != null) {
            return this.pj.pageDialog(page);
        }
        this.showWarning();
        return page;
    }

    public boolean print(Pageable document) {
        if (this.pj != null) {
            this.pj.setPageable(document);
            if (this.pj.printDialog()) {
                try {
                    this.pj.print();
                    return true;
                }
                catch (PrinterException pe) {
                    System.err.println("Could not print: " + pe);
                    return false;
                }
            }
        } else {
            this.showWarning();
        }
        return false;
    }

    public boolean print(Printable painter) {
        if (this.pj != null) {
            this.pj.setPrintable(painter);
            if (this.pj.printDialog()) {
                try {
                    this.pj.print();
                    return true;
                }
                catch (PrinterException pe) {
                    System.err.println("Could not print: " + pe);
                    return false;
                }
            }
        } else {
            this.showWarning();
        }
        return false;
    }

    private void showWarning() {
        JOptionPane.showMessageDialog(null, "Unable to find a default printer.", "Warning", 2);
        System.err.println("Unable to print: Unable to find default printer.");
    }
}

