/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools;

import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.IdentityScope;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.tools.KeyTool;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.SignatureFileVerifier;
import sun.security.x509.NetscapeCertTypeExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSigner {
    private static final Collator collator = Collator.getInstance();
    private static final String META_INF = "META-INF/";
    private static final String SIG_PREFIX = "META-INF/SIG-";
    private static final long SIX_MONTHS = 15552000000L;
    static final String VERSION = "1.0";
    static final int IN_KEYSTORE = 1;
    static final int IN_SCOPE = 2;
    X509Certificate[] certChain;
    PrivateKey privateKey;
    KeyStore store;
    IdentityScope scope;
    String keystore;
    boolean nullStream = false;
    boolean token = false;
    String jarfile;
    String alias;
    char[] storepass;
    boolean protectedPath;
    String storetype;
    String providerName;
    Vector<String> providers = null;
    HashMap<String, String> providerArgs = new HashMap();
    char[] keypass;
    String sigfile;
    String sigalg;
    String digestalg = "SHA1";
    String signedjar;
    String tsaUrl;
    String tsaAlias;
    boolean verify = false;
    boolean verbose = false;
    boolean showcerts = false;
    boolean debug = false;
    boolean signManifest = true;
    boolean externalSF = true;
    private boolean hasExpiredCert = false;
    private boolean hasExpiringCert = false;
    private boolean notYetValidCert = false;
    private boolean badKeyUsage = false;
    private boolean badExtendedKeyUsage = false;
    private boolean badNetscapeCertType = false;
    private boolean alreadyTrustPublisher = false;
    private boolean rootInCacerts = false;
    private CertPath certPath = null;
    private boolean noSigningIssues = true;
    private boolean anyJarsSigned = false;
    private ArrayList<String> verifiedJars = null;
    private ArrayList<String> unverifiedJars = null;
    private ArrayList<CertPath> certs = null;
    private ArrayList<String> details = new ArrayList();
    Hashtable<Certificate, String> storeHash = new Hashtable();

    static {
        collator.setStrength(0);
    }

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    public boolean getAlreadyTrustPublisher() {
        return this.alreadyTrustPublisher;
    }

    public boolean getRootInCacerts() {
        return this.rootInCacerts;
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public boolean hasSigningIssues() {
        return this.hasExpiredCert || this.notYetValidCert || this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType;
    }

    public boolean noSigningIssues() {
        return this.noSigningIssues;
    }

    public boolean anyJarsSigned() {
        return this.anyJarsSigned;
    }

    public ArrayList<String> getDetails() {
        return this.details;
    }

    public ArrayList<CertPath> getCerts() {
        return this.certs;
    }

    public void verifyJars(List<JARDesc> jars, ResourceTracker tracker) throws Exception {
        int i = 0;
        while (i < jars.size()) {
            JARDesc jar2 = jars.get(i);
            this.verifiedJars = new ArrayList();
            this.unverifiedJars = new ArrayList();
            this.certs = new ArrayList();
            String localFile = tracker.getCacheFile(jar2.getLocation()).getAbsolutePath();
            boolean result = this.verifyJar(localFile);
            this.checkTrustedCerts();
            if (!result) {
                this.noSigningIssues = false;
                this.unverifiedJars.add(localFile);
            } else {
                this.verifiedJars.add(localFile);
            }
            ++i;
        }
    }

    public boolean verifyJar(String jarName) throws Exception {
        boolean anySigned = false;
        boolean hasUnsignedEntry = false;
        ZipFile jf = null;
        try {
            try {
                jf = new JarFile(jarName, true);
                Vector<JarEntry> entriesVec = new Vector<JarEntry>();
                byte[] buffer = new byte[8192];
                Enumeration<JarEntry> entries = ((JarFile)jf).entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    entriesVec.addElement(je);
                    InputStream is = null;
                    try {
                        is = ((JarFile)jf).getInputStream(je);
                        while (is.read(buffer, 0, buffer.length) != -1) {
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                Manifest man = ((JarFile)jf).getManifest();
                if (man != null) {
                    if (this.verbose) {
                        System.out.println();
                    }
                    Enumeration e = entriesVec.elements();
                    long now = System.currentTimeMillis();
                    while (e.hasMoreElements()) {
                        JarEntry je = (JarEntry)e.nextElement();
                        String name = je.getName();
                        CodeSigner[] signers = je.getCodeSigners();
                        boolean isSigned = signers != null;
                        anySigned |= isSigned;
                        hasUnsignedEntry |= !je.isDirectory() && !isSigned && !this.signatureRelated(name);
                        if (!isSigned) continue;
                        int i = 0;
                        while (i < signers.length) {
                            Certificate cert;
                            CertPath certPath = signers[i].getSignerCertPath();
                            if (!this.certs.contains(certPath)) {
                                this.certs.add(certPath);
                            }
                            if (!certPath.equals(this.certPath)) {
                                this.certPath = certPath;
                            }
                            if ((cert = signers[i].getSignerCertPath().getCertificates().get(0)) instanceof X509Certificate) {
                                this.checkCertUsage((X509Certificate)cert, null);
                                if (!this.showcerts) {
                                    long notAfter = ((X509Certificate)cert).getNotAfter().getTime();
                                    if (notAfter < now) {
                                        this.hasExpiredCert = true;
                                    } else if (notAfter < now + 15552000000L) {
                                        this.hasExpiringCert = true;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (anySigned) {
                    this.anyJarsSigned = true;
                    if (hasUnsignedEntry || this.hasExpiredCert || this.hasExpiringCert || this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType || this.notYetValidCert) {
                        this.addToDetails(JarSigner.R("SRunWithoutRestrictions"));
                        if (this.badKeyUsage) {
                            this.addToDetails(JarSigner.R("SBadKeyUsage"));
                        }
                        if (this.badExtendedKeyUsage) {
                            this.addToDetails(JarSigner.R("SBadExtendedKeyUsage"));
                        }
                        if (this.badNetscapeCertType) {
                            this.addToDetails(JarSigner.R("SBadNetscapeCertType"));
                        }
                        if (hasUnsignedEntry) {
                            this.addToDetails(JarSigner.R("SHasUnsignedEntry"));
                        }
                        if (this.hasExpiredCert) {
                            this.addToDetails(JarSigner.R("SHasExpiredCert"));
                        }
                        if (this.hasExpiringCert) {
                            this.addToDetails(JarSigner.R("SHasExpiringCert"));
                        }
                        if (this.notYetValidCert) {
                            this.addToDetails(JarSigner.R("SNotYetValidCert"));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (jf != null) {
                jf.close();
            }
        }
        return anySigned && !hasUnsignedEntry && !this.hasExpiredCert && !this.badKeyUsage && !this.badExtendedKeyUsage && !this.badNetscapeCertType && !this.notYetValidCert;
    }

    private void checkTrustedCerts() throws Exception {
        if (this.certPath != null) {
            KeyTool kt = new KeyTool();
            this.alreadyTrustPublisher = kt.isTrusted(this.getPublisher());
            this.rootInCacerts = kt.checkCacertsForCertificate(this.getRoot());
            if (!this.rootInCacerts) {
                this.addToDetails(JarSigner.R("SUntrustedCertificate"));
            } else {
                this.addToDetails(JarSigner.R("STrustedCertificate"));
            }
        }
    }

    public Certificate getPublisher() {
        if (this.certPath != null) {
            List<? extends Certificate> certList = this.certPath.getCertificates();
            if (certList.size() > 0) {
                return certList.get(0);
            }
            return null;
        }
        return null;
    }

    public Certificate getRoot() {
        if (this.certPath != null) {
            List<? extends Certificate> certList = this.certPath.getCertificates();
            if (certList.size() > 0) {
                return certList.get(certList.size() - 1);
            }
            return null;
        }
        return null;
    }

    private void addToDetails(String detail) {
        if (!this.details.contains(detail)) {
            this.details.add(detail);
        }
    }

    private boolean signatureRelated(String name) {
        String ucName = name.toUpperCase();
        if (ucName.equals("META-INF/MANIFEST.MF") || ucName.equals(META_INF) || ucName.startsWith(SIG_PREFIX) && ucName.indexOf("/") == ucName.lastIndexOf("/")) {
            return true;
        }
        if (ucName.startsWith(META_INF) && SignatureFileVerifier.isBlockOrSF(ucName)) {
            return ucName.indexOf("/") == ucName.lastIndexOf("/");
        }
        return false;
    }

    void checkCertUsage(X509Certificate userCert, boolean[] bad) {
        boolean[] keyUsage;
        if (bad != null) {
            bad[2] = false;
            bad[1] = false;
            bad[0] = false;
        }
        if (!((keyUsage = userCert.getKeyUsage()) == null || keyUsage.length >= 1 && keyUsage[0])) {
            if (bad != null) {
                bad[0] = true;
            } else {
                this.badKeyUsage = true;
            }
        }
        try {
            List<String> xKeyUsage = userCert.getExtendedKeyUsage();
            if (xKeyUsage != null && !xKeyUsage.contains("2.5.29.37.0") && !xKeyUsage.contains("1.3.6.1.5.5.7.3.3")) {
                if (bad != null) {
                    bad[1] = true;
                } else {
                    this.badExtendedKeyUsage = true;
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {}
        try {
            byte[] netscapeEx = userCert.getExtensionValue("2.16.840.1.113730.1.1");
            if (netscapeEx != null) {
                DerInputStream in = new DerInputStream(netscapeEx);
                byte[] encoded = in.getOctetString();
                NetscapeCertTypeExtension extn = new NetscapeCertTypeExtension(encoded = new DerValue(encoded).getUnalignedBitString().toByteArray());
                Boolean val = (Boolean)extn.get("object_signing");
                if (!val.booleanValue()) {
                    if (bad != null) {
                        bad[2] = true;
                    } else {
                        this.badNetscapeCertType = true;
                    }
                }
            }
        }
        catch (IOException iOException) {}
    }
}

