/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.lang.reflect.Method;

public class Reflect {
    private boolean accessible;
    private static Object[] zero = new Object[0];

    public Reflect() {
    }

    public Reflect(boolean accessible) {
        this.accessible = accessible;
    }

    public Object invokeStatic(String className, String method) {
        return this.invokeStatic(className, method, zero);
    }

    public Object invokeStatic(String className, String method, Object[] args) {
        try {
            Class<?> c = Class.forName(className, true, Reflect.class.getClassLoader());
            Method m = this.getMethod(c, method, args);
            if (m.isAccessible() != this.accessible) {
                m.setAccessible(this.accessible);
            }
            return m.invoke(null, args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object invoke(Object object, String method) {
        return this.invoke(object, method, zero);
    }

    public Object invoke(Object object, String method, Object[] args) {
        try {
            Method m = this.getMethod(object.getClass(), method, args);
            if (m.isAccessible() != this.accessible) {
                m.setAccessible(this.accessible);
            }
            return m.invoke(object, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Method getMethod(Class type, String method, Object[] args) {
        try {
            Class c = type;
            while (c != null) {
                Method[] methods = c.getMethods();
                int i = 0;
                while (i < methods.length) {
                    Class<?>[] parameters;
                    if (methods[i].getName().equals(method) && (parameters = methods[i].getParameterTypes()).length == args.length) {
                        return methods[i];
                    }
                    ++i;
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

