/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.jnlp.NetxPanel;
import sun.applet.AppletAudioClip;
import sun.applet.AppletEvent;
import sun.applet.AppletImageRef;
import sun.applet.AppletListener;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurity;
import sun.applet.AppletViewerPanel;
import sun.applet.PluginAppletViewerFactory;
import sun.applet.PluginMain;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.XEmbeddedFrame;
import sun.misc.Ref;

public class PluginAppletViewer
extends XEmbeddedFrame
implements AppletContext,
Printable {
    private static String defaultSaveFile = "Applet.ser";
    AppletViewerPanel panel;
    Label label;
    PrintStream statusMsgStream;
    PluginAppletViewerFactory factory;
    private static Map audioClips = new HashMap();
    private static Map imageRefs = new HashMap();
    static Vector appletPanels = new Vector();
    static Hashtable systemParam = new Hashtable();
    static int c;
    private static int x;
    private static int y;
    private static final int XDELTA = 30;
    private static final int YDELTA = 30;
    static String encoding;
    private static AppletMessageHandler amh;

    public PluginAppletViewer(long handle, int x, int y, URL doc, Hashtable atts, PrintStream statusMsgStream, PluginAppletViewerFactory factory) {
        super(handle, true);
        this.factory = factory;
        this.statusMsgStream = statusMsgStream;
        try {
            this.panel = new NetxPanel(doc, atts);
            AppletViewerPanel.debug("Using NetX panel");
        }
        catch (Exception ex) {
            AppletViewerPanel.debug("Unable to start NetX applet - defaulting to Sun applet", ex);
            this.panel = new AppletViewerPanel(doc, atts);
        }
        this.add("Center", this.panel);
        this.panel.init();
        appletPanels.addElement(this.panel);
        this.pack();
        this.setVisible(true);
        WindowAdapter windowEventListener = new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PluginAppletViewer.this.appletClose();
            }

            public void windowIconified(WindowEvent evt) {
                PluginAppletViewer.this.appletStop();
            }

            public void windowDeiconified(WindowEvent evt) {
                PluginAppletViewer.this.appletStart();
            }
        };
        ComponentAdapter componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                if (PluginAppletViewer.this.panel != null) {
                    ComponentListener[] l = PluginAppletViewer.this.panel.getComponentListeners();
                    for (int i = 0; i < l.length; ++i) {
                        l[i].componentResized(event);
                    }
                    PluginAppletViewer.this.panel.validate();
                }
            }

            public void componentMoved(ComponentEvent event) {
                if (PluginAppletViewer.this.panel != null) {
                    ComponentListener[] l = PluginAppletViewer.this.panel.getComponentListeners();
                    for (int i = 0; i < l.length; ++i) {
                        l[i].componentMoved(event);
                    }
                    PluginAppletViewer.this.panel.validate();
                }
            }
        };
        HierarchyBoundsAdapter hierarchyBoundsListener = new HierarchyBoundsAdapter(){

            public void ancestorMoved(HierarchyEvent e) {
                if (PluginAppletViewer.this.panel != null) {
                    HierarchyBoundsListener[] l = PluginAppletViewer.this.panel.getHierarchyBoundsListeners();
                    for (int i = 0; i < l.length; ++i) {
                        l[i].ancestorMoved(e);
                    }
                    PluginAppletViewer.this.panel.validate();
                }
            }

            public void ancestorResized(HierarchyEvent e) {
                if (PluginAppletViewer.this.panel != null) {
                    HierarchyBoundsListener[] l = PluginAppletViewer.this.panel.getHierarchyBoundsListeners();
                    for (int i = 0; i < l.length; ++i) {
                        l[i].ancestorResized(e);
                    }
                    PluginAppletViewer.this.panel.validate();
                }
            }
        };
        this.addWindowListener(windowEventListener);
        this.addComponentListener(componentListener);
        this.addHierarchyBoundsListener(hierarchyBoundsListener);
        class AppletEventListener
        implements AppletListener {
            final Frame frame;

            public AppletEventListener(Frame frame) {
                this.frame = frame;
            }

            public void appletStateChanged(AppletEvent evt) {
                AppletPanel src = (AppletPanel)evt.getSource();
                switch (evt.getID()) {
                    case 51234: {
                        if (src == null) break;
                        PluginAppletViewer.this.resize(PluginAppletViewer.this.preferredSize());
                        PluginAppletViewer.this.validate();
                        break;
                    }
                    case 51236: {
                        Applet a = src.getApplet();
                        if (a != null) {
                            AppletPanel.changeFrameAppContext(this.frame, SunToolkit.targetToAppContext(a));
                            break;
                        }
                        AppletPanel.changeFrameAppContext(this.frame, AppContext.getAppContext());
                        break;
                    }
                }
            }
        }
        this.panel.addAppletListener(new AppletEventListener(this));
        this.showStatus(amh.getMessage("status.start"));
        this.initEventQueue();
    }

    private void initEventQueue() {
        String eventList = System.getProperty("appletviewer.send.event");
        if (eventList == null) {
            this.panel.sendEvent(1);
            this.panel.sendEvent(2);
            this.panel.sendEvent(3);
        } else {
            String[] events = this.splitSeparator(",", eventList);
            for (int i = 0; i < events.length; ++i) {
                System.out.println("Adding event to queue: " + events[i]);
                if (events[i].equals("dispose")) {
                    this.panel.sendEvent(0);
                    continue;
                }
                if (events[i].equals("load")) {
                    this.panel.sendEvent(1);
                    continue;
                }
                if (events[i].equals("init")) {
                    this.panel.sendEvent(2);
                    continue;
                }
                if (events[i].equals("start")) {
                    this.panel.sendEvent(3);
                    continue;
                }
                if (events[i].equals("stop")) {
                    this.panel.sendEvent(4);
                    continue;
                }
                if (events[i].equals("destroy")) {
                    this.panel.sendEvent(5);
                    continue;
                }
                if (events[i].equals("quit")) {
                    this.panel.sendEvent(6);
                    continue;
                }
                if (events[i].equals("error")) {
                    this.panel.sendEvent(7);
                    continue;
                }
                System.out.println("Unrecognized event name: " + events[i]);
            }
            while (!this.panel.emptyEventQueue()) {
            }
            this.appletSystemExit();
        }
    }

    private String[] splitSeparator(String sep, String s) {
        Vector<String> v = new Vector<String>();
        int tokenStart = 0;
        int tokenEnd = 0;
        while ((tokenEnd = s.indexOf(sep, tokenStart)) != -1) {
            v.addElement(s.substring(tokenStart, tokenEnd));
            tokenStart = tokenEnd + 1;
        }
        v.addElement(s.substring(tokenStart));
        Object[] retVal = new String[v.size()];
        v.copyInto(retVal);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioClip getAudioClip(URL url) {
        PluginAppletViewer.checkConnect(url);
        Map map = audioClips;
        synchronized (map) {
            AudioClip clip = (AudioClip)audioClips.get(url);
            if (clip == null) {
                clip = new AppletAudioClip(url);
                audioClips.put(url, clip);
            }
            return clip;
        }
    }

    public Image getImage(URL url) {
        return PluginAppletViewer.getCachedImage(url);
    }

    static Image getCachedImage(URL url) {
        return (Image)PluginAppletViewer.getCachedImageRef(url).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Ref getCachedImageRef(URL url) {
        Map map = imageRefs;
        synchronized (map) {
            AppletImageRef ref = (AppletImageRef)imageRefs.get(url);
            if (ref == null) {
                ref = new AppletImageRef(url);
                imageRefs.put(url, ref);
            }
            return ref;
        }
    }

    static void flushImageCache() {
        imageRefs.clear();
    }

    public Applet getApplet(String name) {
        AppletSecurity security = (AppletSecurity)System.getSecurityManager();
        name = name.toLowerCase();
        SocketPermission panelSp = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Enumeration e = appletPanels.elements();
        while (e.hasMoreElements()) {
            SocketPermission sp;
            AppletPanel p = (AppletPanel)e.nextElement();
            String param = p.getParameter("name");
            if (param != null) {
                param = param.toLowerCase();
            }
            if (!name.equals(param) || !p.getDocumentBase().equals(this.panel.getDocumentBase()) || !panelSp.implies(sp = new SocketPermission(p.getCodeBase().getHost(), "connect"))) continue;
            return p.applet;
        }
        return null;
    }

    public Enumeration getApplets() {
        AppletSecurity security = (AppletSecurity)System.getSecurityManager();
        Vector<Applet> v = new Vector<Applet>();
        SocketPermission panelSp = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Enumeration e = appletPanels.elements();
        while (e.hasMoreElements()) {
            SocketPermission sp;
            AppletPanel p = (AppletPanel)e.nextElement();
            if (!p.getDocumentBase().equals(this.panel.getDocumentBase()) || !panelSp.implies(sp = new SocketPermission(p.getCodeBase().getHost(), "connect"))) continue;
            v.addElement(p.applet);
        }
        return v.elements();
    }

    public void showDocument(URL url) {
        this.showDocument(url, "_self");
    }

    public void showDocument(URL url, String target) {
        try {
            PluginMain.write("url " + url + " " + target);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void showStatus(String status) {
        try {
            PluginMain.write("status " + status);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setStream(String key, InputStream stream) throws IOException {
    }

    public InputStream getStream(String key) {
        return null;
    }

    public Iterator getStreamKeys() {
        return null;
    }

    public static void printTag(PrintStream out, Hashtable atts) {
        String param;
        out.print("<applet");
        String v = (String)atts.get("codebase");
        if (v != null) {
            out.print(" codebase=\"" + v + "\"");
        }
        if ((v = (String)atts.get("code")) == null) {
            v = "applet.class";
        }
        out.print(" code=\"" + v + "\"");
        v = (String)atts.get("width");
        if (v == null) {
            v = "150";
        }
        out.print(" width=" + v);
        v = (String)atts.get("height");
        if (v == null) {
            v = "100";
        }
        out.print(" height=" + v);
        v = (String)atts.get("name");
        if (v != null) {
            out.print(" name=\"" + v + "\"");
        }
        out.println(">");
        int len = atts.size();
        String[] params = new String[len];
        len = 0;
        Enumeration e = atts.keys();
        while (e.hasMoreElements()) {
            int i;
            param = (String)e.nextElement();
            for (i = 0; i < len && params[i].compareTo(param) < 0; ++i) {
            }
            System.arraycopy(params, i, params, i + 1, len - i);
            params[i] = param;
            ++len;
        }
        for (int i = 0; i < len; ++i) {
            param = params[i];
            if (systemParam.get(param) != null) continue;
            out.println("<param name=" + param + " value=\"" + atts.get(param) + "\">");
        }
        out.println("</applet>");
    }

    public void updateAtts(int width, int height) {
        this.panel.atts.remove("width");
        this.panel.atts.remove("height");
        this.panel.atts.put("width", new Integer(width).toString());
        this.panel.atts.put("height", new Integer(height).toString());
    }

    void appletRestart() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    void appletReload() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(0);
        AppletPanel.flushClassLoader(this.panel.getClassLoaderCacheKey());
        try {
            this.panel.joinAppletThread();
            this.panel.release();
        }
        catch (InterruptedException e) {
            return;
        }
        this.panel.createAppletThread();
        this.panel.sendEvent(1);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    public int print(Graphics graphics, PageFormat pf, int pageIndex) {
        return 1;
    }

    void appletStart() {
        this.panel.sendEvent(3);
    }

    void appletStop() {
        this.panel.sendEvent(4);
    }

    private void appletShutdown(AppletPanel p) {
        p.sendEvent(4);
        p.sendEvent(5);
        p.sendEvent(0);
        p.sendEvent(6);
    }

    void appletClose() {
        final AppletViewerPanel p = this.panel;
        new Thread(new Runnable(){

            public void run() {
                PluginAppletViewer.this.appletShutdown(p);
                appletPanels.removeElement(p);
                PluginAppletViewer.this.dispose();
                if (PluginAppletViewer.countApplets() == 0) {
                    PluginAppletViewer.this.appletSystemExit();
                }
            }
        }).start();
    }

    private void appletSystemExit() {
        if (this.factory.isStandalone()) {
            System.exit(0);
        }
    }

    public static int countApplets() {
        return appletPanels.size();
    }

    public static void skipSpace(Reader in) throws IOException {
        while (c >= 0 && (c == 32 || c == 9 || c == 10 || c == 13)) {
            c = in.read();
        }
    }

    public static String scanIdentifier(Reader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
            buf.append((char)c);
            c = in.read();
        }
        return buf.toString();
    }

    public static Hashtable scanTag(Reader in) throws IOException {
        Hashtable<String, String> atts = new Hashtable<String, String>();
        PluginAppletViewer.skipSpace(in);
        while (c >= 0 && c != 62) {
            String att = PluginAppletViewer.scanIdentifier(in);
            String val = "";
            PluginAppletViewer.skipSpace(in);
            if (c == 61) {
                int quote = -1;
                c = in.read();
                PluginAppletViewer.skipSpace(in);
                if (c == 39 || c == 34) {
                    quote = c;
                    c = in.read();
                }
                StringBuffer buf = new StringBuffer();
                while (c > 0 && (quote < 0 && c != 32 && c != 9 && c != 10 && c != 13 && c != 62 || quote >= 0 && c != quote)) {
                    buf.append((char)c);
                    c = in.read();
                }
                if (c == quote) {
                    c = in.read();
                }
                PluginAppletViewer.skipSpace(in);
                val = buf.toString();
            }
            if (!val.equals("")) {
                atts.put(att.toLowerCase(Locale.ENGLISH), val);
            }
            while (!(c == 62 || c < 0 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95)) {
                c = in.read();
            }
        }
        return atts;
    }

    private static Reader makeReader(InputStream is) {
        if (encoding != null) {
            try {
                return new BufferedReader(new InputStreamReader(is, encoding));
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        InputStreamReader r = new InputStreamReader(is);
        encoding = r.getEncoding();
        return new BufferedReader(r);
    }

    public static void parse(long handle, Reader in, URL url, String enc) throws IOException {
        encoding = enc;
        PluginAppletViewer.parse(handle, 1, 1, in, url, System.out, new PluginAppletViewerFactory());
    }

    public static void parse(long handle, int width, int height, Reader in, URL url) throws IOException {
        PluginAppletViewer.parse(handle, width, height, in, url, System.out, new PluginAppletViewerFactory());
    }

    public static void parse(long handle, int width, int height, Reader in, URL url, PrintStream statusMsgStream, PluginAppletViewerFactory factory) throws IOException {
        boolean isAppletTag = false;
        boolean isObjectTag = false;
        boolean isEmbedTag = false;
        String requiresNameWarning = amh.getMessage("parse.warning.requiresname");
        String paramOutsideWarning = amh.getMessage("parse.warning.paramoutside");
        String appletRequiresCodeWarning = amh.getMessage("parse.warning.applet.requirescode");
        String appletRequiresHeightWarning = amh.getMessage("parse.warning.applet.requiresheight");
        String appletRequiresWidthWarning = amh.getMessage("parse.warning.applet.requireswidth");
        String objectRequiresCodeWarning = amh.getMessage("parse.warning.object.requirescode");
        String objectRequiresHeightWarning = amh.getMessage("parse.warning.object.requiresheight");
        String objectRequiresWidthWarning = amh.getMessage("parse.warning.object.requireswidth");
        String embedRequiresCodeWarning = amh.getMessage("parse.warning.embed.requirescode");
        String embedRequiresHeightWarning = amh.getMessage("parse.warning.embed.requiresheight");
        String embedRequiresWidthWarning = amh.getMessage("parse.warning.embed.requireswidth");
        String appNotLongerSupportedWarning = amh.getMessage("parse.warning.appnotLongersupported");
        URLConnection conn = url.openConnection();
        url = conn.getURL();
        int ydisp = 1;
        Hashtable atts = null;
        while ((c = in.read()) != -1) {
            String nm;
            if (c != 60) continue;
            c = in.read();
            if (c == 47) {
                c = in.read();
                nm = PluginAppletViewer.scanIdentifier(in);
                if (!nm.equalsIgnoreCase("applet") && !nm.equalsIgnoreCase("object") && !nm.equalsIgnoreCase("embed")) continue;
                if (isObjectTag && atts.get("code") == null && atts.get("object") == null) {
                    statusMsgStream.println(objectRequiresCodeWarning);
                    atts = null;
                }
                if (atts != null) {
                    atts.remove("width");
                    atts.remove("height");
                    atts.put("width", new Integer(width).toString());
                    atts.put("height", new Integer(height).toString());
                    factory.createAppletViewer(handle, x, y, url, atts);
                    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                    if ((x += 30) > d.width - 300 || (y += 30) > d.height - 300) {
                        x = 0;
                        y = 2 * ydisp * 30;
                        ++ydisp;
                    }
                }
                atts = null;
                isAppletTag = false;
                isObjectTag = false;
                isEmbedTag = false;
                continue;
            }
            nm = PluginAppletViewer.scanIdentifier(in);
            if (nm.equalsIgnoreCase("param")) {
                Hashtable t = PluginAppletViewer.scanTag(in);
                String att = (String)t.get("name");
                if (att == null) {
                    statusMsgStream.println(requiresNameWarning);
                    continue;
                }
                String val = (String)t.get("value");
                if (val == null) {
                    statusMsgStream.println(requiresNameWarning);
                    continue;
                }
                if (atts != null) {
                    String name = att.toLowerCase();
                    atts.put(name, val);
                    continue;
                }
                statusMsgStream.println(paramOutsideWarning);
                continue;
            }
            if (nm.equalsIgnoreCase("applet")) {
                isAppletTag = true;
                atts = PluginAppletViewer.scanTag(in);
                if (atts.get("code") == null && atts.get("object") == null) {
                    statusMsgStream.println(appletRequiresCodeWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("width") == null) {
                    statusMsgStream.println(appletRequiresWidthWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("height") != null) continue;
                statusMsgStream.println(appletRequiresHeightWarning);
                atts = null;
                continue;
            }
            if (nm.equalsIgnoreCase("object")) {
                isObjectTag = true;
                atts = PluginAppletViewer.scanTag(in);
                if (atts.get("codebase") != null) {
                    atts.remove("codebase");
                }
                if (atts.get("width") == null) {
                    statusMsgStream.println(objectRequiresWidthWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("height") != null) continue;
                statusMsgStream.println(objectRequiresHeightWarning);
                atts = null;
                continue;
            }
            if (nm.equalsIgnoreCase("embed")) {
                isEmbedTag = true;
                atts = PluginAppletViewer.scanTag(in);
                if (atts.get("code") == null && atts.get("object") == null) {
                    statusMsgStream.println(embedRequiresCodeWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("width") == null) {
                    statusMsgStream.println(embedRequiresWidthWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("height") != null) continue;
                statusMsgStream.println(embedRequiresHeightWarning);
                atts = null;
                continue;
            }
            if (!nm.equalsIgnoreCase("app")) continue;
            statusMsgStream.println(appNotLongerSupportedWarning);
            Hashtable atts2 = PluginAppletViewer.scanTag(in);
            nm = (String)atts2.get("class");
            if (nm != null) {
                atts2.remove("class");
                atts2.put("code", nm + ".class");
            }
            if ((nm = (String)atts2.get("src")) != null) {
                atts2.remove("src");
                atts2.put("codebase", nm);
            }
            if (atts2.get("width") == null) {
                atts2.put("width", "100");
            }
            if (atts2.get("height") == null) {
                atts2.put("height", "100");
            }
            PluginAppletViewer.printTag(statusMsgStream, atts2);
            statusMsgStream.println();
        }
        in.close();
    }

    @Deprecated
    public static void main(String[] args) throws IOException {
        PluginMain.main(args);
    }

    private static void checkConnect(URL url) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                Permission perm = url.openConnection().getPermission();
                if (perm != null) {
                    security.checkPermission(perm);
                } else {
                    security.checkConnect(url.getHost(), url.getPort());
                }
            }
            catch (IOException ioe) {
                security.checkConnect(url.getHost(), url.getPort());
            }
        }
    }

    static {
        systemParam.put("codebase", "codebase");
        systemParam.put("code", "code");
        systemParam.put("alt", "alt");
        systemParam.put("width", "width");
        systemParam.put("height", "height");
        systemParam.put("align", "align");
        systemParam.put("vspace", "vspace");
        systemParam.put("hspace", "hspace");
        x = 0;
        y = 0;
        encoding = null;
        amh = new AppletMessageHandler("appletviewer");
    }
}

