/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import sun.applet.AppletSecurity;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginParseRequest;

public class PluginMain {
    private static HashMap appletWindows = new HashMap();
    private static HashMap parseRequests = new HashMap();
    private static String currentKey;
    private static PluginAppletViewer currentWindow;
    private static PluginParseRequest currentRequest;
    private static BufferedReader pluginInputStream;
    private static BufferedWriter pluginOutputStream;
    public static final String theVersion;

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.exit(0);
        }
        PluginMain.init();
        PluginMain.start(new FileInputStream(args[0]), new FileOutputStream(args[1]));
        System.exit(0);
    }

    private static void init() {
        Properties avProps = new Properties();
        avProps.put("browser", "sun.applet.AppletViewer");
        avProps.put("browser.version", "1.06");
        avProps.put("browser.vendor", "Sun Microsystems Inc.");
        avProps.put("http.agent", "Java(tm) 2 SDK, Standard Edition v" + theVersion);
        avProps.put("package.restrict.definition.java", "true");
        avProps.put("package.restrict.definition.sun", "true");
        avProps.put("java.version.applet", "true");
        avProps.put("java.vendor.applet", "true");
        avProps.put("java.vendor.url.applet", "true");
        avProps.put("java.class.version.applet", "true");
        avProps.put("os.name.applet", "true");
        avProps.put("os.version.applet", "true");
        avProps.put("os.arch.applet", "true");
        avProps.put("file.separator.applet", "true");
        avProps.put("path.separator.applet", "true");
        avProps.put("line.separator.applet", "true");
        Properties sysProps = System.getProperties();
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = sysProps.getProperty(key);
            avProps.setProperty(key, val);
        }
        System.setProperties(avProps);
        System.setSecurityManager(new AppletSecurity());
    }

    static void registerWindow(PluginAppletViewer pluginappletviewer) {
        appletWindows.put(currentKey, pluginappletviewer);
        currentWindow = (PluginAppletViewer)appletWindows.get(currentKey);
    }

    private static void deregisterWindow(PluginAppletViewer pluginappletviewer) {
        appletWindows.remove(currentWindow);
        currentWindow.dispose();
        currentWindow = null;
    }

    static void start(InputStream inputstream, OutputStream outputstream) throws MalformedURLException, IOException {
        pluginInputStream = new BufferedReader(new InputStreamReader(inputstream, Charset.forName("UTF-8")));
        pluginOutputStream = new BufferedWriter(new OutputStreamWriter(outputstream, Charset.forName("UTF-8")));
        PluginMain.write("running");
        String message = PluginMain.read();
        while (true) {
            int height;
            int width;
            if (message.startsWith("instance")) {
                currentKey = message.substring("instance".length() + 1);
                currentWindow = (PluginAppletViewer)appletWindows.get(currentKey);
                currentRequest = null;
                if (currentWindow == null) {
                    if (!parseRequests.containsKey(currentKey)) {
                        parseRequests.put(currentKey, new PluginParseRequest());
                    }
                    currentRequest = (PluginParseRequest)parseRequests.get(currentKey);
                }
            } else if (message.startsWith("tag")) {
                if (currentRequest != null) {
                    int index = message.indexOf(32, "tag".length() + 1);
                    PluginMain.currentRequest.documentbase = message.substring("tag".length() + 1, index);
                    PluginMain.currentRequest.tag = message.substring(index + 1);
                    if (PluginMain.currentRequest.handle != 0L && !PluginMain.currentRequest.alreadySent) {
                        PluginAppletViewer.parse(PluginMain.currentRequest.handle, 1, 1, new StringReader(PluginMain.currentRequest.tag), new URL(PluginMain.currentRequest.documentbase));
                        parseRequests.remove(currentKey);
                    }
                }
            } else if (message.startsWith("handle")) {
                if (currentRequest != null) {
                    PluginMain.currentRequest.handle = Long.parseLong(message.substring("handle".length() + 1, message.indexOf("width") - 1));
                    width = Integer.parseInt(message.substring(message.indexOf("width") + "width".length() + 1, message.indexOf("height") - 1));
                    height = Integer.parseInt(message.substring(message.indexOf("height") + "height".length() + 1));
                    if (PluginMain.currentRequest.tag != null && !PluginMain.currentRequest.alreadySent) {
                        PluginAppletViewer.parse(PluginMain.currentRequest.handle, width, height, new StringReader(PluginMain.currentRequest.tag), new URL(PluginMain.currentRequest.documentbase));
                        parseRequests.remove(currentKey);
                    }
                }
            } else if (message.startsWith("width")) {
                width = Integer.parseInt(message.substring("width".length() + 1));
                height = currentWindow.getHeight();
                currentWindow.updateAtts(width, height);
                currentWindow.setSize(width, height);
            } else if (message.startsWith("height")) {
                int height2 = Integer.parseInt(message.substring("height".length() + 1));
                int width2 = currentWindow.getWidth();
                currentWindow.updateAtts(width2, height2);
                currentWindow.setSize(width2, height2);
            } else if (message.startsWith("destroy") && currentWindow != null) {
                PluginMain.deregisterWindow(currentWindow);
            }
            message = PluginMain.read();
        }
    }

    static void write(String message) throws IOException {
        pluginOutputStream.write(message, 0, message.length());
        pluginOutputStream.newLine();
        pluginOutputStream.flush();
        System.err.println("  PIPE: appletviewer wrote: " + message);
    }

    static String read() throws IOException {
        String message = pluginInputStream.readLine();
        System.err.println("  PIPE: appletviewer read: " + message);
        if (message == null || message.equals("shutdown")) {
            try {
                pluginInputStream.close();
                pluginOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.err.println("APPLETVIEWER: exiting appletviewer");
            System.exit(0);
        }
        return message;
    }

    static {
        theVersion = System.getProperty("java.version");
    }
}

