/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.peer.CheckboxPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XToolkit;

class XCheckboxPeer
extends XComponentPeer
implements CheckboxPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XCheckboxPeer");
    private static final Insets focusInsets = new Insets(0, 0, 0, 0);
    private static final Insets borderInsets = new Insets(2, 2, 2, 2);
    private static final int checkBoxInsetFromText = 2;
    private static final double MASTER_SIZE = 128.0;
    private static final Polygon MASTER_CHECKMARK = new Polygon(new int[]{1, 25, 56, 124, 124, 85, 64}, new int[]{59, 35, 67, 0, 12, 66, 123}, 7);
    private Shape myCheckMark;
    private Color focusColor = SystemColor.windowText;
    private boolean pressed = false;
    private boolean armed = false;
    private boolean selected;
    private Rectangle textRect;
    private Rectangle focusRect;
    private int checkBoxSize;
    private int cbX;
    private int cbY;
    String label;
    CheckboxGroup checkBoxGroup;

    XCheckboxPeer(Checkbox target) {
        super(target);
        this.selected = target.getState();
        this.label = target.getLabel();
        if (this.label == null) {
            this.label = "";
        }
        this.checkBoxGroup = target.getCheckboxGroup();
        this.updateMotifColors(this.getPeerBackground());
    }

    public void preInit(XCreateWindowParams params) {
        this.textRect = new Rectangle();
        this.focusRect = new Rectangle();
        super.preInit(params);
    }

    public boolean isFocusable() {
        return true;
    }

    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.repaint();
    }

    void handleJavaKeyEvent(KeyEvent e) {
        int i = e.getID();
        switch (i) {
            case 401: {
                this.keyPressed(e);
                break;
            }
            case 402: {
                this.keyReleased(e);
                break;
            }
            case 400: {
                this.keyTyped(e);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.action(!this.selected);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void setLabel(String label) {
        this.label = label == null ? "" : label;
        this.layout();
        this.repaint();
    }

    void handleJavaMouseEvent(MouseEvent e) {
        super.handleJavaMouseEvent(e);
        int i = e.getID();
        switch (i) {
            case 501: {
                this.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseReleased(e);
                break;
            }
            case 504: {
                this.mouseEntered(e);
                break;
            }
            case 505: {
                this.mouseExited(e);
                break;
            }
            case 500: {
                this.mouseClicked(e);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        Checkbox cb;
        if (XToolkit.isLeftMouseButton(e) && (cb = (Checkbox)e.getSource()).contains(e.getX(), e.getY())) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("mousePressed() on " + this.target.getName() + " : armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
            }
            if (!this.isEnabled()) {
                return;
            }
            if (!this.armed) {
                this.armed = true;
            }
            this.pressed = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("mouseReleased() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        boolean sendEvent = false;
        if (XToolkit.isLeftMouseButton(e)) {
            if (this.armed) {
                sendEvent = true;
            }
            this.pressed = false;
            this.armed = false;
            if (sendEvent) {
                this.action(!this.selected);
            } else {
                this.repaint();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("mouseEntered() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        if (this.pressed) {
            this.armed = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("mouseExited() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        if (this.armed) {
            this.armed = false;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public Dimension getMinimumSize() {
        FontMetrics fm = this.getFontMetrics(this.getPeerFont());
        int wdth = fm.stringWidth(this.label) + this.getCheckboxSize(fm) + 4 + 8;
        int hght = Math.max(fm.getHeight() + 8, 15);
        return new Dimension(wdth, hght);
    }

    private int getCheckboxSize(FontMetrics fm) {
        return fm.getHeight() * 76 / 100 - 1;
    }

    public void setBackground(Color c) {
        this.updateMotifColors(c);
        super.setBackground(c);
    }

    public void layout() {
        Dimension size = this.getPeerSize();
        Font f = this.getPeerFont();
        FontMetrics fm = this.getFontMetrics(f);
        String text = this.label;
        this.checkBoxSize = this.getCheckboxSize(fm);
        this.cbX = XCheckboxPeer.borderInsets.left + 2;
        this.cbY = size.height / 2 - this.checkBoxSize / 2;
        int minTextX = XCheckboxPeer.borderInsets.left + 4 + this.checkBoxSize;
        this.textRect.width = fm.stringWidth(text == null ? "" : text);
        this.textRect.height = fm.getHeight();
        this.textRect.x = Math.max(minTextX, size.width / 2 - this.textRect.width / 2);
        this.textRect.y = (size.height - this.textRect.height) / 2;
        this.focusRect.x = XCheckboxPeer.focusInsets.left;
        this.focusRect.y = XCheckboxPeer.focusInsets.top;
        this.focusRect.width = size.width - (XCheckboxPeer.focusInsets.left + XCheckboxPeer.focusInsets.right) - 1;
        this.focusRect.height = size.height - (XCheckboxPeer.focusInsets.top + XCheckboxPeer.focusInsets.bottom) - 1;
        double fsize = this.checkBoxSize;
        this.myCheckMark = AffineTransform.getScaleInstance(fsize / 128.0, fsize / 128.0).createTransformedShape(MASTER_CHECKMARK);
    }

    public void paint(Graphics g) {
        if (g != null) {
            Dimension size = this.getPeerSize();
            Font f = this.getPeerFont();
            this.flush();
            g.setColor(this.getPeerBackground());
            g.fillRect(0, 0, size.width, size.height);
            if (this.label != null) {
                g.setFont(f);
                this.paintText(g, this.textRect, this.label);
            }
            if (this.hasFocus()) {
                this.paintFocus(g, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
            }
            if (this.checkBoxGroup == null) {
                this.paintCheckbox(g, this.cbX, this.cbY, this.checkBoxSize, this.checkBoxSize);
            } else {
                this.paintRadioButton(g, this.cbX, this.cbY, this.checkBoxSize, this.checkBoxSize);
            }
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintCheckbox(Graphics g, int x, int y, int w, int h) {
        boolean useBufferedImage = false;
        BufferedImage buffer = null;
        Graphics2D g2 = null;
        int rx = x;
        int ry = y;
        if (!(g instanceof Graphics2D)) {
            buffer = this.graphicsConfig.createCompatibleImage(w, h);
            g2 = buffer.createGraphics();
            useBufferedImage = true;
            rx = 0;
            ry = 0;
        } else {
            g2 = (Graphics2D)g;
        }
        try {
            this.drawMotif3DRect(g2, rx, ry, w - 1, h - 1, this.armed | this.selected);
            g2.setColor(this.armed | this.selected ? this.selectColor : this.getPeerBackground());
            g2.fillRect(rx + 1, ry + 1, w - 2, h - 2);
            if (this.armed | this.selected) {
                g2.setColor(this.getPeerForeground());
                AffineTransform af = g2.getTransform();
                g2.setTransform(AffineTransform.getTranslateInstance(rx, ry));
                g2.fill(this.myCheckMark);
                g2.setTransform(af);
            }
        }
        finally {
            if (useBufferedImage) {
                g2.dispose();
            }
        }
        if (useBufferedImage) {
            g.drawImage(buffer, x, y, null);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.target.repaint();
    }

    public void paintRadioButton(Graphics g, int x, int y, int w, int h) {
        g.setColor(this.armed | this.selected ? this.darkShadow : this.lightShadow);
        g.drawArc(x - 1, y - 1, w + 2, h + 2, 45, 180);
        g.setColor(this.armed | this.selected ? this.lightShadow : this.darkShadow);
        g.drawArc(x - 1, y - 1, w + 2, h + 2, 45, -180);
        if (this.armed | this.selected) {
            g.setColor(this.selectColor);
            g.fillArc(x + 1, y + 1, w - 1, h - 1, 0, 360);
        }
    }

    protected void paintText(Graphics g, Rectangle textRect, String text) {
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = -1;
        if (this.isEnabled()) {
            g.setColor(this.getPeerForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(this.getPeerBackground().brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(this.getPeerBackground().darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    protected void paintFocus(Graphics g, int x, int y, int w, int h) {
        g.setColor(this.focusColor);
        g.drawRect(x, y, w, h);
    }

    public void setState(boolean state) {
        if (this.selected != state) {
            this.selected = state;
            this.repaint();
        }
    }

    public void setCheckboxGroup(CheckboxGroup g) {
        this.checkBoxGroup = g;
        this.repaint();
    }

    void action(boolean state) {
        final Checkbox cb = (Checkbox)this.target;
        final boolean newState = state;
        XToolkit.executeOnEventHandlerThread(cb, new Runnable(){

            public void run() {
                CheckboxGroup cbg = XCheckboxPeer.this.checkBoxGroup;
                if (cbg != null && cbg.getSelectedCheckbox() == cb && cb.getState()) {
                    cb.setState(true);
                    return;
                }
                cb.setState(newState);
                XCheckboxPeer.this.notifyStateChanged(newState);
            }
        });
    }

    void notifyStateChanged(boolean state) {
        Checkbox cb = (Checkbox)this.target;
        ItemEvent e = new ItemEvent(cb, 701, cb.getLabel(), state ? 1 : 2);
        this.postEvent(e);
    }
}

