/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import sun.java2d.pisces.LineSink;
import sun.java2d.pisces.PiscesCache;

public class Renderer
extends LineSink {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    public static final int INITIAL_EDGES = 1000;
    public static final int DEFAULT_INDICES_SIZE = 8192;
    public static final int DEFAULT_CROSSINGS_SIZE = 32768;
    private int SUBPIXEL_LG_POSITIONS_X;
    private int SUBPIXEL_LG_POSITIONS_Y;
    private int SUBPIXEL_MASK_X;
    private int SUBPIXEL_MASK_Y;
    private int SUBPIXEL_POSITIONS_X;
    private int SUBPIXEL_POSITIONS_Y;
    int MAX_AA_ALPHA;
    private int MAX_AA_ALPHA_DENOM;
    private int HALF_MAX_AA_ALPHA_DENOM;
    private int XSHIFT;
    private int YSHIFT;
    private int YSTEP;
    private int HYSTEP;
    private int YMASK;
    private static final int MIN_QUAD_OPT_WIDTH = 0x640000;
    PiscesCache cache;
    private int boundsMinX;
    private int boundsMinY;
    private int boundsMaxX;
    private int boundsMaxY;
    private int rasterMinX;
    private int rasterMaxX;
    private int rasterMinY;
    private int rasterMaxY;
    private int bboxX0;
    private int bboxY0;
    private int bboxX1;
    private int bboxY1;
    private int windingRule;
    private int x0;
    private int y0;
    private int sx0;
    private int sy0;
    private byte[] rowAA;
    private int firstOrientation;
    private int lastOrientation;
    private int flips;
    private int alphaWidth;
    private int[] edges = new int[5000];
    private int edgeIdx = 0;
    private int edgeMinY = Integer.MAX_VALUE;
    private int edgeMaxY = Integer.MIN_VALUE;
    private int[] crossingIndices;
    private int[] crossings;
    private int crossingMinY;
    private int crossingMaxY;
    private int crossingMinX = Integer.MAX_VALUE;
    private int crossingMaxX = Integer.MIN_VALUE;
    private int crossingMaxXEntries;
    private int numCrossings = 0;
    private boolean crossingsSorted = false;
    private int crossingY;
    private int crossingRowCount;
    private int crossingRowOffset;
    private int crossingRowIndex;

    public void setAntialiasing(int subpixelLgPositionsX, int subpixelLgPositionsY) {
        this.SUBPIXEL_LG_POSITIONS_X = subpixelLgPositionsX;
        this.SUBPIXEL_LG_POSITIONS_Y = subpixelLgPositionsY;
        this.SUBPIXEL_MASK_X = (1 << this.SUBPIXEL_LG_POSITIONS_X) - 1;
        this.SUBPIXEL_MASK_Y = (1 << this.SUBPIXEL_LG_POSITIONS_Y) - 1;
        this.SUBPIXEL_POSITIONS_X = 1 << this.SUBPIXEL_LG_POSITIONS_X;
        this.SUBPIXEL_POSITIONS_Y = 1 << this.SUBPIXEL_LG_POSITIONS_Y;
        this.MAX_AA_ALPHA = this.SUBPIXEL_POSITIONS_X * this.SUBPIXEL_POSITIONS_Y;
        this.MAX_AA_ALPHA_DENOM = 255 * this.MAX_AA_ALPHA;
        this.HALF_MAX_AA_ALPHA_DENOM = this.MAX_AA_ALPHA_DENOM / 2;
        this.XSHIFT = 16 - this.SUBPIXEL_LG_POSITIONS_X;
        this.YSHIFT = 16 - this.SUBPIXEL_LG_POSITIONS_Y;
        this.YSTEP = 1 << this.YSHIFT;
        this.HYSTEP = 1 << this.YSHIFT - 1;
        this.YMASK = ~(this.YSTEP - 1);
    }

    public int getSubpixelLgPositionsX() {
        return this.SUBPIXEL_LG_POSITIONS_X;
    }

    public int getSubpixelLgPositionsY() {
        return this.SUBPIXEL_LG_POSITIONS_Y;
    }

    public void setWindingRule(int windingRule) {
        this.windingRule = windingRule;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public void beginRendering(int boundsX, int boundsY, int boundsWidth, int boundsHeight) {
        this.lastOrientation = 0;
        this.flips = 0;
        this.resetEdges();
        this.boundsMinX = boundsX << 16;
        this.boundsMinY = boundsY << 16;
        this.boundsMaxX = boundsX + boundsWidth << 16;
        this.boundsMaxY = boundsY + boundsHeight << 16;
        this.bboxX0 = boundsX;
        this.bboxY0 = boundsY;
        this.bboxX1 = boundsX + boundsWidth;
        this.bboxY1 = boundsY + boundsHeight;
    }

    public void moveTo(int x0, int y0) {
        this.close();
        this.sx0 = this.x0 = x0;
        this.sy0 = this.y0 = y0;
        this.lastOrientation = 0;
    }

    public void lineJoin() {
    }

    public void lineTo(int x1, int y1) {
        int orientation;
        if (this.y0 == y1) {
            this.x0 = x1;
            return;
        }
        int n = orientation = this.y0 < y1 ? 1 : -1;
        if (this.lastOrientation == 0) {
            this.firstOrientation = orientation;
        } else if (orientation != this.lastOrientation) {
            ++this.flips;
        }
        this.lastOrientation = orientation;
        this.addEdge(this.x0, this.y0 | 1, x1, y1 | 1);
        this.x0 = x1;
        this.y0 = y1;
    }

    public void close() {
        int orientation = this.lastOrientation;
        if (this.y0 != this.sy0) {
            int n = orientation = this.y0 < this.sy0 ? 1 : -1;
        }
        if (orientation != this.firstOrientation) {
            ++this.flips;
        }
        this.lineTo(this.sx0, this.sy0);
    }

    public void end() {
        this.close();
    }

    private void computeCrossingsForEdge(int index, int boundsMinY, int boundsMaxY) {
        int iy1;
        int clipy1;
        int maxY;
        int iy0 = this.edges[index + 1];
        int clipy0 = iy0 > boundsMinY ? iy0 : boundsMinY;
        int minY = (clipy0 + this.HYSTEP & this.YMASK) + this.HYSTEP;
        if (minY > (maxY = ((clipy1 = (iy1 = this.edges[index + 3]) < boundsMaxY ? iy1 : boundsMaxY) - this.HYSTEP & this.YMASK) + this.HYSTEP)) {
            return;
        }
        int ix0 = this.edges[index];
        int ix1 = this.edges[index + 2];
        long dx = (long)ix1 - (long)ix0;
        long dy = (long)iy1 - (long)iy0;
        int orientation = this.edges[index + 4];
        int y = minY;
        long lx = ((long)y - (long)iy0) * dx / dy + (long)ix0;
        this.addCrossing(y >> this.YSHIFT, (int)(lx >> this.XSHIFT), orientation);
        if ((y += this.YSTEP) > maxY) {
            return;
        }
        long xstep = (long)this.YSTEP * dx / dy;
        while (y <= maxY) {
            this.addCrossing(y >> this.YSHIFT, (int)((lx += xstep) >> this.XSHIFT), orientation);
            y += this.YSTEP;
        }
    }

    private void computeBounds() {
        this.rasterMinX = this.crossingMinX & ~this.SUBPIXEL_MASK_X;
        this.rasterMaxX = this.crossingMaxX | this.SUBPIXEL_MASK_X;
        this.rasterMinY = this.crossingMinY & ~this.SUBPIXEL_MASK_Y;
        this.rasterMaxY = this.crossingMaxY | this.SUBPIXEL_MASK_Y;
        if (this.rasterMinX > this.rasterMaxX || this.rasterMinY > this.rasterMaxY) {
            this.rasterMinX = 0;
            this.rasterMaxX = -1;
            this.rasterMinY = 0;
            this.rasterMaxY = -1;
            return;
        }
        if (this.rasterMinX < this.boundsMinX >> this.XSHIFT) {
            this.rasterMinX = this.boundsMinX >> this.XSHIFT;
        }
        if (this.rasterMinY < this.boundsMinY >> this.YSHIFT) {
            this.rasterMinY = this.boundsMinY >> this.YSHIFT;
        }
        if (this.rasterMaxX > this.boundsMaxX >> this.XSHIFT) {
            this.rasterMaxX = this.boundsMaxX >> this.XSHIFT;
        }
        if (this.rasterMaxY > this.boundsMaxY >> this.YSHIFT) {
            this.rasterMaxY = this.boundsMaxY >> this.YSHIFT;
        }
    }

    private int clamp(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    private void _endRendering() {
        int maxY;
        if (this.flips == 0) {
            this.bboxY0 = 0;
            this.bboxX0 = 0;
            this.bboxY1 = -1;
            this.bboxX1 = -1;
            return;
        }
        int minY = this.edgeMinY > this.boundsMinY ? this.edgeMinY : this.boundsMinY;
        int n = maxY = this.edgeMaxY < this.boundsMaxY ? this.edgeMaxY : this.boundsMaxY;
        if (minY > maxY) {
            this.bboxY0 = 0;
            this.bboxX0 = 0;
            this.bboxY1 = -1;
            this.bboxX1 = -1;
            return;
        }
        int iminY = minY >> this.YSHIFT & ~this.SUBPIXEL_MASK_Y;
        int imaxY = maxY >> this.YSHIFT | this.SUBPIXEL_MASK_Y;
        int yextent = imaxY - iminY + 1;
        int size = this.flips * yextent;
        int bmax = (this.boundsMaxY >> this.YSHIFT) - 1;
        if (imaxY > bmax) {
            imaxY = bmax;
        }
        this.bboxX0 = Integer.MAX_VALUE;
        this.bboxX1 = Integer.MIN_VALUE;
        this.bboxY0 = iminY >> this.SUBPIXEL_LG_POSITIONS_Y;
        this.bboxY1 = imaxY + this.SUBPIXEL_POSITIONS_Y - 1 >> this.SUBPIXEL_LG_POSITIONS_Y;
        int rows = 32768 / (this.flips * this.SUBPIXEL_POSITIONS_Y);
        rows = Math.min(rows, yextent);
        rows = Math.max(rows, 1);
        for (int i = iminY; i <= imaxY; i += rows * this.SUBPIXEL_POSITIONS_Y) {
            int last = Math.min(i + rows * this.SUBPIXEL_POSITIONS_Y - 1, imaxY);
            this.setCrossingsExtents(i, last, this.flips);
            int bminY = i << this.YSHIFT;
            int bmaxY = last << this.YSHIFT | ~this.YMASK;
            int maxIdx = this.edgeIdx;
            for (int index = 0; index < maxIdx; index += 5) {
                if (this.edges[index + 3] < bminY) {
                    this.edgeIdx -= 5;
                    int fidx = this.edgeIdx;
                    int tidx = index;
                    this.edges[tidx++] = this.edges[fidx++];
                    this.edges[tidx++] = this.edges[fidx++];
                    this.edges[tidx++] = this.edges[fidx++];
                    this.edges[tidx++] = this.edges[fidx++];
                    this.edges[tidx] = this.edges[fidx];
                    maxIdx -= 5;
                    index -= 5;
                    continue;
                }
                if (this.edges[index + 1] > bmaxY) continue;
                this.computeCrossingsForEdge(index, bminY, bmaxY);
            }
            this.computeBounds();
            if (this.rasterMaxX < this.rasterMinX) continue;
            this.bboxX0 = Math.min(this.bboxX0, this.rasterMinX >> this.SUBPIXEL_LG_POSITIONS_X);
            this.bboxX1 = Math.max(this.bboxX1, this.rasterMaxX + this.SUBPIXEL_POSITIONS_X - 1 >> this.SUBPIXEL_LG_POSITIONS_X);
            this.renderStrip();
        }
        this.crossingListFinished();
    }

    public void endRendering() {
        if (this.cache != null) {
            this.cache.bboxX0 = Integer.MAX_VALUE;
            this.cache.bboxY0 = Integer.MAX_VALUE;
            this.cache.bboxX1 = Integer.MIN_VALUE;
            this.cache.bboxY1 = Integer.MIN_VALUE;
        }
        this._endRendering();
    }

    public void getBoundingBox(int[] bbox) {
        bbox[0] = this.bboxX0;
        bbox[1] = this.bboxY0;
        bbox[2] = this.bboxX1 - this.bboxX0;
        bbox[3] = this.bboxY1 - this.bboxY0;
    }

    private void renderStrip() {
        int j;
        int width;
        this.alphaWidth = width = this.rasterMaxX - this.rasterMinX + 1 >> this.SUBPIXEL_LG_POSITIONS_X;
        int bufLen = width + 1;
        if (this.rowAA == null || this.rowAA.length < bufLen) {
            this.rowAA = new byte[bufLen];
        }
        int mask = this.windingRule == 0 ? 1 : -1;
        int y = 0;
        int prevY = this.rasterMinY - 1;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        this.iterateCrossings();
        while (this.hasMoreCrossingRows()) {
            y = this.crossingY;
            for (j = prevY + 1; j < y; ++j) {
                if ((j & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y && j != this.rasterMaxY) continue;
                this.emitRow(j >> this.SUBPIXEL_LG_POSITIONS_Y, 0, -1);
            }
            prevY = y;
            if (this.crossingRowIndex < this.crossingRowCount) {
                int lx = this.crossings[this.crossingRowOffset + this.crossingRowIndex];
                int hx = this.crossings[this.crossingRowOffset + this.crossingRowCount - 1];
                int x0 = (lx >>= 1) > this.rasterMinX ? lx : this.rasterMinX;
                int x1 = hx < this.rasterMaxX ? (hx >>= 1) : this.rasterMaxX;
                minX = Math.min(minX, (x0 -= this.rasterMinX) >> this.SUBPIXEL_LG_POSITIONS_X);
                maxX = Math.max(maxX, (x1 -= this.rasterMinX) >> this.SUBPIXEL_LG_POSITIONS_X);
            }
            int sum = 0;
            int prev = this.rasterMinX;
            while (this.crossingRowIndex < this.crossingRowCount) {
                int crorientation;
                int crxo = this.crossings[this.crossingRowOffset + this.crossingRowIndex];
                ++this.crossingRowIndex;
                int crx = crxo >> 1;
                int n = crorientation = (crxo & 1) == 1 ? 1 : -1;
                if ((sum & mask) != 0) {
                    int x1;
                    int x0 = prev > this.rasterMinX ? prev : this.rasterMinX;
                    int n2 = x1 = crx < this.rasterMaxX ? crx : this.rasterMaxX;
                    if (x1 > x0) {
                        int x = (x0 -= this.rasterMinX) >> this.SUBPIXEL_LG_POSITIONS_X;
                        int xmaxm1 = (x1 -= this.rasterMinX) - 1 >> this.SUBPIXEL_LG_POSITIONS_X;
                        if (x == xmaxm1) {
                            int n3 = x;
                            this.rowAA[n3] = (byte)(this.rowAA[n3] + (x1 - x0));
                        } else {
                            int n4 = x++;
                            this.rowAA[n4] = (byte)(this.rowAA[n4] + (this.SUBPIXEL_POSITIONS_X - (x0 & this.SUBPIXEL_MASK_X)));
                            int xmax = x1 >> this.SUBPIXEL_LG_POSITIONS_X;
                            while (x < xmax) {
                                int n5 = x++;
                                this.rowAA[n5] = (byte)(this.rowAA[n5] + this.SUBPIXEL_POSITIONS_X);
                            }
                            int n6 = x;
                            this.rowAA[n6] = (byte)(this.rowAA[n6] + (x1 & this.SUBPIXEL_MASK_X));
                        }
                    }
                }
                sum += crorientation;
                prev = crx;
            }
            if ((y & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y && y != this.rasterMaxY) continue;
            this.emitRow(y >> this.SUBPIXEL_LG_POSITIONS_Y, minX, maxX);
            minX = Integer.MAX_VALUE;
            maxX = Integer.MIN_VALUE;
        }
        for (j = prevY + 1; j <= this.rasterMaxY; ++j) {
            if ((j & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y && j != this.rasterMaxY) continue;
            this.emitRow(j >> this.SUBPIXEL_LG_POSITIONS_Y, minX, maxX);
            minX = Integer.MAX_VALUE;
            maxX = Integer.MIN_VALUE;
        }
    }

    private void clearAlpha(byte[] alpha, int width, int minX, int maxX) {
        if (maxX >= minX) {
            int w = maxX - minX + 1;
            if (w + minX > width) {
                w = width - minX;
            }
            int aidx = minX;
            int i = 0;
            while (i < w) {
                alpha[aidx] = 0;
                ++i;
                ++aidx;
            }
        }
    }

    private void emitRow(int y, int minX, int maxX) {
        if (this.cache != null && maxX >= minX) {
            int x0 = minX + (this.rasterMinX >> this.SUBPIXEL_LG_POSITIONS_X);
            int x1 = maxX + (this.rasterMinX >> this.SUBPIXEL_LG_POSITIONS_X);
            this.cache.startRow(y, x0, x1);
            int srcIdx = minX;
            byte startVal = this.rowAA[srcIdx++];
            int runLen = 1;
            while (srcIdx <= maxX) {
                byte nextVal;
                if ((nextVal = this.rowAA[srcIdx++]) == startVal && runLen < 255) {
                    ++runLen;
                    continue;
                }
                this.cache.addRLERun(startVal, runLen);
                runLen = 1;
                startVal = nextVal;
            }
            this.cache.addRLERun(startVal, runLen);
            this.cache.addRLERun((byte)0, 0);
        }
        this.clearAlpha(this.rowAA, this.alphaWidth, minX, maxX);
    }

    public void setCache(PiscesCache cache) {
        this.cache = cache;
    }

    private void addEdge(int x0, int y0, int x1, int y1) {
        int emaxY;
        int eminY;
        int newLen = this.edgeIdx + 5;
        if (this.edges.length < newLen) {
            int[] tmp = new int[Math.max(11 * this.edges.length / 10, newLen)];
            System.arraycopy(this.edges, 0, tmp, 0, this.edgeIdx);
            this.edges = tmp;
        }
        int orientation = 1;
        if (y0 > y1) {
            int tmp = y0;
            y0 = y1;
            y1 = tmp;
            orientation = -1;
        }
        if ((eminY = y0 + this.HYSTEP & this.YMASK) > (emaxY = y1 - this.HYSTEP & this.YMASK)) {
            return;
        }
        if (orientation == -1) {
            int tmp = x0;
            x0 = x1;
            x1 = tmp;
        }
        this.edges[this.edgeIdx++] = x0;
        this.edges[this.edgeIdx++] = y0;
        this.edges[this.edgeIdx++] = x1;
        this.edges[this.edgeIdx++] = y1;
        this.edges[this.edgeIdx++] = orientation;
        if (y0 < this.edgeMinY) {
            this.edgeMinY = y0;
        }
        if (y1 > this.edgeMaxY) {
            this.edgeMaxY = y1;
        }
    }

    private void resetEdges() {
        this.edgeIdx = 0;
        this.edgeMinY = Integer.MAX_VALUE;
        this.edgeMaxY = Integer.MIN_VALUE;
    }

    private void setCrossingsExtents(int minY, int maxY, int maxXEntries) {
        int yextent = maxY - minY + 1;
        if (this.crossingIndices == null || this.crossingIndices.length < yextent) {
            this.crossingIndices = new int[Math.max(yextent, 8192)];
        }
        if (this.crossings == null || this.crossings.length < yextent * maxXEntries) {
            this.crossings = new int[Math.max(yextent * maxXEntries, 32768)];
        }
        this.crossingMinY = minY;
        this.crossingMaxY = maxY;
        this.crossingMaxXEntries = maxXEntries;
        this.resetCrossings();
    }

    private void resetCrossings() {
        int yextent = this.crossingMaxY - this.crossingMinY + 1;
        int start = 0;
        for (int i = 0; i < yextent; ++i) {
            this.crossingIndices[i] = start;
            start += this.crossingMaxXEntries;
        }
        this.crossingMinX = Integer.MAX_VALUE;
        this.crossingMaxX = Integer.MIN_VALUE;
        this.numCrossings = 0;
        this.crossingsSorted = false;
    }

    private void crossingListFinished() {
        if (this.crossings.length > 32768) {
            this.crossings = new int[32768];
        }
        if (this.crossingIndices.length > 8192) {
            this.crossingIndices = new int[8192];
        }
    }

    private void sortCrossings(int[] x, int off, int len) {
        for (int i = off + 1; i < off + len; ++i) {
            int xjm1;
            int j;
            int xj = x[j];
            for (j = i; j > off && (xjm1 = x[j - 1]) > xj; --j) {
                x[j] = xjm1;
                x[j - 1] = xj;
            }
        }
    }

    private void sortCrossings() {
        int start = 0;
        for (int i = 0; i <= this.crossingMaxY - this.crossingMinY; ++i) {
            this.sortCrossings(this.crossings, start, this.crossingIndices[i] - start);
            start += this.crossingMaxXEntries;
        }
    }

    private void addCrossing(int y, int x, int orientation) {
        if (x < this.crossingMinX) {
            this.crossingMinX = x;
        }
        if (x > this.crossingMaxX) {
            this.crossingMaxX = x;
        }
        int n = y - this.crossingMinY;
        int n2 = this.crossingIndices[n];
        this.crossingIndices[n] = n2 + 1;
        int index = n2;
        this.crossings[index] = orientation == 1 ? x | 1 : (x <<= 1);
        ++this.numCrossings;
    }

    private void iterateCrossings() {
        if (!this.crossingsSorted) {
            this.sortCrossings();
            this.crossingsSorted = true;
        }
        this.crossingY = this.crossingMinY - 1;
        this.crossingRowOffset = -this.crossingMaxXEntries;
    }

    private boolean hasMoreCrossingRows() {
        if (++this.crossingY <= this.crossingMaxY) {
            this.crossingRowOffset += this.crossingMaxXEntries;
            int y = this.crossingY - this.crossingMinY;
            this.crossingRowCount = this.crossingIndices[y] - y * this.crossingMaxXEntries;
            this.crossingRowIndex = 0;
            return true;
        }
        return false;
    }
}

