/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Enumeration;

public final class LocalRMIServerSocketFactory
implements RMIServerSocketFactory {
    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port){

            public Socket accept() throws IOException {
                Enumeration<NetworkInterface> nis;
                Socket socket = super.accept();
                InetAddress remoteAddr = socket.getInetAddress();
                String msg = "The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.";
                try {
                    nis = NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException e) {
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.", e);
                }
                while (nis.hasMoreElements()) {
                    NetworkInterface ni = nis.nextElement();
                    Enumeration<InetAddress> addrs = ni.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress localAddr = addrs.nextElement();
                        if (!localAddr.equals(remoteAddr)) continue;
                        return socket;
                    }
                }
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.");
            }
        };
    }

    public boolean equals(Object obj) {
        return obj instanceof LocalRMIServerSocketFactory;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

