/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpStatusException;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Map;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmMemoryImpl;
import sun.management.snmp.jvmmib.EnumJvmMemPoolCollectThreshdSupport;
import sun.management.snmp.jvmmib.EnumJvmMemPoolState;
import sun.management.snmp.jvmmib.EnumJvmMemPoolThreshdSupport;
import sun.management.snmp.jvmmib.EnumJvmMemPoolType;
import sun.management.snmp.jvmmib.JvmMemPoolEntryMBean;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;

public class JvmMemPoolEntryImpl
implements JvmMemPoolEntryMBean {
    protected final int jvmMemPoolIndex;
    static final String memoryTag = "jvmMemPoolEntry.getUsage";
    static final String peakMemoryTag = "jvmMemPoolEntry.getPeakUsage";
    static final String collectMemoryTag = "jvmMemPoolEntry.getCollectionUsage";
    static final MemoryUsage ZEROS = new MemoryUsage(0L, 0L, 0L, 0L);
    final MemoryPoolMXBean pool;
    private long jvmMemPoolPeakReset = 0L;
    private static final EnumJvmMemPoolState JvmMemPoolStateValid = new EnumJvmMemPoolState("valid");
    private static final EnumJvmMemPoolState JvmMemPoolStateInvalid = new EnumJvmMemPoolState("invalid");
    private static final EnumJvmMemPoolType EnumJvmMemPoolTypeHeap = new EnumJvmMemPoolType("heap");
    private static final EnumJvmMemPoolType EnumJvmMemPoolTypeNonHeap = new EnumJvmMemPoolType("nonheap");
    private static final EnumJvmMemPoolThreshdSupport EnumJvmMemPoolThreshdSupported = new EnumJvmMemPoolThreshdSupport("supported");
    private static final EnumJvmMemPoolThreshdSupport EnumJvmMemPoolThreshdUnsupported = new EnumJvmMemPoolThreshdSupport("unsupported");
    private static final EnumJvmMemPoolCollectThreshdSupport EnumJvmMemPoolCollectThreshdSupported = new EnumJvmMemPoolCollectThreshdSupport("supported");
    private static final EnumJvmMemPoolCollectThreshdSupport EnumJvmMemPoolCollectThreshdUnsupported = new EnumJvmMemPoolCollectThreshdSupport("unsupported");
    static final MibLogger log = new MibLogger(JvmMemPoolEntryImpl.class);

    MemoryUsage getMemoryUsage() {
        try {
            Map<Object, Object> m = JvmContextFactory.getUserData();
            if (m != null) {
                MemoryUsage cached = (MemoryUsage)m.get(memoryTag);
                if (cached != null) {
                    log.debug("getMemoryUsage", "jvmMemPoolEntry.getUsage found in cache.");
                    return cached;
                }
                MemoryUsage u = this.pool.getUsage();
                if (u == null) {
                    u = ZEROS;
                }
                m.put(memoryTag, u);
                return u;
            }
            log.trace("getMemoryUsage", "ERROR: should never come here!");
            return this.pool.getUsage();
        }
        catch (RuntimeException x) {
            log.trace("getMemoryUsage", "Failed to get MemoryUsage: " + x);
            log.debug("getMemoryUsage", x);
            throw x;
        }
    }

    MemoryUsage getPeakMemoryUsage() {
        try {
            Map<Object, Object> m = JvmContextFactory.getUserData();
            if (m != null) {
                MemoryUsage cached = (MemoryUsage)m.get(peakMemoryTag);
                if (cached != null) {
                    if (log.isDebugOn()) {
                        log.debug("getPeakMemoryUsage", "jvmMemPoolEntry.getPeakUsage found in cache.");
                    }
                    return cached;
                }
                MemoryUsage u = this.pool.getPeakUsage();
                if (u == null) {
                    u = ZEROS;
                }
                m.put(peakMemoryTag, u);
                return u;
            }
            log.trace("getPeakMemoryUsage", "ERROR: should never come here!");
            return ZEROS;
        }
        catch (RuntimeException x) {
            log.trace("getPeakMemoryUsage", "Failed to get MemoryUsage: " + x);
            log.debug("getPeakMemoryUsage", x);
            throw x;
        }
    }

    MemoryUsage getCollectMemoryUsage() {
        try {
            Map<Object, Object> m = JvmContextFactory.getUserData();
            if (m != null) {
                MemoryUsage cached = (MemoryUsage)m.get(collectMemoryTag);
                if (cached != null) {
                    if (log.isDebugOn()) {
                        log.debug("getCollectMemoryUsage", "jvmMemPoolEntry.getCollectionUsage found in cache.");
                    }
                    return cached;
                }
                MemoryUsage u = this.pool.getCollectionUsage();
                if (u == null) {
                    u = ZEROS;
                }
                m.put(collectMemoryTag, u);
                return u;
            }
            log.trace("getCollectMemoryUsage", "ERROR: should never come here!");
            return ZEROS;
        }
        catch (RuntimeException x) {
            log.trace("getPeakMemoryUsage", "Failed to get MemoryUsage: " + x);
            log.debug("getPeakMemoryUsage", x);
            throw x;
        }
    }

    public JvmMemPoolEntryImpl(MemoryPoolMXBean mp, int index) {
        this.pool = mp;
        this.jvmMemPoolIndex = index;
    }

    public Long getJvmMemPoolMaxSize() throws SnmpStatusException {
        long val = this.getMemoryUsage().getMax();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolUsed() throws SnmpStatusException {
        long val = this.getMemoryUsage().getUsed();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolInitSize() throws SnmpStatusException {
        long val = this.getMemoryUsage().getInit();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCommitted() throws SnmpStatusException {
        long val = this.getMemoryUsage().getCommitted();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolPeakMaxSize() throws SnmpStatusException {
        long val = this.getPeakMemoryUsage().getMax();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolPeakUsed() throws SnmpStatusException {
        long val = this.getPeakMemoryUsage().getUsed();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolPeakCommitted() throws SnmpStatusException {
        long val = this.getPeakMemoryUsage().getCommitted();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCollectMaxSize() throws SnmpStatusException {
        long val = this.getCollectMemoryUsage().getMax();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCollectUsed() throws SnmpStatusException {
        long val = this.getCollectMemoryUsage().getUsed();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCollectCommitted() throws SnmpStatusException {
        long val = this.getCollectMemoryUsage().getCommitted();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolThreshold() throws SnmpStatusException {
        if (!this.pool.isUsageThresholdSupported()) {
            return JvmMemoryImpl.Long0;
        }
        long val = this.pool.getUsageThreshold();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public void setJvmMemPoolThreshold(Long x) throws SnmpStatusException {
        long val = x;
        if (val < 0L) {
            throw new SnmpStatusException(50);
        }
        this.pool.setUsageThreshold(val);
    }

    public void checkJvmMemPoolThreshold(Long x) throws SnmpStatusException {
        if (!this.pool.isUsageThresholdSupported()) {
            throw new SnmpStatusException(220);
        }
        long val = x;
        if (val < 0L) {
            throw new SnmpStatusException(50);
        }
    }

    public EnumJvmMemPoolThreshdSupport getJvmMemPoolThreshdSupport() throws SnmpStatusException {
        if (this.pool.isUsageThresholdSupported()) {
            return EnumJvmMemPoolThreshdSupported;
        }
        return EnumJvmMemPoolThreshdUnsupported;
    }

    public Long getJvmMemPoolThreshdCount() throws SnmpStatusException {
        if (!this.pool.isUsageThresholdSupported()) {
            return JvmMemoryImpl.Long0;
        }
        long val = this.pool.getUsageThresholdCount();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCollectThreshold() throws SnmpStatusException {
        if (!this.pool.isCollectionUsageThresholdSupported()) {
            return JvmMemoryImpl.Long0;
        }
        long val = this.pool.getCollectionUsageThreshold();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public void setJvmMemPoolCollectThreshold(Long x) throws SnmpStatusException {
        long val = x;
        if (val < 0L) {
            throw new SnmpStatusException(50);
        }
        this.pool.setCollectionUsageThreshold(val);
    }

    public void checkJvmMemPoolCollectThreshold(Long x) throws SnmpStatusException {
        if (!this.pool.isCollectionUsageThresholdSupported()) {
            throw new SnmpStatusException(220);
        }
        long val = x;
        if (val < 0L) {
            throw new SnmpStatusException(50);
        }
    }

    public EnumJvmMemPoolCollectThreshdSupport getJvmMemPoolCollectThreshdSupport() throws SnmpStatusException {
        if (this.pool.isCollectionUsageThresholdSupported()) {
            return EnumJvmMemPoolCollectThreshdSupported;
        }
        return EnumJvmMemPoolCollectThreshdUnsupported;
    }

    public Long getJvmMemPoolCollectThreshdCount() throws SnmpStatusException {
        if (!this.pool.isCollectionUsageThresholdSupported()) {
            return JvmMemoryImpl.Long0;
        }
        long val = this.pool.getCollectionUsageThresholdCount();
        if (val > -1L) {
            return new Long(val);
        }
        return JvmMemoryImpl.Long0;
    }

    public static EnumJvmMemPoolType jvmMemPoolType(MemoryType type) throws SnmpStatusException {
        if (type.equals((Object)MemoryType.HEAP)) {
            return EnumJvmMemPoolTypeHeap;
        }
        if (type.equals((Object)MemoryType.NON_HEAP)) {
            return EnumJvmMemPoolTypeNonHeap;
        }
        throw new SnmpStatusException(50);
    }

    public EnumJvmMemPoolType getJvmMemPoolType() throws SnmpStatusException {
        return JvmMemPoolEntryImpl.jvmMemPoolType(this.pool.getType());
    }

    public String getJvmMemPoolName() throws SnmpStatusException {
        return JVM_MANAGEMENT_MIB_IMPL.validJavaObjectNameTC(this.pool.getName());
    }

    public Integer getJvmMemPoolIndex() throws SnmpStatusException {
        return new Integer(this.jvmMemPoolIndex);
    }

    public EnumJvmMemPoolState getJvmMemPoolState() throws SnmpStatusException {
        if (this.pool.isValid()) {
            return JvmMemPoolStateValid;
        }
        return JvmMemPoolStateInvalid;
    }

    public synchronized Long getJvmMemPoolPeakReset() throws SnmpStatusException {
        return new Long(this.jvmMemPoolPeakReset);
    }

    public synchronized void setJvmMemPoolPeakReset(Long x) throws SnmpStatusException {
        long l = x;
        if (l > this.jvmMemPoolPeakReset) {
            long stamp = System.currentTimeMillis();
            this.pool.resetPeakUsage();
            this.jvmMemPoolPeakReset = stamp;
            log.debug("setJvmMemPoolPeakReset", "jvmMemPoolPeakReset=" + stamp);
        }
    }

    public void checkJvmMemPoolPeakReset(Long x) throws SnmpStatusException {
    }
}

