/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableHandler;

public abstract class SnmpTableCache
implements Serializable {
    protected long validity;
    protected transient WeakReference<SnmpCachedData> datas;

    protected boolean isObsolete(SnmpCachedData cached) {
        if (cached == null) {
            return true;
        }
        if (this.validity < 0L) {
            return false;
        }
        return System.currentTimeMillis() - cached.lastUpdated > this.validity;
    }

    protected SnmpCachedData getCachedDatas() {
        if (this.datas == null) {
            return null;
        }
        SnmpCachedData cached = (SnmpCachedData)this.datas.get();
        if (cached == null || this.isObsolete(cached)) {
            return null;
        }
        return cached;
    }

    protected synchronized SnmpCachedData getTableDatas(Object context) {
        SnmpCachedData cached = this.getCachedDatas();
        if (cached != null) {
            return cached;
        }
        SnmpCachedData computedDatas = this.updateCachedDatas(context);
        if (this.validity != 0L) {
            this.datas = new WeakReference<SnmpCachedData>(computedDatas);
        }
        return computedDatas;
    }

    protected abstract SnmpCachedData updateCachedDatas(Object var1);

    public abstract SnmpTableHandler getTableHandler();
}

