/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;

public class NetworkServer
implements Runnable,
Cloneable {
    public Socket clientSocket = null;
    private Thread serverInstance;
    private ServerSocket serverSocket;
    public PrintStream clientOutput;
    public InputStream clientInput;

    public void close() throws IOException {
        this.clientSocket.close();
        this.clientSocket = null;
        this.clientInput = null;
        this.clientOutput = null;
    }

    public boolean clientIsOpen() {
        return this.clientSocket != null;
    }

    public final void run() {
        if (this.serverSocket != null) {
            Thread.currentThread().setPriority(10);
            try {
                while (true) {
                    Socket ns = this.serverSocket.accept();
                    NetworkServer n = (NetworkServer)this.clone();
                    n.serverSocket = null;
                    n.clientSocket = ns;
                    new Thread(n).start();
                }
            }
            catch (Exception e) {
                System.out.print("Server failure\n");
                e.printStackTrace();
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.out.print("cs=" + this.serverSocket + "\n");
            }
        } else {
            try {
                this.clientOutput = new PrintStream(new BufferedOutputStream(this.clientSocket.getOutputStream()), false, "ISO8859_1");
                this.clientInput = new BufferedInputStream(this.clientSocket.getInputStream());
                this.serviceRequest();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final void startServer(int port) throws IOException {
        this.serverSocket = new ServerSocket(port, 50);
        this.serverInstance = new Thread(this);
        this.serverInstance.start();
    }

    public void serviceRequest() throws IOException {
        int n;
        byte[] buf = new byte[300];
        this.clientOutput.print("Echo server " + this.getClass().getName() + "\n");
        this.clientOutput.flush();
        while ((n = this.clientInput.read(buf, 0, buf.length)) >= 0) {
            this.clientOutput.write(buf, 0, n);
        }
    }

    public static void main(String[] argv) {
        try {
            new NetworkServer().startServer(8888);
        }
        catch (IOException e) {
            System.out.print("Server failed: " + e + "\n");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

