/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    private IOUtil() {
    }

    private static int remaining(ByteBuffer[] bufs) {
        int numBufs = bufs.length;
        boolean remaining = false;
        for (int i = 0; i < numBufs; ++i) {
            if (!bufs[i].hasRemaining()) continue;
            return i;
        }
        return -1;
    }

    private static ByteBuffer[] skipBufs(ByteBuffer[] bufs, int nextWithRemaining) {
        int newSize = bufs.length - nextWithRemaining;
        ByteBuffer[] temp = new ByteBuffer[newSize];
        for (int i = 0; i < newSize; ++i) {
            temp[i] = bufs[i + nextWithRemaining];
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fd, ByteBuffer src, long position, NativeDispatcher nd, Object lock) throws IOException {
        int n;
        if (src instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fd, src, position, nd, lock);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer bb = null;
        try {
            bb = Util.getTemporaryDirectBuffer(rem);
            bb.put(src);
            bb.flip();
            src.position(pos);
            int n2 = IOUtil.writeFromNativeBuffer(fd, bb, position, nd, lock);
            if (n2 > 0) {
                src.position(pos + n2);
            }
            n = n2;
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            Util.releaseTemporaryDirectBuffer(bb);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(bb);
        return n;
    }

    private static int writeFromNativeBuffer(FileDescriptor fd, ByteBuffer bb, long position, NativeDispatcher nd, Object lock) throws IOException {
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int written = 0;
        if (rem == 0) {
            return 0;
        }
        written = position != -1L ? nd.pwrite(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, position, lock) : nd.write(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem);
        if (written > 0) {
            bb.position(pos + written);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fd, ByteBuffer[] bufs, NativeDispatcher nd) throws IOException {
        int nextWithRemaining = IOUtil.remaining(bufs);
        if (nextWithRemaining < 0) {
            return 0L;
        }
        if (nextWithRemaining > 0) {
            bufs = IOUtil.skipBufs(bufs, nextWithRemaining);
        }
        int numBufs = bufs.length;
        int bytesReadyToWrite = 0;
        ByteBuffer[] shadow = new ByteBuffer[numBufs];
        for (int i = 0; i < numBufs; ++i) {
            if (!(bufs[i] instanceof DirectBuffer)) {
                ByteBuffer bb;
                int pos = bufs[i].position();
                int lim = bufs[i].limit();
                assert (pos <= lim);
                int rem = pos <= lim ? lim - pos : 0;
                shadow[i] = bb = ByteBuffer.allocateDirect(rem);
                bb.put(bufs[i]);
                bufs[i].position(pos);
                bb.flip();
                continue;
            }
            shadow[i] = bufs[i];
        }
        IOVecWrapper vec = null;
        long bytesWritten = 0L;
        try {
            vec = new IOVecWrapper(numBufs);
            for (int i = 0; i < numBufs; ++i) {
                ByteBuffer nextBuffer = shadow[i];
                long pos = nextBuffer.position();
                long len = (long)nextBuffer.limit() - pos;
                bytesReadyToWrite = (int)((long)bytesReadyToWrite + len);
                vec.putBase(i, ((DirectBuffer)((Object)nextBuffer)).address() + pos);
                vec.putLen(i, len);
            }
            bytesWritten = nd.writev(fd, vec.address, numBufs);
            Object var17_19 = null;
            vec.free();
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            vec.free();
            throw throwable;
        }
        long returnVal = bytesWritten;
        for (int i = 0; i < numBufs; ++i) {
            int len;
            ByteBuffer nextBuffer = bufs[i];
            int pos = nextBuffer.position();
            int lim = nextBuffer.limit();
            assert (pos <= lim);
            int n = len = pos <= lim ? lim - pos : lim;
            if (bytesWritten >= (long)len) {
                bytesWritten -= (long)len;
            } else {
                if (bytesWritten <= 0L) break;
                assert ((long)pos + bytesWritten < Integer.MAX_VALUE);
                int newPosition = (int)((long)pos + bytesWritten);
                nextBuffer.position(newPosition);
                break;
            }
            int newPosition = pos + len;
            nextBuffer.position(newPosition);
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fd, ByteBuffer dst, long position, NativeDispatcher nd, Object lock) throws IOException {
        int n;
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (dst instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fd, dst, position, nd, lock);
        }
        ByteBuffer bb = null;
        try {
            bb = Util.getTemporaryDirectBuffer(dst.remaining());
            int n2 = IOUtil.readIntoNativeBuffer(fd, bb, position, nd, lock);
            bb.flip();
            if (n2 > 0) {
                dst.put(bb);
            }
            n = n2;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Util.releaseTemporaryDirectBuffer(bb);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(bb);
        return n;
    }

    private static int readIntoNativeBuffer(FileDescriptor fd, ByteBuffer bb, long position, NativeDispatcher nd, Object lock) throws IOException {
        int rem;
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (rem == 0) {
            return 0;
        }
        int n2 = 0;
        n2 = position != -1L ? nd.pread(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, position, lock) : nd.read(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem);
        if (n2 > 0) {
            bb.position(pos + n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fd, ByteBuffer[] bufs, NativeDispatcher nd) throws IOException {
        int i;
        int nextWithRemaining = IOUtil.remaining(bufs);
        if (nextWithRemaining < 0) {
            return 0L;
        }
        if (nextWithRemaining > 0) {
            bufs = IOUtil.skipBufs(bufs, nextWithRemaining);
        }
        int numBufs = bufs.length;
        ByteBuffer[] shadow = new ByteBuffer[numBufs];
        for (int i2 = 0; i2 < numBufs; ++i2) {
            if (bufs[i2].isReadOnly()) {
                throw new IllegalArgumentException("Read-only buffer");
            }
            shadow[i2] = !(bufs[i2] instanceof DirectBuffer) ? ByteBuffer.allocateDirect(bufs[i2].remaining()) : bufs[i2];
        }
        IOVecWrapper vec = null;
        long bytesRead = 0L;
        try {
            vec = new IOVecWrapper(numBufs);
            for (int i3 = 0; i3 < numBufs; ++i3) {
                ByteBuffer nextBuffer = shadow[i3];
                long pos = nextBuffer.position();
                long len = nextBuffer.remaining();
                vec.putBase(i3, ((DirectBuffer)((Object)nextBuffer)).address() + pos);
                vec.putLen(i3, len);
            }
            bytesRead = nd.readv(fd, vec.address, numBufs);
            Object var16_16 = null;
            vec.free();
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            vec.free();
            throw throwable;
        }
        long returnVal = bytesRead;
        for (i = 0; i < numBufs; ++i) {
            int newPosition;
            ByteBuffer nextBuffer = shadow[i];
            int pos = nextBuffer.position();
            int len = nextBuffer.remaining();
            if (bytesRead >= (long)len) {
                bytesRead -= (long)len;
            } else {
                if (bytesRead <= 0L) break;
                assert ((long)pos + bytesRead < Integer.MAX_VALUE);
                newPosition = (int)((long)pos + bytesRead);
                nextBuffer.position(newPosition);
                break;
            }
            newPosition = pos + len;
            nextBuffer.position(newPosition);
        }
        for (i = 0; i < numBufs; ++i) {
            if (bufs[i] instanceof DirectBuffer) continue;
            shadow[i].flip();
            bufs[i].put(shadow[i]);
        }
        return returnVal;
    }

    static FileDescriptor newFD(int i) {
        FileDescriptor fd = new FileDescriptor();
        IOUtil.setfdVal(fd, i);
        return fd;
    }

    static native boolean randomBytes(byte[] var0);

    static native void initPipe(int[] var0, boolean var1);

    static native boolean drain(int var0) throws IOException;

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void initIDs();

    static {
        Util.load();
    }
}

