/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.State;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ForwardBuilder
extends Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    private final Set<X509Certificate> trustedCerts;
    private final Set<X500Principal> trustedSubjectDNs;
    private final Set<TrustAnchor> trustAnchors;
    private X509CertSelector eeSelector;
    private X509CertSelector caSelector;
    private X509CertSelector caTargetSelector;
    TrustAnchor trustAnchor;
    private Comparator<X509Certificate> comparator;
    private boolean searchAllCertStores = true;

    ForwardBuilder(PKIXBuilderParameters buildParams, X500Principal targetSubjectDN, boolean searchAllCertStores) {
        super(buildParams, targetSubjectDN);
        this.trustAnchors = buildParams.getTrustAnchors();
        this.trustedCerts = new HashSet<X509Certificate>(this.trustAnchors.size());
        this.trustedSubjectDNs = new HashSet<X500Principal>(this.trustAnchors.size());
        for (TrustAnchor anchor : this.trustAnchors) {
            X509Certificate trustedCert = anchor.getTrustedCert();
            if (trustedCert != null) {
                this.trustedCerts.add(trustedCert);
                this.trustedSubjectDNs.add(trustedCert.getSubjectX500Principal());
                continue;
            }
            this.trustedSubjectDNs.add(anchor.getCA());
        }
        this.comparator = new PKIXCertComparator(this.trustedSubjectDNs);
        this.searchAllCertStores = searchAllCertStores;
    }

    @Override
    Collection<X509Certificate> getMatchingCerts(State currentState, List<CertStore> certStores) throws CertStoreException, CertificateException, IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCerts()...");
        }
        ForwardState currState = (ForwardState)currentState;
        TreeSet<X509Certificate> certs = new TreeSet<X509Certificate>(this.comparator);
        if (currState.isInitial()) {
            this.getMatchingEECerts(currState, certStores, certs);
        }
        this.getMatchingCACerts(currState, certStores, certs);
        return certs;
    }

    private void getMatchingEECerts(ForwardState currentState, List<CertStore> certStores, Collection<X509Certificate> eeCerts) throws IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingEECerts()...");
        }
        if (this.eeSelector == null) {
            this.eeSelector = (X509CertSelector)this.targetCertConstraints.clone();
            this.eeSelector.setCertificateValid(this.date);
            if (this.buildParams.isExplicitPolicyRequired()) {
                this.eeSelector.setPolicy(this.getMatchingPolicies());
            }
            this.eeSelector.setBasicConstraints(-2);
        }
        this.addMatchingCerts(this.eeSelector, certStores, eeCerts, this.searchAllCertStores);
    }

    private void getMatchingCACerts(ForwardState currentState, List<CertStore> certStores, Collection<X509Certificate> caCerts) throws IOException {
        AuthorityInfoAccessExtension aiaExt;
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCACerts()...");
        }
        int initialSize = caCerts.size();
        X509CertSelector sel = null;
        if (currentState.isInitial()) {
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts(): ca is target");
            }
            if (this.caTargetSelector == null) {
                this.caTargetSelector = (X509CertSelector)this.targetCertConstraints.clone();
                this.caTargetSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caTargetSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caTargetSelector.setBasicConstraints(currentState.traversedCACerts);
            sel = this.caTargetSelector;
        } else {
            if (this.caSelector == null) {
                this.caSelector = new X509CertSelector();
                this.caSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caSelector.setSubject(currentState.issuerDN);
            CertPathHelper.setPathToNames(this.caSelector, currentState.subjectNamesTraversed);
            this.caSelector.setBasicConstraints(currentState.traversedCACerts);
            sel = this.caSelector;
        }
        X509CertSelector trustedSel = null;
        if (currentState.isInitial()) {
            trustedSel = this.targetCertConstraints;
        } else {
            trustedSel = new X509CertSelector();
            trustedSel.setSubject(currentState.issuerDN);
        }
        boolean foundMatchingCert = false;
        for (X509Certificate trustedCert : this.trustedCerts) {
            if (!trustedSel.match(trustedCert)) continue;
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts: found matching trust anchor");
            }
            if (!caCerts.add(trustedCert) || this.searchAllCertStores) continue;
            return;
        }
        if ((currentState.isInitial() || this.buildParams.getMaxPathLength() == -1 || this.buildParams.getMaxPathLength() > currentState.traversedCACerts) && this.addMatchingCerts(sel, certStores, caCerts, this.searchAllCertStores) && !this.searchAllCertStores) {
            return;
        }
        if (!currentState.isInitial() && Builder.USE_AIA && (aiaExt = currentState.cert.getAuthorityInfoAccessExtension()) != null) {
            this.getCerts(aiaExt, caCerts);
        }
        if (debug != null) {
            int numCerts = caCerts.size() - initialSize;
            debug.println("ForwardBuilder.getMatchingCACerts: found " + numCerts + " CA certs");
        }
    }

    private boolean getCerts(AuthorityInfoAccessExtension aiaExt, Collection<X509Certificate> certs) {
        if (!Builder.USE_AIA) {
            return false;
        }
        List<AccessDescription> adList = aiaExt.getAccessDescriptions();
        if (adList == null || adList.isEmpty()) {
            return false;
        }
        boolean add = false;
        for (AccessDescription ad : adList) {
            CertStore cs = URICertStore.getInstance(ad);
            try {
                if (!certs.addAll(cs.getCertificates(this.caSelector))) continue;
                add = true;
                if (this.searchAllCertStores) continue;
                return true;
            }
            catch (CertStoreException cse) {
                if (debug == null) continue;
                debug.println("exception getting certs from CertStore:");
                cse.printStackTrace();
            }
        }
        return add;
    }

    @Override
    void verifyCert(X509Certificate cert, State currentState, List<X509Certificate> certPathList) throws GeneralSecurityException {
        boolean isTrustedCert;
        if (debug != null) {
            debug.println("ForwardBuilder.verifyCert(SN: " + Debug.toHexString(cert.getSerialNumber()) + "\n  Issuer: " + cert.getIssuerX500Principal() + ")" + "\n  Subject: " + cert.getSubjectX500Principal() + ")");
        }
        ForwardState currState = (ForwardState)currentState;
        if (certPathList != null) {
            boolean policyMappingFound = false;
            for (X509Certificate cpListCert : certPathList) {
                X509CertImpl cpListCertImpl = X509CertImpl.toImpl(cpListCert);
                PolicyMappingsExtension policyMappingsExt = cpListCertImpl.getPolicyMappingsExtension();
                if (policyMappingsExt != null) {
                    policyMappingFound = true;
                }
                if (debug != null) {
                    debug.println("policyMappingFound = " + policyMappingFound);
                }
                if (!cert.equals(cpListCert) || !this.buildParams.isPolicyMappingInhibited() && policyMappingFound) continue;
                if (debug != null) {
                    debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        if (!(isTrustedCert = this.trustedCerts.contains(cert))) {
            Set<String> unresCritExts = cert.getCriticalExtensionOIDs();
            if (unresCritExts == null) {
                unresCritExts = Collections.emptySet();
            }
            for (PKIXCertPathChecker checker : currState.forwardCheckers) {
                checker.check(cert, unresCritExts);
            }
            for (PKIXCertPathChecker checker : this.buildParams.getCertPathCheckers()) {
                Set<String> supportedExts;
                if (checker.isForwardCheckingSupported() || (supportedExts = checker.getSupportedExtensions()) == null) continue;
                unresCritExts.removeAll(supportedExts);
            }
            if (!unresCritExts.isEmpty()) {
                unresCritExts.remove(PKIXExtensions.BasicConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.NameConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                unresCritExts.remove(PKIXExtensions.PolicyMappings_Id.toString());
                unresCritExts.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                unresCritExts.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                unresCritExts.remove(PKIXExtensions.KeyUsage_Id.toString());
                unresCritExts.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                if (!unresCritExts.isEmpty()) {
                    throw new CertificateException("Unrecognized critical extension(s)");
                }
            }
        }
        if (currState.isInitial()) {
            return;
        }
        if (!isTrustedCert) {
            if (cert.getBasicConstraints() == -1) {
                throw new CertificateException("cert is NOT a CA cert");
            }
            KeyChecker.verifyCAKeyUsage(cert);
        }
        if (this.buildParams.isRevocationEnabled() && CrlRevocationChecker.certCanSignCrl(cert) && !currState.keyParamsNeeded()) {
            currState.crlChecker.check(currState.cert, cert.getPublicKey(), true);
        }
        if (!currState.keyParamsNeeded()) {
            currState.cert.verify(cert.getPublicKey(), this.buildParams.getSigProvider());
        }
    }

    @Override
    boolean isPathCompleted(X509Certificate cert) {
        for (TrustAnchor anchor : this.trustAnchors) {
            if (anchor.getTrustedCert() != null) {
                if (!cert.equals(anchor.getTrustedCert())) continue;
                this.trustAnchor = anchor;
                return true;
            }
            X500Principal trustedCAName = anchor.getCA();
            if (!trustedCAName.equals(cert.getIssuerX500Principal())) continue;
            if (this.buildParams.isRevocationEnabled()) {
                try {
                    CrlRevocationChecker crlChecker = new CrlRevocationChecker(anchor, this.buildParams);
                    crlChecker.check(cert, anchor.getCAPublicKey(), true);
                }
                catch (CertPathValidatorException cpve) {
                    if (debug == null) continue;
                    debug.println("ForwardBuilder.isPathCompleted() cpve");
                    cpve.printStackTrace();
                    continue;
                }
            }
            try {
                cert.verify(anchor.getCAPublicKey(), this.buildParams.getSigProvider());
            }
            catch (InvalidKeyException ike) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() invalid DSA key found");
                continue;
            }
            catch (Exception e) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() unexpected exception");
                e.printStackTrace();
                continue;
            }
            this.trustAnchor = anchor;
            return true;
        }
        return false;
    }

    @Override
    void addCertToPath(X509Certificate cert, LinkedList<X509Certificate> certPathList) {
        certPathList.addFirst(cert);
    }

    @Override
    void removeFinalCertFromPath(LinkedList<X509Certificate> certPathList) {
        certPathList.removeFirst();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PKIXCertComparator
    implements Comparator<X509Certificate> {
        static final String METHOD_NME = "PKIXCertComparator.compare()";
        private final Set<X500Principal> trustedSubjectDNs;

        PKIXCertComparator(Set<X500Principal> trustedSubjectDNs) {
            this.trustedSubjectDNs = trustedSubjectDNs;
        }

        @Override
        public int compare(X509Certificate oCert1, X509Certificate oCert2) {
            int distanceTto2;
            int distanceTto1;
            X500Name tSubjectName;
            if (oCert1.equals(oCert2)) {
                return 0;
            }
            X500Principal cIssuer1 = oCert1.getIssuerX500Principal();
            X500Principal cIssuer2 = oCert2.getIssuerX500Principal();
            X500Name cIssuer1Name = X500Name.asX500Name(cIssuer1);
            X500Name cIssuer2Name = X500Name.asX500Name(cIssuer2);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() o1 Issuer:  " + cIssuer1);
                debug.println("PKIXCertComparator.compare() o2 Issuer:  " + cIssuer2);
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() MATCH TRUSTED SUBJECT TEST...");
            }
            boolean m1 = this.trustedSubjectDNs.contains(cIssuer1);
            boolean m2 = this.trustedSubjectDNs.contains(cIssuer2);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() m1: " + m1);
                debug.println("PKIXCertComparator.compare() m2: " + m2);
            }
            if (m1 && m2) {
                return -1;
            }
            if (m1) {
                return -1;
            }
            if (m2) {
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() NAMING DESCENDANT TEST...");
            }
            for (X500Principal tSubject : this.trustedSubjectDNs) {
                tSubjectName = X500Name.asX500Name(tSubject);
                distanceTto1 = Builder.distance(tSubjectName, cIssuer1Name, -1);
                distanceTto2 = Builder.distance(tSubjectName, cIssuer2Name, -1);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() distanceTto1: " + distanceTto1);
                    debug.println("PKIXCertComparator.compare() distanceTto2: " + distanceTto2);
                }
                if (distanceTto1 <= 0 && distanceTto2 <= 0) continue;
                if (distanceTto1 == distanceTto2) {
                    return -1;
                }
                if (distanceTto1 > 0 && distanceTto2 <= 0) {
                    return -1;
                }
                if (distanceTto1 <= 0 && distanceTto2 > 0) {
                    return 1;
                }
                if (distanceTto1 < distanceTto2) {
                    return -1;
                }
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() NAMING ANCESTOR TEST...");
            }
            for (X500Principal tSubject : this.trustedSubjectDNs) {
                tSubjectName = X500Name.asX500Name(tSubject);
                distanceTto1 = Builder.distance(tSubjectName, cIssuer1Name, Integer.MAX_VALUE);
                distanceTto2 = Builder.distance(tSubjectName, cIssuer2Name, Integer.MAX_VALUE);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() distanceTto1: " + distanceTto1);
                    debug.println("PKIXCertComparator.compare() distanceTto2: " + distanceTto2);
                }
                if (distanceTto1 >= 0 && distanceTto2 >= 0) continue;
                if (distanceTto1 == distanceTto2) {
                    return -1;
                }
                if (distanceTto1 < 0 && distanceTto2 >= 0) {
                    return -1;
                }
                if (distanceTto1 >= 0 && distanceTto2 < 0) {
                    return 1;
                }
                if (distanceTto1 > distanceTto2) {
                    return -1;
                }
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() SAME NAMESPACE AS TRUSTED TEST...");
            }
            for (X500Principal tSubject : this.trustedSubjectDNs) {
                tSubjectName = X500Name.asX500Name(tSubject);
                X500Name tAo1 = tSubjectName.commonAncestor(cIssuer1Name);
                X500Name tAo2 = tSubjectName.commonAncestor(cIssuer2Name);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() tAo1: " + String.valueOf(tAo1));
                    debug.println("PKIXCertComparator.compare() tAo2: " + String.valueOf(tAo2));
                }
                if (tAo1 == null && tAo2 == null) continue;
                if (tAo1 != null && tAo2 != null) {
                    int hopsTto1 = Builder.hops(tSubjectName, cIssuer1Name, Integer.MAX_VALUE);
                    int hopsTto2 = Builder.hops(tSubjectName, cIssuer2Name, Integer.MAX_VALUE);
                    if (debug != null) {
                        debug.println("PKIXCertComparator.compare() hopsTto1: " + hopsTto1);
                        debug.println("PKIXCertComparator.compare() hopsTto2: " + hopsTto2);
                    }
                    if (hopsTto1 == hopsTto2) continue;
                    if (hopsTto1 > hopsTto2) {
                        return 1;
                    }
                    return -1;
                }
                if (tAo1 == null) {
                    return 1;
                }
                return -1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() CERT ISSUER/SUBJECT COMPARISON TEST...");
            }
            X500Principal cSubject1 = oCert1.getSubjectX500Principal();
            X500Principal cSubject2 = oCert2.getSubjectX500Principal();
            X500Name cSubject1Name = X500Name.asX500Name(cSubject1);
            X500Name cSubject2Name = X500Name.asX500Name(cSubject2);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() o1 Subject: " + cSubject1);
                debug.println("PKIXCertComparator.compare() o2 Subject: " + cSubject2);
            }
            int distanceStoI1 = Builder.distance(cSubject1Name, cIssuer1Name, Integer.MAX_VALUE);
            int distanceStoI2 = Builder.distance(cSubject2Name, cIssuer2Name, Integer.MAX_VALUE);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() distanceStoI1: " + distanceStoI1);
                debug.println("PKIXCertComparator.compare() distanceStoI2: " + distanceStoI2);
            }
            if (distanceStoI2 > distanceStoI1) {
                return -1;
            }
            if (distanceStoI2 < distanceStoI1) {
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() no tests matched; RETURN 0");
            }
            return -1;
        }
    }
}

