/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.Padding;
import com.sun.crypto.provider.SunJCE;
import javax.crypto.ShortBufferException;

final class ISO10126Padding
implements Padding {
    private int blockSize;

    ISO10126Padding(int blockSize) {
        this.blockSize = blockSize;
    }

    public void padWithLen(byte[] in, int off, int len) throws ShortBufferException {
        if (in == null) {
            return;
        }
        if (off + len > in.length) {
            throw new ShortBufferException("Buffer too small to hold padding");
        }
        byte paddingOctet = (byte)(len & 0xFF);
        byte[] padding = new byte[len];
        SunJCE.RANDOM.nextBytes(padding);
        padding[len - 1] = paddingOctet;
        System.arraycopy(padding, 0, in, off, len);
    }

    public int unpad(byte[] in, int off, int len) {
        if (in == null || len == 0) {
            return 0;
        }
        byte lastByte = in[off + len - 1];
        int padValue = lastByte & 0xFF;
        if (padValue < 1 || padValue > this.blockSize) {
            return -1;
        }
        int start = off + len - (lastByte & 0xFF);
        if (start < off) {
            return -1;
        }
        return start;
    }

    public int padLength(int len) {
        int paddingOctet = this.blockSize - len % this.blockSize;
        return paddingOctet;
    }
}

