

Manuel de l'utilisateur d'aptitude


Version 0.4.11.11


Daniel Burrows

<dburrows@debian.org>

Copyright © 2004-2008 Daniel Burrows

This manual is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This manual is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this manual; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA

--------------------------------------------------------------------------------
Table des matières



  Introduction


        Qu'est-ce qu'aptitude, au fait ?

        Qu'est-ce qu'un gestionnaire de paquets ?

        Qu'est-ce que le système apt ?

        Comment se procure-t-on aptitude ?


              Paquets précompilés d'aptitude, « ce que 99% des utilisateurs
              devraient utiliser »

              Construire aptitude depuis les sources

              Assurer le suivi, et participer au developpement d'aptitude



  1. Notions pour commencer


        Utiliser aptitude


              Les bases d'aptitude

              Naviguer dans la liste des paquets d'aptitude

              Rechercher des paquets par leur nom

              Gérer les paquets

              Mettre   jour la liste des paquets et installer des paquets


        Utiliser aptitude depuis la ligne de commande


  2. Guide de référence d'aptitude


        L'interface utilisateur d'aptitude


              Utiliser les menus

              Commandes du menu

              Travailler avec plusieurs vues

              Devenir administrateur (« root »)


        Gérer les paquets


              Gérer la liste des paquets

              Accéder aux informations des paquets

              Modifier l'état d'un paquet

              Résoudre les problèmes de dépendance

              Télécharger, installer et supprimer des paquets

              Qu'est-ce que la confiance en matière de gestion des paquets ?

              Gérer les paquets automatiquement installés


        Motifs de recherche


              Searching for strings

              Shorthand for search terms

              Searches and Versions

              Explicit search targets

              Search Term Reference


        Personnalisation d'aptitude


              Personnaliser la liste des paquets

              Personnaliser les raccourcis clavier

              Personnaliser la couleur du texte et les styles

              Personnaliser la disposition de l'affichage

              Référence du fichier de configuration

              Thèmes


        Jouer au démineur


  3. FAQ d'aptitude

  4. Crédits

  I. Référence de la ligne de commande


        aptitude --; interface évoluée pour le gestionnaire de paquets

        aptitude-create-state-bundle --; bundle the current aptitude state

        aptitude-run-state-bundle --; unpack an aptitude state bundle and
        invoke aptitude on it


Liste des illustrations



  2.1. Commandes disponibles dans le menu Actions

  2.2. Commandes disponibles dans le menu Annuler

  2.3. Commandes disponibles dans le menu Paquet

  2.4. Commandes disponibles dans le menu Solveur

  2.5. Commandes disponibles dans le menu Rechercher

  2.6. Commandes disponibles dans le menu Options

  2.7. Commandes disponibles dans le menu Vues

  2.8. Commandes disponibles dans le menu Aide

  2.9. Valeurs de l'indicateur de « l'état courant »

  2.10. Valeurs de l'indicateur « d'action »

  2.11. Syntax of the ?for term

  2.12. Styles personnalisables dans aptitude

Liste des tableaux



  2.1. Quick guide to search terms

Liste des exemples



  2.1. Use of the ?= term.

  2.2. Use of the ?bind term

  2.3. Use of the ?for term


Introduction

Table des matières



  Qu'est-ce qu'aptitude, au fait ?

  Qu'est-ce qu'un gestionnaire de paquets ?

  Qu'est-ce que le système apt ?

  Comment se procure-t-on aptitude ?


        Paquets précompilés d'aptitude, « ce que 99% des utilisateurs
        devraient utiliser »

        Construire aptitude depuis les sources

        Assurer le suivi, et participer au developpement d'aptitude



  « Maître, Emacs connaît-il la nature du Bouddha ? » demanda le     
   novice.

   « Pourquoi en serait-il autrement ? », répondit le maître. « Il
   fait sacrément bien tout le reste ». Quelques années plus tard, le
   novice reçut l'illumination.

                                                                -- John Fouhy


Voici le manuel de l'utilisateur d'aptitude ! Cette introduction explique ce
qu'est aptitude et   quoi il sert. Pour accéder aux informations sur la
manière de l'utiliser, allez directement au Chapitre 1, Notions_pour
commencer.


Qu'est-ce qu'aptitude, au fait ?

aptitude est un gestionnaire de paquets très complet pour les systèmes Debian
GNU/Linux ; il est basé sur la fameuse infrastructure de gestion de paquets
apt. aptitude fournit les fonctionnalités de dselect et d'apt-get, ainsi que
beaucoup d'autres, introuvables dans ces programmes.


Qu'est-ce qu'un gestionnaire de paquets ?

Un gestionnaire de paquets garde la trace des programmes installés sur votre
ordinateur. Il facilite l'installation de nouveaux programmes, la mise   jour
ou la suppression de ceux que vous aviez précédemment installés. Comme le nom
le suggère, un gestionnaire de paquets traite des paquets : un paquet est un
ensemble de fichiers liés et qui peuvent être installés ou supprimés en
bloc.

Généralement, un paquet fournit un programme particulier. Par exemple, le
client de messagerie instantanée gaim est contenu dans le paquet Debian du
même nom. D'un autre côté, il est fréquent qu'un programme se compose de
plusieurs paquets apparentés. Par exemple, l'éditeur d'image gimp n'est pas
constitué que du paquet gimp, mais aussi du paquet gimp-data ; de plus
plusieurs paquets optionnels supplémentaires (contenant des données diverses,
de la documentation, etc.) sont aussi disponibles. Il arrive aussi que plusieurs
petits programmes apparentés soient fournis dans un unique paquet. Par exemple,
le paquet fileutils contient plusieurs commandes Unix usuelles telles que ls,
cp, etc.

Certains paquets requièrent d'autres paquets pour fonctionner. À l'intérieur
de Debian, les paquets peuvent dépendre, recommander, suggérer, casser,ou
être en conflit (« conflict ») avec d'autres paquets.


* Si un paquet A dépend d'un paquet B, alors B est nécessaire au bon
  fonctionnement de A. Par exemple, le paquet gimp dépend du paquet gimp-data
  pour s'assurer que l'éditeur de graphismes GIMP aura accès   ses fichiers
  de données.

* Si un paquet A recommande un autre paquet B, alors B ajoute au paquet A une
  fonctionnalité importante qui sera appréciée dans la plupart des cas. Par
  exemple, le paquet mozilla-browser recommande le paquet mozilla-psm qui ajoute
  la gestion des transferts de données sécurisés au navigateur web Mozilla.
  Bien que mozilla-psm ne soit pas absolument nécessaire pour que Mozilla
  fonctionne, la plupart des utilisateurs veulent que Mozilla gère la
  transmission sécurisée de données confidentielles (tel que leur numéro de
  carte bancaire).

* Si un paquet A suggère un autre paquet B, alors le paquet B fournit une
  fonctionnalité qui peut améliorer A sans qu'elle ne soit généralement
  nécessaire. Par exemple, le paquet kmail suggère le paquet gnupg qui
  contient un logiciel de chiffrement que KMail peut utiliser.

* Si un paquet A est en conflit avec un autre paquet B, alors les deux paquets
  ne peuvent pas être installés au même moment. Par exemple, fb-music-hi est
  en conflit avec fb-music-low car ils fournissent tous deux des jeux de
  musiques de remplacement pour le jeu Frozen Bubble.


Le travail du gestionnaire de paquets est de présenter une interface qui aide
l'utilisateur   gérer l'ensemble des paquets installés sur son système.
aptitude fournit une telle interface en tirant parti du système de gestion de
paquets apt.


Qu'est-ce que le système apt ?

Pouvoir capable d'installer et de supprimer des paquets, c'est formidable, mais
le programme basique chargé de faire cela (connu sous le nom de dpkg) ne fait
que cela et rien de plus. C'est très bien si vous téléchargez un ou deux
paquets «   la main », mais cela devient vite fatiguant quand vous essayez
de gérer un grand nombre de paquets. De plus, si un nouveau paquet intéressant
nécessite des programmes que vous n'avez pas encore installés, vous devez
télécharger vous-mêmes les nouveaux paquets requis. Enfin, si vous décidez
par la suite de supprimer ce paquet, les paquets additionnels vont rester sur
votre système et occuper de la place sur vos disques   moins que vous ne les
supprimiez vous-même.

Toutes ces opérations sont fastidieuses et la plupart des systèmes de gestion
de paquets sont accompagnés de programmes qui se chargent de tout cela   votre
place. apt est la base commune sur laquelle sont construits ces programmes : en
plus d'aptitude, des programmes comme synaptic et apt-watch utilisent apt.

apt fonctionne grâce   une liste des paquets qui peuvent être téléchargés
depuis Debian sur votre ordinateur. Cette liste est utilisée pour trouver les
paquets qui ont besoin d'être mis   jour et pour installer de nouveaux
paquets. apt peut aussi résoudre automatiquement de nombreux problèmes de
dépendances : par exemple, quand vous choisissez d'installer un paquet, il
recherche tous les paquets supplémentaires requis et les installe en même
temps.

Avec un gestionnaire de paquet basé sur apt, tel qu'aptitude, vous avez trois
opérations fondamentales : mettre   jour la liste des paquets disponibles en
téléchargeant de nouvelles listes depuis les serveurs Debian, sélectionner
quels paquets doivent être installés, mis   jour ou supprimés, et enfin
mettre   exécution votre sélection en procédant réellement aux
installations, suppressions, etc.

Les gestionnaires de paquets basés sur apt lisent la liste des « sources »
(dépôt de paquets Debian) dans le fichier /etc/apt/sources.list. La
présentation du format et du contenu de ce fichier n'entre pas dans le cadre de
ce document, mais ils sont décrits dans la page de manuel sources.list(5).


 Comment se procure-t-on aptitude ?

Si vous lisez ce document sans avoir installé aptitude sur votre système,
cette section explique comment vous sortir de cette mauvaise passe. Vous devriez
aller directement   la partie sur les paquets binaires.


Paquets précompilés d'aptitude, « ce que 99% des utilisateurs devraient
utiliser »

Un paquet précompilé, ou « binaire », est le moyen le plus courant et le
plus facile d'installer aptitude. Vous devriez uniquement tenter d'installer
depuis les sources si aucun paquet binaire n'est disponible pour une raison ou
une autre, ou si vous avez des besoins particuliers qui ne sont pas satisfaits
par les paquets binaires.

Si vous êtes en train d'utiliser un système Debian, exécutez la commande
suivante en tant que root : apt-get install aptitude. Sinon, le fournisseur de
votre système a dû créer un paquet pour aptitude. Dans le doute, vous pouvez
le contacter pour d'avantage de conseils.


Construire aptitude depuis les sources

Vous pouvez aussi construire aptitude depuis les sources. Néanmoins, il est
probable que ce ne soit pas utile si apt est déj  installé sur votre
système. Si ce n'est pas le cas vous pouvez installer aptitude depuis les
sources en suivant les étapes :


  1. Installer les programmes suivants :


     * Un compilateur C++, comme g++.

     * Les fichiers de développement d'apt, habituellement disponibles dans le
       paquet nommé libapt-pkg-dev.

     * The libsigc++-2.0 library, available in the package libsigc++-2.0-dev or
       from http://libsigc.sourceforge.net.

     * The cwidget library, available in the package libcwidget-dev or from
       http://cwidget.alioth.debian.org.

     * The gettext program, which should be included with your Linux
       distribution.

     * A make tool, such as GNU make.

     * Enfin, télécharger le code source le plus récent d'aptitude,
       disponible sur http://packages.debian.org/unstable/admin/aptitude (faites
       défiler l'écran jusqu'en bas et télécharger le fichier
       « .orig.tar.gz »).



Une fois tous ces composants réunis, ouvrez un terminal et exécutez la
commande : tar zxf aptitude-0.4.11.11.tar.gz pour désarchiver le code source.
Une fois les sources désarchivées, tapez cd aptitude-0.4.11.11 && ./configure
&& make pour compiler aptitude. Si cela réussit, assurez-vous que vous êtes
sous l'utilisateur root (en utilisant, par exemple, su), tapez alors make
install pour installer aptitude sur votre ordinateur. Une fois aptitude
correctement installé, taper aptitude   l'invite de la ligne de commande
devrait lancer le programme.


Assurer le suivi, et participer au developpement d'aptitude


Récupérer l'arborescence des sources d'aptitude

Si vous souhaitez tester le tout dernier code source en date d'aptitude, vous
pouvez télécharger le code source non encore publié d'aptitude en utilisant
Mercurial. Installez Mercurial (disponible   http://www.selenic.com/mercurial/
) et exécutez la commande hg clone http://hg.debian.org/hg/aptitude/head
aptitude afin de récupérer le code source le plus récent.


 [Avertissement]  Avertissement

                  The aptitude Mercurial repository is an active development
                  tree; it will change as bugs are fixed and features are added,
                  and there is absolutely no guarantee that it will even
                  compile, let alone run properly! Bug reports are welcome, but
                  be aware that you use development code entirely at your own
                  risk![1]



Liste de diffusion

<aptitude-devel@lists.alioth.debian.org> est la principale liste de diffusion
concernant le developpement d'aptitude. Les archives de cette liste sont
accessibles ici http://lists.alioth.debian.org/pipermail/aptitude-devel/. Pour
s'y abonner, consultez la page Web http://lists.alioth.debian.org/mailman/
listinfo/aptitude-devel.


Proposer des correctifs (patches).

Dans l'absolu, les correctifs devraient être soumis   la liste de diffusion
d'aptitude <aptitude-devel@lists.alioth.debian.org>. Mais si vous préférez les
envoyer en privé, vous pouvez utiliser l'adresse de courriel
<aptitude@packages.debian.org> ou <dburrows@debian.org>. Une rapide description
des raisons qui ont motivées ce correctif ainsi qu'une explication de son mode
de fonctionnement sont grandement appréciés.


Suivre les modifications dans l'arborescence de sources d'aptitude

L'arborescence des sources d'aptitude est régulièrement mis   jour avec de
nouvelles fonctionnalités, des corrections de bogues, et de nouveaux bogues.
Dès qu'un code source est disponible sur votre machine (voir la section
précédente), vous pouvez vous déplacer dans le répertoire (cd) et taper hg
pull && hg update afin de le mettre   jour avec les changements apparus sur le
dépot principal.

Pour être averti automatiquement lorsque des modifications ont été faites sur
le code de base d'aptitude inscrivez-vous au fil RSS disponible   http://
hg.debian.org/hg/aptitude/head?cl=tip;style=rss.


Construire aptitude   partir de l'arborescence de développement.

To build aptitude from the Mercurial repository, you must have the programs
autoconf and automake installed. Type sh ./autogen.sh && ./configure to generate
the files needed to compile aptitude, then execute make and make install.



--------------------------------------------------------------------------------
[1]Bien sûr, vous utilisez tous les logiciels libres   vos propres risques,
mais le risque induit par l'utilisation d'un arbre de développement actif est
encore plus grand.


Chapitre 1. Notions pour commencer

Table des matières



  Utiliser aptitude


        Les bases d'aptitude

        Naviguer dans la liste des paquets d'aptitude

        Rechercher des paquets par leur nom

        Gérer les paquets

        Mettre   jour la liste des paquets et installer des paquets


  Utiliser aptitude depuis la ligne de commande


  Un voyage de mille lieues commence toujours par un premier pas.  

                                                          -- Lao Tsu


aptitude est un programme assez gros avec de nombreuses fonctionnalités et il
peut être un peu lourd pour les nouveaux utilisateurs qui veulent l'aborder. Ce
chapitre ne décrit pas de façon exhaustive les fonctionnalités d'aptitude
(consultez Chapitre 2, Guide_de_référence_d'aptitude pour cela), mais il
fournit un aperçu des fonctionnalités de base les plus utilisées de ce
programme.


Utiliser aptitude

Cette section décrit comment utiliser l'interface graphique d'aptitude. Pour
des informations sur l'utilisation de l'interface d'aptitude en ligne de
commande, consultez la section intitulée « Utiliser aptitude depuis la ligne
de commande ».


Les bases d'aptitude

Pour lancer aptitude, ouvrez votre terminal préféré et tapez sur la ligne de
commande :

toto$ aptitude

Une fois que le cache est chargé (ce qui peut prendre un peu de temps sur les
machines les plus lentes), l'écran principal d'aptitude apparaît :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--- Installed Packages
--- Not Installed Packages
--- Obsolete and Locally Created Packages
--- Virtual Packages
--- Tasks






These packages are currently installed on your computer.








Comme vous pouvez le voir, l'écran principal d'aptitude est divisé en
plusieurs parties. La ligne bleue en haut du terminal est la barre de menu, et
les lignes bleues juste au dessous contient des informations sur quelques
commandes importantes. La zone noire qui les suit contient la liste de tous les
paquets disponibles, classés par groupes de paquets. Le groupe actuellement
sélectionné (« Paquets installés ») est mis en évidence et sa
description est indiquée dans l'espace noir du bas.

Comme le suggèrent les lignes en haut de l'écran, vous pouvez accéder au menu
d'aptitude avec le raccourci clavier Contrôle+t ; vous pouvez aussi cliquer
avec la souris sur un onglet du menu si votre système gère ce mécanisme.
Utilisez le raccourci Contrôle+t va ouvrir le menu Actions :

 Actions  Undo  Package  Search  Options  Views  Help
+-------------------------+  u: Update  g: Download/Install/Remove Pkgs
|Install/remove packages g|
|Update package list     u|
|Forget new packages     f|
|Clean package cache      |eated Packages
|Clean obsolete files     |
|Mark Upgradable         U|
|Play Minesweeper         |
|Become root              |
+-------------------------+
|Quit                    Q|
+-------------------------+
These packages are currently installed on your computer.









Perform all pending installs and removals

Utilisez les flèches et Entrée pour sélectionner un onglet du menu (ou, si
votre système le permet, cliquez sur celui-ci avec la souris) ; pour fermer le
menu sans rien sélectionner, utilisez   nouveau le raccourci clavier
Contrôle+t. Le menu actuellement surligné est expliqué en bas de l'écran. Si
une option du menu peut être utilisée via un raccourci clavier, celui-ci est
affiché dans le menu : par exemple, la commande « Mettre   jour les listes
de paquets » peut être lancée en appuyant sur u.

À tout moment, appuyer sur ? vous permet d'afficher une liste des principaux
raccourcis clavier disponibles.


Naviguer dans la liste des paquets d'aptitude

La liste des paquets est l'interface principale d'aptitude. Quand aptitude
démarre, la liste est organisée suivant un certain nombre de groupes comme on
peut le voir sur la capture suivante :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--- Installed Packages
--- Not Installed Packages
--- Obsolete and Locally Created Packages
--- Virtual Packages
--- Tasks






These packages are currently installed on your computer.









 [Note]  Note

         Les groupes de paquets vides sont automatiquement cachés par aptitude,
         donc vous pourriez voir plus ou moins de groupes que ceux présents sur
         cette capture.


Sur la capture précédente, le premier groupe (« Paquets installés ») est
surligné pour indiquer qu'il est actuellement sélectionné. Vous pouvez
modifier la sélection avec les flèches haut et bas. Notez que la description
affichée en bas change en conséquence. Pour « déployer » un groupe,
appuyez sur Entrée quand le groupe est sélectionné :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--\ Installed Packages
  --- admin - Administrative utilities (install software, manage users, etc)
  --- base - The Debian base system
  --- devel - Utilities and programs for software development
  --- doc - Documentation and specialized programs for viewing documentation
  --- editors - Text editors and word processors
  --- electronics - Programs for working with circuits and electronics
  --- games - Games, toys, and fun programs
  --- gnome - The GNOME Desktop System
  --- graphics - Utilities to create, view, and edit graphics files

These packages are currently installed on your computer.








Comme vous pouvez le voir, le groupe « Paquets installés » a été
déployé pour faire apparaître son contenu : il contient un certain nombre de
sous-groupes sommairement définis par le type de programmes qu'ils contiennent.
Déployer la section « admin » en la sélectionnant et en appuyant sur
Entrée affiche :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--\ Installed Packages
  --\ admin - Administrative utilities (install software, manage users, etc)
    --- main - The main Debian archive
  --- base - The Debian base system
  --- devel - Utilities and programs for software development
  --- doc - Documentation and specialized programs for viewing documentation
  --- editors - Text editors and word processors
  --- electronics - Programs for working with circuits and electronics
  --- games - Games, toys, and fun programs
  --- gnome - The GNOME Desktop System

Packages in the 'admin' section allow you to perform administrative tasks such
as installing software, managing users, configuring and monitoring your system,
examining network traffic, and so on.






Le groupe « admin » contient un unique sous-groupe, l'archive Debian
« main ». Déployer ce groupe révèle quelques paquets !


 [Astuce]  Astuce

           Pour aller plus vite, vous pouvez utiliser la touche [ pour déployer
           d'un seul coup tous les sous-groupes d'un groupe donné.
           Sélectionner « Paquets installés » et appuyer sur [ fait
           immédiatement apparaître les paquets sur la capture suivante.


 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--\ Installed Packages
  --\ admin - Administrative utilities (install software, manage users, etc)
    --\ main - The main Debian archive
i     acpid                                                1.0.3-19   1.0.3-19
i     alien                                                8.44       8.44
i     anacron                                              2.3-9      2.3-9
i     apt-show-versions                                    0.07       0.07
i A   apt-utils                                            0.5.25     0.5.25
i     apt-watch                                            0.3.2-2    0.3.2-2
i     aptitude                                             0.2.14.1-2 0.2.14.1-2

The Debian distribution consists of packages from the 'main' section. Every
package in 'main' is Free Software.

For more information about what Debian considers to be Free Software, see
http://www.debian.org/social_contract#guidelines




En plus des touches de flèches, vous pouvez naviguer   travers la liste de
paquets, page   page, en utilisant les touches Page précédente et Page
suivante.


 [Astuce]  Astuce

           Quand toutes les informations ne peuvent être affichées dans la
           moitié basse de l'écran, les touches a et z peuvent être
           utilisées pour faire défiler cette zone.



Rechercher des paquets par leur nom

Pour trouver rapidement un paquet dont vous connaissez le nom, appuyez sur /
pour ouvrir une boîte de recherche :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
i     frozen-bubble                                        1.0.0-5    1.0.0-5
i A   frozen-bubble-data                                   1.0.0-5    1.0.0-5
i     geekcode                                             1.7.3-1    1.7.3-1
i     gfpoken                                              0.25-3     0.25-3
i     ggz-gnome-client                                     0.0.7-2    0.0.7-2
i     ggz-gtk-client                                       0.0.7-1    0.0.7-1
i     ggz-gtk-game-data                                    0.0.7-2    0.0.7-2
i +--------------------------------------------------------------------------+
i |Search for:                                                               |
i |froz                                                                      |
Po|                             [ Ok ]                             [ Cancel ]|
Fr+--------------------------------------------------------------------------+
attempt to shoot bubbles into groups of the same color to cause them to pop. It
features 100 single-player levels, a two-player mode, music and striking
graphics.

This game is widely rumored to be responsible for delaying the Woody release.

URL: http://www.frozen-bubble.org/

Comme vous pouvez le voir sur la capture précédente, une recherche de froz
trouve le paquet frozen-bubble. Avec le langage de recherche évolué
d'aptitude, décrit dans la section intitulée « Motifs de recherche », il
est possible de trouver des paquets en utilisant des critères plus ou moins
complexes.


 [Astuce]  Astuce

           Vous pouvez rechercher en arrière dans la liste des paquets en
           appuyant sur \ et vous pouvez répéter la dernière recherche en
           appuyant sur n après avoir fermé la boîte de recherche.


Parfois il est plus pratique de cacher tous les paquets   l'exception de ceux
qui correspondent   quelques critères particuliers. Pour ce faire, appuyez sur
l :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--- Installed Packages
--- Not Installed Packages
--- Obsolete and Locally Created Packages
--- Virtual Packages
--- Tasks


  +--------------------------------------------------------------------------+
  |Enter the new package tree limit:                                         |
  |apti                                                                      |
  |                             [ Ok ]                             [ Cancel ]|
Th+--------------------------------------------------------------------------+ a








Cette boîte de dialogue fonctionne exactement comme la boîte de recherche,
sauf qu'au lieu de mettre en évidence le paquet suivant qui correspond   ce
que vous tapez dans la boîte de dialogue, il cache tous les paquets qui ne
correspondent pas. Par exemple, taper apti dans cette boîte de dialogue et
appuyer sur Entrée va cacher tous les paquets sauf ceux dont le nom contient
« apti » :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--\ Installed Packages
  --\ admin - Administrative utilities (install software, manage users, etc)
    --\ main - The main Debian archive
i     aptitude                                             0.2.14.1-2 0.2.14.1-2
i A   synaptic                                             0.51-1     0.51-1
  --\ x11 - The X window system and related software
    --\ main - The main Debian archive
i     xfree86-driver-synaptics                             0.13.3-1   0.13.3-1
--- Not Installed Packages
--- Virtual Packages

These packages are currently installed on your computer.









Gérer les paquets

Maintenant que vous savez vous déplacer dans la liste des paquets, il est temps
de commencer   utiliser aptitude pour installer ou supprimer des paquets. Dans
cette section, vous allez apprendre   sélectionner les paquets   installer,
  supprimer ou   mettre   jour.


 [Astuce]  Astuce

           Vous ne pouvez changer la configuration globale de votre système que
           sous l'utilisateur root. Si vous voulez vous familiariser avec
           aptitude, vous pouvez, sans danger, le lancer en tant qu'utilisateur
           normal avec l'assurance de ne pas pouvoir endommager votre système.
           aptitude vous informera quand vous essaierez de faire quelque chose
           que seul l'utilisateur root peut faire ; si vous souhaitez continuer,
           il vous faudra donner le mot de passe de root.


All changes to a package are performed by first highlighting it in the package
list, then pressing a key corresponding to the action which should be performed.
The basic action keys [2] are + to install or upgrade a package, - to remove a
package, and = to prevent a package from being automatically upgraded (this is
known as holding the package). These actions are not performed immediately;
aptitude will simply update the package list to show the change that has been
requested.

Par exemple, dans la capture ci-dessous, le paquet kaffeine a été
sélectionné et on a pressé +. Le paquet est maintenant mis en surbrillance en
vert et la lettre « i » est apparue   gauche de son nom pour indiquer qu'il
sera installé. De plus, une estimation de l'espace qu'il va utiliser est
affichée.

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1                  Will use 2925kB of disk space  DL Size:
1375kB
  --\ kde - The KDE Desktop System
    --\ main - The main Debian archive
p     bibletime-i18n                                        <none>     1.4.1-1
p     education-desktop-kde                                 <none>     0.771
p     junior-kde                                            <none>     1.4
piA   kaffeine                                      +2843kB <none>     0.4.3-1
pi    kaffeine-mozilla                              +81.9kB <none>     0.4.3-1
p     karamba                                               <none>     0.17-5
p     kde-devel                                             <none>     4:3.1.2

p     kde-devel-extras                                      <none>     4:3.1.2
The K Desktop Environment (development files)
A metapackage containing dependencies for the core development suite of KDE
including kdesdk, qt3-designer, and all core KDE -dev packages.








 [Astuce]  Astuce

           À tout moment vous pouvez utiliser Annuler ->; Annuler
           (Contrôle+u) pour « annuler » les changements faits sur un ou
           plusieurs paquets. C'est très utile si une action a des
           conséquences imprévues, et que vous souhaitez « revenir en
           arrière ».


En plus des actions qui affectent des paquets individuels, une autre action
importante est disponible : taper U va tenter de mettre   jour tous les
paquets qui peuvent l'être. Vous devriez utiliser cette commande
régulièrement pour maintenir votre système   jour.


Gérer les paquets cassés

Parfois, changer l'état d'un paquet fait apparaître ses relations de
dépendances comme non satisfaites. Des paquets avec des dépendances non
satisfaites sont dits cassés. aptitude vous avertira quand cela arrive en
expliquant pourquoi cela est arrivé. Par exemple voici ce qui arrive si vous
tentez de supprimer sound-juicer :

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.3.3       #Broken: 1   Will free 48.6MB of disk space
i A   nautilus                                             2.10.1-4   2.10.1-4
i     nautilus-cd-burner                                   2.10.2-1.1 2.10.2-1.1
i A   nautilus-data                                        2.10.1-4   2.10.1-4
i     netspeed                                             0.12.1-1   0.12.1-1
i A   oaf                                                  0.6.10-3   0.6.10-3
i     pybliographer                                        1.2.6.2-1  1.2.6.2-1
i     rhythmbox                                            0.8.8-13   0.8.8-13
i     shermans-aquarium                                    3.0.1-1    3.0.1-1
idA   sound-juicer                                 -1733kB 2.10.1-3   2.10.1-3
GNOME 2 CD Ripper
sound-juicer will be removed.


The following packages depend on sound-juicer and will be broken by its
removal:


  * gnome-desktop-environment depends on sound-juicer

[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

As you can see, aptitude displays three indicators that something has gone
wrong: first, the number of broken packages is displayed in the upper blue area;
second, the lower half of the display changes to describe broken packages that
are related to the currently highlighted package; third, a bar appears at the
bottom of the screen with a suggestion on how to solve the problem. To quickly
find broken packages in the package list, you can press b or search for ?broken.


 [Note]  Note

         Le texte [1(1)/...] indique l'avancement du solveur de dépendance
         d'aptitude. Le premier nombre est la solution que vous avez
         actuellement sélectionnée, et le second est le nombre de solutions
         qu'aptitude a déj  trouvées. La présence du texte « ... »
         indique qu'il pourrait y avoir d'autres solutions que celles déj 
         trouvées. Si aptitude a l'assurance qu'il a trouvé toutes les
         solutions possibles, le texte affiché est alors [1/1].


Pour voir les autres solutions qui, selon aptitude, peuvent résoudre ce
problème, appuyez sur e. Un écran similaire au suivant apparaîtra :

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    gstreamer0.8-cdparanoia                           [0.8.10-1 (unstable, now)]
    sound-juicer                                                [2.10.1-2 (now)]
















[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Ici, vous pouvez voir une autre solution en appuyant sur . ou retourner voir les
solutions que vous examiniez précédemment en appuyant sur ,. Pour appliquer la
solution courante et retourner   la liste des paquets, appuyez sur !. Par
exemple, appuyer sur . pendant l'écran précédent passe   la solution
suivante :

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    sound-juicer                                      [2.10.1-3 (unstable, now)]
  --\ Downgrade the following packages:
    gstreamer0.8-cdparanoia          [0.8.11-1 unstable, now -> 0.8.8-3 testing]















[2(2)/...] Suggest 1 keep,1 downgrade
e: Examine  !: Apply  .: Next  ,: Previous

En plus des commandes de navigation, vous pouvez « rejeter » une solution en
appuyant sur r. Par exemple, la première solution annule la suppression de
sound-juicer qui est justement l'action que nous tentions de faire ! En
appuyant sur r pendant la sélection de l'item correspondant   cette action, on
peut alors faire en sorte qu'aptitude ne tente plus d'annuler la suppression de
sound-juicer.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
R   sound-juicer                                      [2.10.1-3 (unstable, now)]






GNOME 2 CD Ripper
gnome-desktop-environment depends upon sound-juicer
--\ The following actions will resolve this dependency:
  -> Remove gnome-desktop-environment [1:2.10.2.3 (unstable, testing, now)]
R -> Cancel the removal of sound-juicer
  -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]




[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Comme vous pouvez le voir, le choix correspondant   conserver sound-juicer  
sa version actuelle est devenu rouge et a été marqué avec « R » ce qui
indique qu'il a été rejeté. Les solutions qui seront générées après cela
(c.- -d., toutes les solutions que vous n'avez pas encore vues) excluront cette
action. Cependant les solutions qui incluent cette action et qui ont déj 
été vues resteront disponibles.


 [Note]  Note

         Dans la capture d'écran ci-dessus, la description de sound-juicer est
         affichée au milieu de l'écran ; En dessous, les dépendances, qui
         ont imposé de garder sound-juicer dans sa version actuelle, sont
         affichées, suivies de toutes les solutions connues par aptitude pour
         résoudre cette dépendance.


Par exemple, si ce rejet est mis en &#339;uvre immédiatement après la
suppression de sound-juicer, appuyer sur . affichera la solution suivante, en
passant la solution qui annulait l'installation de sound-juicer et
l'installation de gstreamer0.8-cdparanoia dans une version antérieure.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Remove the following packages:
    gnome-desktop-environment              [1:2.10.2.3 (unstable, testing, now)]

















[2(2)/...] Suggest 1 removal
e: Examine  !: Apply  .: Next  ,: Previous

Les rejets sont appliqués uniquement aux nouvelles solutions, c'est- -dire  
celles qui sont générées quand vous appuyez sur . lorsque la dernière
solution générée est affichée. Les solutions déj  générées contiendront
toujours ces rejets. Vous pouvez annuler un rejet   tout moment en
sélectionnant l'action rejetée, puis en appuyant sur r ; des solutions
contenant cette action pourront être   nouveau générées, ainsi que celles
qui avaient été précédemment « oubliées ».

The opposite of rejecting an action is approving it. To approve an action, just
select it and press a; this forces the problem resolver to choose the action
whenever possible[3]. Approved actions will turn green and will be marked with
« A », as in the following screenshot:

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Remove the following packages:
A   gnome-desktop-environment              [1:2.10.2.3 (unstable, testing, now)]

















[2(2)/...] Suggest 1 removal
e: Examine  !: Apply  .: Next  ,: Previous


 [Important]  Important

              Si vous ne résolvez pas toutes les dépendances, aptitude
              utilisera automatiquement sa suggestion courante, lorsque vous
              validerez votre sélection avec g. Néanmoins, il est difficile de
              résoudre automatiquement des problèmes de dépendances, et vous
              pourriez ne pas être satisfait du résultat, si bien qu'il est
              généralement préférable de vérifier les suggestions
              d'aptitude avant de mettre   exécution votre sélection.



Mettre   jour la liste des paquets et installer des paquets

Arrivé ici, vous connaissez assez aptitude pour réellement faire des
modifications sur votre système.

Vous devriez périodiquement mettre   jour la liste des paquets disponibles
depuis les serveurs Debian, afin d'avoir connaissance des nouveaux paquets et
des nouvelles versions des paquets. Pour ce faire, appuyez sur u. À tout moment
pendant le téléchargement, presser q vous permettra de l'abandonner.

Une fois que vous avez une liste de paquets récente, vous pouvez choisir les
paquets   mettre   jour,   installer ou   supprimer comme cela est décrit
dans la section précédente. Pour passer en revue les actions que vous avez
demandées, appuyez sur g une seule fois. Si vous installez le paquet kaffeine-
mozilla (comme dans l'exemple précédent), l'écran suivant apparaît :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1                  Will use 2925kB of disk space  DL Size:
1375kB
--\ Packages being automatically installed to satisfy dependencies

piA kaffeine                                        +2843kB <none>     0.4.3-1
--\ Packages to be installed
pi  kaffeine-mozilla                                +81.9kB <none>     0.4.3-1







These packages are being installed because they are required by another package
you have chosen for installation.

If you select a package, an explanation of its current state will appear in this
space.




Comme vous pouvez le voir, aptitude a décidé d'installer automatiquement
kaffeine car kaffeine-mozilla le requiert. À ce moment, vous avez le choix
entre continuer l'installation en appuyant sur g ou l'abandonner en appuyant sur
q.


Utiliser aptitude depuis la ligne de commande

En plus de son interface « visuelle » décrite dans la section précédente,
aptitude peut être utilisé pour gérer les paquets directement depuis la ligne
de commande de la même manière que vous utiliseriez apt-get. Cette section
couvre les actions en ligne de commande les plus courantes d'aptitude. Pour plus
d'informations, consultez la référence pour la ligne de commande d'aptitude.

En général, une invocation d'aptitude sur la ligne de commande ressemble  
ceci :

aptitude action [arguments...]

action tells aptitude what action it is to take; the remaining arguments are
used in an option-specific fashion. Typically they will consist of package names
and command-line switches[4].

Les actions les plus importantes sont :



  aptitude update

      Cette commande met   jour la liste des paquets comme si vous étiez
      entré dans l'interface graphique et aviez appuyé sur u.


  aptitude safe-upgrade

      This command will upgrade as many packages as it can upgrade without
      removing existing packages.

      It is sometimes necessary to remove one package in order to upgrade
      another; this command is not able to upgrade packages in such situations.
      Use the full-upgrade command to upgrade those packages as well.


  aptitude full-upgrade

      Like safe-upgrade, this command will attempt to upgrade packages, but it
      is more aggressive about solving dependency problems: it will install and
      remove packages until all dependencies are satisfied. Because of the
      nature of this command, it is possible that it will do undesirable things,
      and so you should be careful when using it.


       [Note]  Note

               Pour des raisons historique, cette commande s'appelait  
               l'originedist-upgrade, et ce nom est toujours reconnu par
               aptitude.



  aptitude [ install | remove | purge ] pkg1 [pkg2...]

      These commands install, remove, or purge[5] the specified packages.
      « Installing » a package which is already installed but can be
      upgraded will cause it to be upgraded.


  aptitude search pattern1 [pattern2...]

      This command searches for packages whose name contains any of the given
      patterns, printing the result to the terminal. In addition to just being a
      string of text, each pattern can be a search pattern as described in la
      section intitulée « Motifs de recherche ». [6] For instance,
      « aptitude search gnome kde » will list all packages whose name
      contains either « gnome » or « kde ».


  aptitude show pkg1 [pkg2...]

      Afficher les informations sur chaque pqt sur le terminal.


Les commandes qui installent, mettent   jour ou suppriment des paquets
acceptent toutes le paramètre « -s », qui signifie « simuler ». Quand
« -s » est passé sur la ligne de commande, le programme exécute les
actions qu'il devrait normalement effectuer sans réellement télécharger ou
installer/supprimer aucun fichier.

aptitude présentera parfois une invite comme celle-ci :

Les NOUVEAUX paquets suivants vont être automatiquement installés :
  space-orbit-common
Les NOUVEAUX paquets suivants vont être installés :
  space-orbit space-orbit-common
0 paquets mis   jour, 2 nouvellement installés, 0   enlever et 0 non mis  
jour.
Il est nécessaire de télécharger 3200ko d'archives. Après dépaquetage,
8413ko
seront utilisés.
Voulez-vous continuer ? [O/n/?]

En plus des options « Oui » et « Non » qui sont évidentes, un certain
nombre de commandes sont disponibles et peuvent être utilisées pour modifier
les informations affichées   l'invite ou pour spécifier des options
supplémentaires. Par exemple, taper s affichera ou cachera l'information sur
l'espace disque que chaque paquet va utiliser :

Voulez-vous continuer ? [O/n/?] s

Les changements de taille seront affichés.

Les NOUVEAUX paquets suivants vont être automatiquement installés :
  space-orbit-common <+8020kB>
Les NOUVEAUX paquets suivants vont être installés :
  space-orbit <+393kB> space-orbit-common <+8020kB>
0 paquets mis   jour, 2 nouvellement installés, 0   enlever et 0 non mis  
jour.
Il est nécessaire de télécharger 3200ko d'archives. Après dépaquetage,
8413ko
seront utilisés.
Voulez-vous continuer ? [O/n/?]

De manière analogue, taper d affichera des informations sur les paquets
automatiquement installés ou supprimés :

Les NOUVEAUX paquets suivants vont être automatiquement installés :
  space-orbit-common (D: space-orbit)
Les NOUVEAUX paquets suivants vont être installés :
  space-orbit space-orbit-common
0 paquets mis   jour, 2 nouvellement installés, 0   enlever et 0 non mis  
jour.
Il est nécessaire de télécharger 3200ko d'archives. Après dépaquetage,
8413ko
seront utilisés.

Cela indique que space-orbit-common est sur le point d'être installé parce que
space-orbit en dépend. Vous pouvez voir la liste complète des options
possibles en entrant ?   l'invite.

Si votre demande casse une dépendance d'une manière qui ne peut pas être
résolue simplement, aptitude vous demandera quoi faire :

The following packages are BROKEN:
  libsdl1.2debian
The following packages will be REMOVED:
  libsdl1.2debian-alsa
.
.
.
The following actions will resolve these dependencies:

Install the following packages:
libsdl1.2debian-all [1.2.12-1 (unstable)]

Score is 41

Accept this solution? [Y/n/q/?]

Taper y (ou simplement sur entrée) validera la solution proposée. Taper n
affichera la « meilleure » solution suivante :

Accept this solution? [Y/n/q/?] n
The following actions will resolve these dependencies:

Install the following packages:
libsdl1.2debian-esd [1.2.12-1 (unstable)]

Score is 19

Accept this solution? [Y/n/q/?]

Comme dans l'invite principale de la ligne de commande, vous pouvez effectuer
des actions supplémentaires, comme par exemple la modification de l'état d'un
paquet depuis l'invite de résolution des dépendances. Tapez ? pour afficher la
liste complète.

Typing q will abort the automatic resolver and allow you to resolve the
dependencies manually:

Accept this solution? [Y/n/q/?] q
aptitude failed to find a solution to these dependencies.  You can solve them
yourself by hand or type 'n' to quit.
The following packages have unmet dependencies:
  libsdl1.2debian: Depends: libsdl1.2debian-alsa (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-all (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-esd (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-arts (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-oss (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-nas (= 1.2.12-1) but it is not
installable or
                            libsdl1.2debian-pulseaudio (= 1.2.12-1) but it is
not installable
Resolve these dependencies by hand? [N/+/-/_/:/?]

You can use any of the package manipulation commands to resolve the broken
dependencies (type ? for a full list of the available commands). Type n or press
enter to quit aptitude:

Resolve these dependencies by hand? [N/+/-/_/:/?] n
Abort.

Pour une documentation complète des caractéristiques de la ligne de commande
d'aptitude, consultez la Référence de la ligne de commande.



--------------------------------------------------------------------------------
[2] Vous pouvez aussi utiliser le menu Paquet pour modifier l'état d'un paquet.
Consultez la section intitulée « Le menu Paquet » pour plus de détails.

[3] Approuver une action est un peu différent de simplement imposer que toute
solution contienne l'action ; cela signifie qu'  choisir entre une action
approuvée et une qui ne l'est pas, il prendra la première. S'il y a plusieurs
actions approuvées, elles seront toutes susceptibles d'être proposées dans la
solution.

[4]Une « option courte » est une lettre précédée d'un tiret, par exemple,
« -a », « -v », etc.

[5]Purger un paquet supprime le paquet ainsi que tous ses fichiers de
configuration.

[6] En fait, c'est aussi vrai pour les commandes qui prennent des paquets en
argument, comme install ou show.


Chapitre 2. Guide de référence d'aptitude

Table des matières



  L'interface utilisateur d'aptitude


        Utiliser les menus

        Commandes du menu

        Travailler avec plusieurs vues

        Devenir administrateur (« root »)


  Gérer les paquets


        Gérer la liste des paquets

        Accéder aux informations des paquets

        Modifier l'état d'un paquet

        Résoudre les problèmes de dépendance

        Télécharger, installer et supprimer des paquets

        Qu'est-ce que la confiance en matière de gestion des paquets ?

        Gérer les paquets automatiquement installés


  Motifs de recherche


        Searching for strings

        Shorthand for search terms

        Searches and Versions

        Explicit search targets

        Search Term Reference


  Personnalisation d'aptitude


        Personnaliser la liste des paquets

        Personnaliser les raccourcis clavier

        Personnaliser la couleur du texte et les styles

        Personnaliser la disposition de l'affichage

        Référence du fichier de configuration

        Thèmes


  Jouer au démineur


  Le Lapin Blanc mit ses lunettes. « Où dois-je commencer votre       
   Majesté ? » demanda-t-il.

   « Commence au commencement », répondit gravement le Roi, « et
   continue jusqu'  ce que tu arrives   la fin, alors arrête-toi. »

                             -- Lewis Carrol, Alice au pays des merveilles


aptitude is a large program with many features, and it is sometimes difficult to
remember how to do something, or even to remember whether that something is even
possible. Indeed, many feature requests received by the author describe features
which are already present but are difficult to find.[7]

Dans une tentative pour combattre cette opacité, ce guide de référence
décrit toutes les fonctionnalités et les paramètres de configuration
d'aptitude. Pour un guide plus abordable sur les fonctionnalités les plus
importantes d'aptitude, consultez Chapitre 1, Notions_pour_commencer.


 [Note]  Note

         Le comportement et l'apparence d'aptitude peuvent être configurés de
         nombreuses façons. Ce manuel décrit comment le programme fonctionne
         avec la configuration par défaut. La description de la manière dont
         différentes configurations affectent son comportement est donnée dans
         la section intitulée « Personnalisation d'aptitude ».



L'interface utilisateur d'aptitude

Cette section décrit la partie de l'interface utilisateur d'aptitude qui ne
s'occupe pas de la gestion des paquets.


Utiliser les menus

La barre de menu en haut de l'écran liste les commandes les plus importantes
d'aptitude. Pour activer la barre de menu, utilisez le raccourci clavier
Control+t, vous pouvez alors vous y déplacer avec les touches de flèches et
sélectionner une entrée du menu avec Entrée.

Certaines entrées du menu ont aussi des « clés d'accès rapide » :
lettres ou chiffres qui peuvent être utilisés pour sélectionner une entrée
alors que le menu est actif. Ces clés d'accès rapide sont affichées avec une
nuance de blanc plus clair que le reste du menu.

En plus, certaines entrées du menu ont des « raccourcis clavier » qui
effectuent la même action que l'entrée du menu même lorsque le menu n'est pas
actif. Ces raccourcis sont indiqués   droite des entrées du menu.

In the remainder of the manual, menu commands will be written like this: Menu
->; Item (key). This indicates that you should choose Item from the Menu
menu, and that key is the shortcut for this command.


Commandes du menu


Le menu Actions

Figure 2.1. Commandes disponibles dans le menu Actions

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|                                      |Si un aperçu d'installation n'est pas |
|                                      |visible, en affiche un. Sinon lance un |
|Actions ->; Installer/enlever des |processus d'installation comme décrit |
|paquets (g)                           |dans la section intitulée             |
|                                      |« Télécharger, installer et        |
|                                      |supprimer des paquets ».             |
|______________________________________|_______________________________________|
|Actions ->; Mettre   jour les    |Met   jour la liste des paquets.      |
|listes de paquets (u)                 |                                       |
|______________________________________|_______________________________________|
|                                      |Marque tous les paquets susceptibles de|
|Actions ->; Marquer comme étant  |l'être,   l'exception de ceux qui    |
|susceptible de mise   jour (U)       |sont gelés ou interdits de mise      |
|                                      |jour, comme devant être mis   jour.  |
|______________________________________|_______________________________________|
|                                      |Oublie quels paquets sont              |
|Actions ->; Oublier quels paquets |« nouveaux » (c'est- -dire vide   |
|sont nouveaux (f)                     |l'arborescence « Nouveaux            |
|                                      |paquets »).                          |
|______________________________________|_______________________________________|
|                                      |Annule toutes les installations, les   |
|Actions ->; Annuler les actions en|suppressions et les gels de paquets en |
|attente                               |attente. Cela revient   exécuter sur |
|                                      |l'ensemble des paquets la commande pour|
|                                      |les garder dans leur état actuel.     |
|______________________________________|_______________________________________|
|Actions ->; Nettoyer le cache des |Delete all the compressed packages that|
|paquets                               |were downloaded by aptitude [a].       |
|______________________________________|_______________________________________|
|                                      |Supprime toutes les archives de paquets|
|                                      |qui ont été téléchargées par      |
|                                      |aptitude[a] et qui ne sont plus        |
|                                      |disponibles dans les archives Debian.  |
|Actions ->; Enlever les fichiers  |On peut supposer que ce sont des       |
|périmés                             |paquets obsolètes et qui peuvent être|
|                                      |supprimés pour libérer de l'espace   |
|                                      |disque sans que cela ne nécessite de  |
|                                      |téléchargements inutiles par         |
|                                      |ailleurs.                              |
|______________________________________|_______________________________________|
|                                      |Lance le démineur, comme cela est     |
|Actions ->; Jouer au démineur    |décrit dans la section intitulée     |
|                                      |« Jouer au démineur ».            |
|______________________________________|_______________________________________|
|                                      |Continue   travailler en tant         |
|Actions ->; Devenir administrateur|qu'utilisateur root. Voir la section   |
|                                      |intitulée « Devenir administrateur  |
|                                      |(« root ») ».                    |
|______________________________________|_______________________________________|
|Actions ->; Quitter (Q)           |Quit aptitude, saving any changes to   |
|                                      |package states.                        |
|______________________________________|_______________________________________|
|[a] ou tout autre utilitaire apt.                                             |
|______________________________________________________________________________|




Le menu Annuler

Figure 2.2. Commandes disponibles dans le menu Annuler

 _____________________________________________________________________________
|Commande                             |Description                            |
|_____________________________________|_______________________________________|
|                                     |Cancel the effect of the last change to|
|                                     |a package's state, up to the last time |
|Annuler ->; Annuler (Contrôle+u)|aptitude was started, the package list |
|                                     |was updated, or an install run was     |
|                                     |performed.                             |
|_____________________________________|_______________________________________|




Le menu Paquet

Figure 2.3. Commandes disponibles dans le menu Paquet

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|Paquet ->; Installer (+)          |Marque le paquet actuellement          |
|                                      |sélectionné pour installation.       |
|______________________________________|_______________________________________|
|Paquet ->; Supprimer (-)          |Marque le paquet actuellement          |
|                                      |sélectionné pour suppression.        |
|______________________________________|_______________________________________|
|Paquet ->; Purger (_)             |Marque le paquet actuellement          |
|                                      |sélectionné pour purge.              |
|______________________________________|_______________________________________|
|                                      |Annule toute installation, mise   jour|
|                                      |ou suppression prévue pour le paquet  |
|Paquet ->; Garder (:)             |actuellement sélectionné et retire   |
|                                      |tout gel qui aurait été mis sur le   |
|                                      |paquet.                                |
|______________________________________|_______________________________________|
|Paquet ->; Geler (=)              |Gèle le paquet actuellement           |
|                                      |sélectionné.                         |
|______________________________________|_______________________________________|
|                                      |Marque le paquet actuellement          |
|                                      |sélectionné comme étant un paquet   |
|                                      |« installé automatiquement ». Pour|
|Paquet ->; Marquer automatiquement|plus d'informations sur les paquets    |
|(M)                                   |installés manuellement et             |
|                                      |automatiquement, consultez la section  |
|                                      |intitulée « Gérer les paquets      |
|                                      |automatiquement installés ».        |
|______________________________________|_______________________________________|
|                                      |Marque le paquet actuellement          |
|                                      |sélectionné comme étant un paquet   |
|                                      |« installé manuellement ». Pour   |
|Paquet ->; Marquer manuellement   |plus d'informations sur les paquets    |
|(m)                                   |installés manuellement et             |
|                                      |automatiquement, consultez la section  |
|                                      |intitulée « Gérer les paquets      |
|                                      |automatiquement installés ».        |
|______________________________________|_______________________________________|
|                                      |Si un paquet qui peut être mis   jour|
|                                      |est sélectionné, cela interdit sa    |
|Paquet ->; Interdire la version   |mise   jour vers la version           |
|(F)                                   |actuellement disponible uniquement. Si |
|                                      |une version du paquet est              |
|                                      |sélectionnée, cela interdit au paquet|
|                                      |d'être mis   jour vers cette version.|
|______________________________________|_______________________________________|
|                                      |Affiche un écran contenant des        |
|                                      |informations sur le paquet actuellement|
|Paquet ->; Informations (entrée) |sélectionné, comme les paquets dont  |
|                                      |il dépend, les paquets qui en         |
|                                      |dépendent, et ses versions            |
|                                      |disponibles.                           |
|______________________________________|_______________________________________|
|                                      |When browsing the package list, cycles |
|                                      |through the information that can be    |
|                                      |displayed in the information area (the |
|                                      |lower half of the display). The        |
|                                      |information area can display the long  |
|Package ->; Cycle Information (i) |description of the selected package    |
|                                      |(its default behavior), a summary of   |
|                                      |the dependencies related to the        |
|                                      |package, or an analysis of which other |
|                                      |packages require or suggest the        |
|                                      |selected package.                      |
|______________________________________|_______________________________________|
|                                      |Affiche la liste des modifications du  |
|                                      |paquet Debian actuellement             |
|Paquet ->; Liste des modifications|sélectionné. Pour voir les           |
|(C)                                   |modifications d'une version            |
|                                      |particulière, sélectionnez cette     |
|                                      |version avant d'exécuter cette        |
|                                      |commande.                              |
|______________________________________|_______________________________________|




Le menu Solveur

Figure 2.4. Commandes disponibles dans le menu Solveur

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|Solutions ->; Examiner la solution|Affiche une description détaillée de |
|(e)                                   |la suggestion actuelle.                |
|______________________________________|_______________________________________|
|Solutions ->; Appliquer la        |Exécute les actions actuellement      |
|solution (!)                          |suggérées.                           |
|______________________________________|_______________________________________|
|Solutions ->; Solution suivante   |Sélectionne la suggestion suivante.   |
|(.)                                   |                                       |
|______________________________________|_______________________________________|
|Solutions ->; Solution            |Sélectionne la suggestion             |
|précédente (,)                      |précédente.                          |
|______________________________________|_______________________________________|
|Solutions ->; Première solution  |Sélectionne la première suggestion.  |
|(<)                                   |                                       |
|______________________________________|_______________________________________|
|                                      |Sélectionne la suggestion la plus     |
|Solutions ->; Dernière solution  |récente (voir la section intitulée   |
|(>)                                   |« Résoudre les problèmes de        |
|                                      |dépendance »).                      |
|______________________________________|_______________________________________|
|                                      |Lors de l'examen d'une solution,       |
|                                      |rejette l'action actuellement          |
|                                      |sélectionnée et passe   l'action    |
|Solutions ->; Marquer comme       |suivante (voir la section intitulée   |
|rejeté (r)                           |« Résoudre les problèmes de        |
|                                      |dépendance »). Si l'action était   |
|                                      |dans l'état approuvé, son approbation|
|                                      |est annulée.                          |
|______________________________________|_______________________________________|
|                                      |Lors de l'examen d'une solution,       |
|                                      |approuve l'action actuellement         |
|                                      |sélectionnée et passe   l'action    |
|Solutions ->; Marquer comme retenu|suivante (voir la section intitulée   |
|(a)                                   |« Résoudre les problèmes de        |
|                                      |dépendance »). Si l'action était   |
|                                      |dans l'état rejeté, son rejet est    |
|                                      |annulé.                               |
|______________________________________|_______________________________________|
|                                      |Lors de l'examen d'une solution,       |
|                                      |affiche des informations détaillées  |
|Solveur ->; Afficher la cible     |sur le paquet touché par l'action     |
|(entrée)                             |actuellement sélectionnée (voir la   |
|                                      |section intitulée « Résoudre les   |
|                                      |problèmes de dépendance »).        |
|______________________________________|_______________________________________|
|                                      |Reject (as if with Solutions ->;   |
|                                      |Marquer comme rejeté (r)) all actions |
|                                      |that would break a hold on a package or|
|                                      |install a forbidden version. These     |
|Resolver ->; Reject Breaking Holds|actions are rejected by default unless |
|                                      |Aptitude::ProblemResolver::Allow-Break-|
|                                      |Holds is set to true, but this menu    |
|                                      |item allows you to reject them manually|
|                                      |at any time.                           |
|______________________________________|_______________________________________|




Le menu Rechercher

Figure 2.5. Commandes disponibles dans le menu Rechercher

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|                                      |Recherche le paquet suivant dans la    |
|                                      |liste des paquets qui correspond au    |
|Rechercher ->; Rechercher (/)     |motif de recherche (voir la section    |
|                                      |intitulée « Motifs de               |
|                                      |recherche »).                        |
|______________________________________|_______________________________________|
|                                      |Recherche le paquet précédent dans la|
|Search ->; Rechercher en arrière |liste des paquets qui correspond au    |
|(\)                                   |motif de recherche (voir la section    |
|                                      |intitulée « Motifs de               |
|                                      |recherche »).                        |
|______________________________________|_______________________________________|
|Rechercher ->; Rechercher        |Répète la dernière recherche.       |
|nouveau (n)                           |                                       |
|______________________________________|_______________________________________|
|                                      |Répeter la dernière commande, mais   |
|Rechercher ->; Rechercher en      |dans le sens inverse. Si la dernière  |
|arrière (N)                          |commande Rechercher était Rechercher  |
|                                      |vers le haut, alors cela exécutera un |
|                                      |Rechercher vers le bas, et vice versa. |
|______________________________________|_______________________________________|
|                                      |Filtre la liste de paquets en omettant |
|Rechercher ->; Affichage restreint|tous les paquets qui ne correspondent  |
|(l)                                   |pas au motif de recherche (voir la     |
|                                      |section intitulée « Motifs de       |
|                                      |recherche »).                        |
|______________________________________|_______________________________________|
|                                      |Retire le filtrage de la liste de      |
|Rechercher ->; Affichage complet  |paquets (tous les paquets sont         |
|                                      |affichés).                            |
|______________________________________|_______________________________________|
|Rechercher ->; Rechercher les     |Find the next broken package. This is  |
|cassés (b)                           |equivalent to searching for ?broken.   |
|______________________________________|_______________________________________|




Le menu Options

Figure 2.6. Commandes disponibles dans le menu Options

 ___________________________________________________________________________
|Commande                           |Description                            |
|___________________________________|_______________________________________|
|                                   |Open a new top-level view in which you |
|                                   |can modify aptitude's settings.        |
|                                   |Configuration options are displayed in |
|                                   |a tree similar to the tree of packages;|
|Options ->; Preferences        |to enable or disable an option, select |
|                                   |it and press Space or Enter.           |
|                                   |Configuration options are saved to     |
|                                   |~/.aptitude/config immediately upon    |
|                                   |being selected.                        |
|___________________________________|_______________________________________|
|Options ->; Revenir aux options|Revient aux options de configuration   |
|par défaut                        |par défaut.                           |
|___________________________________|_______________________________________|




Le menu Vues


 [Note]  Note

         Pour un aperçu du fonctionnement des vues, voir la section intitulée
         « Travailler avec plusieurs vues ».


Figure 2.7. Commandes disponibles dans le menu Vues

 _____________________________________________________________________________
|Commande                             |Description                            |
|_____________________________________|_______________________________________|
|Vues ->; Suivant (F6)            |Va   la vue active suivante.          |
|_____________________________________|_______________________________________|
|Vues ->; Précédent (F7)        |Va   la précédente vue active.      |
|_____________________________________|_______________________________________|
|Vues ->; Fermer (q)              |Ferme la vue actuelle.                 |
|_____________________________________|_______________________________________|
|Vues ->; Nouvelle vue des paquets|Crée une nouvelle vue de la liste des |
|                                     |paquets.                               |
|_____________________________________|_______________________________________|
|                                     |Crée une vue qui affiche les paquets  |
|Vues ->; Voir les recommandations|qui ne sont pas installés et qu'un    |
|                                     |paquet installé sur votre système    |
|                                     |recommande.                            |
|_____________________________________|_______________________________________|
|Vues ->; Nouvelle liste des      |Crée une nouvelle vue de la liste des |
|paquets                              |paquets dans laquelle les paquets ne   |
|                                     |sont pas triés.                       |
|_____________________________________|_______________________________________|
|                                     |Crée une nouvelle vue de la liste des |
|Vues ->; Consultation par        |paquets dans laquelle les paquets sont |
|« Debtags »                      |rangés en fonction de leur entrée    |
|                                     |debtags.                               |
|_____________________________________|_______________________________________|
|Vues ->; Consultation par        |Affiche la liste des paquets,          |
|catégories                          |organisée par catégorie.             |
|_____________________________________|_______________________________________|
|                                     |D'autres entrées du menu apparaissent.|
|Entrées supplémentaires            |Il s'agit des vues actuellement        |
|                                     |actives. Pour atteindre directement une|
|                                     |vue, sélectionnez-la dans ce menu.    |
|_____________________________________|_______________________________________|




Le menu Aide

Figure 2.8. Commandes disponibles dans le menu Aide

 _____________________________________________________________________________
|Commande                            |Description                             |
|____________________________________|________________________________________|
|Aide ->; À propos              |Affiche des informations de copyright.  |
|____________________________________|________________________________________|
|Aide ->; Aide (?)               |Affiche l'aide en ligne.                |
|____________________________________|________________________________________|
|Aide ->; Manuel Utilisateur     |Affiche le manuel de l'utilisateur (ce  |
|                                    |document).                              |
|____________________________________|________________________________________|
|Aide ->; FAQ                    |Affiche la FAQ d'aptitude.              |
|____________________________________|________________________________________|
|Aide ->; Liste des modifications|Affiche la liste des principales        |
|                                    |modifications apportées   aptitude.   |
|____________________________________|________________________________________|
|                                    |Affiche les termes de la licence sous   |
|Aide ->; Licence                |laquelle vous pouvez copier, modifier et|
|                                    |distribuer aptitude.                    |
|____________________________________|________________________________________|




Travailler avec plusieurs vues

aptitude vous permet de travailler avec plusieurs « vues »   la fois. Une
« vue » (parfois appelée « écran ») est simplement quelque chose qui
apparaît dans une zone de l'écran en dessous de la barre de menu. La vue la
plus courante est la liste des paquets, la vue des téléchargements est aussi
assez courante.

Quand plusieurs vues sont ouvertes en même temps, une barre listant l'ensemble
des vues actives apparaît en haut de l'écran. Par exemple, si on examine apt
en appuyant sur entrée, puis qu'on examine libc6, l'écran ressemblera  
ceci :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
         Packages                  apt info                  libc6 info
aptitude 0.3.1
i A  --\ libc6                                             2.3.2.ds1- 2.3.2.ds1-
  Description: GNU C Library: Shared libraries and Timezone data
    Contains the standard libraries that are used by nearly all programs on the
    system. This package includes shared versions of the standard C library and
    the standard math library, as well as many others. Timezone data is also
    included.
  Priority: required
  Section: base
  Maintainer: GNU Libc Maintainers <debian-glibc@lists.debian.org>
  Compressed size: 4901k
  Uncompressed size: 15.9M
  Source Package: glibc
  --\ Depends
    --- libdb1-compat
  --\ Suggests
    --- locales
    --- glibc-doc
  --\ Conflicts
GNU C Library: Shared libraries and Timezone data

Vous pouvez fermer la vue courante avec Vues ->; Fermer (q). Pour atteindre
les vues précédentes et suivantes, utilisez Vues ->; Suivant (F6) et Vues
->; Précédent (F7) ou cliquez sur le nom de la vue en haut de l'écran.
Vous pouvez aussi trouver une liste de toutes les vues actives dans le menu
Vues.

Comme ci-dessus, certaines commandes (par exemple, voir les informations d'un
paquet) vont créer automatiquement de nouvelles vues. Vous pouvez aussi
demander la création d'une nouvelle vue avec Vues ->; Nouvelle vue des
paquets ou Vues ->; Consultation par catégories.


Devenir administrateur (« root »)

Certaines actions, telles que la mise   jour de la liste des paquets, ne
peuvent être réalisées qu'en tant que root. Si vous n'êtes pas root au
moment de mettre   jour la liste des paquets, aptitude va vous demander de le
devenir :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
--- Installed Packages
--- Not Installed Packages
--- Obsolete and Locally Created Packages
--- Virtual Packages
--- Tasks

  +-------------------------------------------------------------------------+
  |Updating the package lists requires administrative privileges, which     |
  |you currently do not have.  Would you like to change to the root account?|
  |                                                                         |
  |         [ Become root ]                  [ Don't become root ]          |
Th+-------------------------------------------------------------------------+








Si vous sélectionnez « Devenir administrateur », aptitude va vous demander
de saisir le mot de passe de root. Une fois que vous l'aurez correctement saisi,
aptitude effectuera les actions qui ont nécessité les droits d'administration.
Vous resterez root après la fin de l'action.

Vous pouvez passer sous le compte root   tout moment en utilisant la commande
Actions ->; Devenir administrateur. Tous les changements que vous avez
apportés   l'état des paquets sont préservés (mais ils ne seront
sauvegardés qu'  la fermeture d'aptitude).


Gérer les paquets

Cette section décrit comment manipuler la liste des paquets, comment installer
de nouveaux paquets sur votre système et comment supprimer de vieux paquets.


Gérer la liste des paquets

Pour garder la liste des paquets   jour, il est recommandé de la mettre  
jour régulièrement. Vous pouvez le faire grâce   la commande Actions ->;
Mettre   jour les listes de paquets (u).


Accéder aux informations des paquets

Les informations sur les paquets sont présentes   plusieurs endroits : la
liste des paquets donne un aperçu rapide de l'état de chaque paquet et
d'autres vues sont aussi disponibles avec des informations détaillées sur
chaque paquet.


La liste des paquets

La liste des paquets montre un résumé succinct de l'état d'un paquet. Par
exemple, le paquet webmin pourrait avoir le résumé suivant :

piAU  webmin                                        +5837kB <aucun>    1.160-2

Les quatre caractères sur la gauche indiquent que le paquet n'est pas installé
(« p »), qu'il est sur le point d'être installé (« i »), qu'il a été
installé automatiquement (« A »), et qu'il ne provient pas d'une source
fiable (« U »). À droite, on peut lire la version actuelle et la version la
plus récente disponible, ainsi qu'une indication de l'espace supplémentaire
que l'installation va utiliser.


 [Astuce]  Astuce

           Vous pouvez personnaliser la manière d'afficher ce résumé.
           Consultez la section intitulée « Personnaliser la manière
           d'afficher les paquets » pour plus de détails.


Les quatre indicateurs d'état sur la gauche de l'écran donnent les
informations de base sur l'état d'un paquet. Le premier caractère indique
l'état courant du paquet. Le second indique l'action qui sera entreprise sur le
paquet. Le troisième indique si le paquet a été automatiquement installé
(voir la section intitulée « Gérer les paquets automatiquement
installés »). Enfin, le quatrième indique si le paquet est fiable (voir la
section intitulée « Qu'est-ce que la confiance en matière de gestion des
paquets ? »).

Les valeurs possibles pour l'indicateur de « l'état courant » sont données
dans Figure 2.9, « Valeurs de l'indicateur de « l'état courant » » et
les valeurs possibles de l'indicateur « d'action » sont données dans
Figure 2.10, « Valeurs de l'indicateur « d'action » ».

Figure 2.9. Valeurs de l'indicateur de « l'état courant »


i - le paquet est installé et toutes ses dépendances sont satisfaites.

c - le paquet a été supprimé mais ses fichiers de configuration sont toujours
    présents sur le système.

p - le paquet et tous ses fichiers de configuration ont été supprimés, ou le
    paquet n'a jamais été installé.

v - le paquet est virtuel.

B - le paquet a des dépendances cassées.

u - le paquet a été dépaqueté mais pas configuré.

C -   moitié configuré : la configuration du paquet a été interrompue.

H -   moitié installé : l'installation du paquet a été interrompue.




Figure 2.10. Valeurs de l'indicateur « d'action »


i - le paquet va être installé.

u - le paquet va être mis   jour.

d - le paquet va être supprimé : il sera supprimé mais ses fichiers de
    configuration resteront sur le système.

p - le paquet va être purgé : lui et ses fichiers de configuration seront
    supprimés.

h - le paquet est gelé : il sera gardé dans sa version actuelle, même si une
    version plus récente est disponible, jusqu'  ce que le gel soit retiré.

F - toute mise   jour du paquet est interdite.

r - le paquet va être réinstallé.

    le paquet est « cassé » : certaines de ses dépendances ne sont pas
B - satisfaites. aptitude ne vous permettra pas d'installer, supprimer ou mettre
      jour quoique ce soit tant que des paquets sont cassés.




De plus, si le terminal le permet, aptitude utilise des couleurs pour indiquer
l'état d'un paquet. La distinction entre les états se fait principalement
grâce   la couleur de l'arrière plan :



  Noir
      Le paquet ne peut pas être mise   jour (ou il ne sera pas installé) et
      il n'a pas de problème de dépendance. Si le paquet est déj  installé,
      son nom est en surbrillance.


  Vert
      Le paquet est sur le point d'être installé.


  Bleu
      Le paquet est actuellement installé et il va être mis   jour.


  Magenta
      Le paquet est actuellement installé, mais il va être supprimé.


  Blanc
      Le paquet est actuellement installé et il est « gelé » dans sa
      version courante : les mises   jour automatiques l'ignoreront.


  Rouge
      Le paquet est cassé : certaines de ces dépendances ne sont pas
      satisfaites.


Enfin, la moitié inférieure de l'écran affiche la description longue.
aptitude tentera de détecter si le paquet est impliqué dans des problèmes de
dépendances. Si c'est le cas, des informations concernant ces problèmes de
dépendances y seront affichées. Pour passer des informations de dépendances
  la description du paquet, et inversement, appuyez sur i.


Information détaillée d'un paquet

Appuyer sur Entrée pendant qu'un paquet est en surbrillance affichera un écran
contenant les informations sur ce paquet :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.2.14.1
i A --\ apt                                                0.5.25     0.5.25
  Description: Advanced front-end for dpkg
    This is Debian's next generation front-end for the dpkg package manager. It
    provides the apt-get utility and APT dselect method that provides a simpler,
    safer way to install and upgrade packages.

    APT features complete installation ordering, multiple source capability and
    several other unique features, see the Users Guide in apt-doc.
  Essential: yes
  Priority: important
  Section: base
  Maintainer: APT Development Team <deity@lists.debian.org>
  Compressed size: 970k
  Uncompressed size: 2961k
  Source Package: apt
  --\ Depends
    --- libc6 (>= 2.3.2.ds1-4)
    --- libgcc1 (>= 1:3.3.3-1)
    --- libstdc++5 (>= 1:3.3.3-1)
  --\ Suggests
    --- aptitude | synaptic | gnome-apt | wajig
    --- dpkg-dev
    --\ apt-doc (UNSATISFIED)
p     0.6.25
p     0.5.25
  --\ Replaces
    --- libapt-pkg-doc (< 0.3.7)
    --- libapt-pkg-dev (< 0.3.7)
  --- Package names provided by apt
  --- Packages which depend on apt
  --\ Versions
p A 0.6.25
i A 0.5.25

On peut naviguer dans cet écran de manière similaire   la liste des
paquets : par exemple, dans la capture précédente, l'arbre des dépendances
sur apt-doc fait apparaître les versions disponibles d'apt-doc qui peuvent
satisfaire la dépendance. Ces versions peuvent être manipulées de la même
manière que les paquets : par exemple, pour installer la version 0.5.25 de
apt-doc, il vous suffit de la mettre en surbrillance et d'appuyer sur +.


 [Astuce]  Astuce

           Pour satisfaire rapidement une dépendance, sélectionnez-la et
           appuyez sur +. aptitude tentera automatiquement de la satisfaire.


En plus des dépendances d'un paquet, vous pouvez voir le nom des paquets qu'il
fournit, les paquets qui dépendent de lui, ainsi que les versions disponibles
du paquet (en incluant tous les paquets qui le fournissent).

Comme d'habitude, vous pouvez quitter cet écran et retourner   la vue
principale en appuyant sur q. Par commodité, quelques autres écrans
d'information (qui n'affichent que quelques informations courantes et cachent le
reste) sont disponibles : appuyez sur v pour voir les versions d'un paquet, d
pour voir les dépendances d'un paquet et r pour voir les « dépendances
inverses » d'un paquet (c'est- -dire les paquets qui dépendent de ce
paquet).


Modifier l'état d'un paquet

Les commandes suivantes sont disponibles pour modifier l'état des paquets. Ces
commandes prennent effet au prochain lancement d'un processus d'installation.
Jusque-l , toutes ces commandes peuvent être annulées en utilisant Annuler
->; Annuler (Contrôle+u).

Pour appliquer une commande   un paquet, il suffit de le sélectionner dans une
liste de paquets et d'exécuter la commande. Ces commandes peuvent aussi être
appliquées   un groupe de paquets en sélectionnant l'en-tête du groupe (par
exemple : « Paquets pouvant être mis   jour ») et en exécutant la
commande.

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|                                      |Marque le paquet courant pour          |
|                                      |installation.                          |
|                                      |                                       |
|Installation : Paquet ->;        |Si le paquet n'est pas installé, il le|
|Installer (+)                         |sera. S'il est déj  installé, il    |
|                                      |sera mis   jour, si possible, et les  |
|                                      |éventuels marquages empêchant sa mise|
|                                      |  jour (p. ex. Gel) seront annulés.  |
|______________________________________|_______________________________________|
|                                      |Marque le paquet courant pour          |
|Suppression : Paquet ->;         |suppression.                           |
|Supprimer (-)                         |                                       |
|                                      |Si le paquet est installé, il sera    |
|                                      |supprimé.                             |
|______________________________________|_______________________________________|
|                                      |Marque le paquet courant pour purge.   |
|                                      |                                       |
|                                      |Si le paquet est installé, il sera    |
|Purge : Paquet ->; Purger (_)    |supprimé. De plus, s'il est déj     |
|                                      |supprimé, tout fichier restant (comme |
|                                      |les fichiers de configuration) lié   |
|                                      |ce paquet sera supprimé du système.  |
|______________________________________|_______________________________________|
|                                      |Marque le paquet courant pour qu'il    |
|                                      |soit gardé dans sa version actuelle.  |
|                                      |                                       |
|Garde : Paquet ->; Garder (:)    |Toute action qui était prévue sur le |
|                                      |paquet (installation, suppression ou   |
|                                      |mise   jour) est annulée et tout gel |
|                                      |persistant sur le paquet est retiré.  |
|______________________________________|_______________________________________|
|                                      |Place un gel persistant sur le paquet. |
|                                      |                                       |
|                                      |As with Keep, any action that was to be|
|Gel : Paquet ->; Geler (=)       |performed on the package is cancelled. |
|                                      |In addition, the package will not be   |
|                                      |automatically upgraded [a] until the   |
|                                      |hold is removed. You may cancel a hold |
|                                      |by issuing the Install command.        |
|______________________________________|_______________________________________|
|                                      |Le paquet ne sera pas automatiquement  |
|                                      |mis   jour[a] vers la version vers    |
|                                      |laquelle il peut actuellement l'être. |
|                                      |S'il est sur le point d'être          |
|                                      |installé, sa mise   jour sera        |
|                                      |annulée.                              |
|                                      |                                       |
|                                      |Si vous lancez cette commande sur une  |
|                                      |version particulière d'un paquet, le  |
|Paquet ->; Interdire la version   |paquet ne sera pas mis   jour vers la |
|(F)                                   |version sélectionnée. Remarquez qu'on|
|                                      |ne peut interdire qu'une seule version |
|                                      |  la fois.                            |
|                                      |                                       |
|                                      |Cette fonction est principalement      |
|                                      |fournie pour faciliter la vie des      |
|                                      |utilisateurs de la distribution        |
|                                      |« unstable », afin qu'ils puissent |
|                                      |éviter certaines versions de paquet   |
|                                      |connues comme étant défectueuses.    |
|______________________________________|_______________________________________|
|                                      |Réinstalle le paquet.                 |
|                                      |                                       |
|                                      |Remarquez que la marque de             |
|                                      |réinstallation ne sera pas            |
|                                      |sauvegardée quand vous quitterez      |
|Réinstaller : appuyer sur L         |aptitude ou lancerez un processus      |
|                                      |d'installation pour des raisons        |
|                                      |techniques. (Brièvement, les couches  |
|                                      |logicielles sous-jacentes (dpkg et apt)|
|                                      |ne fournissent aucun moyen de savoir si|
|                                      |une réinstallation a réussi ou non). |
|______________________________________|_______________________________________|
|                                      |Indique si le paquet doit être traité|
|                                      |comme ayant été automatiquement      |
|Paquet ->; Marquer automatiquement|installé. Les paquets automatiquement |
|(M), Paquet ->; Marquer           |installés sont supprimés quand plus  |
|manuellement (m)                      |aucun paquet ne les requiert. Pour plus|
|                                      |d'informations, consultez la section   |
|                                      |intitulée « Gérer les paquets      |
|                                      |automatiquement installés ».        |
|______________________________________|_______________________________________|
|[a] That is, it will be unaffected by Actions ->; Marquer comme étant    |
|susceptible de mise   jour (U) or the full-upgrade or safe-upgrade command-  |
|line actions.                                                                 |
|______________________________________________________________________________|

En plus de ces commandes qui affectent le paquet sélectionné, il y a deux
commandes qui affectent un grand nombre de paquets d'un seul coup quelque soit
ce qui est sélectionné. Actions ->; Oublier quels paquets sont nouveaux
(f) enlève l'état « nouveau » de tous les paquets de la liste de paquets
et Actions ->; Marquer comme étant susceptible de mise   jour (U) marque
tous les paquets qui peuvent l'être pour mise   jour,   l'exception des
paquets qui sont gelés ou qui seraient mis   jour vers une version interdite.


 [Note]  Note

         Tout changement de l'état des paquets est enregistré quand vous
         quittez aptitude, mettez   jour la liste des paquets ou lancez un
         processus d'installation. Si vous ne voulez pas enregistrer vos
         changements, vous pouvez toujours abandonner aptitude en pressant Ctrl-
         C.



Résoudre les problèmes de dépendance

Si un problème de dépendances survient, aptitude peut vous aider   la
résoudre. Dès qu'un problème arrive, une barre rouge apparaît en bas de
l'écran avec un résumé des suggestions d'aptitude pour le résoudre. Par
exemple, dans la capture d'écran suivante, aptitude indique qu'il est possible
de résoudre le problème en gardant deux paquets dans leur version actuelle.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.3.3       #Broken: 1   Will free 48.6MB of disk space
i A   nautilus                                             2.10.1-4   2.10.1-4
i     nautilus-cd-burner                                   2.10.2-1.1 2.10.2-1.1
i A   nautilus-data                                        2.10.1-4   2.10.1-4
i     netspeed                                             0.12.1-1   0.12.1-1
i A   oaf                                                  0.6.10-3   0.6.10-3
i     pybliographer                                        1.2.6.2-1  1.2.6.2-1
i     rhythmbox                                            0.8.8-13   0.8.8-13
i     shermans-aquarium                                    3.0.1-1    3.0.1-1
idA   sound-juicer                                 -1733kB 2.10.1-3   2.10.1-3
GNOME 2 CD Ripper
sound-juicer will be removed.


The following packages depend on sound-juicer and will be broken by its
removal:


  * gnome-desktop-environment depends on sound-juicer

[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Comme il est indiqué en bas de l'écran, vous pouvez voir d'autres solutions en
appuyant sur . et ,, appliquer la solution courante en appuyant sur ! et
examiner la solution plus en détail en appuyant sur e. Quand vous examinez la
solution courante, un écran semblable au suivant apparaît.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    gstreamer0.8-cdparanoia                           [0.8.10-1 (unstable, now)]
    sound-juicer                                                [2.10.1-2 (now)]
















[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Vous pouvez accéder aux informations sur le paquet affecté par une action en
appuyant simplement sur entrée lorsque le paquet est sélectionné. Pour
obtenir une explication détaillée sur les raisons d'un choix particulier, il
suffit de sélectionner l'élément dans la liste. Dans la moitié basse de
l'écran, s'afficheront la dépendance qui a été résolue par aptitude et tous
les moyens par lesquels la dépendance aurait pu être résolue.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
    gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
    sound-juicer                                      [2.10.1-3 (unstable, now)]






cdparanoia plugin for GStreamer
sound-juicer depends upon gstreamer0.8-cdparanoia
--\ The following actions will resolve this dependency:
  -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]
  -> Remove sound-juicer [2.10.1-3 (unstable, now)]
  -> Cancel the removal of gstreamer0.8-cdparanoia
  -> Downgrade gstreamer0.8-cdparanoia [0.8.11-1 (unstable, now) -> 0.8.8-3 (tes



[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Vous pouvez guider la résolution de dépendances vers la solution de votre
choix en approuvant ou rejetant les actions élémentaires d'une solution. Si
vous approuvez une action, aptitude choisira, autant que possible, cette action
en ignorant les alternatives (s'il y a plusieurs actions approuvées, elles
seront toutes choisies). À l'inverse, si vous rejetez une action, aptitude ne
choisira jamais cette action.

To reject an action, highlight it and press r; the rejection can be cancelled by
pressing r again. Similarly, select an action and press a to approve it. You can
undo either action by using Annuler ->; Annuler (Contrôle+u) while the
resolver screen is active. If you cancel a rejection or an approval, any
solutions that were ignored will be available the next time that you generate a
new solution.


 [Note]  Note

         By default, the resolver rejects actions that change the state of held
         packages, or that install forbidden versions of packages. You can
         override these rejections, thus allowing the hold or forbidding to be
         automatically overridden, in the same way that you would override any
         other rejection. Setting the configuration option Aptitude::
         ProblemResolver::Allow-Break-Holds to true will disable this behavior,
         meaning that the resolver will always break holds (albeit at a penalty,
         see Aptitude::ProblemResolver::BreakHoldScore).


Les actions rejetées sont mises en rouge et marquées avec un « R », et
celles approuvées sont mises en vert et marquées avec un « A ». Comme vous
pouvez le voir dans la capture suivante où l'action de « conserver
gstreamer0.8-cdparanoia dans sa version actuelle » a été rejetée et
l'action de « conserver sound-juicer dans sa version actuelle » approuvée.

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ Keep the following packages at their current version:
R   gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
A   sound-juicer                                      [2.10.1-3 (unstable, now)]
















[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Les rejets et les approbations n'affectent que les solutions nouvellement
générées. Il est possible de savoir si une nouvelle solution va être
générée en regardant l'indicateur en bas   gauche de l'écran. S'il y a un
nombre entre parenthèses, celui-ci indique le nombre de solutions générées.
Et donc, si le nombre hors des parenthèses et celui   l'intérieur sont égaux
(comme ci-dessus), appuyer sur . va générer une nouvelle solution. S'il n'y a
pas de nombre entre parenthèses (l'indicateur affiche, par exemple, [1/5]),
alors il n'y a pas d'autre solution   générer. À tout moment, vous pouvez
sélectionner la dernière solution générée en appuyant sur > et la première
avec <.


 [Important]  Important

              L'état du système de résolution des problèmes est mis   zéro
              quand vous modifiez l'état d'un paquet. Si vous marquez un paquet
              pour installation, pour mise   jour, pour suppression, etc.,
              aptitude oubliera tous vos rejets et approbations, ainsi que
              toutes les solutions générées jusque l .


En plus de la sélection des actions dans la liste en haut de l'écran, vous
pouvez sélectionner ces actions dans la liste du bas. Pour avoir accès  
cette seconde liste, vous pouvez soit cliquer dessus avec votre souris, soit
appuyer sur Tab. Enfin, en appuyant sur o, vous afficherez les décisions
triées. Cela consiste en une liste des dépendances qui ont été résolues et
des actions qui ont amené ce résultat, comme le montre la capture suivante .

 Actions  Undo  Package  Resolver  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                Packages                          Resolve Dependencies
  --\ gnome-desktop-environment depends upon sound-juicer
    -> Cancel the removal of sound-juicer
  --\ sound-juicer depends upon gstreamer0.8-cdparanoia
    -> Cancel the removal of gstreamer0.8-cdparanoia





GNOME 2 CD Ripper
gnome-desktop-environment depends upon sound-juicer
--\ The following actions will resolve this dependency:
  -> Remove gnome-desktop-environment [1:2.10.2.3 (unstable, testing, now)]
  -> Cancel the removal of sound-juicer
  -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]




[1(1)/...] Suggest 2 keeps
e: Examine  !: Apply  .: Next  ,: Previous

Appuyer   nouveau sur o quitte ce mode d'affichage.


Télécharger, installer et supprimer des paquets

Changing package states as described in the previous section does not actually
affect what is installed on your system. Thus, you can adjust the state of
packages without affecting your system until you are happy with what you see;
once you are, you can « commit » the changes by actually installing and
removing packages.[8]

Pour appliquer vos changements, utilisez la commande Actions ->; Installer/
enlever des paquets (g). Sélectionner cette commande va afficher un aperçu
décrivant les changements qui seront effectués. Cet écran n'est qu'une liste
de paquets et vous pouvez manipuler les paquets (par exemple, annuler des
suppressions non désirées) de la même manière que vous le feriez dans la
liste principale.

Quand vous êtes prêt, utilisez Vues ->; Fermer (q) pour annuler
l'installation ou Actions ->; Installer/enlever des paquets (g) pour la
lancer. aptitude téléchargera tous les fichiers nécessaires, puis vous
demandera s'il faut continuer le processus. Si vous validez par
« Continuer », les installations et suppressions vont débuter.

Les paquets qui sont téléchargés par aptitude sont placés dans un
répertoire de cache (habituellement /var/cache/apt/archives). Normalement, ils
y sont laissés ad infinitum. Pour supprimer tous les fichiers de ce
répertoire, utilisez Actions ->; Nettoyer le cache des paquets, pour ne
supprimer que les fichiers qui ne peuvent plus être téléchargés (c'est- -
dire les paquets obsolètes), utilisez Actions ->; Enlever les fichiers
périmés.


Qu'est-ce que la confiance en matière de gestion des paquets ?

La possibilité pour apt d'accéder   de nombreuses sources de paquets conduit
  un risque potentiel en matière de sécurité. Supposons que vous ajoutiez
une archive publiée par Jean-Kevin Lepirate   votre fichier sources.list afin
d'installer le paquet ubersuper de Jean-Kevin. Il est possible que l'archive de
Jean-Kevin contienne aussi ses propres versions « personnalisées » de
paquets comme libc6 ou ssh... et ces versions vont voler vos informations
personnelles ou ouvrir des portes dérobées sur votre système ! Si ces
paquets ont un numéro de version supérieur   ceux des paquets Debian
légitimes, apt les installera sur votre système   la prochaine mise   jour,
sans se soucier de rien, permettant   Jean-Kevin de faire sa sale besogne dans
votre dos. Jean-Kevin pourrait aussi modifier votre miroir des archives Debian
et remplacer les logiciels légitimes par ses versions corrompues.

Heureusement, les nouvelles versions d'apt et d'aptitude, comme celle qui est
documentée dans ce manuel, intègrent des mécanismes de protection pour
contrer ce genre d'attaque. apt utilise de puissants mécanismes de sécurité
basés sur le célèbre logiciel de chiffrement GPG pour vérifier que les
paquets qui sont distribués depuis les miroirs officiels Debian sont bien les
mêmes que ceux qui ont été envoyés par les responsables de paquets Debian.
aptitude vous avertira alors si vous tentez d'installer un paquet depuis une
source non-Debian, ou si vous tentez de mettre   jour un paquet provenant d'une
source Debian vers une version qui ne vient pas d'une source Debian.


 [Avertissement]  Avertissement

                  Les mécanismes de sécurité d'apt fournissent une garantie
                  presque totale que le contenu de votre miroir est identique au
                  contenu de l'archive Debian principale. Néanmoins, ce n'est
                  pas une panacée. Par exemple, il existe théoriquement de
                  nombreuses façons de mettre un paquet corrompu dans l'archive
                  Debian principale.

                  S'assurer que vous n'installez des logiciels que depuis des
                  sources fiables vous apportera un degré important de
                  protection contre les paquets malveillants, mais ça ne peut
                  pas éliminer tous les risques inhérents   l'installation de
                  logiciels.



Comprendre la confiance

apt allows the administrator of an archive to provide a signature of the
archive's index. This signature, which (for all practical purposes) cannot be
forged, indicates that the package files listed in the index are the same files
that the administrator intended to place in the archive: ie, that the contents
of the archive have not been tampered with since it was created.[9] The
signature can be validated by checking that it corresponds to the
administrator's public key. The public key of the Debian archive is distributed
with apt, typically on your Debian CD.

Quand aptitude télécharge l'index d'une archive, il vérifie si l'index est
bien signé. S'il ne l'est pas, aptitude ne fera pas confiance aux paquets de
cette archive (voir plus bas pour savoir ce que cela signifie). S'il a une
signature mais que celle-ci est incorrecte ou ne peut être vérifiée, un
avertissement sera affiché et aptitude refusera de faire confiance aux paquets
de cette archive.

Plus tard, quand vous lancerez un processus d'installation, aptitude vérifiera
si les paquets viennent de sources fiables. Si un paquet douteux est sur le
point d'être installé, ou si un paquet est mis   jour d'une version fiable
vers une version non fiable, un avertissement est affiché et vous avez la
possibilité d'interrompre le téléchargement :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
aptitude 0.3.0                    Will use 831kB of disk space   DL Size: 30.4MB
--\ Packages to be upgraded
iu U wesnoth                                       -98.3kB 0.8.7-1    0.8.8-1.0w
iuAU wesnoth-data                                  +930kB  0.8.7-1    0.8.8-1.0w
+------------------------------------------------------------------------------+
|WARNING: untrusted versions of the following packages will be installed!     #|
|                                                                             #|
|Untrusted packages could compromise your system's security.  You should only #|
|proceed with the installation if you are certain that this is what you want  #|
|to do.                                                                       #|
|                                                                             #|
|  * wesnoth [version 0.8.8-1.0wesnoth.org]                                   #|
|  * wesnoth-data [version 0.8.8-1.0wesnoth.org]                              #|
|  * wesnoth-music [version 0.8.8-1.0wesnoth.org]                             #|
|         [ Really Continue ]                  [ Abort Installation ]          |
+------------------------------------------------------------------------------+
                                                                               #
                                                                               #
                                                                               #
                                                                               #
                                                                               #
                                                                               #


Faire confiance   d'autres clés

Il peut être pratique de faire en sorte qu'apt fasse confiance   d'autres
archives, en plus de l'archive Debian principale. Pour chaque archive  
laquelle vous voulez faire confiance, vous devez récupérer la clé publique
utilisée pour signer l'index des paquets de cette archive. C'est habituellement
un fichier texte dont le nom fini par .asc. Il doit être fourni par
l'administrateur du serveur ou téléchargeable depuis un serveur de clés
publiques. Pour plus d'information sur ce que sont les clés publiques et
comment les récupérer, consultez la page web de GPG.

La liste des clés auxquelles apt fait confiance est stockée dans le fichier
porte-clés /etc/apt/trusted.gpg. Une fois que vous avez la clé GPG, vous
pouvez l'ajouter   ce fichier en exécutant la commande gpg --no-default-
keyring --keyring /etc/apt/trusted.gpg --import nouvelleclef.asc. aptitude fera
alors confiance   toutes les archives signées avec la clé contenue dans
nouvelleclef.asc.


 [Avertissement]  Avertissement

                  Une fois que la clé d'une archive a été ajoutée au porte-
                  clés d'apt, il lui sera accordé autant de confiance qu'aux
                  miroirs Debian eux-mêmes ! Vous ne devriez faire cela que si
                  vous êtes absolument sûr que la clé que vous ajoutez est la
                  bonne et que la personne qui détient cette clé est   la
                  fois fiable et compétente.



Gérer les paquets automatiquement installés

>Pour installer un paquet, il est souvent nécessaire d'en installer plusieurs
autres (pour satisfaire ses dépendances). Par exemple, si vous voulez installer
le paquet clanbomber, vous devez aussi installer le paquet libclanlib2. Lorsque
vous supprimez clanbomber, vous n'avez probablement plus besoin du paquet
libclanlib2. aptitude tentera de le détecter et de supprimer automatiquement le
paquet libclanlib2.

It works like this: when you install a package, aptitude will automatically
install any other packages on which it depends. These packages are marked as
having been « automatically installed »; aptitude will monitor them and
remove them when they are no longer depended upon by any manually installed
package [10] . They will appear in the preview as « packages being removed
because they are no longer used. »

Comme pour tout procédé automatique, les choses peuvent potentiellement mal
tourner. Par exemple, même si un paquet a été installé automatiquement pour
commencer, il peut s'avérer utile par lui-même. Vous pouvez retirer la marque
« automatique »   tout moment en appuyant sur m et, si le paquet est déj 
marqué   supprimer, vous pouvez annuler la suppression et retirer la marque
« automatique » avec Paquet ->; Installer (+).


Motifs de recherche

When you search for a package or set a display limit in aptitude, the string you
enter is known as a « search pattern ». While the most basic usage of search
patterns is to match packages by name, aptitude allows you to create much more
complex searches. In addition to the visual interface, some command-line
operations can use search patterns; see Référence de la ligne de commande for
details.

A search pattern consists of one or more conditions (sometimes known as
« terms »); packages match the pattern if they match all of its terms. Terms
generally start with a question mark (« ? »), followed by the name of the
match term, which describes the search that the term performs: for instance, the
term ?name matches package names, while the term ?version matches package
versions. Finally, any additional parameters to the search term are placed in
parentheses (see the documentation of individual terms for details of what each
term's parameters mean).


 [Note]  Note

         Text with no leading « ? » can also form a search pattern: aptitude
         will attempt to match it against package names. However, because
         « ? » is a regular expression metacharacter, aptitude will not
         recognize question marks as terminators for these « bare » strings.
         For instance, the search pattern « apt?name(python) » will not
         search for packages whose name contains both « apt » and
         « python »; instead, it will search for packages whose name matches
         the regular expression « apt?name(python) ».



 [Avertissement]  Avertissement

                  The behavior of aptitude when given a search pattern without a
                  leading « ? » (or « ~ ») is provided as a convenience
                  for interactive use and will change in future releases;
                  scripts that invoke aptitude should explicitly name the search
                  strategy they want to use. That is, scripts should search for
                  « ?name(coq) » or « ~ncoq » rather than « coq »).



Searching for strings

Many search terms take a string as a parameter and match it against one or more
fields of a package. Strings can be entered either with or without double quotes
(« " »), so « ?name(scorch) » and « ?name("scorch") » will perform
the same search. If you enter a search string using double quotes, you can
include a literal double-quote in the search string by placing a backslash
(« \ ») immediately before it: for instance, « ?description
("\"easy\"") » will match any package whose description contains the string
« "easy" ».

If you enter a « bare » string, one not surrounded by double quotes, then
aptitude will consider the string to have « ended » when it encounters the
closing parenthesis or the comma before a second argument to the search term.
[11] To remove the special meaning of these characters, place a tilde
(« ~ ») directly before them. For instance, « ?description(etc)) » is a
syntax error, because the first « ) » ends the ?description term, and the
second « ) » does not correspond to any « ( ». In contrast,
« ?description(etc~)) » matches any package whose description contains the
text « etc) ». There are additional considerations if you are using the
shorthand notation for a term; see la section intitulée « Shorthand for
search terms » for details.

Most textual searches (for package names, descriptions, etc) are performed using
case-insensitive regular expressions. A regular expression will match against a
field if any portion of the field matches the expression; for instance, « ogg
[0-9] » will match « libogg5 », « ogg123 », and « theogg4u ». Some
characters have a special meaning within regular expressions [12] , so if you
want to match them in searches you need to backslash-escape them: for instance,
to find « g++ », you should use the pattern « g\+\+ ».

The characters « ! » and « | » have special meanings within search
patterns. In order to include these characters in an unquoted string, you can
place a tilde (« ~ ») directly before them. For instance, to match packages
whose description contains either « grand » or « oblique », use the
pattern « ?description(grand~|oblique) ». However, you will probably find it
more convenient to simply use a quoted string in these cases: « ?description
("grand|oblique") ».


Shorthand for search terms

Some search terms can be written using « short » forms, which consist of a
tilde (« ~ ») followed by a single character that identifies the term, and
finally the arguments (if any) to the term. For instance, the short form of
?name(aptitude) is ~n aptitude.

When writing a term using its short form, tilde characters and
« whitespace » -- that is, space characters, tabs, and so on -- will break
the term off and start a new term. For instance, « ~mDaniel Burrows » will
match any package whose maintainer field contains « Daniel » and whose name
contains « Burrows », while « ~i~napt » matches installed packages whose
name contains apt. To include whitespace characters in the search expression,
you can either place a tilde in front of it (as in Daniel~ Burrows) or place
quotation marks around it (as in "Debian Project" or even Debian" "Project).
Inside a quoted string, the backslash character (« \ ») can be used to
cancel the special meaning of the quotation mark: for instance, ~d"\"email" will
match any package whose description contains a quotation mark followed
immediately by email. [13]


 [Note]  Note

         Question marks (« ? ») will not end the short form of a term, even
         if they are followed by the name of a search term. For instance,
         « ~napt?priority(required) » will match all packages whose name
         matches the regular expression « apt?priority(required) ». To
         combine a short query term with a search term specified by name, add
         one or more spaces between the two terms, as in « ~napt ?priority
         (required) », or place quotation marks around the text (if any)
         following the short form of a term, as in « ~n"apt"?priority
         (required) ».


Tableau 2.1, « Quick guide to search terms » lists the short form of each
search term.


Searches and Versions

By default, a pattern matches a package if any version of the package matches
the pattern. However, some patterns will restrict their sub-patterns to only
match against some versions of a package. For instance, the search term ?depends
(pattern) will select any package that depends on a package matching pattern.
However, pattern will only be checked against the versions of the package that
actually satisfy a dependency. This means that if foo depends on bar (>= 3.0)
and versions 2.0, 3.0, and 4.0 of bar are available, then in the search pattern
?depends(?version(2\.0)), only versions 3.0 and 4.0 will be tested against
?version(2\.0), and hence foo will not be found by this search.

It matters which versions are checked because, as in the example above, some
patterns will match one version but not another. For instance, the pattern
?installed will only match the version of the package (if any) that is currently
installed. Similarly, the pattern ?maintainer(maintainer) will only match
versions that have the given maintainer. Normally all versions of a package have
the same maintainer, but this is not always the case; in fact, any search
pattern that examines the fields of a package (other than its name, of course)
will behave this way, because all the fields of a package can change between
versions.

To test a pattern against all the versions of a package, even if the pattern
would normally be tested against only some of the versions, use the ?widen term.
For instance, ?depends(?widen(?version(2\.0))) will match any package A that
depends on a package B, where B has a version matching 2.0, regardless of
whether that version actually satisfies A's dependency. On the other hand, the
?narrow term restricts the versions that its sub-pattern is matched against:
?narrow(?installed, ?depends(?version(ubuntu))) will match any package whose
installed version has a dependency that can be satisfied by a package whose
version string contains « ubuntu ».


 [Note]  Note

         There is a subtle, but important, distinction between matching a
         pattern against a package, and matching it against all the versions of
         that package. When a pattern is matched against a package, each of its
         terms is matched against the package, and so each term will match if
         any version of the package matches. In contrast, when a pattern is
         matched against each version of a package, it will successfully match
         if it matches when all its terms are matched against the same version
         of the package.

         For example: suppose that version 3.0-1 of the package aardvark is
         installed, but that version 4.0-1 is available. Then the search
         expression ?version(4\.0-1)?installed matches aardvark, because
         ?version(4\.0-1) matches against version 4.0-1 of aardvark, while
         ?installed matches against version 3.0-1. On the other hand, this
         expression does not match against all the versions of aardvark, because
         no single version is installed and also has a version number of 4.0-1.



Explicit search targets

Some particularly complex searches can be expressed in aptitude using explicit
targets. In normal search expressions, there is no way to refer to the package
or version that is currently being tested. For instance, suppose that you want
to search for all packages P that depend on a second package Q such that Q
recommends P. Clearly you need to start out with a ?depends(...) term. But the
term filling in the ... needs to somehow select packages that are identical to
the one being matched against ?depends. When describing the goal above, I dealt
with this by giving the packages names, calling them P and Q; terms with
explicit targets do exactly the same thing. [14]

An explicit target is introduced by the ?for term:

Figure 2.11. Syntax of the ?for term

?for variable: pattern



This behaves exactly like pattern, but variable can be used within pattern to
refer to the package or version that pattern is being matched against. You can
use variable in two ways:


  1. The term ?= will match exactly the package or version indicated by the
     given variable. Specifically: if the corresponding ?for term is limited to
     a particular version, then ?= will match either that version (if ?= is
     limited) or the whole package; otherwise it will match any version of the
     package.

     See Exemple 2.1, «  Use of the ?= term.  » for an example of how to
     use ?=.

  2. The term ?bind(variable, pattern) will match any package or version if the
     value of variable matches against pattern.

     For ?-style terms, a shorthand form is available. The expression ?bind
     (variable, ?term[(args)]) can be replaced by ?variable:term(args).

     See Exemple 2.2, « Use of the ?bind term » for an example of how to
     use ?bind.



Search Term Reference

Tableau 2.1, « Quick guide to search terms » provides a brief summary of
all the search terms provided by aptitude. A full description of each term can
be found below.

Tableau 2.1. Quick guide to search terms

 __________________________________________________________________________
|Long form                |Short form          |Description                |
|_________________________|____________________|___________________________|
|                         |                    |Select the package bound to|
|?=variable               |                   |variable; see la section   |
|                         |                    |intitulée « Explicit    |
|                         |                    |search targets ».        |
|_________________________|____________________|___________________________|
|?not(pattern)            |!pattern            |Select any package that    |
|                         |                    |does not match pattern.    |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that have  |
|                         |                    |been marked for the given  |
|?action(action)          |~aaction            |action (e.g.,              |
|                         |                    |« install » or         |
|                         |                    |« upgrade »).          |
|_________________________|____________________|___________________________|
|?all-versions(pattern)   |                   |Select packages whose      |
|                         |                    |versions all match pattern.|
|_________________________|____________________|___________________________|
|                         |                    |Select any package that    |
|?and(pattern1, pattern2) |pattern1 pattern2   |matches both pattern1 and  |
|                         |                    |pattern2.                  |
|_________________________|____________________|___________________________|
|                         |                    |Select packages for which  |
|?any-version(pattern)    |                   |at least one version       |
|                         |                    |matches pattern.           |
|_________________________|____________________|___________________________|
|                         |                    |Select packages from the   |
|?archive(archive)        |~Aarchive           |given archive (such as     |
|                         |                    |« unstable »).         |
|_________________________|____________________|___________________________|
|?automatic               |~M                  |Select packages that were  |
|                         |                    |automatically installed.   |
|_________________________|____________________|___________________________|
|                         |                    |Selects anything if        |
|                         |?variable:term-name[|variable matches pattern;  |
|?bind(variable, pattern) |(args)]             |see la section intitulée  |
|                         |                    |« Explicit search        |
|                         |                    |targets ».               |
|_________________________|____________________|___________________________|
|?broken                  |~b                  |Select packages that have a|
|                         |                    |broken dependency.         |
|_________________________|____________________|___________________________|
|                         |                    |Select package that have a |
|?broken-depType          |~BdepType           |broken dependency of the   |
|                         |                    |given depType.             |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that have a|
|?broken-depType(pattern) |~DB[depType:]pattern|broken dependency of the   |
|                         |                    |given depType matching     |
|                         |                    |pattern.                   |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that a     |
|?broken-reverse-depType  |~RBdepType:pattern  |package matching pattern   |
|(pattern)                |                    |declares a broken          |
|                         |                    |dependency of type depType.|
|_________________________|____________________|___________________________|
|                         |                    |Select packages that       |
|?conflicts(pattern)      |~Cpattern           |conflict with a package    |
|                         |                    |matching pattern.          |
|_________________________|____________________|___________________________|
|?config-files            |~c                  |Select packages that were  |
|                         |                    |removed but not purged.    |
|_________________________|____________________|___________________________|
|                         |                    |Match packages that declare|
|?depType(pattern)        |~D[depType:]pattern |a dependency of type       |
|                         |                    |depType on a package       |
|                         |                    |matching pattern.          |
|_________________________|____________________|___________________________|
|                         |                    |Select packages whose      |
|?description(description)|~ddescription       |description matches        |
|                         |                    |description.               |
|_________________________|____________________|___________________________|
|                         |                    |Select essential packages, |
|?essential               |~E                  |those with Essential: yes  |
|                         |                    |in their control files.    |
|_________________________|____________________|___________________________|
|?false                   |~F                  |Select no packages.        |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that match |
|                         |                    |pattern with variable bound|
|?for variable: pattern   |                   |to the package being       |
|                         |                    |matched; see la section    |
|                         |                    |intitulée « Explicit    |
|                         |                    |search targets ».        |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?garbage                 |~g                  |not required by any        |
|                         |                    |manually installed package.|
|_________________________|____________________|___________________________|
|?installed               |~i                  |Select installed packages. |
|_________________________|____________________|___________________________|
|?maintainer(maintainer)  |~mresponsable       |Select packages maintained |
|                         |                    |by maintainer.             |
|_________________________|____________________|___________________________|
|                         |                    |Select packages for which a|
|?narrow(filter, pattern) |~S filter pattern   |single version matches both|
|                         |                    |filter and pattern.        |
|_________________________|____________________|___________________________|
|?name(name)              |~nname, name        |Select packages with the   |
|                         |                    |given name.                |
|_________________________|____________________|___________________________|
|?new                     |~N                  |Select new packages.       |
|_________________________|____________________|___________________________|
|?obsolete                |~o                  |Match installed packages   |
|                         |                    |that cannot be downloaded. |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that match |
|?or(pattern1, pattern2)  |pattern1 | pattern2 |pattern1, pattern2, or     |
|                         |                    |both.                      |
|_________________________|____________________|___________________________|
|?origin(origin)          |~Oorigine           |Select packages with the   |
|                         |                    |given origin.              |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that       |
|?provides(pattern)       |~Ppattern           |provide a package matching |
|                         |                    |pattern.                   |
|_________________________|____________________|___________________________|
|?priority(priority)      |~ppriorité         |Select packages with the   |
|                         |                    |given priority.            |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?reverse-depType(pattern)|~R[depType:]pattern |the targets of a dependency|
|                         |                    |of type depType declared by|
|                         |                    |a package matching pattern.|
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?reverse-broken-depType  |                    |the targets of a broken    |
|(pattern)                |~RBdepType:pattern  |dependency of type depType |
|                         |                    |declared by a package      |
|                         |                    |matching pattern.          |
|_________________________|____________________|___________________________|
|?section(section)        |~ssection           |Select packages in the     |
|                         |                    |given section.             |
|_________________________|____________________|___________________________|
|                         |                    |Select packages whose      |
|?source-package(name)    |                   |source package name matches|
|                         |                    |the regular expression     |
|                         |                    |name.                      |
|_________________________|____________________|___________________________|
|                         |                    |Select packages whose      |
|?source-version(version) |                   |source version matches the |
|                         |                    |regular expression version.|
|_________________________|____________________|___________________________|
|?tag(tag)                |~Gmarqueur          |Select packages that have  |
|                         |                    |the given debtags tag.     |
|_________________________|____________________|___________________________|
|?true                    |~T                  |Select all packages.       |
|_________________________|____________________|___________________________|
|?task(task)              |~ttâche            |Select packages that are in|
|                         |                    |the given task.            |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?upgradable              |~U                  |installed and can be       |
|                         |                    |upgraded.                  |
|_________________________|____________________|___________________________|
|                         |                    |Select packages that are   |
|?user-tag                |                   |marked with a user-tag     |
|                         |                    |matching the regular       |
|                         |                    |expression user-tag.       |
|_________________________|____________________|___________________________|
|                         |                    |Select packages whose      |
|?version(version)        |~Vversion           |version matches version    |
|                         |                    |(special values: CURRENT,  |
|                         |                    |CANDIDATE, and TARGET).    |
|_________________________|____________________|___________________________|
|?virtual                 |~v                  |Select virtual packages.   |
|_________________________|____________________|___________________________|
|                         |                    |Select versions for which  |
|                         |                    |pattern matches any version|
|?widen(pattern)          |~Wpattern           |of the corresponding       |
|                         |                    |package, discarding local  |
|                         |                    |version restrictions.      |
|_________________________|____________________|___________________________|





  nom
      Est en correspondance avec les paquets dont le nom correspond  
      l'expression rationnelle nom. C'est le mode de recherche par
      « défaut », utilisé pour les motifs qui ne commencent pas par ~.


       [Note]  Note

               To match packages whose names contain several different
               substrings, use the ?name term (described below); for instance,
               « ?name(apti)?name(tude) » will match any package whose name
               contains both « apti » and « tude ».



  ?=variable
      Matches packages that correspond to the value of variable, which must be
      bound by an enclosing ?for. For instance, ?for x: ?depends( ?recommends
      ( ?=x ) ) will match any package x that depends on a package which
      recommends x.

      For instance, the following search expression matches packages that
      conflict with themselves:

      Exemple 2.1.  Use of the ?= term.

      ?for x: ?conflicts(?=x)


      See la section intitulée « Explicit search targets » for more
      information.


  ?not(pattern), !pattern
      Matches packages which do not match the pattern pattern. For instance,
      « ?not(?broken) » selects packages that are not « broken ».


       [Note]  Note

               To include a « ! » in a search string, it must be
               « escaped » by placing a tilde (« ~ ») in front of it;
               otherwise, aptitude will consider it to be part of a ?not term.
               For instance, to select packages whose description contains
               « extra! », use « ?description(extra~!) ».



  ?and(pattern1, pattern2), pattern1 pattern2
      Matches packages that match both pattern1 and pattern2.


  ?or(pattern1, pattern2), pattern1 | pattern2
      Matches packages that match either pattern1 or pattern2.


       [Note]  Note

               Pour inclure un « | » dans une expression rationnelle, il
               doit être « déspécialisé » pour éviter qu'aptitude ne
               fasse un OU logique sur les mots. Pour ce faire, écrivez
               « ~| ».



  (pattern)
      Matches pattern. For instance, « opengl (perl|python) » matches any
      package whose name contains opengl, and also contains either perl or
      python.


  ?action(action), ~aaction
      Correspond avec les paquets sur lesquels l'action donnée va être
      effectuée. Action peut être « install », « upgrade »,
      « downgrade », « remove », « purge », « hold » (si le
      paquet a été marqué   conserver), ou « keep » (si un paquet n'est
      pas modifié).

      Note that this only tests whether an action is actually queued up to be
      performed on a package, not whether it could be performed. Thus, for
      instance, ?action(upgrade) matches exactly those packages that you have
      already decided to upgrade, not packages which could be upgraded in the
      future (for that, use ?upgradable).


  ?all-versions(pattern)
      Matches any package whose versions all match the given expression. Each
      version of a package will be separately tested against pattern, and the
      package will match if all of its versions match. Packages without
      versions, such as virtual packages, will always be matched by this search
      term.

      This term may not be used in a context in which the versions to match
      against have already been narrowed, such as within ?depends or ?narrow.
      However, it may always be used within ?widen.


  ?any-version(pattern)
      Matches a package if any one of its versions matches the enclosed pattern.
      This is the dual to ?all-versions.

      This term may not be used in a context in which the versions to match
      against have already been narrowed, such as within ?depends or ?narrow.
      However, it may always be used within ?widen.


       [Note]  Note

               This term is closely related to ?narrow. In fact, ?any-version
               (pattern1 pattern2) is exactly the same as ?narrow(pattern1,
               pattern2).



  ?archive(archive), ~Aarchive
      Matches package versions which are available from an archive that matches
      the regular expression archive. For instance, « ?archive(testing) »
      matches any package available from the testing archive.


  ?automatic, ~M
      Correspond aux paquets qui ont été automatiquement installés.


   ?bind(variable, pattern), ?variable:term-name[(args)]
      Matches any package or version if the given pattern matches the package or
      version bound to variable, which must be defined in an enclosing ?for.

      Exemple 2.2. Use of the ?bind term

      ?for x: ?depends(?depends(?for z: ?bind(x, ?depends(?=z))))

      ?for x: ?depends(?depends(?for z: ?x:depends(?=z)))


      The two search patterns in the above example both match any package x such
      that x depends on a package y which in turn depends on a package z such
      that x also depends directly on z. The first pattern uses ?bind directly,
      while the second one uses an equivalent shorthand syntax.

      See la section intitulée « Explicit search targets » for more
      information.


  ?broken, ~b
      Correspond aux paquets qui sont « cassés » : ils cassent, ou ont une
      dépendance, une pré-dépendance, ou un conflit non satisfait.


  ?broken-depType, ~BdepType
      Matches packages which have an unfulfilled (« broken ») dependency of
      the given depType. depType can be « depends », « predepends »,
      « recommends », « suggests », « breaks », « conflicts »,
      or « replaces ».


  ?broken-depType(pattern), ~DB[depType:]pattern
      Matches packages with an unsatisfied dependency of type depType on a
      package matching pattern. depType may be any one of the dependency types
      listed in the documentation of ?broken-depType.


  ?conflicts(pattern), ~Cpattern
      Matches packages which conflict with a package matching the given pattern.
      For instance, « ?conflicts(?maintainer(dburrows@debian.org)) » matches
      any package which conflicts with a package I maintain.


  ?config-files, ~c
      Correspond aux paquets qui ont été supprimés mais dont les fichiers de
      configuration restent sur le système (c'est- -dire qu'ils ont été
      supprimés, mais pas purgés).


  ?depType(pattern), ~D[depType:]pattern
      depType may be any one of the dependency types given in the documentation
      of ?broken-depType, as well as provides: for instance, ?depends(libpng3)
      will match any package that depends on libpng3. If the short form (~D) is
      used and depType is not present, it defaults to depends.

      If depType is « provides », matches packages that provide a package
      matching pattern (the equivalent of ?provides). Otherwise, matches
      packages which declare a dependency of type depType upon a package version
      which matches pattern.


  ?description(description), ~ddescription
      Correspond aux paquets dont la description correspond   l'expression
      rationnelle description.


  ?essential, ~E
      Correspond aux paquets Essentiels.


  ?false, ~F
      This term does not match any package. [15]


  ?for variable: pattern
      Matches pattern, but the given variable may be used inside pattern to
      refer to the package or package version this term to.

      You can use variable in two ways. To apply a ?-style term to the variable,
      write ?variable:term-name(args); for instance, ?x:depends(apt). In
      addition, the term ?=variable will select any package or version that
      matches the value of the given variable.

      For instance, the following term will match any package x that both
      depends and recommends a second package y.

      Exemple 2.3. Use of the ?for term

      ?for x: ?depends( ?for y: ?x:recommends( ?=y ) )


      See la section intitulée « Explicit search targets » for more
      information.


  ?garbage, ~g
      Correspond aux paquets qui ne sont pas installés, ou qui ont été
      installés automatiquement mais desquels aucun paquet installé ne
      dépend.


  ?installed, ~i
      Correspond aux paquets qui sont actuellement installés.

      Bien que par défaut toutes les versions sont testées, ceci n'entre en
      correspondance qu'avec les paquets installés.


  ?maintainer(maintainer), ~mmaintainer
      Matches packages whose Maintainer field matches the regular expression
      maintainer. For instance, « ?maintainer(joeyh) » will find all
      packages maintained by Joey Hess.


   ?narrow(filter, pattern), ~S filter pattern
      This term « narrows » the search to package versions matching filter.
      In particular, it matches any package version which matches both filter
      and pattern. The string value of the match is the string value of pattern.


  ?name(name), ~nname
      Matches packages whose name matches the regular expression name. For
      instance, most of the packages that match « ?name(^lib) » are
      libraries of one sort or another.


  ?new, ~N
      Matches packages which are « new »: that is, they have been added to
      the archive since the last time the list of packages was cleared using
      Actions ->; Oublier quels paquets sont nouveaux (f) or the command-
      line action forget-new.


   ?obsolete, ~o
      Ce mot correspond   tout paquet installé qui n'est disponible dans
      aucune version d'une quelconque archive. Ces paquets apparaissent dans
      l'interface visuel en tant que « Obsolete ou installé localement »


  ?origin(origin), ~Oorigin
      Matches package versions whose origin matches the regular expression
      origin. For instance, « !?origin(debian) » will find any unofficial
      packages on your system (packages not from the Debian archive).


  ?provides(pattern), ~Ppattern
      Matches package versions which provide a package that matches the pattern.
      For instance, « ?provides(mail-transport-agent) » will match all the
      packages that provide « mail-transport-agent ».


  ?priority(priority), ~ppriority
      Matches packages whose priority is priority; priority must be extra,
      important, optional, required, or standard. For instance, « ?priority
      (required) » matches packages whose priority is « required ».


  ?reverse-depType(pattern), ~R[depType:]pattern
      depType may be either « provides » or one of the dependency types
      given in the documentation of ?broken-depType. If depType is not present,
      it defaults to depends.

      If depType is « provides », matches packages whose name is provided by
      a package version matching pattern. Otherwise, matches packages which a
      package version matching pattern declares a dependency of type depType
      upon.


  ?reverse-broken-depType(pattern), ?broken-reverse-depType(pattern), ~RB
  [depType:]pattern
      depType may be either « provides » or one of the dependency types
      given in the documentation of ?broken-depType. If depType is not present,
      it defaults to depends.

      Matches packages which a package version matching pattern declares an
      unsatisfied dependency of type depType upon.


   ?section(section), ~ssection
      Correspond aux paquets dont la section correspond   l'expression
      rationnelle section.


   ?source-package(name)
      Matches packages whose source package name matches the regular expression
      name.


   ?source-version(version)
      Matches packages whose source version matches the regular expression
      version.


  ?tag(tag), ~Gtag
      Matches packages whose Tag field matches the regular expression tag. For
      instance, the pattern ?tag(game::strategy) would match strategy games.

      Pour plus d'informations sur l'étiquetage et debtags, consultez http://
      debtags.alioth.debian.org.


   ?task(task), ~ttask
      Correspond aux paquets qui font partie d'une tâche dont le nom correspond
        l'expression rationnelle tâche.


   ?true, ~T
      This term matches any package. For instance, « ?installed?provides
      (?true) » matches installed packages which are provided by any package.


   ?upgradable, ~U
      Ce mot correspond   tout paquet installé qui peut être mis   jour.


   ?user-tag(tag)
      This term matches any package that is marked with a user-tag matching the
      regular expression tag.


   ?version(version), ~Vversion
      Matches any package version whose version number matches the regular
      expression version, with the exceptions noted below. For instance,
      « ?version(debian) » matches packages whose version contains
      « debian ».

      Les valeurs suivantes de version sont traitées spécialement. Pour
      rechercher une version contenant ces valeurs, faites les précéder d'une
      barre oblique inverse ; par exemple, pour rechercher des paquets dont le
      numéro de version contient « CURRENT », rechercher « \CURRENT ».


      * CURRENT correspond   la version actuellement installée d'un paquet,
        s'il y en a une.

      * CANDIDATE correspond   la version, si elle existe, du paquet qui sera
        installée si vous appuyez sur + quand le paquet est sélectionné ou si
        vous lancez aptitude install avec son nom.

      * TARGET correspond   la version d'un paquet dont l'installation est
        prévue, si elle existe.



   ?virtual, ~v
      Matches any package which is purely virtual: that is, its name is provided
      by a package or mentioned in a dependency, but no package of that name
      exists. For instance, « ?virtual!?provides(?true) » matches packages
      which are virtual and are not provided by any package: ie, packages which
      are depended upon but do not exist.


   ?widen(pattern), ~Wpattern
      « Widens » the match: if the versions to match against have been
      limited by an enclosing term (such as ?depends), these limits are dropped.
      Thus, ?widen(pattern) matches a package version if pattern matches any
      version of that package.



Personnalisation d'aptitude


Personnaliser la liste des paquets

La liste de paquets peut être énormément personnalisée : la manière
d'afficher les paquets, de les ranger, de les trier et même l'organisation de
l'affichage sont toutes modifiables.


Personnaliser la manière d'afficher les paquets

This section describes how to configure the contents and format of the package
list, status line, and header line, as well as the output of aptitude search.

Le format de chacune de ces zones est défini par une « chaîne de format ».
Une chaîne de format est une chaîne de texte contenant des commandes de format
débutant par % comme %p, %S, etc. L'affichage correspondant est créé en
remplaçant les commandes débutant par % en fonction de leur signification
(donnée ci-dessous).

Une commande de format (commençant par %) peut soit avoir une taille fixe et
dans ce cas elle est toujours remplacée par la même quantité de texte (avec
l'ajout d'espaces pour le compléter si nécessaire), soit elle est
« étirable » ce qui signifie qu'elle prend tout l'espace laissé libre par
les colonnes de texte   taille fixe. S'il y a plusieurs colonnes étirables,
l'espace supplémentaire est divisé équitablement entre les colonnes.

Toutes les commandes de format possèdent une taille fixe et/ou étirable par
défaut. La taille d'une commande de format peut être modifiée en insérant la
valeur de la taille voulue entre le signe pourcentage (%) et le caractère
identifiant le format. Par exemple, %20V produit une colonne version installable
des paquets d'une largeur de 20 caractères. Placer un point d'interrogation (?)
entre le signe % et le caractère identifiant la commande de format entraîne la
variation de la largeur de base de la colonne en fonction de son contenu.
Remarquez, néanmoins, que les colonnes de ce type risque de ne plus s'aligner
verticalement.

Si vous souhaitez qu'une commande de format soit étirable, même si elle
possède normalement une largeur fixe, placez un signe dièse (« # »)
immédiatement après elle. Par exemple, pour afficher la version installable
d'un paquet sans vous soucier de sa longueur, utilisez la commande de format
%V#. Vous pouvez aussi mettre un # après autre chose qu'une commande de
format ; aptitude va alors « étirer » le texte qui précède le # en
insérant des espaces additionnelles après lui.

En résumé, la syntaxe des commandes de format est :

%[largeur][?]code[#]

The configuration variables Aptitude::UI::Package-Display-Format, Aptitude::UI::
Package-Status-Format, and Aptitude::UI::Package-Header-Format define the
default formats the package list, the header at the top of the package list, and
the status line below the package list respectively. To change how the results
of an aptitude search command are displayed, use the -F option.

Les commandes de format (débutant par %) suivantes sont disponibles :


 [Note]  Note

         Plusieurs des descriptions ci-dessous font référence « au
         paquet ». Avec l'interface graphique, c'est soit le paquet qui est
         affiché, soit le paquet actuellement sélectionné. Dans la recherche
         avec l'interface en ligne de commande, c'est le paquet qui est
         affiché.



Commande Nom                 Taille par défaut Étirable Description

                                                          Ce n'est pas vraiment
                                                          une commande de
                                                          format, cela insère
%%       % littéral         1                  Non       simplement un signe
                                                          pourcentage dans
                                                          l'affichage  
                                                          l'endroit où elle est
                                                          placée.

                                                          Dans certaines
                                                          circonstances, une
                                                          chaîne de format
                                                          d'affichage comportera
                                                          des
                                                          « paramètres » :
                                                          par exemple, dans la
                                                          ligne de commande
%#nombre Remplacement de     Variable           Non       search, les groupes
         paramètre                                       correspondants   la
                                                          recherche sont
                                                          utilisés comme
                                                          paramètres lors de
                                                          l'affichage du
                                                          résultat. Le code de
                                                          format sera remplacé
                                                          par le paramètre
                                                          indiqué par nombre.

                                                          Caractère unique
                                                          résumant l'action  
                                                          exécuter sur le
%a       Marque d'action     1                  Non       paquet, comme décrit
                                                          dans Figure 2.10,
                                                          « Valeurs de
                                                          l'indicateur
                                                          « d'action » ».

                                                          Description plus
%A       Action              10                 Non       lisible de l'action  
                                                          exécuter sur le
                                                          paquet.

                                                          S'il n'y a pas de
                                                          paquet cassé, cela ne
                                                          produit rien. Sinon,
%B       Comptage des        12                 Non       cela produit une
         cassés                                          chaîne telle que
                                                          « Cassé : 10 »
                                                          indiquant le nombre de
                                                          paquets cassés.

                                                          Caractère unique
                                                          résumant l'état
                                                          actuel du paquet,
         Marqueur d'état                                 comme décrit dans
%c       actuel              1                  Non       Figure 2.9,
                                                          « Valeurs de
                                                          l'indicateur de
                                                          « l'état
                                                          courant » ».

                                                          Description plus
%C       État actuel        11                 Non       lisible de l'état
                                                          actuel du paquet.

%d       Description         40                 Oui       Description courte du
                                                          paquet.

%D       Taille du paquet    6                  Non       Taille de l'archive
                                                          contenant le paquet.

                                                          Nom d'hôte de
%H       Nom d'hôte         15                 Non       l'ordinateur sur
                                                          lequel aptitude
                                                          fonctionne.

                                                          Affiche la priorité
                                                          maximale assignée  
                                                          la version du paquet.
                                                          Pour les paquets, cela
%i       Priorité (Pin      4                  Non       affiche la priorité
         priority)                                        de la version dans
                                                          laquelle le paquet est
                                                          forcé d'être
                                                          installé (s'il y en a
                                                          une).

                                                          Espace (estimé) que
%I       Taille installée   6                  Non       prend le paquet sur le
                                                          disque.

%m       Responsable         30                 Oui       Responsable du paquet.

                                                          Si le paquet a été
         Marquage                                         installé
%M       automatique         1                  Non       automatiquement,
                                                          affiche « A »,
                                                          sinon n'affiche rien.

                                                          Outputs the version of
%n       Version du          Longueur de        Non       aptitude that is
         programme           « 0.4.11.11 »            running, currently
                                                          « 0.4.11.11 ».

                             The length of the            Outputs the name of
%N       Nom du programme    name.              Non       the program; usually
                                                          « aptitude ».

                                                          Si aucun paquet ne
                                                          doit être installé,
                                                          n'affiche rien. Sinon,
                                                          affiche une chaîne
                                                          indiquant la taille
         Taille                                          totale prise par les
%o       télécharger       15                 Non       paquets   installer
                                                          (c'est- -dire une
                                                          estimation de ce qu'il
                                                          faut télécharger) ;
                                                          par exemple,
                                                          « 28,5ko  
                                                          télécharger ».

                                                          Affiche le nom du
                                                          paquet. Quand un
                                                          paquet est affiché
%p       Nom du paquet       30                 Oui       dans une arborescence,
                                                          le nom sera indenté,
                                                          si possible, en
                                                          fonction de la
                                                          profondeur de l'arbre.

%P       Priorité           9                  Non       Affiche la priorité
                                                          du paquet.

         Compteur des                                     Affiche le nombre
%r       dépendances        2                  Non       approximatif de
         inverses                                         paquets installés qui
                                                          dépendent du paquet.

                                                          Affiche la description
                                                          abrégée de la
%R       Abréviation de la  3                  Non       priorité du paquet :
         priorité                                        par exemple,
                                                          « Important »
                                                          devient « Imp ».

%s       Section             10                 Non       Affiche la section du
                                                          paquet.

                                                          Si le paquet n'est pas
%S       Niveau de confiance 1                  Non       certifié par une
                                                          source de confiance,
                                                          affiche la lettre "U".

%t       Archive             10                 Oui       Archive dans laquelle
                                                          se trouve le paquet.

                                                          Outputs « * » if
%T       Étiqueté          1                  Non       the package is tagged,
                                                          nothing otherwise.[16]

                                                          Si l'action prévue
                                                          doit modifier l'espace
         Modification de                                  disque utilisé, cela
%u       l'utilisation du    30                 Non       indique le changement,
         disque                                           par exemple,
                                                          « Utilisera 100,0Mo
                                                          d'espace disque. »

                                                          Affiche la version
                                                          actuellement
                                                          installée du paquet,
%v       Version actuelle    10                 Non       ou <aucun> si le
                                                          paquet n'est pas
                                                          actuellement
                                                          installé.

                                                          Affiche la version du
                                                          paquet qui serait
                                                          installée si Paquet
                                                          ->; Installer (+)
%V       Version installable 10                 Non       était exécuté sur
                                                          le paquet, ou <aucun>
                                                          si le paquet n'est pas
                                                          actuellement
                                                          installé.

                                                          Affiche l'espace
                                                          supplémentaire
         Changement de                                    utilisé ou l'espace
%Z       taille              7                  Non       libéré par
                                                          l'installation, la
                                                          mise   jour ou la
                                                          suppression du paquet.



Personnaliser la hiérarchie des paquets

La hiérarchie des paquets est produite par une politique de regroupement : des
règles décrivant la manière de construire la hiérarchie. La politique de
regroupement décrit une « succession » de règles. Chaque règle peut
retirer des paquets, créer une sous-hiérarchie dans laquelle on place des
paquets ou encore manipuler l'arborescence. Les variables de configuration
Aptitude::UI::Default-Grouping et Aptitude::UI::Default-Preview-Grouping
définissent les politiques de regroupement lors de la création,
respectivement, de nouvelles listes de paquets et de nouveaux écrans de
prévisualisation. Vous pouvez définir la politique de regroupement pour la
liste de paquets actuelle en appuyant sur G.

La politique de regroupement est décrite par une liste de règles séparées
par des virgules : règle1,règle2,.... Chaque règle est constituée du nom de
la règle, éventuellement suivi d'arguments : par exemple, versions ou section
(subdir). Le fait que des arguments soient requis et le nombre d'arguments
requis (ou permis) dépend du type de règle.

Une règle peut être non terminale ou terminale. Une règle non terminale va
traiter un paquet en produisant une partie de la hiérarchie, puis en le passant
  la règle suivante. Une règle terminale, au contraire, va aussi traiter une
partie de l'arborescence (typiquement les entrées correspondant au paquet),
mais ne passera pas le paquet   la règle qui suit. Si aucune règle terminale
n'est spécifiée, aptitude va utiliser la règle par défaut qui crée les
« entrées de paquet » standards.



  action

      Regroupe les paquets suivant l'action prévue sur ceux-ci. Les paquets qui
      ne peuvent être mis   jour ou qui sont inchangés sont ignorés. C'est
      le regroupement qui est utilisé dans l'arborescence d'aperçu
      d'installation.


  deps

      C'est une règle terminale.

      Crée les entrées de paquets standard qui peuvent être dépliées pour
      laisser apparaître les dépendances d'un paquet.


  filter(motif)

      N'inclut que les paquets dont au moins une version correspond   motif.

      Si motif est manquant, aucun paquet n'est écarté. Ceci est une
      fonctionnalité de compatibilité ascendante et peut être supprimée dans
      le futur.


  firstchar

      Regroupe les paquets en fonction de la première lettre de leur nom.


  hier

      Regroupe les paquets en fonction d'un fichier de données annexe qui
      décrit une « hiérarchie » de paquets.


  pattern(motif [=> titre][, ...])

      Une politique de regroupement personnalisable. Chaque version de chaque
      paquet est mise en correspondance avec les motifs donnés. La première
      correspondance trouvée est utilisée pour assigner un titre au paquet ;
      les paquets sont alors triés selon leur titre. Les chaînes de la forme
      \N qui apparaissent dans le titre seront remplacées par le Nième
      résultat de la recherche. Si titre est absent, sa valeur par défaut est
      alors \1.

      For instance, pattern(?maintainer() => \1) will group packages according
      to their Maintainer field. The policy pattern(?maintainer()) will do the
      same thing, as the absent title defaults to \1.

      Instead of => title, an entry may end with ||. This indicates that
      packages matching the corresponding pattern will be inserted into the tree
      at the same level as the pattern grouping, rather than being placed in
      subtrees. For instance, pattern(?action(remove) => Packages Being Removed,
      ?true ||) will place packages that are being removed into a subtree, and
      place all the other packages at the current level. Any later grouping
      policies will apply to both sets of packages, of course.

      Consultez la section la section intitulée « Motifs de recherche »
      pour plus d'information sur le format de motif.


  priority

      Regroupe les paquets en fonction de leur priorité.


  section[(mode[,passthrough])]

      Regroupe les paquets en fonction de leur champ Section.

      mode peut prendre les valeurs suivantes :



        none
            Group based on the whole Section field, so categories like « non-
            free/games » will be created. This is the default if no mode is
            specified.


        topdir
            Group based on the part of the Section field before the first /
            character; if this part of the Section is not recognized, or if
            there is no /, the first entry in the list Aptitude::Sections::Top-
            Sections will be used instead.


        subdir
            Group based on the part of the Section field after the first /
            character, if it is contained in the list Aptitude::Sections::Top-
            Sections. If not, or if there is no /, group based on the entire
            Section field instead.


        subdirs
            Group based on the part of the Section field after the first /
            character, if the portion of the field preceding it is contained in
            the list Aptitude::Sections::Top-Sections; if not, or if there is no
            /, the entire field will be used. If there are multiple / characters
            in the portion of the field that is used, a hierarchy of groups will
            be formed. For instance, if « games » is not a member of
            Aptitude::Sections::Top-Sections, then a package with a section of
            « games/arcade » will be placed under the top-level heading
            « games », in a sub-tree named « arcade ».


      Si passthrough est présent, les paquets qui, pour une raison ou une
      autre, ne possèdent pas de véritable Section (par exemple, les paquets
      virtuels) sont passés directement au niveau de regroupement suivant sans
      être placés en premier dans une sous-catégorie.


  status

      Trie les paquets dans les catégories suivantes :


      * Installés

      * Non installés

      * Mise   jour de sécurité

      * Pouvant être mis   jour

      * Obsolètes ou créés localement

      * Virtuels



  tag[(aspect)]

      Regroupe les paquets en fonction de l'information du champ Marqueur
      contenu dans les fichiers de paquets Debian. Si aspect est fourni, alors
      seuls les marqueurs correspondants   cet aspect seront affichés. Sinon,
      tous les paquets seront affichés au moins une fois (les paquets sans
      marqueur seront placés dans une liste séparée de ceux qui en ont).

      Pour plus d'informations sur debtags, consultez le site http://
      debtags.alioth.debian.org.


  task

      Crée une arborescence appelée « Tâches » qui contient les tâches
      disponibles (les informations sur les tâches sont lues depuis debian-
      tasks.desc du paquet tasksel). La règle suivant task va créer ses
      catégories comme des enfants de Tâches.


  versions

      C'est une règle terminale.

      Crée des entrées de paquets standard qui peuvent être dépliées pour
      laisser apparaître les versions du paquet.



Personnaliser la manière de trier les paquets

By default, packages in the package list or in the output of aptitude search are
sorted by name. However, it is often useful to sort them according to different
criteria (for instance, package size), and aptitude allows you to do just that
by modifying the sorting policy.

Comme la politique de regroupement décrite dans la section précédente, la
politique de tri est une liste séparée par des virgules. Chaque entrée de la
liste est le nom d'une règle de tri ; si les paquets sont identiques selon la
première règle, la seconde tente de les trier, et ainsi de suite. Placer un
caractère tilde (~) avant la règle inverse la signification habituelle de la
règle. Par exemple, priority,~name va trier les paquets par priorité, et les
paquets de même priorité seront placés dans l'ordre alphabétique inverse.

To change the sorting policy for an active package list, press S. To change the
default sorting for all package lists, set the configuration option Aptitude::
UI::Default-Sorting. To change the sorting policy for aptitude search, use the -
-sort command-line option.

Les règles disponibles sont :



  installsize
      Trie les paquets selon l'estimation de la taille nécessaire  
      l'installation.


  name
      Trie les paquets selon leur nom.


  priority
      Trie les paquets selon leur priorité.


  version
      Trie les paquets selon leur version.



Personnaliser les raccourcis clavier

Les touches utilisées pour lancer des commandes d'aptitude peuvent être
personnalisées dans le fichier de configuration. Chaque commande possède une
variable de configuration associée sous Aptitude::UI::Keybindings. Pour changer
la séquence de touches liée   une commande, il suffit de modifier la variable
correspondant   la séquence de touches. Par exemple, pour associer la touche s
  une recherche, mettez Aptitude::UI::Keybindings::Search   « s ». Vous
pouvez demander   ce que la touche Contrôle soit aussi enfoncé en plaçant
« C- » devant la touche : par exemple mettre « C-s »   la place de
« s » va lier la recherche   la recherche   Contrôle+s au lieu de s.
Enfin, vous pouvez lier une commande   plusieurs séquences de touches en une
seule fois en les séparant par des virgules : par exemple utiliser « s,C-
s » aura pour conséquence que s et Contrôle+s lanceront une recherche.

Les commandes suivantes peuvent être liées   une séquence de touches en
configurant les variables Aptitude::UI::Keybindings::commande, où commande est
le nom de la commande   lier :

 ______________________________________________________________________________
|Commande              |Valeur par défaut|Description                         |
|______________________|__________________|____________________________________|
|                      |                  |Si des paquets sont cassés et      |
|ApplySolution         |!                 |aptitude a suggéré une solution au|
|                      |                  |problème, applique immédiatement  |
|                      |                  |la solution.                        |
|______________________|__________________|____________________________________|
|                      |                  |Se déplace au début de l'affichage|
|Begin                 |home,C-a          |courant : au début de la liste ou |
|                      |                  |  gauche d'un champ de saisie de   |
|                      |                  |texte.                              |
|______________________|__________________|____________________________________|
|                      |                  |Envoie un rapport de bogue contre le|
|BugReport             |B                 |paquet couramment sélectionné, en |
|                      |                  |utilisant reportbug.                |
|______________________|__________________|____________________________________|
|                      |                  |Annule l'interaction courante. Par  |
|Cancel                |C-g,escape,C-[    |exemple, sort d'une boîte de       |
|                      |                  |dialogue ou du menu.                |
|______________________|__________________|____________________________________|
|                      |                  |Affiche le fichier changelog.Debian |
|Changelog             |C                 |du paquet actuellement sélectionné|
|                      |                  |ou de la version du paquet.         |
|______________________|__________________|____________________________________|
|                      |                  |Change la politique de regroupement |
|ChangePkgTreeGrouping |G                 |de la liste de paquets actuellement |
|                      |                  |active.                             |
|______________________|__________________|____________________________________|
|                      |                  |Change la restriction d'affichage de|
|ChangePkgTreeLimit    |l                 |la liste de paquets actuellement    |
|                      |                  |active.                             |
|______________________|__________________|____________________________________|
|                      |                  |Change la politique de tri de la    |
|ChangePkgTreeSorting  |S                 |liste de paquets actuellement       |
|                      |                  |active.                             |
|______________________|__________________|____________________________________|
|                      |                  |Marque le paquet actuellement       |
|ClearAuto             |m                 |sélectionné comme ayant été     |
|                      |                  |installé manuellement.             |
|______________________|__________________|____________________________________|
|                      |                  |Replie toute l'arborescence         |
|CollapseAll           |]                 |sélectionnée dans une liste       |
|                      |                  |hiérarchique.                      |
|______________________|__________________|____________________________________|
|                      |                  |Replie la racine de l'arborescence  |
|CollapseTree          |Aucune séquence  |sélectionnée dans une liste       |
|                      |                  |hiérarchique.                      |
|______________________|__________________|____________________________________|
|                      |                  |Dans l'éditeur de hiérarchie garde|
|Commit                |N                 |en mémoire l'emplacement           |
|                      |                  |hiérarchique du paquet actuel et   |
|                      |                  |passe au paquet suivant.            |
|______________________|__________________|____________________________________|
|                      |                  |Dans les boîtes de dialogue, c'est |
|                      |                  |équivalent   « Ok ». Lors     |
|Confirm               |enter             |d'une interaction en ligne de       |
|                      |                  |commande avec une question   choix |
|                      |                  |multiples, cela choisit l'option par|
|                      |                  |défaut.                            |
|______________________|__________________|____________________________________|
|Cycle                 |tab               |Change le focus clavier vers le     |
|                      |                  |« widget » suivant.             |
|______________________|__________________|____________________________________|
|CycleNext             |f6                |Change vers la vue active suivante. |
|______________________|__________________|____________________________________|
|CycleOrder            |o                 |Circule parmi des éléments        |
|                      |                  |prédéfinis de l'affichage.        |
|______________________|__________________|____________________________________|
|CyclePrev             |f7                |Change vers la vue active           |
|                      |                  |précédente.                       |
|______________________|__________________|____________________________________|
|DelBOL                |C-u               |Supprime tout le texte entre le     |
|                      |                  |curseur et le début de la ligne.   |
|______________________|__________________|____________________________________|
|DelBack               |backspace,C-h     |Supprime le caractère précédent  |
|                      |                  |lors de la saisie de texte.         |
|______________________|__________________|____________________________________|
|DelEOL                |C-k               |Supprime tout le texte depuis le    |
|                      |                  |curseur jusqu'  la fin de la ligne.|
|______________________|__________________|____________________________________|
|DelForward            |delete,C-d        |Supprime le caractère sous le      |
|                      |                  |curseur lors de la saisie de texte. |
|______________________|__________________|____________________________________|
|Dependencies          |d                 |Affiche les dépendances du paquet  |
|                      |                  |actuellement sélectionné.         |
|______________________|__________________|____________________________________|
|                      |                  |Dans la liste de paquets, alterne   |
|DescriptionCycle      |i                 |les vues disponibles dans la zone   |
|                      |                  |d'information.                      |
|______________________|__________________|____________________________________|
|                      |                  |Dans la liste de paquets, descend   |
|DescriptionDown       |z                 |d'une ligne dans la zone            |
|                      |                  |d'information.                      |
|______________________|__________________|____________________________________|
|                      |                  |Dans la liste de paquets, monte     |
|DescriptionUp         |a                 |d'une ligne dans la zone            |
|                      |                  |d'information.                      |
|______________________|__________________|____________________________________|
|                      |                  |If not in a preview screen, display |
|DoInstallRun          |g                 |the preview screen [a]; if in a     |
|                      |                  |preview screen, perform an install  |
|                      |                  |run.                                |
|______________________|__________________|____________________________________|
|                      |                  |Descend : par exemple, descend dans|
|Down                  |down,j            |un affichage de texte, ou           |
|                      |                  |sélectionne l'entrée suivante dans|
|                      |                  |une liste.                          |
|______________________|__________________|____________________________________|
|                      |                  |Lance « dpkg-reconfigure » sur  |
|DpkgReconfigure       |R                 |le paquet actuellement              |
|                      |                  |sélectionné.                      |
|______________________|__________________|____________________________________|
|                      |                  |Si des paquets sont cassés, écrit |
|DumpResolver          |*                 |l'état actuel du solveur de        |
|                      |                  |problème dans un fichier (pour des |
|                      |                  |raisons de débogage).              |
|______________________|__________________|____________________________________|
|EditHier              |E                 |Ouvre l'éditeur hiérarchique.     |
|______________________|__________________|____________________________________|
|                      |                  |Se déplace   la fin de l'affichage|
|End                   |end,C-e           |courant :   la fin de la liste ou |
|                      |                  |  droite d'un champ de saisie de   |
|                      |                  |texte.                              |
|______________________|__________________|____________________________________|
|                      |                  |Si des paquets sont cassés et      |
|                      |                  |qu'aptitude a suggéré une solution|
|ExamineSolution       |e                 |au problème, affiche une boîte de |
|                      |                  |dialogue contenant une description  |
|                      |                  |détaillée de la solution.         |
|______________________|__________________|____________________________________|
|                      |                  |Déploie toute l'arborescence       |
|ExpandAll             |[                 |sélectionnée dans une liste       |
|                      |                  |hiérarchique.                      |
|______________________|__________________|____________________________________|
|                      |                  |Déploie la racine de l'arborescence|
|ExpandTree            |Aucune séquence  |sélectionnée dans une liste       |
|                      |                  |hiérarchique.                      |
|______________________|__________________|____________________________________|
|                      |                  |Sélectionne la première solution  |
|FirstSolution         |<                 |générée par le solveur de        |
|                      |                  |problème.                          |
|______________________|__________________|____________________________________|
|                      |                  |Interdit   un paquet d'être mis  |
|ForbidUpgrade         |F                 |jour vers la version actuelle d'un  |
|                      |                  |paquet (ou une version              |
|                      |                  |particulière).                     |
|______________________|__________________|____________________________________|
|                      |                  |Oublie quels paquets sont           |
|ForgetNewPackages     |f                 |« nouveaux » (ce qui implique   |
|                      |                  |que la liste des « nouveaux »   |
|                      |                  |paquets devienne vide).             |
|______________________|__________________|____________________________________|
|Help                  |?                 |Affiche l'aide en ligne   l'écran.|
|______________________|__________________|____________________________________|
|                      |                  |Dans un éditeur comportant un      |
|HistoryNext           |down,C-n          |historique, descend dans            |
|                      |                  |l'historique.                       |
|______________________|__________________|____________________________________|
|                      |                  |Dans un éditeur comportant un      |
|HistoryPrev           |up,C-p            |historique, remonte dans            |
|                      |                  |l'historique.                       |
|______________________|__________________|____________________________________|
|Hold                  |=                 |Gèle un paquet.                    |
|______________________|__________________|____________________________________|
|Install               |+                 |Marque un paquet pour installation. |
|______________________|__________________|____________________________________|
|                      |                  |Marque un unique paquet pour        |
|InstallSingle         |I                 |installation. Tous les autres       |
|                      |                  |paquets sont gardés dans leur      |
|                      |                  |version actuelle.                   |
|______________________|__________________|____________________________________|
|Keep                  |:                 |Annule toute demande d'installation |
|                      |                  |ou de suppression d'un paquet.      |
|______________________|__________________|____________________________________|
|                      |                  |Sélectionne la dernière solution  |
|LastSolution          |<                 |générée par le solveur de        |
|                      |                  |problème.                          |
|______________________|__________________|____________________________________|
|                      |                  |Se déplace vers la gauche : par   |
|                      |                  |exemple, se déplace vers la gauche |
|Left                  |left,h            |dans la barre de menu, ou déplace  |
|                      |                  |le curseur vers la gauche lors de la|
|                      |                  |saisie de texte.                    |
|______________________|__________________|____________________________________|
|                      |                  |Dans une liste hiérarchique,       |
|                      |                  |sélectionne l'enfant suivant       |
|LevelDown             |J                 |l'entrée actuellement              |
|                      |                  |sélectionnée (l'entrée suivante  |
|                      |                  |au même niveau avec le même       |
|                      |                  |parent).                            |
|______________________|__________________|____________________________________|
|                      |                  |Dans une liste hiérarchique,       |
|                      |                  |sélectionne l'enfant précédent   |
|LevelUp               |K                 |l'entrée actuellement              |
|                      |                  |sélectionnée (l'entrée           |
|                      |                  |précédente au même niveau avec le|
|                      |                  |même parent).                      |
|______________________|__________________|____________________________________|
|                      |                  |Tente de mettre   jour tous les    |
|MarkUpgradable        |U                 |paquets qui ne sont pas bloqués ou |
|                      |                  |interdits de mise   jour.          |
|______________________|__________________|____________________________________|
|MineFlagSquare        |f                 |Dans le démineur, place ou enlève |
|                      |                  |le drapeau d'une case.              |
|______________________|__________________|____________________________________|
|MineLoadGame          |L                 |Charge une partie de démineur.     |
|______________________|__________________|____________________________________|
|MineSaveGame          |S                 |Sauvegarde une partie de démineur. |
|______________________|__________________|____________________________________|
|MineSweepSquare       |Aucune séquence  |Fait le ménage autour de la case   |
|                      |                  |actuelle dans le démineur.         |
|______________________|__________________|____________________________________|
|MineUncoverSquare     |Aucune séquence  |Découvre la case actuelle dans le  |
|                      |                  |démineur                           |
|______________________|__________________|____________________________________|
|                      |                  |Découvre la case actuelle dans le  |
|MineUncoverSweepSquare|enter             |démineur si elle est couverte,     |
|                      |                  |sinon fait le ménage autour d'elle.|
|______________________|__________________|____________________________________|
|NextPage              |pagedown,C-f      |Va   la page suivante de           |
|                      |                  |l'affichage courant.                |
|______________________|__________________|____________________________________|
|NextSolution          |.                 |Va   la solution suivante du       |
|                      |                  |solveur de dépendance.             |
|______________________|__________________|____________________________________|
|No                    |n[b]              |Sélectionne la réponse « non »|
|                      |                  |dans une boîte de dialogue oui/non.|
|______________________|__________________|____________________________________|
|                      |                  |Sélectionne le parent de l'entrée |
|Parent                |^                 |sélectionnée dans une liste       |
|                      |                  |hiérarchique.                      |
|______________________|__________________|____________________________________|
|PrevPage              |pageup,C-b        |Va   la page précédente de       |
|                      |                  |l'affichage courant.                |
|______________________|__________________|____________________________________|
|PrevSolution          |,                 |Revient   la solution précédente |
|                      |                  |du solveur de dépendance.          |
|______________________|__________________|____________________________________|
|Purge                 |_                 |Marque le paquet actuellement       |
|                      |                  |sélectionné pour purge.           |
|______________________|__________________|____________________________________|
|                      |                  |Active le bouton actuellement       |
|PushButton            |space,enter       |sélectionné, ou modifie l'état   |
|                      |                  |d'une boîte   cocher.             |
|______________________|__________________|____________________________________|
|Quit                  |q                 |Ferme la vue actuelle.              |
|______________________|__________________|____________________________________|
|QuitProgram           |Q                 |Quitte le programme.                |
|______________________|__________________|____________________________________|
|                      |                  |Reject all resolver actions that    |
|RejectBreakHolds      |                 |would break a hold; equivalent to   |
|                      |                  |Resolver ->; Reject Breaking    |
|                      |                  |Holds.                              |
|______________________|__________________|____________________________________|
|Refresh               |C-l               |Redessine la totalité de l'écran. |
|______________________|__________________|____________________________________|
|Remove                |-                 |Marque un paquet pour suppression.  |
|______________________|__________________|____________________________________|
|ReInstall             |L                 |Marque le paquet actuellement       |
|                      |                  |sélectionné pour réinstallation. |
|______________________|__________________|____________________________________|
|RepeatSearchBack      |N                 |Répète la dernière recherche,    |
|                      |                  |mais dans la direction opposée.    |
|______________________|__________________|____________________________________|
|ReSearch              |n                 |Répète la dernière recherche.    |
|______________________|__________________|____________________________________|
|                      |                  |Affiche les paquets qui dépendent  |
|ReverseDependencies   |r                 |du paquet actuellement              |
|                      |                  |sélectionné.                      |
|______________________|__________________|____________________________________|
|                      |                  |Se déplace vers la droite : par   |
|                      |                  |exemple, se déplace vers la droite |
|Right                 |right,l           |dans la barre de menu, ou déplace  |
|                      |                  |le curseur vers la droite lors de la|
|                      |                  |saisie de texte.                    |
|______________________|__________________|____________________________________|
|SaveHier              |S                 |Dans l'éditeur de hiérarchie,     |
|                      |                  |sauvegarde la hiérarchie actuelle. |
|______________________|__________________|____________________________________|
|                      |                  |Active la fonction de               |
|Search                |/                 |« recherche » sur l'élément de|
|                      |                  |l'interface actuellement actif.     |
|______________________|__________________|____________________________________|
|                      |                  |Active la fonction de « recherche |
|SearchBack            |\                 |arrière » sur l'élément de     |
|                      |                  |l'interface actuellement actif.     |
|______________________|__________________|____________________________________|
|SearchBroken          |b                 |Dans une arborescence de paquets,   |
|                      |                  |recherche le paquet cassé suivant. |
|______________________|__________________|____________________________________|
|SetAuto               |M                 |Marque le paquet courant comme ayant|
|                      |                  |été automatiquement installé.    |
|______________________|__________________|____________________________________|
|                      |                  |Dans une liste de paquets, définit |
|ShowHideDescription   |D                 |si la zone d'information est visible|
|                      |                  |ou non.                             |
|______________________|__________________|____________________________________|
|                      |                  |Lors de l'affichage d'une solution, |
|                      |                  |marque l'action actuellement        |
|SolutionActionApprove |a                 |sélectionnée comme                |
|                      |                  |« approuvée » (elle sera,      |
|                      |                  |autant que possible, incluse dans   |
|                      |                  |les prochaines solutions).          |
|______________________|__________________|____________________________________|
|                      |                  |Lors de l'affichage d'une solution, |
|                      |                  |marque l'action actuellement        |
|SolutionActionReject  |r                 |sélectionnée comme « rejeté »|
|                      |                  |(les prochaines solutions ne la     |
|                      |                  |contiendront pas).                  |
|______________________|__________________|____________________________________|
|                      |                  |Déploie ou réduit l'arborescence  |
|ToggleExpanded        |enter             |actuellement sélectionnée dans une|
|                      |                  |liste hiérarchique.                |
|______________________|__________________|____________________________________|
|ToggleMenuActive      |C-m,f10,C-space   |Active ou désactive le menu        |
|                      |                  |principal.                          |
|______________________|__________________|____________________________________|
|                      |                  |Cancels the last action, up to when |
|Undo                  |C-_,C-u           |aptitude was started OR the last    |
|                      |                  |time you update the package lists or|
|                      |                  |installed packages.                 |
|______________________|__________________|____________________________________|
|                      |                  |Monte : par exemple, dans un écran|
|Up                    |up,k              |de sélection, va au texte          |
|                      |                  |précédent, ou dans une liste, va  |
|                      |                  |  l'entrée précédente.          |
|______________________|__________________|____________________________________|
|                      |                  |Met   jour la liste de paquets en  |
|UpdatePackageList     |u                 |téléchargeant de nouvelles listes |
|                      |                  |depuis Internet si nécessaire.     |
|______________________|__________________|____________________________________|
|Versions              |v                 |Affiche les versions disponibles du |
|                      |                  |paquet actuellement sélectionné.  |
|______________________|__________________|____________________________________|
|                      |                  |Cette séquence va sélectionner le |
|Yes                   |y [b]             |bouton « Oui » dans les boîtes |
|                      |                  |de dialogue oui/non.                |
|______________________|__________________|____________________________________|
|[a]   moins que Aptitude::Display-Planned-Action soit « false » (faux).  |
|                                                                              |
|[b] Cette valeur par défaut peut varier suivant la locale (c'est- -dire la  |
|langue du système).                                                          |
|______________________________________________________________________________|

En plus des touches de lettres, chiffres et ponctuations, les touches
« spéciales » suivantes peuvent être liées dans une séquence :

 _____________________________________________________________________________
|Nom de la touche|Description                                                 |
|________________|____________________________________________________________|
|a1              |Touche A1.                                                  |
|________________|____________________________________________________________|
|a3              |Touche A3.                                                  |
|________________|____________________________________________________________|
|b2              |Touche B2.                                                  |
|________________|____________________________________________________________|
|backspace       |Touche Retour Arrière.                                     |
|________________|____________________________________________________________|
|backtab         |Touche Tabulation Arrière.                                 |
|________________|____________________________________________________________|
|begin           |Touche Begin (pas Origine, c'est- -dire « Home »).     |
|________________|____________________________________________________________|
|break           |Touche « break ».                                       |
|________________|____________________________________________________________|
|c1              |Touche C1.                                                  |
|________________|____________________________________________________________|
|c3              |Touche C3.                                                  |
|________________|____________________________________________________________|
|cancel          |Touche Annuler (« Cancel »).                            |
|________________|____________________________________________________________|
|create          |Touche Création (« Create »).                          |
|________________|____________________________________________________________|
|                |Virgule (,) -- notez que, comme les virgules sont utilisées|
|comma           |pour lister les séquences, c'est l'unique moyen de lier une|
|                |virgule dans une séquence de touches.                      |
|________________|____________________________________________________________|
|command         |Touche Retour Arrière.                                     |
|________________|____________________________________________________________|
|copy            |Touche Copier.                                              |
|________________|____________________________________________________________|
|delete          |Touche Supprime.                                            |
|________________|____________________________________________________________|
|delete_line     |Touche « delete line ».                                 |
|________________|____________________________________________________________|
|down            |Touche flèche « bas ».                                 |
|________________|____________________________________________________________|
|end             |Touche Fin.                                                 |
|________________|____________________________________________________________|
|entry           |Touche Entrée.                                             |
|________________|____________________________________________________________|
|exit            |Touche Sortie (« Exit »).                               |
|________________|____________________________________________________________|
|f1, f2, ..., f10|Les touches F1   F10.                                      |
|________________|____________________________________________________________|
|find            |Touche Recherche.                                           |
|________________|____________________________________________________________|
|home            |Touche Origine.                                             |
|________________|____________________________________________________________|
|insert          |Touche Insérer.                                            |
|________________|____________________________________________________________|
|insert_exit     |Touche « insert exit ».                                 |
|________________|____________________________________________________________|
|clear           |Touche « clear ».                                       |
|________________|____________________________________________________________|
|clear_eol       |Touche « clear to end of line ».                        |
|________________|____________________________________________________________|
|clear_eos       |Touche « clear to end of screen ».                      |
|________________|____________________________________________________________|
|insert_line     |Touche « insert line ».                                 |
|________________|____________________________________________________________|
|left            |Touche flèche « gauche ».                              |
|________________|____________________________________________________________|
|mark            |Touche Mark.                                                |
|________________|____________________________________________________________|
|message         |Touche Message.                                             |
|________________|____________________________________________________________|
|move            |Touche Move.                                                |
|________________|____________________________________________________________|
|next            |Touche Suivant.                                             |
|________________|____________________________________________________________|
|open            |Touche Open.                                                |
|________________|____________________________________________________________|
|previous        |Touche Précédent.                                         |
|________________|____________________________________________________________|
|print           |Touche Imprimer.                                            |
|________________|____________________________________________________________|
|redo            |Touche Refaire.                                             |
|________________|____________________________________________________________|
|reference       |Touche Référence.                                         |
|________________|____________________________________________________________|
|refresh         |Touche Refresh.                                             |
|________________|____________________________________________________________|
|replace         |Touche Replace.                                             |
|________________|____________________________________________________________|
|restart         |Touche Restart.                                             |
|________________|____________________________________________________________|
|resume          |Touche Resume.                                              |
|________________|____________________________________________________________|
|return          |Touche Retour.                                              |
|________________|____________________________________________________________|
|right           |Touche flèche « droite ».                              |
|________________|____________________________________________________________|
|save            |Touche Save.                                                |
|________________|____________________________________________________________|
|scrollf         |Touche « scroll forward ».                              |
|________________|____________________________________________________________|
|scrollr         |Touche « scroll backward ».                             |
|________________|____________________________________________________________|
|select          |Touche Select.                                              |
|________________|____________________________________________________________|
|suspend         |Touche Suspend.                                             |
|________________|____________________________________________________________|
|pagedown        |Touche « Page Suivante ».                               |
|________________|____________________________________________________________|
|pageup          |Touche « Page Précédente ».                           |
|________________|____________________________________________________________|
|space           |Touche Espace.                                              |
|________________|____________________________________________________________|
|tab             |Touche Tab.                                                 |
|________________|____________________________________________________________|
|undo            |Touche Annuler.                                             |
|________________|____________________________________________________________|
|up              |Touche flèche « haut ».                                |
|________________|____________________________________________________________|

In addition to binding keys globally, it is possible to change key bindings for
one particular part (or domain) of aptitude: for instance, to make Tab the
equivalent of the right arrow key in menu bars, set Aptitude::UI::Keybindings::
Menubar::Right to « tab,right ». The following domains are available:

 ______________________________________________________________________________
|Domaine      |Description                                                     |
|_____________|________________________________________________________________|
|EditLine     |Utilisé par les boîtes de saisie de texte, comme le champ de  |
|             |saisie de la boîte de dialogue de « recherche ».           |
|_____________|________________________________________________________________|
|Menu         |Utilisé par les onglets de menus.                              |
|_____________|________________________________________________________________|
|Menubar      |Utilisé par la barre de menu du haut de l'écran.              |
|_____________|________________________________________________________________|
|Minesweeper  |Utilisé par le mode démineur.                                 |
|_____________|________________________________________________________________|
|             |Utilisé par les questions   choix multiples qui apparaissent  |
|MinibufChoice|si vous avez choisi de voir des questions apparaître dans la   |
|             |ligne d'état.                                                  |
|_____________|________________________________________________________________|
|Pager        |Utilisé pour afficher un fichier présent sur le disque (par   |
|             |exemple, le fichier texte d'aide).                              |
|_____________|________________________________________________________________|
|             |Utilisé par les paquets, les arborescences de paquets, les     |
|PkgNode      |versions et les dépendances de paquets quand ils apparaissent  |
|             |dans des listes de paquets.                                     |
|_____________|________________________________________________________________|
|PkgTree      |Utilisé par les listes de paquets.                             |
|_____________|________________________________________________________________|
|Table        |Utilisé par les présentations d'objets graphiques (par        |
|             |exemple, les boîtes de dialogue).                              |
|_____________|________________________________________________________________|
|TextLayout   |Utilisé par les affichages formatés de texte, tels que les    |
|             |descriptions de paquets.                                        |
|_____________|________________________________________________________________|
|Tree         |Utilisé par tous les affichages d'arborescence (dont les listes|
|             |de paquets pour lesquelles PkgTree reste prépondérant).       |
|_____________|________________________________________________________________|


Personnaliser la couleur du texte et les styles

Les couleurs et les styles visuels utilisés par aptitude pour l'affichage
peuvent être personnalisées. Chaque élément visuel a un « style »
associé qui décrit les couleurs et caractéristiques visuelles particulières
qui sont utilisées pour l'afficher. Les styles prennent la forme d'une liste
des paramètres de couleurs et de caractéristiques. Cette liste n'est pas
nécessairement exhaustive, si des couleurs ou caractéristiques ne sont pas
spécifiées explicitement, leur valeur est prise du contexte d'affichage
environnant. En fait, la plupart des éléments visuels possèdent un style
« vide » par défaut.

Vous pouvez changer le contenu d'un style en créant un groupe de configuration
du même nom dans le fichier de configuration d'apt ou d'aptitude. Par exemple,
le style « MenuBorder » est utilisé pour dessiner la bordure autour des
menus déroulants. Par défaut, cette bordure est bleue sur blanc en gras.
Mettre le texte suivant dans le fichier de configuration va le changer en blanc
sur cyan :

Aptitude::UI::Styles {
  MenuBorder {fg white; bg cyan; set bold;};
};

Comme vous pouvez le voir, un groupe de configuration de style consiste en une
séquence d'instructions. Les catégories générales des instructions sont :



  fg couleur
      Utilise la couleur donnée pour le texte actif. Une liste des couleurs
      acceptées par aptitude est disponible ci-dessous.


  bg couleur
      Utilise la couleur donnée pour le texte inactif. Une liste des couleurs
      acceptées par aptitude est disponible ci-dessous.


  set attribut
      Active l'attribut de texte donné. Une liste des attributs de texte
      acceptés par aptitude est disponible ci-dessous.


  clear attribut
      Désactive l'attribut de texte donné. Une liste des attributs de texte
      acceptés par aptitude est disponible ci-dessous.


  flip attribut
      Inverse l'état de l'attribut de texte donné : s'il est activé dans
      l'élément environnant, il sera désactivé et inversement. Une liste des
      attributs de texte acceptés par aptitude est disponible ci-dessous.


The colors that aptitude recognizes are black, blue, cyan, green, magenta, red,
white, and yellow [17]. In addition, you may specify default in place of a
background color to use the default terminal background (this could be the
default color, an image file, or even « transparent »). The styles that
aptitude recognizes are:



  blink
      Active le clignotement du texte.


  bold
      Rend la couleur du texte du premier plan (ou d'arrière plan si la vidéo
      inverse est activée) plus claire.


  dim
      Peut entraîner le texte   être plus estompé sur certains terminaux.
      Aucun effet n'a été observé sur les terminaux Linux usuels.


  reverse
      Inverse les couleurs d'avant et arrière plan. Beaucoup d'éléments
      visuels utilisent cet attribut pour faire des effets de surbrillance.


  standout
      Active le « meilleur mode de surbrillance du terminal ». Dans les
      xterms, c'est comparable, mais pas totalement identique   la vidéo
      inverse. Le comportement des autres terminaux peut varier.


  underline
      Active le soulignement du texte.


Vous pouvez sélectionner plusieurs de ces attributs en une fois en les
séparant par des virgules. Par exemple, vous pourriez utiliser set
bold,standout;.


 [Note]  Note

         Comme signalé ci-dessus, l'interprétation des styles et des attributs
         de texte est hautement dépendant du terminal. Il vous faudra
         certainement expérimenter un peu pour trouver ce que certains
         paramétrages font dans votre terminal.


Les styles suivants peuvent être personnalisés dans aptitude :

Figure 2.12. Styles personnalisables dans aptitude

 ______________________________________________________________________________
|Style                     |Valeur par défaut       |Description              |
|__________________________|_________________________|_________________________|
|Bullet                    |fg yellow; set bold;     |Style des puces dans les |
|                          |                         |listes   puces.         |
|__________________________|_________________________|_________________________|
|                          |                         |Style des nouvelles      |
|                          |                         |versions du paquet dans  |
|                          |                         |la vue affichant la liste|
|                          |                         |de modification du       |
|                          |                         |paquet. aptitude ne      |
|ChangelogNewerVersion     |set bold;                |mettra en surbrillance   |
|                          |                         |les nouvelles versions du|
|                          |                         |paquet que si vous avez  |
|                          |                         |le paquet libparse-      |
|                          |                         |debianchangelog-perl     |
|                          |                         |installé.               |
|__________________________|_________________________|_________________________|
|Default                   |fg white; bg black;      |Style de base de         |
|                          |                         |l'écran.                |
|__________________________|_________________________|_________________________|
|DepBroken                 |fg black; bg red;        |Style des dépendances   |
|                          |                         |non satisfaites.         |
|__________________________|_________________________|_________________________|
|                          |                         |Style des entrées de    |
|                          |fg black; bg blue; set   |menu qui sont            |
|DisabledMenuEntry         |dim;                     |désactivées et qui ne  |
|                          |                         |peuvent pas être        |
|                          |                         |utilisées.              |
|__________________________|_________________________|_________________________|
|                          |                         |Style utilisé pour      |
|                          |                         |indiquer qu'un fichier a |
|                          |                         |été « atteint »,   |
|DownloadHit               |fg black; bg green;      |c'est- -dire, qu'il n'a |
|                          |                         |pas changé depuis la    |
|                          |                         |dernière fois qu'il a   |
|                          |                         |été téléchargé.     |
|__________________________|_________________________|_________________________|
|                          |                         |Style de la barre de     |
|DownloadProgress          |fg blue; bg yellow;      |progression d'un         |
|                          |                         |téléchargement.        |
|__________________________|_________________________|_________________________|
|                          |                         |Style d'une ligne        |
|                          |fg white; bg black; clear|éditable (par exemple la|
|EditLine                  |reverse;                 |zone d'entrée dans la   |
|                          |                         |boîte de dialogue de    |
|                          |                         |recherche).              |
|__________________________|_________________________|_________________________|
|Error                     |fg white; bg red; set    |Style des messages       |
|                          |bold;                    |d'erreur.                |
|__________________________|_________________________|_________________________|
|Header                    |fg white; bg blue; set   |Style du haut de         |
|                          |bold;                    |l'écran.                |
|__________________________|_________________________|_________________________|
|                          |                         |Style du nom du menu     |
|HighlightedMenuBar        |fg white; bg blue; set   |actuellement             |
|                          |bold,reverse;            |sélectionné dans la    |
|                          |                         |barre de menu.           |
|__________________________|_________________________|_________________________|
|                          |                         |Style de choix           |
|HighlightedMenuEntry      |fg white; bg blue; set   |actuellement             |
|                          |bold,reverse;            |sélectionné dans un    |
|                          |                         |menu.                    |
|__________________________|_________________________|_________________________|
|                          |                         |Style de la boîte de    |
|MediaChange               |fg yellow; bg red; set   |dialogue utilisée pour  |
|                          |bold;                    |demander   l'utilisateur|
|                          |                         |d'insérer un autre CD.  |
|__________________________|_________________________|_________________________|
|MenuBar                   |fg white; bg blue; set   |Style de la barre de     |
|                          |bold;                    |menu.                    |
|__________________________|_________________________|_________________________|
|                          |fg white; bg blue; set   |Style de la bordure      |
|MenuBorder                |bold;                    |entourant un menu        |
|                          |                         |déroulant.              |
|__________________________|_________________________|_________________________|
|MenuEntry                 |fg white; bg blue;       |Style de chaque entrée  |
|                          |                         |d'un menu déroulant.    |
|__________________________|_________________________|_________________________|
|MineBomb                  |fg red; set bold;        |Style des bombes dans le |
|                          |                         |démineur.               |
|__________________________|_________________________|_________________________|
|MineBorder                |set bold;                |Style de la bordure d'un |
|                          |                         |tableau du démineur.    |
|__________________________|_________________________|_________________________|
|MineFlag                  |fg red; set bold;        |Style des drapeaux dans  |
|                          |                         |le démineur.            |
|__________________________|_________________________|_________________________|
|                          |                         |Style du nombre N dans le|
|MineNumberN               |Variés                  |démineur. N est entre 0 |
|                          |                         |et 8.                    |
|__________________________|_________________________|_________________________|
|                          |                         |Couleur utilisée pour   |
|                          |                         |afficher les             |
|MultiplexTab              |fg white; bg blue;       |« onglets » autres   |
|                          |                         |que celui actuellement   |
|                          |                         |sélectionné.           |
|__________________________|_________________________|_________________________|
|                          |                         |Couleur utilisée pour   |
|MultiplexTabHighlighted   |fg blue; bg white;       |afficher l'« onglet »|
|                          |                         |actuellement             |
|                          |                         |sélectionné.           |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgBroken                 |fg red; flip reverse;    |paquets qui ont des      |
|                          |                         |dépendances non         |
|                          |                         |satisfaites.             |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgBrokenHighlighted      |fg red;                  |paquets en surbrillance  |
|                          |                         |qui ont des dépendances |
|                          |                         |non satisfaites.         |
|__________________________|_________________________|_________________________|
|                          |                         |Style des paquets qui ne |
|PkgNotInstalled           |                        |sont pas actuellement    |
|                          |                         |installés et qu'il n'est|
|                          |                         |pas prévu d'installer.  |
|__________________________|_________________________|_________________________|
|                          |                         |Style des paquets en     |
|                          |                         |surbrillance qui ne sont |
|PkgNotInstalledHighlighted|                        |pas actuellement         |
|                          |                         |installés et qu'il n'est|
|                          |                         |pas prévu d'installer.  |
|__________________________|_________________________|_________________________|
|                          |                         |Style des paquets qui    |
|                          |                         |sont actuellement        |
|PkgIsInstalled            |set bold;                |installés et sur        |
|                          |                         |lesquels aucune action   |
|                          |                         |n'est prévu.            |
|__________________________|_________________________|_________________________|
|                          |                         |Style des paquets en     |
|                          |                         |surbrillance qui sont    |
|PkgIsInstalledHighlighted |set bold; flip reverse;  |actuellement installés  |
|                          |                         |et sur lesquels aucune   |
|                          |                         |action n'est prévu.     |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToDowngrade            |set bold;                |paquets, style des       |
|                          |                         |paquets qu'il est prévu |
|                          |                         |de mettre   jour.       |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgToDowngradeHighlighted |set bold; flip reverse   |paquets en surbrillance  |
|                          |                         |qu'il est prévu de      |
|                          |                         |mettre   une version    |
|                          |                         |antérieure.             |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToHold                 |fg white; flip reverse;  |paquets, style des       |
|                          |                         |paquets qui sont gelés. |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToHoldHighlighted      |fg white;                |paquets, style des       |
|                          |                         |paquets en surbrillance  |
|                          |                         |qui sont gelés.         |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgToInstall              |fg green; flip reverse;  |paquets qu'il est prévu |
|                          |                         |d'installer (pas de      |
|                          |                         |mettre   jour) ou de    |
|                          |                         |réinstaller.            |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|                          |                         |paquets en surbrillance  |
|PkgToInstallHighlighted   |fg green;                |qu'il est prévu         |
|                          |                         |d'installer (pas de      |
|                          |                         |mettre   jour) ou de    |
|                          |                         |réinstaller.            |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgToRemove               |fg magenta; flip reverse;|paquets qu'il est prévu |
|                          |                         |de supprimer ou de       |
|                          |                         |purger.                  |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|                          |                         |paquets, style des       |
|PkgToRemoveHighlighted    |fg magenta;              |paquets en surbrillance  |
|                          |                         |qu'il est prévu de      |
|                          |                         |supprimer ou de purger.  |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToUpgrade              |fg cyan; flip reverse;   |paquets, style des       |
|                          |                         |paquets qu'il est prévu |
|                          |                         |de mettre   jour.       |
|__________________________|_________________________|_________________________|
|                          |                         |Dans la liste des        |
|PkgToUpgradeHighlighted   |fg cyan;                 |paquets, style des       |
|                          |                         |paquets qu'il est prévu |
|                          |                         |de mettre   jour.       |
|__________________________|_________________________|_________________________|
|                          |                         |Style de l'indicateur    |
|                          |                         |d'avancement tel que     |
|Progress                  |fg blue; bg yellow;      |celui qui apparaît lors |
|                          |                         |du chargement du cache   |
|                          |                         |des paquets.             |
|__________________________|_________________________|_________________________|
|                          |                         |Style des solutions      |
|SolutionActionApproved    |bg green;                |approuvées dans une     |
|                          |                         |solution.                |
|__________________________|_________________________|_________________________|
|                          |                         |Style des solutions      |
|SolutionActionRejected    |bg red;                  |rejetées dans une       |
|                          |                         |solution.                |
|__________________________|_________________________|_________________________|
|Status                    |fg white; bg blue; set   |Style de la ligne d'état|
|                          |bold;                    |en bas de l'écran.      |
|__________________________|_________________________|_________________________|
|                          |                         |Couleur de base de toutes|
|TreeBackground            |                        |les listes et arbres     |
|                          |                         |visuels.                 |
|__________________________|_________________________|_________________________|
|                          |                         |Couleur utilisées pour  |
|TrustWarning              |fg red; bg black; set    |afficher les             |
|                          |bold;                    |avertissements concernant|
|                          |                         |les paquets de confiance.|
|__________________________|_________________________|_________________________|




Personnaliser la disposition de l'affichage

Il est possible de réordonner la liste des paquets d'aptitude en apportant les
modifications appropriées au fichier de configuration.


Éléments d'affichage

La disposition est conservée dans le groupe de configuration Aptitude::UI::
Default-Package-View et consiste en une liste d'éléments d'affichage :

Name Type {
  Row row;
  Column column;
  Width width;
  Height height;

  additional options...
};

Cela crée un élément d'affichage nommé Nom dont le type est donné par Type.
Les options Row, Column, Width et Height doivent être présentes. Elles
déterminent où l'élément d'affichage est situé. Voyez ci-dessous pour une
explication détaillée sur la manière dont les éléments d'affichage sont
disposés.

Vous trouverez des exemples concernant la manière de modifier la disposition de
l'affichage en consultant la définition du thème par défaut dans le fichier /
usr/share/aptitude/aptitude-defaults.

Les types d'éléments d'affichage suivants sont disponibles :



  Description
      Cet élément d'affichage contient la « zone d'information »
      (typiquement une description du paquet actuellement sélectionné).

      L'option PopUpDownKey donne le nom d'une commande clavier qui va montrer
      ou cacher l'élément d'affichage. Par exemple, mettre cette option  
      ShowHideDescription va donner   l'élément d'affichage actuel le même
      comportement que celui par défaut pour la zone d'information. L'option
      PopUpDownLinked donne le nom d'un autre élément d'affichage ;
      l'élément courant sera montré ou caché   chaque fois que l'autre
      élément le sera.


  MainWidget
      C'est une référence   l'élément d'affichage « principal » :
      typiquement c'est une liste de paquets. Une disposition d'affichage doit
      contenir exactement un élément MainWidget : pas un de plus, pas un de
      moins.


  Static
      Zone de l'écran qui affiche du texte ; elle peut contenir du code
      formaté tel que décrit dans la section intitulée « Personnaliser la
      manière d'afficher les paquets ». Le texte   afficher peut être
      donné dans l'option Columns, ou être stocké dans la variable
      spécifiée par l'option ColumnsCfg. La couleur du texte est déterminée
      par le nom de la couleur passé   l'option Color.

      Les objets Static peuvent être affichés et cachés de la même manière
      que les objets Description en utilisant les options PopUpDownKey et
      PopUpDownLinked.



Placement des éléments d'affichage

Les éléments d'affichage sont disposés dans une « table ». Le coin
supérieur gauche d'un élément est dans la cellule donnée par les options Row
et Column (commençant habituellement   la ligne 0 et la colonne 0 bien que ce
ne soit pas obligatoire). La largeur d'un élément en cellule est donnée par
son option Width, et sa hauteur est donnée par son option Height.

Une fois que l'élément d'affichage est disposé et qu'il a reçu une étendue
initiale   l'écran, il est possible qu'il reste de l'espace. S'il y a de
l'espace libre verticalement chaque ligne contenant un élément d'affichage
dont l'option RowExpand est   true se verra allouer une partie de l'espace
libre. De façon analogue, s'il y a de l'espace libre horizontalement, chaque
colonne contenant un élément d'affichage dont l'option ColExpand est   true
se verra allouer une partie de l'espace libre.

Dans le cas où il n'y a pas assez d'espace, chaque ligne ou colonne dont tous
les objets ont leurs options RowShrink ou ColShrink   true sera rétrécie.
S'il n'y en a pas assez, toutes les lignes et colonnes sont réduites pour
s'ajuster   l'espace disponible.

Si un élément d'affichage n'est pas agrandi, mais ses lignes ou colonnes le
sont, son alignement est déterminé par les options RowAlign et ColAlign. Les
configurer   Left (gauche), Right (droite), Top (haut), Bottom (bas), ou Center
(centré) va indiquer   aptitude où placer l'élément verticalement et
horizontalement.

Par exemple, le groupe de configuration suivant crée un élément statique
nommé « Header » qui est large de trois cellules et qui s'agrandit
horizontalement mais pas verticalement. Il a la même couleur que les autres
lignes d'en-tête et utilise le format standard des lignes d'en-tête :

Header Static {
  Row 0;
  Column 0;
  Width 3;
  Height 1;

  ColExpand true;
  ColAlign Center;

  RowAlign Center;

  Color ScreenHeaderColor;
  ColumnsCfg HEADER;
};


Référence des options de la disposition de l'affichage

Les options suivantes sont disponibles pour les éléments d'affichage :



  ColAlign alignement;
      Alignement doit être Left (gauche), Right (droite), ou Center (centré).
      Si la ligne contenant l'élément d'affichage courant est plus large que
      l'élément lui-même et que ColExpand est false, l'élément sera placé
      dans la ligne selon la valeur alignement.

      Si cette option est absente, la valeur par défaut est Left.


  ColExpand true|false;
      Si cette option est mise   true (vrai), la colonne contenant l'élément
      d'affichage se verra allouer une partie de l'espace horizontal libre qui
      serait disponible.

      Si cette option est absente, la valeur par défaut est false (faux).


  Color couleur;
      Cette option s'applique   l'élément Static. Couleur est le nom d'une
      couleur (par exemple, ScreenStatusColor) qui devrait être utilisé comme
      couleur par défaut pour afficher l'élément d'affichage.

      Si cette option est absente, la valeur par défaut est
      DefaultWidgetBackground.


  ColShrink true|false;
      Si cette option est mise   true sur chaque élément d'une colonne et
      qu'il n'y a pas assez d'espace horizontal, la colonne sera rétrécie
      autant qu'il faut pour rentrer dans l'espace disponible. Remarquez qu'une
      colonne peut être rétrécie même si ColShrink est false ; cela indique
      simplement qu'aptitude devrait essayer de réduire une colonne
      particulière avec les autres.

      Si cette option est absente, la valeur par défaut est false (faux).


  Column colonne;
      Spécifie la colonne la plus   gauche pouvant contenir cet élément
      d'affichage.


  Columns format;
      Cette option s'applique aux éléments d'affichage Static pour lesquels
      l'option ColumnsCfg n'est pas configurée. Elle configure le contenu de
      l'affichage de la ligne d'état. C'est une chaîne de format comme décrit
      dans la section intitulée « Personnaliser la manière d'afficher les
      paquets ».


  ColumnsCfg HEADER|STATUS|nom;
      Cette option s'applique aux éléments d'affichage Static. Il configure le
      format d'affichage de l'élément courant   la valeur d'une autre
      variable de configuration. Si c'est HEADER ou STATUS, les options,
      respectivement, Aptitude::UI::Package-Header-Format et Aptitude::UI::
      Package-Status-Format, sont utilisées. Sinon l'option nom est utilisée.

      Si cette option est absente, la valeur de l'option Columns est utilisée
      pour contrôler le contenu de l'élément statique.


  Height hauteur;
      Spécifie la hauteur de l'élément d'affichage courant.


  PopUpDownKey commande;
      Cette option s'applique aux éléments d'affichage Description et Static.

      Commande est le nom d'une commande clavier (par exemple,
      ShowHideDescription). Quand cette séquence de touches est pressée,
      l'élément d'affichage est caché s'il est visible et affiché s'il est
      caché.


  PopUpDownLinked élément;
      Cette option s'applique aux éléments d'affichage Description et Static.

      élément est le nom d'un élément d'affichage. Quand élément est
      affiché, l'élément courant sera affiché lui aussi et quand élément
      est caché, l'élément courant sera caché lui aussi.


  Row ligne;
      Spécifie la ligne se trouvant placée le plus haut et pouvant contenir
      cet élément d'affichage.


  RowAlign alignement;
      alignement doit être Top (haut), Bottom (bas) ou Center (centré). Si la
      ligne contenant l'élément d'affichage courant est plus haute que
      l'élément lui-même et que RowExpand est false, l'élément sera placé
      dans la ligne selon la valeur alignement.

      Si cette option est absente, la valeur de l'option est Top.


  RowExpand true|false;
      Si cette option est mise   true (vrai), la ligne contenant l'élément
      d'affichage se verra allouer une partie de l'espace horizontal libre qui
      serait disponible.

      Si cette option est absente, la valeur par défaut est false (faux).


  RowShrink true|false;
      Si cette option est mise   true sur chaque élément d'une ligne, et s'il
      n'y a pas assez d'espace horizontal, la ligne sera rétrécie autant qu'il
      faut pour rentrer dans l'espace disponible. Remarquez qu'une ligne peut
      être rétrécie même si RowShrink est false ; cela indique simplement
      qu'aptitude devrait essayer de réduire une ligne particulière avec les
      autres.

      Si cette option est absente, la valeur par défaut est false (faux).


  Visible true|false;
      Configuré   false (faux), cet élément d'affichage sera initialement
      caché. Ce n'est probablement utile que combiné avec PopUpDownKey et/ou
      PopUpDownLinked.

      Si cette option est absente, la valeur de l'option est true.


  Width largeur;
      Spécifie la largeur de l'élément d'affichage courant.



Référence du fichier de configuration


Format du fichier de configuration

Basiquement, le fichier de configuration d'aptitude est une liste de couples
d'options et de leurs valeurs. Chaque ligne du fichier devrait avoir la forme
« Option Valeur; » : par exemple, dans le fichier de configuration, la
ligne suivante met l'option Aptitude::Theme   « Dselect ».

Aptitude::Theme "Dselect";

Une option peut « contenir » d'autres options si elles sont écrites entre
accolades placées entre l'option et le point-virgule qui la suit, comme ceci :

Aptitude::UI {
  Package-Status-Format "";
  Package-Display-Format "";
};

Une option qui contient d'autres options est parfois appelée groupe. En fait,
le deux-points doublé, qui apparaît dans les noms d'options est une manière
simplifiée pour indiquer l'inclusion : l'option Aptitude::UI::Default-Grouping
est contenu dans le groupe Aptitude::UI, qui est lui-même dans le groupe
Aptitude. Ainsi, si vous le souhaitez, vous pourriez configurer cette option  
"" comme cela :

Aptitude {
  UI {
    Default-Grouping "";
  };
};

Pour plus d'informations sur le format du fichier de configuration, consultez la
page de manuel apt.conf(5).


Emplacement des fichiers de configuration

La configuration d'aptitude est lue, dans l'ordre, depuis les sources
suivantes :


  1. Le fichier de configuration de l'utilisateur, ~/.aptitude/config. Ce
     fichier est écrasé lorsque l'utilisateur modifie la configuration dans le
     menu Options.

  2. Le fichier de configuration du système, /etc/apt/apt.conf.

  3. Les valeurs par défaut conservées dans /usr/share/aptitude/aptitude-
     defaults.

  4. Default values built into aptitude.


Quand une option est évaluée, ces sources sont consultées dans l'ordre, et la
première qui fournit une valeur pour l'option est utilisée. Par exemple,
configurer une option dans /etc/apt/apt.conf va écraser la valeur par défaut
d'aptitude pour cette option, mais cela n'écrasera pas la configuration de
l'utilisateur dans ~/.aptitude/config.


Options de configuration disponibles

Les options de configuration suivantes sont utilisées par aptitude. Notez que
ce ne sont pas les seules options de configuration disponibles ; les options
utilisées par le système apt sous-jacent ne sont pas listées ici. Consultez
les pages de manuel apt(8) et apt.conf(5) pour les informations sur les options
d'apt.

Option:Apt::Install-Recommends

Valeur par défaut:true

Description: Si cette option est mise   true et si Aptitude::Auto-Install est
aussi   true, installer un nouveau paquet induira l'installation de tous les
paquets qu'il recommande. De plus, si cette option est   true, alors aptitude
ne considérera pas les paquets comme inutilisés (et donc ne le retirera pas
automatiquement) tant qu'un paquet les recommande. Pour plus d'information,
consultez la section intitulée « Gérer les paquets automatiquement
installés ».

Option:Aptitude::Allow-Null-Upgrade

Valeur par défaut:false

Description: Normalement, si vous essayez de démarrer un processus
d'installation alors qu'aucune action n'est prévue, aptitude affiche un
avertissement et revient   la liste des paquets. Si cette option est true,
aptitude affichera l'aperçu d'installation, même s'il y a des paquets pouvant
être mis   jour, plutôt qu'afficher un rappel concernant la commande Actions
->; Marquer comme étant susceptible de mise   jour (U).

Option:Aptitude::Always-Use-Safe-Resolver

Valeur par défaut:false

Description: If this option is true, aptitude's command-line actions will always
use a « safe » dependency resolver, as if --safe-resolver had been passed on
the command line.

Option:Aptitude::Autoclean-After-Update

Valeur par défaut:false

Description: Si cette option est mise   true, aptitude fera le ménage parmi
les fichiers obsolètes (consultez Actions ->; Enlever les fichiers
périmés)   chaque mise   jour de la liste des paquets.

Option:Aptitude::Auto-Fix-Broken

Valeur par défaut:true

Description: Si cette option est mise   false, aptitude demandera la permission
avant de tenter de corriger un paquet cassé.

Option:Aptitude::Auto-Install

Valeur par défaut:true

Description: Si cette option est mise   true, aptitude essaiera automatiquement
de satisfaire les dépendances d'un paquet quand vous le sélectionnez pour
installation.

Option:Aptitude::Auto-Upgrade

Valeur par défaut:false

Description: Si cette option est mise   true, aptitude marquera automatiquement
tous les paquets pouvant être mis   jour pour qu'ils le soient au démarrage
du programme, comme si vous aviez exécuté la commande Actions ->; Marquer
comme étant susceptible de mise   jour (U).

Option:Aptitude::CmdLine::Always-Prompt

Valeur par défaut:false

Description: En mode ligne de commande, si cette option est   « true »,
aptitude demandera toujours confirmation avant de commencer   installer ou
supprimer des paquets, même si la confirmation aurait normalement été
sautée. C'est équivalent   l'option -P de la ligne de commande.

Option:Aptitude::CmdLine::Assume-Yes

Valeur par défaut:false

Description: En mode ligne de commande, si cette option est   « true »,
aptitude agira comme si l'utilisateur répondait « oui »   chaque invite,
causant le saut de la plupart des questions. C'est équivalent   l'option -y de
la ligne de commande.

Option:Aptitude::CmdLine::Disable-Columns

Valeur par défaut:false

Description: If this option is enabled, the results of command-line searches
(performed via aptitude search) will not be formatted into fixed-width columns
or truncated to the screen width. This is equivalent to the --disable-columns
command-line option.

Option:Aptitude::CmdLine::Download-Only

Valeur par défaut:false

Description: En mode ligne de commande, si cette option est   « true »,
aptitude téléchargera les paquets sans les installer. C'est équivalent  
l'option -d de la ligne de commande.

Option:Aptitude::CmdLine::Fix-Broken

Valeur par défaut:false

Description: En mode ligne de commande, si cette option est   « true »,
aptitude sera plus agressif lorsqu'il tentera de corriger les dépendances de
paquets cassés. C'est équivalent   l'option -f de la ligne de commande.

Option:Aptitude::CmdLine::Ignore-Trust-Violations

Valeur par défaut:false

Description: In command-line mode, causes aptitude to ignore the installation of
untrusted packages. This is a synonym for Apt::Get::AllowUnauthenticated.

Option:Aptitude::CmdLine::Package-Display-Format

Valeur par défaut:%c%a%M %p# - %d#

Description: C'est une chaîne de format, tel que décrit dans la section
intitulée « Personnaliser la manière d'afficher les paquets », qui est
utilisée pour afficher le résultat d'une recherche en ligne de commande. C'est
équivalent   l'option -F de la ligne de commande.

Option:Aptitude::CmdLine::Package-Display-Width

Valeur par défaut:

Description: Cette option donne la largeur en caractères avec laquelle les
résultats des recherches en ligne de commande doivent être formatées. Une
chaîne vide (la valeur par défaut, c'est- -dire "") indique que les
résultats des recherches sont formatés pour la taille du terminal actuel ou
pour un affichage de 80 colonnes si la taille ne peut pas être déterminée.

Option:Aptitude::CmdLine::Request-Strictness

Valeur par défaut:10000

Description: En mode ligne de commande, si des problèmes de dépendances sont
rencontrés, aptitude ajoutera cette valeur au score, donné par le solveur de
dépendances, de toute action que vous demandez explicitement.

Option:Aptitude::CmdLine::Resolver-Debug

Valeur par défaut:false

Description: En mode ligne de commande, si cette option est   true, aptitude
affichera énormément d'informations pendant les tentatives de résolutions de
dépendances cassées. Comme le nom le suggère, c'est option est principalement
destinée   aider au débogage du solveur de problème.

Option:Aptitude::CmdLine::Resolver-Dump

Valeur par défaut:

Description: En mode ligne de commande, s'il est nécessaire de résoudre des
dépendances cassées et que cette option contient le nom d'un fichier dans
lequel il est possible d'écrire, l'état du solveur est écrit dans ce fichier
avant d'entreprendre toute résolution.

Option:Aptitude::CmdLine::Resolver-Show-Steps

Valeur par défaut:false

Description: Quand cette option est   true, une solution en dépendance sera
affichée comme une suite de dépendances individuelles. Par exemple,
« wesnoth depends upon wesnoth-data (= 1.2.4-1) -> installing wesnoth-data
1.2.4-1 (unstable) ».

Option:Aptitude::CmdLine::Safe-Upgrade::No-New-Installs

Valeur par défaut:false

Description: In command-line mode, if this option is true, the safe-upgrade
command will not attempt to resolve dependencies by installing new packages. If
upgrading package A would require package B to be newly installed, package A
will not be upgraded. This corresponds to the command-line option --no-new-
installs.

Option:Aptitude::CmdLine::Show-Deps

Valeur par défaut:false

Description: En mode ligne de commande, si cette option est   « true »,
aptitude affichera un résumé des dépendances (s'il y en a) liées   l'état
d'un paquet. C'est équivalent   l'option -D de la ligne de commande.

Option:Aptitude::CmdLine::Show-Size-Changes

Valeur par défaut:false

Description: En mode ligne de commande, si cette option est   « true »,
aptitude affichera les changements attendus de l'espace disque utilisé par
chaque paquet. C'est équivalent   l'option -Z de la ligne de commande.

Option:Aptitude::CmdLine::Show-Versions

Valeur par défaut:false

Description: En mode ligne de commande, si cette option est   « true »,
aptitude affichera la version d'un paquet qui est sur le point d'être installé
ou supprimé. C'est équivalent   l'option -V de la ligne de commande.

Option:Aptitude::CmdLine::Show-Why

Valeur par défaut:false

Description: In command-line mode, if this option is true, aptitude will display
the manually installed packages that require each automatically installed
package, or the manually installed packages that cause a conflict with each
automatically removed package. This is equivalent to the -W command-line option
and displays the same information you can access via aptitude why or by pressing
i in a package list.

Option:Aptitude::CmdLine::Simulate

Valeur par défaut:false

Description: This option is deprecated; use Aptitude::Simulate instead. In
command-line mode, causes aptitude to just display the actions that would be
performed (rather than actually performing them); in the visual interface,
causes aptitude to start in read-only mode regardless of whether you are root or
not. This is equivalent to the -s command-line option.

Option:Aptitude::CmdLine::Verbose

Valeur par défaut:0

Description: Cette option contrôle le niveau de verbosité du mode ligne de
commande d'aptitude. Chaque occurrence de l'option -v sur la ligne de commande
ajoute 1   cette valeur.

Option:Aptitude::CmdLine::Visual-Preview

Valeur par défaut:false

Description: Si cette option est mise   true, aptitude va entrer dans le mode
graphique pour afficher l'aperçu du processus d'installation et pour
télécharger les paquets.

Option:Aptitude::Debtags-Binary

Valeur par défaut:/usr/bin/debtags

Description: The absolute path to the debtags command. If configured with libept
support, aptitude will invoke this program whenever the package lists are
updated, passing it the arguments listed in Aptitude::Debtags-Update-Options.

Option:Aptitude::Debtags-Update-Options

Valeur par défaut:--local

Description: Additional options to pass to debtags update when invoking it after
the package lists are updated. These are split at whitespace; single and double-
quoted strings are recognized, so setting this to « --vocabulary='/file with a
space » will store the debtags vocabulary in « /file with a space ».

Option:Aptitude::Delete-Unused

Valeur par défaut:true

Description: Si cette option est mise   true, les paquets automatiquement
installés qui ne sont plus nécessaires seront automatiquement supprimés. Pour
plus d'informations, consultez la section intitulée « Gérer les paquets
automatiquement installés ».

Option:Aptitude::Delete-Unused-Pattern

Valeur par défaut:

Description: Obsolète, alias pour Aptitude::Keep-Unused-Pattern. Si Aptitude::
Keep-Unused-Pattern n'est pas paramétrée ou paramétrée avec une chaîne
vide, la valeur de cette option de configuration va la supplanter. Sinon
Aptitude::Delete-Unused-Pattern est ignorée.

Option:Aptitude::Display-Planned-Action

Valeur par défaut:true

Description: Si cette option est mise   true, aptitude affichera un aperçu
d'installation avant de réellement exécuter les actions que vous avez
demandées.

Option:Aptitude::Forget-New-On-Install

Valeur par défaut:false

Description: Si cette option est mise   true, aptitude videra la liste des
nouveaux paquets   chaque fois que vous installez, mettez   jour ou supprimez
des paquets, comme si vous aviez exécuté la commande Actions ->; Oublier
quels paquets sont nouveaux (f).

Option:Aptitude::Forget-New-On-Update

Valeur par défaut:false

Description: Si cette option est mise   true, aptitude videra la liste des
nouveaux paquets   chaque fois que la liste des paquets est mise   jour, comme
si vous aviez exécuté la commande Actions ->; Oublier quels paquets sont
nouveaux (f).

Option:Aptitude::Get-Root-Command

Valeur par défaut:su:/usr/bin/su

Description: Cette option définit la commande externe qu'aptitude utilisera
pour devenir l'utilisateur root (consultez la section intitulée « Devenir
administrateur (« root ») »). Cette option est de la forme protocole:
commande. protocole doit être soit su ou sudo; Elle détermine comment aptitude
utilise le programme quand il veut obtenir les priviléges du root. Si le
protocol est su,alors commande -c arguments sera utilisée pour devenir root.
Dans le cas contraire, aptitude utilise commande arguments. Le premier mot de
commande est le nom du programme qui doit être utilisé, les mots restant sont
traités en tant qu'arguments de ce programme.

Option:Aptitude::Ignore-Old-Tmp

Valeur par défaut:false

Description: Les anciennes versions d'aptitude créaient un répertoire
~/.aptitude/.tmp qui n'est plus nécessaire. Si ce répertoire existe et
Aptitude::Ignore-Old-Tmp est   true, aptitude vous demandera s'il faut le
supprimer. Cette option est automatiquement mis   true après que vous ayez
répondu. D'un autre côté, si ce répertoire n'existe pas, cette option est
mise   false et vous en seriez averti si ce répertoire venait  
réapparaître.

Option:Aptitude::Ignore-Recommends-Important

Valeur par défaut:false

Description: In previous versions of aptitude, the setting Aptitude::Recommends-
Important caused recommendations to be installed automatically, the same way
that Apt::Install-Recommends does today. If this option is set to false and
Aptitude::Recommends-Important is also set to false, aptitude will set Apt::
Install-Recommends to false and set Aptitude::Ignore-Recommends-Important to
true on startup.

Option:Aptitude::Keep-Recommends

Valeur par défaut:false

Description: If this option is true, then aptitude will not consider packages to
be unused (and thus will not automatically remove them) as long as any installed
package recommends them, even if Apt::Install-Recommends is false. For more
information, see la section intitulée « Gérer les paquets automatiquement
installés ».

Option:Aptitude::Keep-Suggests

Valeur par défaut:false

Description: Si cette option est mise   true, aptitude ne considérera pas les
paquets comme inutilisés (et donc ne les retirera pas automatiquement) tant
qu'un paquet installé les suggère. Pour plus d'informations, consultez la
section intitulée « Gérer les paquets automatiquement installés ».

Option:Aptitude::Keep-Unused-Pattern

Valeur par défaut:

Description: Si Aptitude::Delete-Unused est   true, seul les paquets
inutilisés qui ne correspondent pas   ce motif (voir la section intitulée
« Motifs de recherche ») seront supprimés. Si cette option est configurée
avec une chaîne vide (valeur par défaut), tous les paquets inutilisés sont
supprimés.

Option:Aptitude::LockFile

Valeur par défaut:/var/lock/aptitude

Description: A file that will be fcntl-locked to ensure that at most one
aptitude process can modify the cache at once. In normal circumstances, you
should never need to modify this; it may be useful for debugging. Note: if
aptitude complains that it cannot acquire a lock, this is not because the lock
file needs to be deleted. fcntl locks are managed by the kernel and will be
destroyed when the program holding them terminates; failure to acquire the lock
means that another running program is using it!

Option:Aptitude::Log

Valeur par défaut:/var/log/aptitude

Description: Si cette option est une chaîne non vide, aptitude journalisera les
installations, suppressions et mises   jour de paquets qu'il effectue. Si la
valeur de Aptitude::Log commence par le caractère « | », le reste de cette
valeur est utilisé comme nom d'une commande   travers laquelle le journal est
envoyé : par exemple, |mail -s 'Aptitude install run' root enverra le journal
au compte root. Pour journaliser dans plusieurs fichiers ou commandes, vous
pouvez configurer cette option sous la forme d'une liste de cibles pour la
journalisation.

Option:Aptitude::Parse-Description-Bullets

Valeur par défaut:true

Description: Si cette option est activée, aptitude essaiera de détecter
automatiquement les items d'une liste dans les descriptions de paquets. Cela
améliore généralement l'affichage des descriptions, mais le formatage des
descriptions d'anciens paquets pourrait être moins bon quand cette option est
  true plutôt qu'  false.

Option:Aptitude::Pkg-Display-Limit

Valeur par défaut:

Description: Filtre par défaut s'appliquant   la liste des paquets ;
consultez la section intitulée « Motifs de recherche » pour plus de
détails sur son format.

Option:Aptitude::ProblemResolver::Allow-Break-Holds

Valeur par défaut:false

Description: If this option is set to true, the problem resolver will consider
breaking package holds or installing forbidden versions in order to resolve a
dependency. If it is set to false, these actions will be rejected by default,
although you can always enable them manually (see la section intitulée
« Résoudre les problèmes de dépendance »).

Option:Aptitude::ProblemResolver::BreakHoldScore

Valeur par défaut:-300

Description: How much to reward or penalize solutions that change the state of a
held package or install a forbidden version. Note that unless Aptitude::
ProblemResolver::Allow-Break-Holds is set to true, the resolver will never break
a hold or install a forbidden version unless it has explicit permission from the
user.

Option:Aptitude::ProblemResolver::BrokenScore

Valeur par défaut:-100

Description: Nombre de points ajouté ou retranché aux solutions potentielles
en se basant sur le nombre de dépendances qu'ils cassent. Pour chaque
dépendance cassée par une solution possible, ce nombre de points est ajouté
  son score ; Généralement, il s'agit de points négatifs.

Option:Aptitude::ProblemResolver::Discard-Null-Solution

Valeur par défaut:true

Description: Si cette option est mise   true, aptitude ne suggérera jamais
d'annuler toutes les actions que vous aviez prévues pour résoudre un problème
de dépendances.

Option:Aptitude::ProblemResolver::EssentialRemoveScore

Valeur par défaut:-100000

Description: Nombre de points ajouté ou retiré au score des solutions
supprimant un paquet « essentiel ».

Option:Aptitude::ProblemResolver::ExtraScore

Valeur par défaut:-1

Description: Ce nombre de points sera ajouté au score de toute version d'un
paquet dont la priorité est « extra ».

Option:Aptitude::ProblemResolver::FullReplacementScore

Valeur par défaut:500

Description: Removing a package and installing another package that fully
replaces it (i.e., conflicts with it, replaces it, and provides it) is assigned
this score.

Option:Aptitude::ProblemResolver::ImportantScore

Valeur par défaut:5

Description: Ce nombre de points sera ajouté au score de toute version d'un
paquet dont la priorité est « important ».

Option:Aptitude::ProblemResolver::Infinity

Valeur par défaut:1000000

Description: Score « maximum », surnommé infini, pour les solutions
potentielles : si un ensemble d'actions   un score pire que -infini, il sera
écarté immédiatement.

Option:Aptitude::ProblemResolver::InstallScore

Valeur par défaut:-20

Description: Nombre de points que le solveur de problème devrait donner  
l'installation d'un paquet, s'il n'est pas déj  prévu de l'installer.

Option:Aptitude::ProblemResolver::KeepScore

Valeur par défaut:0

Description: Nombre de points que le solveur devrait donner pour garder un
paquet dans son état actuel, s'il n'est pas déj  prévu de garder ce paquet
dans son état courant.

Option:Aptitude::ProblemResolver::Max-Successors

Valeur par défaut:0

Description: Quand de nouvelles solutions sont générées, cette valeur
contrôle le temps que durera cette procédure de génération. Les successeurs
sont générés par lot, et dès qu'au moins un et au plus le maximum de noeuds
successeurs ont été générées, la génération de n&#339;ud s'arrête.
Augmenter cette valeur peut améliorer le score des premières solutions, mais
cela peut aussi faire durer plus longtemps chaque « étape ».

Option:Aptitude::ProblemResolver::NonDefaultScore

Valeur par défaut:-40

Description: Nombre de points que le solveur de problème devrait donner  
l'installation d'une version d'un paquet autre que celle par défaut (une qui
n'est ni la version actuelle, ni la « version candidate »).

Option:Aptitude::ProblemResolver::OptionalScore

Valeur par défaut:1

Description: Ce nombre de points sera ajouté au score de toute version d'un
paquet dont la priorité est « optionnel ».

Option:Aptitude::ProblemResolver::PreserveAutoScore

Valeur par défaut:0

Description: Nombre de points que le solveur de problème devrait donner   la
préservation des installations et suppressions automatiques.

Option:Aptitude::ProblemResolver::PreserveManualScore

Valeur par défaut:60

Description: Nombre de points que le solveur de problème devrait donner   la
préservation des actions explicitement sélectionnées par l'utilisateur.

Option:Aptitude::ProblemResolver::RemoveScore

Valeur par défaut:-300

Description: Nombre de points que le solveur de problème devrait donner   la
suppression d'un paquet s'il n'est pas déj  marqué pour suppression.

Option:Aptitude::ProblemResolver::RequiredScore

Valeur par défaut:4

Description: Ce nombre de points sera ajouté au score de toute version d'un
paquet dont la priorité est « requis ».

Option:Aptitude::ProblemResolver::ResolutionScore

Valeur par défaut:50

Description: En dehors de tout autre facteur, les solutions potentielles qui
résolvent toutes les dépendances non satisfaites sont récompensées par ce
bonus.

Option:Aptitude::ProblemResolver::StandardScore

Valeur par défaut:3

Description: Ce nombre de points sera ajouté au score de toute version d'un
paquet dont la priorité est « standard ».

Option:Aptitude::ProblemResolver::StepLimit

Valeur par défaut:5000

Description: The maximum number of « steps » which should be performed by
the problem resolver on each attempt to find a solution to a dependency problem.
Decreasing this number will make aptitude « give up » sooner; increasing it
will permit the search for a solution to consume much more time and memory
before it is aborted. Setting StepLimit to 0 will disable the problem resolver
entirely. The default value is large enough to accomodate commonly encountered
situations, while preventing aptitude from « blowing up » if an overly
complicated problem is encountered. (note: this applies only to command-line
searches; in the visual interface, the resolver will continue working until it
reaches a solution)

Option:Aptitude::ProblemResolver::StepScore

Valeur par défaut:70

Description: Nombre de points ajouté ou retranché aux solutions potentielles
en se basant sur leur longueur. Pour chaque action comprise dans une solution,
ce nombre de points est ajouté   son score ; Plus cette valeur est grande,
plus l'algorithme essaye de favoriser le premier choix plutôt que de s'orienter
vers une alternative. Cela permettra d'obtenir plus rapidement une solution,
mais qui risque d'être de qualité moindre   ce qu'elle aurait pu être.

Option:Aptitude::ProblemResolver::Trace-Directory

Valeur par défaut:

Description: If this value is set, then each time the problem resolver produces
a solution, a stripped-down version of the package state sufficient to reproduce
that solution is written to the given file. If Aptitude::ProblemResolver::Trace-
File is also set, the same information will also be written to the trace file.
Trace directories are more transparent than trace files, and are more suitable
for, e.g., including in source trees as test cases.

Option:Aptitude::ProblemResolver::Trace-File

Valeur par défaut:

Description: If this value is set, then each time the problem resolver produces
a solution, a stripped-down version of the package state sufficient to reproduce
that solution is written to the given file. If Aptitude::ProblemResolver::Trace-
Directory is also set, the same information will also be written to the trace
directory. A trace file is simply a compressed archive of a trace directory; it
will take less space than the trace directory and is suitable for transmission
over a network.

Option:Aptitude::ProblemResolver::UndoFullReplacementScore

Valeur par défaut:-500

Description: Installing a package and removing another package that fully
replaces it (i.e., conflicts with it, replaces it, and provides it) is assigned
this score.

Option:Aptitude::ProblemResolver::UnfixedSoftScore

Valeur par défaut:-200

Description: Nombre de points ajouté ou retranché aux solutions potentielles
qui laissent une recommandation (champ « Recommande ») non satisfaite. Il
est généralement plus petit que « RemoveScore », car sinon aptitude
pourrait supprimer des paquets plutôt que de laisser leurs recommandations non
satisfaites. Consultez la section intitulée « Résoudre les problèmes de
dépendance » pour plus de détails.

Option:Aptitude::ProblemResolver::UpgradeScore

Valeur par défaut:0

Description: Quel nombre de points le solveur de problème devrait donner   la
montée (ou la descente) en version vers la version candidate du paquet, s'il
n'est pas déj  prévu de le mettre   jour.

Option:Aptitude::ProblemResolver::WaitSteps

Valeur par défaut:50

Description: Le nombre d'étapes   effectuer par le solveur au premier plan
avant de replacer la résolution en tâche de fond. L'interface d'aptitude est
figé pendant le calcul, diminuer cette valeur rend le programme plus réactif,
mais peut entraîner l'apparition inutile de l'indicateur d'avancement.

Option:Aptitude::Purge-Unused

Valeur par défaut:false

Description: Si cette option est mise   true et si Aptitude::Delete-Unused est
aussi   true, les paquets qui ne sont plus utilisés seront purgé du système,
en supprimant leurs fichiers de configuration et peut-être des données
importantes. Pour plus d'informations sur les paquets considérés comme
« inutilisé », consultez la section intitulée « Gérer les paquets
automatiquement installés ». CETTE OPTION PEUT ENTRAÎNER DES PERTES DE
DONNÉES ! NE L'ACTIVEZ QUE SI VOUS SAVEZ CE QUE VOUS FAITES !

Option:Aptitude::Recommends-Important

Valeur par défaut:true

Description: This is an obsolete configuration option that has been superseded
by Apt::Install-Recommends. On startup, aptitude will copy Aptitude::Recommends-
Important (if it exists) to Apt::Install-Recommends and then clear Aptitude::
Recommends-Important in your user configuration file.

Option:Aptitude::Safe-Resolver::No-New-Installs

Valeur par défaut:false

Description: If this option is true, then when the « safe » dependency
resolver has been activated via --safe-resolver, the resolver will not be
allowed to install packages that are not currently installed. This is similar to
Aptitude::CmdLine::Safe-Upgrade::No-New-Installs, but applies only to command-
line actions other than safe-upgrade.

Option:Aptitude::Safe-Resolver::No-New-Upgrades

Valeur par défaut:false

Description: If this option is enabled, then when the « safe » dependency
resolver has been activated via --safe-resolver, the resolver will not be
allowed to resolve dependencies by upgrading packages.

Option:Aptitude::Sections::Descriptions

Valeur par défaut:See $prefix/share/aptitude/section-descriptions

Description: This option is a group whose members define the descriptions
displayed for each section when using the « section » package hierarchy
grouping policy. Descriptions are assigned to section trees based on the last
component of the name: for instance, a member of this group named « games »
will be used to describe the Sections « games », « non-free/games », and
« non-free/desktop/games ». Within the text of section descriptions, the
string « \n » will be replaced by a line-break, and the string « '' »
will be replaced by a double-quote character.

Option:Aptitude::Sections::Top-Sections

Valeur par défaut:"main"; "contrib"; "non-free"; "non-US";

Description: A configuration group whose elements are the names of the top-level
archive sections. The « topdir », « subdir », and « subdirs »
grouping policies use this list to interpret Section fields: if the first path
element of a package's Section is not contained in this list, or if its Section
has only one element, then the package will be grouped using the first member of
this list as its first path element. For example, if the first member of Top-
Sections is « main », then a package whose Section is « games » will be
treated as if its Section field were « games/arcade ».

Option:Aptitude::Simulate

Valeur par défaut:false

Description: In command-line mode, causes aptitude to just display the actions
that would be performed (rather than actually performing them); in the visual
interface, causes aptitude to start in read-only mode regardless of whether you
are root or not. This is equivalent to the -s command-line option.

Option:Aptitude::Spin-Interval

Valeur par défaut:500

Description: Nombre de millisecondes d'attente entre la mise   jour du
« spinner » qui apparaît pendant le fonctionnement du solveur.

Option:Aptitude::Suggests-Important

Valeur par défaut:false

Description: This is an obsolete option; use Aptitude::Keep-Suggests instead.
Setting this option to true has the same effect as setting Aptitude::Keep-
Suggests to true.

Option:Aptitude::Suppress-Read-Only-Warning

Valeur par défaut:false

Description: If this option is false, aptitude will display a warning the first
time that you attempt to modify package states while aptitude is in read-only
mode.

Option:Aptitude::Theme

Valeur par défaut:

Description: Thème qu'aptitude doit utiliser. Consultez la section intitulée
« Thèmes » pour plus d'informations.

Option:Aptitude::Track-Dselect-State

Valeur par défaut:true

Description: Si cette option est mise   true, aptitude essaiera de détecter si
un changement a été apporté   l'état du paquet par l'utilisation de dselect
ou dpkg : par exemple, si vous supprimez un paquet avec dpkg, aptitude
n'essaiera pas de le réinstaller. Notez que cela peut ne pas toujours
fonctionner parfaitement.

Option:Aptitude::UI::Advance-On-Action

Valeur par défaut:false

Description: Si cette option est mise   true, changer l'état d'un paquet (par
exemple, le marquer pour installation) basculera la mise en surbrillance vers le
prochain paquet dans le groupe courant.

Option:Aptitude::UI::Auto-Show-Reasons

Valeur par défaut:true

Description: Si cette option est mise   true, sélectionner un paquet qui est
cassé, ou qui semble avoir cassé d'autres paquets, va entraîner l'affichage
dans la zone d'information des raisons expliquant pourquoi ce paquet est cassé.

Option:Aptitude::UI::Default-Grouping

Valeur par défaut:filter(missing),status,section(subdirs,passthrough),section
(topdir)

Description: Configure la politique de regroupement par défaut utilisée pour
la liste des paquets. Consultez la section intitulée « Personnaliser la
hiérarchie des paquets » pour des informations supplémentaires sur les
politiques de regroupement.

Option:Aptitude::UI::Default-Package-View

Valeur par défaut:

Description: Cette option est un groupe dont les membres définissent
l'apparence par défaut de l'affichage d'aptitude. Consultez la section
intitulée « Personnaliser la disposition de l'affichage » pour plus
d'informations.

Option:Aptitude::UI::Default-Preview-Grouping

Valeur par défaut:action

Description: Configure la politique de regroupement par défaut utilisée pour
les écrans d'aperçu. Consultez la section intitulée « Personnaliser la
hiérarchie des paquets » pour des informations supplémentaires sur les
politiques de regroupement.

Option:Aptitude::UI::Default-Sorting

Valeur par défaut:name

Description: Configure la politique de tri par défaut des vues de paquets.
Consultez la section intitulée « Personnaliser la manière de trier les
paquets » pour plus d'informations.

Option:Aptitude::UI::Description-Visible-By-Default

Valeur par défaut:true

Description: Quand une liste de paquets est affichée pour la première fois, la
zone d'information (qui contient généralement la description longue du paquet
courant) sera visible si cette option est mise   true et cachée si elle est  
false.

Option:Aptitude::UI::Exit-On-Last-Close

Valeur par défaut:true

Description: Si cette option est mise   true, fermer toutes les vues actives
quittera aptitude. Sinon, aptitude ne quittera pas avant que vous exécutiez la
commande Actions ->; Quitter (Q). Consultezla section intitulée
« Travailler avec plusieurs vues » pour plus d'informations.

Option:Aptitude::UI::Fill-Text

Valeur par défaut:false

Description: Si cette option est mise   true, aptitude formatera les lignes
pour qu'elles occupent exactement la largeur de l'écran.

Option:Aptitude::UI::HelpBar

Valeur par défaut:true

Description: Si cette option est mise   true, une ligne d'information sur les
raccourcis clavier importants est affichée en haut de l'écran.

Option:Aptitude::UI::Incremental-Search

Valeur par défaut:true

Description: Si cette option est mise   true, aptitude effectuera des
recherches « incrémentales » : pendant que vous tapez le motif de
recherche, il cherchera le paquet suivant qui correspond   ce que vous avez
tapé jusque l .

Option:Aptitude::UI::InfoAreaTabs

Valeur par défaut:false

Description: If this option is true, aptitude will display tabs at the top of
the information area (the pane at the bottom of the screen) describing the
different modes the area can be set to.

Option:Aptitude::UI::Keybindings

Valeur par défaut:

Description: C'est un groupe de configuration dont les membres définissent les
relations entre séquences de touches et commandes dans aptitude. Pour plus
d'informations, consultez la section intitulée « Personnaliser les raccourcis
clavier ».

Option:Aptitude::UI::Menubar-Autohide

Valeur par défaut:false

Description: Si cette option est mise   true, la barre de menu sera cachée
lorsqu'elle ne sera pas utilisée.

Option:Aptitude::UI::Minibuf-Download-Bar

Valeur par défaut:false

Description: Si cette option est mise   true, aptitude utilisera un mécanisme
plus discret pour afficher l'avancement des téléchargements : une barre en
bas de l'écran apparaîtra pour afficher l'état actuel du téléchargement.
Lorsqu'un téléchargement est actif, appuyer sur q l'annulera.

Option:Aptitude::UI::Minibuf-Prompts

Valeur par défaut:false

Description: Si cette option est mise   true, certaines questions (comme les
questions oui/non ou   choix multiples) seront affichées en bas de l'écran
plutôt que dans une boîte de dialogue.

Option:Aptitude::UI::New-Package-Commands

Valeur par défaut:true

Description: Si cette option est mise   false, des commandes comme Paquet
->; Installer (+) auront le comportement dépassé qu'elles avaient dans
d'anciennes versions d'aptitude.

Option:Aptitude::UI::Package-Display-Format

Valeur par défaut:%c%a%M %p %Z %v %V

Description: Cette option contrôle la chaîne de format utilisée pour afficher
les paquets dans les listes de paquets. Pour plus d'informations sur les
chaînes de format, consultez la section intitulée « Personnaliser la
manière d'afficher les paquets ».

Option:Aptitude::UI::Package-Header-Format

Valeur par défaut:%N %n #%B %u %o

Description: Cette option contrôle la chaîne de format utilisée pour afficher
la ligne d'en-tête de la liste des paquets (c'est- -dire la ligne qui
apparaît entre la liste de paquets et la barre de menu). Pour plus
d'informations sur les chaînes de format, consultez la section intitulée
« Personnaliser la manière d'afficher les paquets ».

Option:Aptitude::UI::Package-Status-Format

Valeur par défaut:%d

Description: Cette option contrôle la chaîne de format utilisée pour afficher
la ligne d'état de la liste des paquets (c'est- -dire la ligne qui apparaît
entre la liste de paquets et la zone d'information). Pour plus d'informations
sur les chaînes de format, consultez la section intitulée « Personnaliser la
manière d'afficher les paquets ».

Option:Aptitude::UI::Pause-After-Download

Valeur par défaut:OnlyIfError

Description: Si cette option est   true, après avoir fini de télécharger les
paquets, aptitude affichera un message demandant si vous souhaitez continuer
l'installation. Si cette option est   OnlyIfError, un message ne sera affiché
qu'en cas d'échec du téléchargement. Si cette option est   false, aptitude
enchaînera immédiatement avec l'écran suivant   la fin du téléchargement.

Option:Aptitude::UI::Preview-Limit

Valeur par défaut:

Description: Filtre par défaut appliqué   l'écran de prévisualisation.
Consultez la section intitulée « Motifs de recherche » pour des détails
sur son format.

Option:Aptitude::UI::Prompt-On-Exit

Valeur par défaut:true

Description: Si cette option est mise   true, aptitude affichera une demande de
confirmation avant de quitter.

Option:Aptitude::UI::Styles

Valeur par défaut:

Description: Ceci est le groupe de configuration dont le contenu définit quels
styles textuels aptitude utilise pour afficher l'information. Pour plus
d'informations, consultez la section intitulée « Personnaliser la couleur du
texte et les styles ».

Option:Aptitude::UI::ViewTabs

Valeur par défaut:true

Description: Si cette option est mise   false, aptitude n'affichera pas le
bandeau listant les vues actuellement actives en haut de l'écran.

Option:Aptitude::Warn-Not-Root

Valeur par défaut:true

Description: Si cette option est mise   true, aptitude détectera quand vous
avez besoin des privilèges d'administration et vous demandera si vous souhaitez
passer sous le compte administrateur (root) si vous ne l'êtes pas déj .
Consultez la section intitulée « Devenir administrateur (« root ») »
pour plus d'informations.

Option:DebTags::Vocabulary

Valeur par défaut:/usr/share/debtags/vocabulary

Description: Emplacement du fichier de vocabulaire de debtags utilisé pour
charger les métadonnées des marqueurs du paquet.

Option:Dir::Aptitude::state

Valeur par défaut:/var/lib/aptitude

Description: Répertoire dans lequel les informations d'état persistant
d'aptitude sont conservées.

Option:Quiet

Valeur par défaut:0

Description: Cette option contrôle le niveau de silence de la ligne de
commande. La paramétrer   un niveau plus important désactive d'avantage les
indicateurs d'avancement.


Thèmes

Dans aptitude, un thème est juste un ensemble d'options de configuration. Les
thèmes sont utilisés pour venir recouvrir les valeurs par défaut de certaines
options. Si une option n'est pas configurée dans le fichier de configuration du
système ou dans votre fichier de configuration personnel, aptitude utilisera
les valeurs des options provenant du thème actuel, s'il y en a un de
disponible, avant d'utiliser les valeurs par défaut standard.

Un thème est simplement un groupe nommé sous Aptitude::Themes dont chacune des
options de configuration recouvrira l'option correspondante de la configuration
globale. Par exemple, si le thème Dselect est sélectionné, l'option
Aptitude::Themes::Dselect::Aptitude::UI::Package-Display-Format recouvrira la
valeur par défaut de l'option Aptitude::UI::Package-Display-Format.

Pour sélectionner un thème, donner le nom du thème comme valeur de l'option
de configuration d'Aptitude::Theme. Par exemple :

Aptitude::Theme Vertical-Split;

Les thèmes suivants sont fournis avec aptitude dans /usr/share/aptitude/
aptitude-defaults :



  Dselect
      Ce thème donne   aptitude une apparence et un comportement proche du
      vénérable gestionnaire de paquet dselect :

       Actions  Undo  Package  Search  Options  Views  Help
      f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
      --\ Installed Packages
        --\ Priority required
          --\ base - The Debian base system
      c   base  base-file 3.0.16      3.0.16      Debian base system
      miscellaneous fil
      c   base  base-pass 3.5.7       3.5.7       Debian base system master
      password a
      c   base  bash      2.05b-15    2.05b-15    The GNU Bourne Again SHell
      c   base  bsdutils  1:2.12-7    1:2.12-7    Basic utilities from 4.4BSD-
      Lite
      c   base  coreutils 5.0.91-2    5.0.91-2    The GNU core utilities
      c   base  debianuti 2.8.3       2.8.3       Miscellaneous utilities
      specific to
      c   base  diff      2.8.1-6     2.8.1-6     File comparison utilities
      base-files                      installed ; none
      required
      This package contains the basic filesystem hierarchy of a Debian system,
      and
      several important miscellaneous files, such as /etc/debian_version,
      /etc/host.conf, /etc/issue, /etc/motd, /etc/profile, /etc/nsswitch.conf,
      and
      others, and the text of several common licenses in use on Debian systems.







  Vertical-Split
      Ce thème arrange l'affichage de manière   ce que la description du
      paquet actuel s'affiche   droite de la liste des paquets plutôt qu'en-
      dessous de cette liste. Ce thème est utile avec des terminaux très
      larges, et peut-être aussi lors de l'édition de la hiérarchie des
      paquets intégrée.

       Actions  Undo  Package  Search  Options  Views  Help
      f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
      aptitude 0.2.14.1
      --\ Installed Packages                  Modern computers support the
      Advanced  #
        --\ admin - Administrative utilities  Configuration and Power Interface
          --\ main - The main Debian archive  (ACPI) to allow intelligent power
      i   acpid         1.0.3-19   1.0.3-19   management on your system and to
      query
      i   alien         8.44       8.44       battery and configuration status.
      i   anacron       2.3-9      2.3-9
      i   apt-show-vers 0.07       0.07       ACPID is a completely flexible,
      totally
      i A apt-utils     0.5.25     0.5.25     extensible daemon for delivering
      ACPI
      i   apt-watch     0.3.2-2    0.3.2-2    events. It listens on a file
      i   aptitude      0.2.14.1-2 0.2.14.1-2 (/proc/acpi/event) and when an
      event
      i   at            3.1.8-11   3.1.8-11   occurs, executes programs to
      handle the
      i   auto-apt      0.3.20     0.3.20     event. The programs it executes
      are
      i   cron          3.0pl1-83  3.0pl1-83  configured through a set of
      i   debconf       1.4.29     1.4.29     configuration files, which can be
      i   debconf-i18n  1.4.29     1.4.29     dropped into place by packages or
      by
      i A debootstrap   0.2.39     0.2.39     the admin.
      i A deborphan     1.7.3      1.7.3
      i   debtags       0.16       0.16       In order to use this package you
      need a
      i A defoma        0.11.8     0.11.8     recent Kernel (=>2.4.7). This can
      be
      i   discover      2.0.4-5    2.0.4-5    one including the patches on
      Utilities for using ACPI power management



Jouer au démineur

Au cas où vous seriez fatigué d'installer et supprimer des paquets, aptitude
inclut une version du jeu classique « démineur ». Pour le lancer,
sélectionner Actions ->; Jouer au démineur. Le plateau initial du
démineur apparaîtra alors :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                              10/10 mines  13 seconds





                                   +--------+
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   +--------+





À l'intérieur du rectangle qui apparaît   l'écran sont cachées dix mines.
Votre but est de déterminer, grâce   votre intuition, votre logique et la
chance, où ces mines se trouvent sans en faire exploser une seule ! Pour ce
faire, vous devez découvrir toutes les cases qui ne contiennent pas de mines.
Ce faisant, vous allez obtenir des informations importantes concernant les cases
qui contiennent des mines. Attention tout de même, découvrir une case qui
contient une mine la fera exploser, mettant fin au jeu immédiatement !

Pour découvrir une case (et savoir si une mine y est cachée), sélectionnez la
case avec les flèches et appuyer sur Entrée :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                             10/10 mines  387 seconds





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |    1...|
                                   | 1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Comme vous pouvez le voir, une partie de la zone cachée (vide) du plateau a
été révélée dans cette capture d'écran. Les cases contenant un . sont les
cases qui ne sont adjacentes   aucune mine. Les chiffres dans les autres cases
indiquent combien de mines il y a dans les cases adjacentes.

Si vous pensez savoir où une mine se trouve, vous pouvez placer un drapeau sur
celle-ci. Pour faire cela, sélectionner la case suspecte et appuyer sur f. Par
exemple, dans la capture suivante, j'ai décidé que la case sur la partie
gauche de l'écran avait l'air suspecte...

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                              9/10 mines  961 seconds





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |    1...|
                                   |F1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Comme vous pouvez le voir, un F est apparu sur la case sélectionnée. Il n'est
plus possible de découvrir cette case, même accidentellement, jusqu'  ce que
le drapeau soit enlevé (en appuyant   nouveau sur f). Une fois que vous avez
placé un drapeau sur toutes les mines qui sont   côté d'une case (par
exemple, les cases avec un 1   côté du drapeau au dessus), pour pouvez
« faire le ménage » autour de la case. Ce n'est qu'une facilité pour
découvrir toutes les cases adjacentes (  l'exception de celles contenant un
drapeau, bien sûr). Par exemple, faisons le ménage autour du 1 ci-dessus :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                              9/10 mines  2290
seconds





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |221 1...|
                                   |F1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Heureusement, ma supposition sur l'emplacement de cette mine était bon. Si
j'avais eu tort, j'aurais perdu immédiatement :

 Actions  Undo  Package  Search  Options  Views  Help
f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
Minesweeper                                   Minesweeper    Lost in 2388
seconds





                                   +--------+
                                   |^2......|
                                   |^2111...|
                                   |221^1...|
                                   |^1111...|
                                   |11...111|
                                   |...113^ |
                                   |1122* ^ |
                                   | ^ ^   ^|
                                   +--------+





Quand vous avez perdu, l'emplacement de toutes les mines est révélé : les
mines non explosées sont indiquées par un accent circonflexe (^), et celle sur
laquelle vous avez « marché » est indiquée par une astérisque (*).



--------------------------------------------------------------------------------
[7]J'ai plaisir   dire que le nombre de ces requêtes a fortement diminué
juste après la première parution de ce guide. Espérons qu'il y ait un lien
entre ces deux événements.

[8]Cela est parfois appelé « processus d'installation », même s'il se peut
que vous mettiez   jour ou supprimiez des paquets en plus d'en installer.

[9]Comme indiqué plus haut, cela n'indique pas que les paquets dans l'archive
sont sûrs ou non malveillants ; il montre simplement qu'ils sont d'origine.

[10] More precisely: they will be removed when there is no path via Depends,
PreDepends, or Recommends to them from a manually installed package. If
Aptitude::Keep-Suggests is true, a Suggests relationship is also enough to keep
a package installed.

[11] aptitude will only treat the comma as special if there is a second
argument, so (for instance) « ?name(apt,itude) » searches for the string
« apt,itude » in the Name field of packages.

While this behavior is well-defined, it may be surprising; I recommend using
quoted strings for any pattern that contains characters that could have a
special meaning.

[12] Characters with a special meaning include: « + », « - », « . »,
« ( », « ) », « | », « [ », « ] », « ^ », « $ », and
« ? ». Note that some of these are also aptitude metacharacters, so if you
want to type (for instance) a literal « | », it must be double-escaped:
« ?description(\~|) » will match packages whose description contains a
vertical bar character (« | »).

[13] Les séquences d'échappement \\, \n et \t sont également disponibles.

[14] Astute readers will note that this is essentially a way to explicitly name
the variable in the lambda;-terms corresponding to the term. A typical term would
have the form « lambda; x . name-equals(x, pattern) »; giving this an
explicit target makes x visible in the search language.

[15] This is provided largely for symmetry with ?true.

[16]Actuellement l'étiquetage n'est pas géré, cette commande est destinée  
un usage futur.

[17] Sur certains terminaux, un arrière plan « yellow » (jaune) s'affichera
en brun.


Chapitre 3. FAQ d'aptitude


  « Quel... est ton nom ? »                                     

   « Arthur, roi des Anglais. »

   « Quelle... est ta quête ? »

   « Je cherche le Saint Graal ! »

   « Quelle... est la vitesse d'une hirondelle   vide ? »

   « Qu'est-ce que vous voulez dire ? Une hirondelle d'Afrique ou
   d'Europe ? »

   « Euh ? Je ... je n'sais pa--AAAAAAAS ! »

                                         -- Monty Python, sacré Graal




  3.1. Comment puis-je trouver un paquet par son nom exact ?

  3.2. Comment puis-je trouver les paquets cassés ?

  3.3. Je veux sélectionner du texte avec la souris, pourquoi aptitude ne me
  laisse-t-il pas faire ?


3.1. Comment puis-je trouver un paquet par son nom exact ?

     Comme signalé dans la section intitulée « Motifs de recherche »,
     quand vous recherchez un paquet par son nom, le texte que vous tapez est en
     fait une expression rationnelle. Donc, le motif de recherche « ^nom$ »
     correspondra uniquement au paquet nommé nom.

     Par exemple, vous pouvez rechercher apt (mais pas aptitude ou synaptic) en
     tapant ^apt$. Vous pouvez rechercher g++ (mais pas g++-2.95 ou g++-3.0) en
     tapant ^g\+\+$.

3.2. Comment puis-je trouver les paquets cassés ?

     Utiliser la commande Rechercher ->; Rechercher les cassés (b).

3.3. Je veux sélectionner du texte avec la souris, pourquoi aptitude ne me
     laisse-t-il pas faire ?

     Normally, you cannot select text in an xterm while a program running in
     that terminal (such as aptitude) is using the mouse. However, you can
     override this behavior and perform a selection by holding the Shift key
     down while you click on the terminal.



Chapitre 4. Crédits


  Personne ne se rappelle du chanteur. La chanson reste.  

                      -- Terry Pratchett, Le dernier héros


Cette section garde le souvenir des personnes qui ont contribué   aptitude un
jour ou l'autre.


 [Note]  Note

         This section is presently rather incomplete and will likely be updated
         and expanded as time goes on (in particular, there are many missing
         translation credits due to the huge number of sources of translations
         [18]). If you think you should be on this list, please email
         <dburrows@debian.org> with an explanation of why you think so.


Traduction et internationalisation



  Traduction brésilienne
      Andre Luis Lopes, Gustavo Silva


  Traduction chinoise
      Carlos Z.F. Liu


  Traduction tchèque
      Miroslav Kure


  Traduction danoise
      Morten Brix Pedersen, Morten Bo Johansen


  Traduction néerlandaise
      Luk Claes


  Traduction finnoise
      Jaakko Kangasharju


  Traduction française
      Martin Quinson, Jean-Luc Coulon


  Traduction allemande
      Sebastian Schaffert, Erich Schubert, Sebastian Kapfer, Jens Seidel


  Traduction italienne
      Danilo Piazzalunga


  Traduction japonaise
      Yasuo Eto, Noritada Kobayashi


  Traduction lituanienne
      Darius Zhitkevicius


  Traduction polonaise
      Michal Politowski


  Traduction portugaise
      Nuno Sénica, Miguel Figueiredo


  Traduction norvégienne
      Håvard Korsvoll


  Traduction espagnole
      Jordi Malloch, Ruben Porras


  Traduction suédoise
      Daniel Nylander


  Correctif initial d'internationalisation (i18n)
      Masato Taruishi


  Maintenance et tri de l'i18n
      Christian Perrier


Documentation



  Manuel de l'utilisateur
      Daniel Burrows


Programmation



  Conception et mise en &#339;uvre du programme
      Daniel Burrows


  Gestion du champ Cassé pour dpkg.
      Ian Jackson, Michael Vogt




--------------------------------------------------------------------------------
[18] Il devrait être possible de créer une liste assez complète des
contributeurs de l'internationalisation en se basant sur le ChangeLog, les
références au système de gestion des bogues Debian et les versions de
l'historique d'aptitude, mais cela demanderait un énorme investissement en
temps qui n'est pas possible actuellement.



Référence de la ligne de commande

--------------------------------------------------------------------------------
Table des matières



  aptitude --; interface évoluée pour le gestionnaire de paquets

  aptitude-create-state-bundle --; bundle the current aptitude state

  aptitude-run-state-bundle --; unpack an aptitude state bundle and invoke
  aptitude on it


Nom

aptitude --; interface évoluée pour le gestionnaire de paquets


Synopsis

aptitude [options...] { autoclean | clean | forget-new | keep-all | update |
safe-upgrade }

aptitude [options...] { changelog | full-upgrade | download | forbid-version |
hold | install | markauto | purge | reinstall | remove | show | unhold |
unmarkauto | build-dep | build-depends } packages...

aptitude extract-cache-subset output-directory packages...

aptitude [options...] search motifs...

aptitude [options...] { add-user-tag | remove-user-tag } tag packages...

aptitude [options...] { why | why-not } [patterns...] package

aptitude [-S fname] [ -u | -i ]

aptitude help


Description

aptitude est une interface en mode texte pour le gestionnaire de paquets de
Debian GNU/Linux.

Elle permet   l'utilisateur de connaître la liste des paquets et de réaliser
des tâches d'administration comme l'installation, la mise   jour ou
l'effacement de paquets. Ces tâches peuvent être réalisées en mode
« interactif » ou   partir de la « ligne de commande ».


Commandes en ligne de commande

Le premier argument qui ne commence pas par un tiret (« - ») sera
considéré comme étant la commande que le programme doit réaliser. Si aucune
commande n'est donnée, aptitude démarrera en mode interactif.

Commandes disponibles :



  install
      Install one or more packages. The packages should be listed after the
      « install » command; if a package name contains a tilde character
      (« ~ ») or a question mark (« ? »), it will be treated as a search
      pattern and every package matching the pattern will be installed (see the
      section « Search Patterns » in the aptitude reference manual).

      Pour sélectionner une version précise d'un paquet, ajoutez
      « =version » au nom du paquet : par exemple, « aptitude install
      apt=0.3.1 ». De la même façon, pour choisir un paquet d'une archive
      précise, ajoutez « /archive » au nom du paquet : par exemple,
      « aptitude install apt/experimental ».

       Tous les paquets listés sur la ligne de commande ne doivent pas
      nécessairement être installé. Vous pouvez dire   aptitude d'agir
      différemment avec un paquet en suffixant un « attribut de surcharge »
      au nom du paquet. Par exemple, aptitude remove wesnoth+ installera wesnoth
      au lieu de le supprimer. Les attributs de surcharge suivants sont
      disponibles :



        paquet+
            Installe paquet.


        paquet+M
            Installe paquet et le marque comme installé automatiquement (notez
            que si aucun autre paquet ne dépend de paquet, cela entraînera sa
            suppression immédiate).


        paquet-
            Supprime paquet.


        paquet_
            Purge paquet : supprime le paquet ainsi que tous ses fichiers de
            configuration.


        paquet=
            Marque paquet comme étant   conserver : annule toute action
            d'installation, de mise   jour ou de suppression, et empêche ce
            paquet d'être mis   jour automatiquement dans le futur.


        paquet:
            Garde paquet   sa version actuelle : annule toute action
            d'installation, de mise   jour ou de suppression. Contrairement  
            « hold » (voir ci-dessus), cela n'empêche pas ce paquet d'être
            mis   jour automatiquement dans le futur.


        paquet&M
            Marque paquet comme ayant été installé automatiquement.


        paquet&m
            Marque paquet comme ayant été installé manuellement.


      Cas particulier, « install » sans autre argument résoudra les
      commandes en suspens ou différées.


       [Note]  Note

               Une fois que vous avez appuyé sur Y   l'invite de confirmation
               finale, la commande « install » modifie les informations
               enregistrées sur les actions qu'aptitude doit réaliser. De ce
               fait, si vous lancez la commande « aptitude install toto
               titi » puis que vous arrêtiez l'installation alors qu'aptitude
               a déj  commencé   télécharger et installer des paquets,
               vous devrez lancer « aptitude remove toto titi » pour
               l'annuler.



  remove, purge, hold, unhold, keep, reinstall
      These commands are the same as « install », but apply the named action
      to all packages given on the command line for which it is not overridden.
      The difference between hold and keep is that hold will cause a package to
      be ignored by future safe-upgrade or full-upgrade commands, while keep
      merely cancels any scheduled actions on the package. unhold will allow a
      package to be upgraded by future safe-upgrade or full-upgrade commands,
      without otherwise altering its state.

      Par exemple, « aptitude remove '~ndeity' » supprimera tous les paquets
      dont le nom contient « deity »).


  markauto, unmarkauto
      Indique que les paquets ont été respectivement installés
      automatiquement, ou   la main. Vous pouvez choisir les paquets grâce  
      la syntaxe vue plus haut, et même indiquer les commandes   réaliser.
      Par exemple, « aptitude markauto '~slibs' » marquera tous les paquets
      de la section « libs » comme ayant été installés automatiquement.

      Pour plus d'informations sur les paquets installés automatiquement,
      consultez la section « Gérer les paquets automatiquement installés »
      dans le manuel de référence d'aptitude.


  build-depends, build-dep
      Satisfy the build-dependencies of a package. Each package name may be a
      source package, in which case the build dependencies of that source
      package are installed; otherwise, binary packages are found in the same
      way as for the « install » command, and the build-dependencies of the
      source packages that build those binary packages are satisfied.

      If the command-line parameter --arch-only is present, only architecture-
      dependent build dependencies (i.e., not Build-Depends-Indep or Build-
      Conflicts-Indep) will be obeyed.


  forbid-version
      Empêche la mise   jour vers une version précise d'un paquet. Cette
      option interdit   aptitude la mise   jour automatique vers cette
      version, mais permettra le passage aux versions suivantes. Par défaut,
      aptitude choisira la version vers laquelle ce paquet aurait normalement
      dû être mis   jour. Vous pouvez modifier ce choix en ajoutant
      « =version » au nom du paquet : par exemple, « aptitude forbid-
      version vim=1.2.3.broken-4 ».

      Cette commande est pratique pour éviter les versions boguées des paquets
      sans avoir   définir ou supprimer des gels   la main. Si vous décidez
      finalement d'installer la version que vous aviez interdite, la commande
      « install » mettra fin   l'interdiction.


  update
      Met   jour la liste des paquets disponibles sur les serveurs maîtres.
      (C'est l'équivalent de « apt-get update »).


  safe-upgrade
      Upgrades installed packages to their most recent version. Installed
      packages will not be removed unless they are unused (see the section
      « Managing Automatically Installed Packages » in the aptitude
      reference manual). Packages which are not currently installed may be
      installed to resolve dependencies unless the --no-new-installs command-
      line option is supplied.

      It is sometimes necessary to remove one package in order to upgrade
      another; this command is not able to upgrade packages in such situations.
      Use the full-upgrade command to upgrade as many packages as possible.


  full-upgrade
      Upgrades installed packages to their most recent version, removing or
      installing packages as necessary. This command is less conservative than
      safe-upgrade and thus more likely to perform unwanted actions. However, it
      is capable of upgrading packages that safe-upgrade cannot upgrade.


       [Note]  Note

               Cette commande s'appellait dist-upgrade pour des raisons
               historiques, aptitude la reconnait toujours. dist-upgrade est un
               synonyme de full-upgrade.



  keep-all
      Annule toutes les actions prévues sur des paquets. Tout paquet dont
      l'état indique une action prévue d'installation, de suppression ou de
      mise   jour verra son état remis   zéro.


  forget-new
      Ignore les « nouveaux » paquets (équivaut   presser « f » en
      mode interactif).


  search
      Recherche les paquets qui correspondent   un ou plusieurs motifs donnés
      sur la ligne de commande. Tous les paquets correspondant aux expressions
      demandées seront affichés. Par exemple, « aptitude search '~N'
      edit » affichera tous les « nouveaux » paquets et ceux dont le nom
      contient « edit ». Les expressions de recherche sont expliquées en
      détail dans « Motifs de recherche » dans le manuel de référence
      d'aptitude.

      A moins d'avoir invoqué l'option -F, la sortie de la commande aptitude
      search ressemblera   quelque chose comme ceci :

      i   apt                             - Advanced front-end for dpkg

      pi  apt-build                       - frontend to apt to build, optimize
      and in
      cp  apt-file                        - APT package searching utility -
      - command-
      ihA raptor-utils                    - Raptor RDF Parser utilities

      Les résultats sont présentés ligne par ligne. Le premier caractère de
      chaque ligne indique l'état courant du paquet : les états les plus
      courants sont p qui signifie qu'aucune trace du paquet n'est présente sur
      le système, c qui signifie que le paquet   été supprimé mais que ses
      fichiers de configuration sont toujours présent sur le système, i qui
      signifie que le paquet est installé et v qui signifie que le paquet est
      virtuel. Le second caractère indique l'action prévue (s'il y en a une,
      un espace sinon) sur le paquet. Les actions les plus courantes sont : i
      pour les paquets sur le point   installer, d pour ceux   supprimer et p
      pour ceux   purger (c- -d,   supprimer ainsi que ses fichiers de
      configuration). Si le dernier caractère est un A, le paquet a été
      installé automatiquement.

      For a complete list of the possible state and action flags, see the
      section « Accessing Package Information » in the aptitude reference
      guide. To customize the output of search, see the command-line options -
      F and --sort.


  show
      Displays detailed information about one or more packages, listed following
      the search command. If a package name contains a tilde character
      (« ~ ») or a question mark (« ? »), it will be treated as a search
      pattern and all matching packages will be displayed (see the section
      « Search Patterns » in the aptitude reference manual).

      Si le niveau de verbosité est au moins 1 (c'est- -dire que l'option -
      v est présente sur la ligne de commande), les informations sur toutes les
      versions du paquets sont affichées. Sinon, seules les informations sur la
      « version installable » sont affichées (la version qui serait
      téléchargée par « aptitude install »).

      Vous pouvez afficher les informations d'une version particulière d'un
      paquet en suffixant =version au nom du paquet ; vous pouvez également
      afficher les informations sur une version d'une archive particulière en
      suffixant /archive au nom du paquet. Si un des ces arguments est présent,
      seule la version demandée sera affichée, quelque soit le niveau de
      verbosité.

      Si le niveau de verbosité est au moins 1, les champs architecture, taille
      compressée, nom de fichier et somme md5 du paquet sont affichés. Si le
      niveau de verbosité est au moins 2, la ou les versions sélectionnées
      seront affichées une fois pour chacune des archives dans lesquelles elles
      sont trouvées.


  add-user-tag, remove-user-tag
      Adds a user tag to or removes a user tag from the selected group of
      packages. If a package name contains a tilde (« ~ ») or question mark
      (« ? »), it is treated as a search pattern and the tag is added to or
      removed from all the packages that match the pattern (see the section
      « Search Patterns » in the aptitude reference manual).

      User tags are arbitrary strings associated with a package. They can be
      used with the ?user-tag(tag) search term, which will select all the
      packages that have a user tag matching tag.


  why, why-not
      Explains the reason that a particular package should or cannot be
      installed on the system.

      Cette commande cherche les paquets qui dépendent ou sont en conflit avec
      ce paquet. Il affiche la suite de dépendances qui s'enchainent jusqu'au
      paquet visé, et une note indique l'état de chacun des paquets de la
      suite de dépendances.

      $ aptitude why kdepim
      i   nautilus-data Recommends nautilus
      i A nautilus      Recommends desktop-base (>= 0.2)
      i A desktop-base  Suggests   gnome | kde | xfce4 | wmaker
      p   kde           Depends    kdepim (>= 4:3.4.3)

      The command why finds a dependency chain that installs the package named
      on the command line, as above. Note that the dependency that aptitude
      produced in this case is only a suggestion. This is because no package
      currently installed on this computer depends on or recommends the kdepim
      package; if a stronger dependency were available, aptitude would have
      displayed it.

      A contrario, why-not cherche la chaîne de dépendances qui conduit au
      conflit avec le paquet ciblé.

      $ aptitude why-not textopo
      i   ocaml-core          Depends   ocamlweb
      i A ocamlweb            Depends   tetex-extra | texlive-latex-extra
      i A texlive-latex-extra Conflicts textopo

      If one or more patterns are present, then aptitude will begin its search
      at these patterns; that is, the first package in the chain it prints will
      be a package matching the pattern in question. The patterns are considered
      to be package names unless they contain a tilde character (« ~ ») or a
      question mark (« ? »), in which case they are treated as search
      patterns (see the section « Search Patterns » in the aptitude
      reference manual).

      If no patterns are present, then aptitude will search for dependency
      chains beginning at manually installed packages. This effectively shows
      the packages that have caused or would cause a given package to be
      installed.


       [Note]  Note

               aptitude why ne réalise par une recherche compléte de
               dépendances. Il n'affiche que les relations directes entre
               paquet. Par exemple, si A a besoin de B, que C a besoin de D, et
               que B et C sont en conflit, « aptitude why-not D » ne
               trouvera pas la réponse « A dépend de BB, B est en conflit
               avec C, et D dépend de C ».


      Aptitude n'affiche par défaut que les chaînes de dépendances « most
      installed, strongest, tightest, shortest ». Dans ce cas, il cherche une
      chaîne qui ne contient que les paquets qui sont installés ou qui seront
      installés. Il recherche les dépendances les plus fortes possibles dans
      ce cadre, et recherche les chaînes qui évitent les dépendances ORed et
      Provides, et il recherche la chaîne de dépendance la plus courte qui
      respecte ces contraintes. Ces régles sont appliquées de façon de moins
      en moins stricte jusqu'  ce qu'une correspondance soit trouvée.

      Si le niveau du mode verbeux est   1 ou plus, alors toutes les
      explications qu'aptitude trouvera seront affichées, dans l'ordre de
      pertinence décroissante. Si le niveau de mode verbeux est de 2 ou plus,
      un trés important niveau d'information de débogage sera affiché sur la
      sortie standard.

      Cette commande renvoie un 0 si elle réussit, 1 si aucune explication n'a
      été trouvée, et -1 si une erreur apparaît.


  clean
      Supprime tous les paquets .deb téléchargés et enregistrés dans le
      répertoire cache (normalement /var/cache/apt/archives).


  autoclean
      Supprime tout paquet enregistré dans le cache et qui n'est plus proposé
      au téléchargement. Cela vous permet d'empêcher que le cache ne
      grossisse démesurément avec le temps, sans avoir   le vider
      complètement.


  changelog
      Télécharge et affiche le journal des modifications pour chaque paquet
      source ou binaires.

      Par défaut, le journal correspondant   la version qui serait installé
      par « aptitude install » est téléchargé. Vous pouvez sélectionner
      une version particulière d'un paquet en suffixant =version au nom du
      paquet ; vous pouvez également sélectionner la version d'une archive
      particulière en suffixant /archive au nom du paquet.


  download
      Downloads the .deb file for the given package to the current directory. If
      a package name contains a tilde character (« ~ ») or a question mark
      (« ? »), it will be treated as a search pattern and all the matching
      packages will be downloaded (see the section « Search Patterns » in
      the aptitude reference manual).

      Par défaut, le fichier correspondant   la version qui serait installé
      par « aptitude install » est téléchargé. Vous pouvez sélectionner
      une version particulière d'un paquet en suffixant =version au nom du
      paquet ; vous pouvez également sélectionner la version d'une archive
      particulière en suffixant /archive au nom du paquet.


  extract-cache-subset
      Copy the apt configuration directory (/etc/apt) and a subset of the
      package database to the specified directory. If no packages are listed,
      the entire package database is copied; otherwise only the entries
      corresponding to the named packages are copied. Each package name may be a
      search pattern, and all the packages matching that pattern will be
      selected (see the section « Search Patterns » in the aptitude
      reference manual). Any existing package database files in the output
      directory will be overwritten.

      Dependencies in binary package stanzas will be rewritten to remove
      references to packages not in the selected set.


  help
      Affiche un bref résumé des commandes et options disponibles.



Options

Les options qui suivent peuvent être utilisées afin de modifier le
comportement des commandes ci-dessus. Remarquez que les commandes ne vont pas
toutes réagir   chaque option (en effet, certaines options n'ont aucun sens
pour certaines commandes).



  --add-user-tag tag
      For full-upgrade, safe-upgrade, forbid-version, hold, install, keep-all,
      markauto, unmarkauto, purge, reinstall, remove, unhold, and unmarkauto:
      add the user tag tag to all packages that are installed, removed, or
      upgraded by this command as if with the add-user-tag command.


  --add-user-tag-to tag,pattern
      For full-upgrade, safe-upgrade forbid-version, hold, install, keep-all,
      markauto, unmarkauto, purge, reinstall, remove, unhold, and unmarkauto:
      add the user tag tag to all packages that match pattern as if with the
      add-user-tag command. The pattern is a search pattern as described in the
      section « Search Patterns » in the aptitude reference manual.

      For instance, aptitude safe-upgrade --add-user-tag-to "new-
      installs,?action(install)" will add the tag new-installs to all the
      packages installed by the safe-upgrade command.


  --allow-new-upgrades
      When the safe resolver is being used (i.e., --safe-resolver was passed or
      Aptitude::Always-Use-Safe-Resolver is set to true), allow the dependency
      resolver to install upgrades for packages regardless of the value of
      Aptitude::Safe-Resolver::No-New-Upgrades.


  --allow-new-installs
      Allow the safe-upgrade command to install new packages; when the safe
      resolver is being used (i.e., --safe-resolver was passed or Aptitude::
      Always-Use-Safe-Resolver is set to true), allow the dependency resolver to
      install new packages. This option takes effect regardless of the value of
      Aptitude::Safe-Resolver::No-New-Installs.


  --allow-untrusted
      Install packages from untrusted sources without prompting. You should only
      use this if you know what you are doing, as it could easily compromise
      your system's security.


  --disable-columns
      This option causes aptitude search to output its results without any
      special formatting. In particular: normally aptitude will add whitespace
      or truncate search results in an attempt to fit its results into vertical
      « columns ». With this flag, each line will be formed by replacing any
      format escapes in the format string with the correponding text; column
      widths will be ignored.

      For instance, the first few lines of output from « aptitude search -
      F '%p %V' --disable-columns libedataserver » might be:

      disksearch 1.2.1-3
      hp-search-mac 0.1.3
      libbsearch-ruby 1.5-5
      libbsearch-ruby1.8 1.5-5
      libclass-dbi-abstractsearch-perl 0.07-2
      libdbix-fulltextsearch-perl 0.73-10

      As in the above example, --disable-columns is often useful in combination
      with a custom display format set using the command-line option -F.

      This corresponds to the configuration option Aptitude::CmdLine::Disable-
      Columns.


  -D, --show-deps
      For commands that will install or remove packages (install, full-upgrade,
      etc), show brief explanations of automatic installations and removals.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Deps.


  -d, --download-only
      N'installe ni ne supprime aucun paquet. Télécharge simplement les
      paquets nécessaires dans le cache.

      Directive du fichier de configuration : Aptitude::CmdLine::Download-Only.


   -F format, --display-format format
      Définit le format qui sera utilisé pour afficher les résultats de la
      commande search. Par exemple, « %p %V %v » affichera le nom du paquet,
      suivi du numéro de la version installée, ainsi que les versions
      disponibles. Pour plus d'informations, consultez la section
      « Personnaliser la manière d'afficher les paquets » dans le manuel de
      référence d'aptitude.

      The command-line option --disable-columns is often useful in combination
      with -F.

      Directive du fichier de configuration : Aptitude::CmdLine::Package-
      Display-Format.


  -f
      Essaye témérairement de résoudre les dépendances des paquets cassés,
      même si cela implique d'ignorer des actions demandées sur la ligne de
      commande.

      Directive du fichier de configuration : Aptitude::CmdLine::Fix-Broken.


  --full-resolver
      When package dependency problems are encountered, use the default
      « full » resolver to solve them. Unlike the « safe » resolver
      activated by --safe-resolver, the full resolver will happily remove
      packages to fulfill dependencies. It can resolve more situations than the
      safe algorithm, but its solutions are more likely to be undesirable.

      This option can be used to force the use of the full resolver even when
      Aptitude::Always-Use-Safe-Resolver is true. The safe-upgrade command never
      uses the full resolver and does not accept the --full-resolver option.


  -h, --help
      Affiche un court message d'aide. Identique   l'action help.


   --no-new-installs
      Prevent safe-upgrade from installing any new packages; when the safe
      resolver is being used (i.e., --safe-resolver was passed or Aptitude::
      Always-Use-Safe-Resolver is set to true), forbid the dependency resolver
      from installing new packages. This option takes effect regardless of the
      value of Aptitude::Safe-Resolver::No-New-Installs.

      This mimics the historical behavior of apt-get upgrade.

      This corresponds to the configuration option Aptitude::CmdLine::Safe-
      Upgrade::No-New-Installs.


  --no-new-upgrades
      When the safe resolver is being used (i.e., --safe-resolver was passed or
      Aptitude::Always-Use-Safe-Resolver is set to true), allow the dependency
      resolver to install new packages regardless of the value of Aptitude::
      Safe-Resolver::No-New-Installs.


  -O ordre, --sort ordre
      Specify the order in which output from the search command should be
      displayed. For instance, passing « installsize » for order will list
      packages in order according to their size when installed (see the section
      « Customizing how packages are sorted » in the aptitude reference
      manual for more information).


  -o clef=valeur
      Définit une option du fichier de configuration   la volée. Utilisez par
      exemple -o Aptitude::Log=/tmp/mes-logs afin de consigner (logs) les
      événements d'aptitude dans le fichier /tmp/mes-logs. Pour plus
      d'informations sur les options du fichier de configuration, consultez le
      chapitre « Référence du fichier de configuration » dans le manuel de
      référence d'aptitude.


  -P, --prompt
      Always display a prompt before downloading, installing or removing
      packages, even when no actions other than those explicitly requested will
      be performed.

      Directive du fichier de configuration : Aptitude::CmdLine::Always-Prompt.


  --purge-unused
      Purge les paquets dont aucun autre paquet installé ne dépend. Cela
      revient   mettre le paramètre « -o Aptitude::Purge-Unused=true » sur
      la ligne de commande.


  -q[=n], --quiet[=n]
      Enlève tous les indicateurs d'avancement et rend ainsi la sortie
      journalisable. Cette option peut être passée plusieurs fois pour rendre
      le programme de plus en plus silencieux, mais contrairement   apt-get,
      aptitude n'ajoute pas implicitement -y quand -q est passée plus d'une
      fois.

      Le paramètre optionnel =n peut être utilisé pour configurer directement
      le taux de silence (par exemple, pour surcharger un paramétrage dans /
      etc/apt/apt.conf) ; le programme agit alors comme si -q lui avait été
      passée exactement n fois.


  -R, --without-recommends
      Ne gère pas les recommandations de dépendances lors de l'installation de
      nouveaux paquets (prioritaire sur les réglages de /etc/apt/apt.conf and
      ~/.aptitude/config). Les paquets installés précédemment pour ces même
      raisons de recommandation ne seront pas supprimés.

      This corresponds to the pair of configuration options Apt::Install-
      Recommends and Aptitude::Keep-Recommends.


  -r, --with-recommends
      Traite les suggestions ou les recommandations en tant que dépendances
      lors de l'installation des nouveaux paquets. (Prioritaire sur les
      réglages de /etc/apt.conf et ~/.aptitude/config).

      This corresponds to the configuration option Apt::Install-Recommends


  --remove-user-tag tag
      For full-upgrade, safe-upgrade forbid-version, hold, install, keep-all,
      markauto, unmarkauto, purge, reinstall, remove, unhold, and unmarkauto:
      remove the user tag tag from all packages that are installed, removed, or
      upgraded by this command as if with the add-user-tag command.


  --remove-user-tag-from tag,pattern
      For full-upgrade, safe-upgrade forbid-version, hold, install, keep-all,
      markauto, unmarkauto, purge, reinstall, remove, unhold, and unmarkauto:
      remove the user tag tag from all packages that match pattern as if with
      the remove-user-tag command. The pattern is a search pattern as described
      in the section « Search Patterns » in the aptitude reference manual.

      For instance, aptitude safe-upgrade --remove-user-tag-from "not-
      upgraded,?action(upgrade)" will remove the not-upgraded tag from all
      packages that the safe-upgrade command is able to upgrade.


  -s, --simulate
      En mode ligne de commande, affiche la liste des actions qui seraient
      réalisées, mais ne les lance pas réellement. Il n'est pas nécessaire
      d'avoir les privilèges d'administration. Dans l'interface visuelle, ouvre
      toujours le cache en mode lecture seule que vous soyez administrateur ou
      non.

      Directive du fichier de configuration : Aptitude::Simulate.


  --safe-resolver
      When package dependency problems are encountered, use a « safe »
      algorithm to solve them. This resolver attempts to preserve as many of
      your choices as possible; it will never remove a package or install a
      version of a package other than the package's default candidate version.
      It is the same algorithm used in safe-upgrade; indeed, aptitude --safe-
      resolver full-upgrade is equivalent to aptitude safe-upgrade. Because
      safe-upgrade always uses the safe resolver, it does not accept the --safe-
      resolver flag.

      This option is equivalent to setting the configuration variable Aptitude::
      Always-Use-Safe-Resolver to true.


  --schedule-only
      Pour les commandes qui modifient l'état des paquets, programme les
      actions   faire pour plus tard, mais ne les fait pas. Vous pouvez
      exécuter les actions programmées en lançant aptitude install sans
      paramètre. Cela revient   faire la sélection correspondante en mode
      visuel, puis   quitter aptitude normalement.

      Par exemple, aptitude --schedule-only install evolution va programmer
      l'installation future du paquet evolution.


  -t version, --target-release version
      Définit la version   partir de laquelle les paquets devront être
      installés. Par exemple, « aptitude -t expérimental ... » installera
      les paquets de la distribution expérimentale, si rien d'autre n'est
      précisé. Pour les actions de la ligne de commandes « changelog »,
      « download » et « show », cela revient   suffixer /version au nom
      de chaque paquet cité sur la ligne de commandes. Pour les autres
      commandes, cela modifiera la version installée par défaut selon les
      règles décrites dans apt_preferences(5).

      Directive du fichier de configuration : APT::Default-Release.


  -V, --show-versions
      Indique quelle version du paquet sera installée.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Versions.


  -v, --verbose
      Force quelques commandes (show par exemple)   afficher des informations
      supplémentaires. Peut être invoqué plusieurs fois afin d'obtenir des
      informations de plus en plus complètes.

      Directive du fichier de configuration : Aptitude::CmdLine::Verbose.


  --version
      Affiche la version et quelques informations sur l'environnement de
      compilation d'aptitude.


  --visual-preview
      Lance l'interface visuelle et affiche l'écran d'accueil, plutôt que
      d'afficher l'habituelle invite de commande en ligne.


  -W, --show-why
      In the preview displayed before packages are installed or removed, show
      which manually installed package requires each automatically installed
      package. For instance:

      $ aptitude --show-why install mediawiki
      ...
      The following NEW packages will be installed:
        libapache2-mod-php5{a} (for mediawiki)  mediawiki  php5{a} (for
      mediawiki)
        php5-cli{a} (for mediawiki)  php5-common{a} (for mediawiki)
        php5-mysql{a} (for mediawiki)

      When combined with -v or a non-zero value for Aptitude::CmdLine::Verbose,
      this displays the entire chain of dependencies that lead each package to
      be installed. For instance:

      $ aptitude -v --show-why install libdb4.2-dev
      The following NEW packages will be installed:
        libdb4.2{a} (libdb4.2-dev D: libdb4.2)  libdb4.2-dev
      The following packages will be REMOVED:
        libdb4.4-dev{a} (libdb4.2-dev C: libdb-dev P<- libdb-dev)

      This option will also describe why packages are being removed, as shown
      above. In this example, libdb4.2-dev conflicts with libdb-dev, which is
      provided by libdb-dev.

      This argument corresponds to the configuration option Aptitude::CmdLine::
      Show-Why and displays the same information that is computed by aptitude
      why and aptitude why-not.


  -w largeur, --width largeur
      Définit la largeur utilisée pour l'affichage du résultat de la commande
      search. (Par défaut, c'est la largeur du terminal).

      Directive du fichier de configuration : Aptitude::CmdLine::Package-
      Display-Width


  -y, --assume-yes
      Répond « oui »   toute question de type oui/non. En fait, cette
      option supprime l'invite (le prompt) qui apparaît quand on installe, met
        jour ou supprime des paquets. N'affecte pas les réponses aux questions
      particulièrement dangereuses, telles que la suppression des paquets
      essentiels. A priorité sur -P.

      Directive du fichier de configuration : Aptitude::CmdLine::Assume-Yes.


  -Z
      Affiche l'espace disque qui sera utilisé ou libéré par chacun des
      paquets   installer, mettre   jour ou supprimer.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Size-
      Changes.


Les options suivantes s'appliquent au mode visuel du programme. Toutefois, elles
ne sont utilisées qu'en interne. Normalement, vous n'en aurez pas besoin.



  -i
      Affiche l'écran de téléchargement au démarrage du programme
      (équivalent au lancement du programme, puis   l'appui sur « g »). On
      ne peut pas se servir en même temps de cette option et de -u.


  -S nom-fichier
      Charge les informations supplémentaires   partir de nom-fichier plutôt
      qu'  partir du fichier standard.


  -u
      Lance la mise   jour de la liste des paquets dès le démarrage du
      programme. On ne peut pas se servir en même temps de cette option et de -
      i.



Variables d'environnement



  HOME
      Si $HOME/.aptitude existe, aptitude stockera son fichier de configuration
      dans $HOME/.aptitude/config. Sinon, il recherchera le répertoire
      personnel de l'utilisateur courant, grâce   getpwuid(2) pour y placer
      son fichier de configuration.


  PAGER
      Quand cette variable d'environnement est paramétrée, aptitude
      l'utilisera pour afficher les journaux de modification   l'invocation de
      « aptitude changelog ». La valeur par défaut est more.


  TMP
      Quand TMPDIR n'est pas paramétrée, aptitude stockera ses fichiers
      temporaires dans TMP si cette dernière variable est paramétrée. Sinon,
      il les stockera dans /tmp.


  TMPDIR
      aptitude stockera ses fichiers temporaires dans le répertoire spécifié
      par cette variable d'environnement. Si TMPDIR n'est pas paramétrée,
      alors TMP est utilisée. Si cette dernière ne l'est pas non plus, alors
      aptitude utilise /tmp.



Files



  /var/lib/aptitude/pkgstates
      The file in which stored package states and some package flags are stored.




  /etc/apt/apt.conf, /etc/apt/apt.conf.d/*, ~/.aptitude/config
      The configuration files for aptitude. ~/.aptitude/config overrides /etc/
      apt/apt.conf. See apt.conf(5) for documentation of the format and contents
      of these files.



Voir aussi

apt-get(8), apt(8), /usr/share/doc/aptitude/html/lang/index.html du paquet
aptitude-doc-lang

--------------------------------------------------------------------------------

Nom

aptitude-create-state-bundle --; bundle the current aptitude state


Synopsis

aptitude-create-state-bundle [options...] output-file


Description

aptitude-create-state-bundle produces a compressed archive storing the files
that are required to replicate the current package archive state. The following
files and directories are included in the bundle:


* $HOME/.aptitude

* /var/lib/aptitude

* /var/lib/apt

* /var/cache/apt/*.bin

* /etc/apt

* /var/lib/dpkg/status


The output of this program can be used as an argument to aptitude-run-state-
bundle(1).


Options



  --force-bzip2
      Override the autodetection of which compression algorithm to use. By
      default, aptitude-create-state-bundle uses bzip2(1) if it is available,
      and gzip(1) otherwise. Passing this option forces the use of bzip2 even if
      it doesn't appear to be available.


  --force-gzip
      Override the autodetection of which compression algorithm to use. By
      default, aptitude-create-state-bundle uses bzip2(1) if it is available,
      and gzip(1) otherwise. Passing this option forces the use of gzip even if
      bzip2 is available.


  --help
      Print a brief usage message, then exit.


  --print-inputs
      Instead of creating a bundle, display a list of the files and directories
      that the program would include if it generated a bundle.



File Format

The bundle file is simply a tar(1) file compressed with bzip2(1) or gzip(1),
with each of the input directory trees rooted at « . ».


Voir aussi

aptitude-run-state-bundle(1), aptitude(8), apt(8)

--------------------------------------------------------------------------------

Nom

aptitude-run-state-bundle --; unpack an aptitude state bundle and invoke
aptitude on it


Synopsis

aptitude-run-state-bundle [options...] input-file [ program [arguments...]]


Description

aptitude-run-state-bundle unpacks the given aptitude state bundle created by
aptitude-create-state-bundle(1) to a temporary directory, invokes program on it
with the supplied arguments, and removes the temporary directory afterwards. If
program is not supplied, it defaults to aptitude(8).


Options

The following options may occur on the command-line before the input file.
Options following the input file are presumed to be arguments to aptitude.



  --append-args
      Place the options that give the location of the state bundle at the end of
      the command line when invoking program, rather than at the beginning (the
      default is to place options at the beginning).


  --help
      Display a brief usage summary.


  --prepend-args
      Place the options that give the location of the state bundle at the
      beginning of the command line when invoking program, overriding any
      previous --append-args (the default is to place options at the beginning).


  --no-clean
      Do not remove the unpacked state directory after running aptitude. You
      might want to use this if, for instance, you are debugging a problem that
      appears when aptitude's state file is modified. When aptitude finishes
      running, the name of the state directory will be printed so that you can
      access it in the future.

      This option is enabled automatically by --statedir.


  --really-clean
      Delete the state directory after running aptitude, even if --no-clean or -
      -statedir was supplied.


  --statedir
      Instead of treating the input file as a state bundle, treat it as an
      unpacked state bundle. For instance, you can use this to access the state
      directory that was created by a prior run with --no-clean.


  --unpack
      Unpack the input file to a temporary directory, but don't actually run
      aptitude.



Voir aussi

aptitude-create-state-bundle(1), aptitude(8), apt(8)

