GLib = imports.gi.GLib;

Seed.sprintf = function ()
{
    if (typeof arguments == "undefined") { return null; }
    if (arguments.length < 1) { return null; }
    if (typeof arguments[0] != "string") { return null; }
    if (typeof RegExp == "undefined") { return null; }

    var string = arguments[0];
    var exp = new RegExp(/(%([%]|(\-)?(\+|\x20)?(0)?(\d+)?(\.(\d)?)?([bcdfosxX])))/g);
    var matches = new Array();
    var strings = new Array();
    var convCount = 0;
    var stringPosStart = 0;
    var stringPosEnd = 0;
    var matchPosEnd = 0;
    var newString = '';
    var match = null;

    while (match = exp.exec(string)) {
        if (match[9]) { convCount += 1; }

        stringPosStart = matchPosEnd;
        stringPosEnd = exp.lastIndex - match[0].length;
        strings[strings.length] = string.substring(stringPosStart, stringPosEnd);

        matchPosEnd = exp.lastIndex;
        matches[matches.length] = {
            match: match[0],
            left: match[3] ? true : false,
            sign: match[4] || '',
            pad: match[5] || ' ',
            min: match[6] || 0,
            precision: match[8],
            code: match[9] || '%',
            negative: parseInt(arguments[convCount]) < 0 ? true : false,
            argument: String(arguments[convCount])
        };
    }
    strings[strings.length] = string.substring(matchPosEnd);

    if (matches.length == 0) { return string; }
    if ((arguments.length - 1) < convCount) { return null; }

    var code = null;
    var match = null;
    var i = null;

    for (i=0; i<matches.length; i++) {

        if (matches[i].code == '%') { substitution = '%' }
        else if (matches[i].code == 'b') {
            matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(2));
            substitution = Seed.sprintf.convert(matches[i], true);
        }
        else if (matches[i].code == 'c') {
            matches[i].argument = String(String.fromCharCode(parseInt(Math.abs(parseInt(matches[i].argument)))));
            substitution = Seed.sprintf.convert(matches[i], true);
        }
        else if (matches[i].code == 'd') {
            matches[i].argument = String(Math.abs(parseInt(matches[i].argument)));
            substitution = Seed.sprintf.convert(matches[i]);
        }
        else if (matches[i].code == 'f') {
            matches[i].argument = String(Math.abs(parseFloat(matches[i].argument)).toFixed(matches[i].precision ? matches[i].precision : 6));
            substitution = Seed.sprintf.convert(matches[i]);
        }
        else if (matches[i].code == 'o') {
            matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(8));
            substitution = Seed.sprintf.convert(matches[i]);
        }
        else if (matches[i].code == 's') {
            matches[i].argument = matches[i].argument.substring(0, matches[i].precision ? matches[i].precision : matches[i].argument.length)
            substitution = Seed.sprintf.convert(matches[i], true);
        }
        else if (matches[i].code == 'x') {
            matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
            substitution = Seed.sprintf.convert(matches[i]);
        }
        else if (matches[i].code == 'X') {
            matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
            substitution = Seed.sprintf.convert(matches[i]).toUpperCase();
        }
        else {
            substitution = matches[i].match;
        }

        newString += strings[i];
        newString += substitution;

    }
    newString += strings[i];

    return newString;

};

Seed.sprintf.convert = function(match, nosign)
{
    if (nosign) {
        match.sign = '';
    } else {
        match.sign = match.negative ? '-' : match.sign;
    }
    var l = match.min - match.argument.length + 1 - match.sign.length;
    var pad = new Array(l < 0 ? 0 : l).join(match.pad);
    if (!match.left) {
        if (match.pad == "0" || nosign) {
            return match.sign + pad + match.argument;
        } else {
            return pad + match.sign + match.argument;
        }
    } else {
        if (match.pad == "0" || nosign) {
            return match.sign + match.argument + pad.replace(/0/g, ' ');
        } else {
            return match.sign + match.argument + pad;
        }
    }
};


Seed.repl = function()
{
	try
	{
		if(readline)
		{
			// readline is loaded
		}
	}
	catch (e)
	{
		try
		{
			readline = imports.readline;
		}
		catch (e)
		{
			print(e.name + " " + e.message);
			return true;
		}
	}

	try
	{
		item = readline.readline("> ");
		if (item == "continue")
			return false;
		print(eval(item));
	}
	catch (e)
	{
		print(e.name + " " + e.message);
	}
	return true;
}


Seed.glib_repl = function()
{
	GLib.idle_add(Seed.repl, null);
}

Seed.thread_repl = function()
{
	GLib.thread_create_full(function() { while(Seed.repl()){} },
							null, 0, true);
}

Seed.printf = function () { print(Seed.sprintf.apply(this, arguments)) };

if(!imports.searchPath || (imports.searchPath.length == 0))
{
	imports.searchPath = [ "/usr/share/gnome-js",
	                       "/usr/lib/seed",
	                       "/usr/share/seed",
	                       "/usr/local/lib/seed",
	                       "/usr/local/share/seed",
	                       "/usr/lib/seed",
	                       "/usr/share/seed" ];

	if(Seed.argv.length > 1)
	{
		__script_path__ = GLib.path_get_dirname(Seed.argv[1]);
		
		try
		{
		if(!GLib.path_is_absolute(__script_path__))
		{
			__script_path__ = GLib.build_filenamev([GLib.get_current_dir(),
			                                      __script_path__]);
		}
		
		__script_path__ = imports.os.realpath(__script_path__);
		
		if(__script_path__ && __script_path__ != "")
			imports.searchPath.push(__script_path__);
		}
		catch(e)
		{
			print(imports.JSON.stringify(e));
		}
	}

	imports.searchPath.push(".");
}
