/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.NamedWeakReference;
import java.util.List;
import javax.naming.NamingException;

public final class FactoryEnumeration {
    private List factories;
    private int posn = 0;
    private ClassLoader loader;

    FactoryEnumeration(List factories, ClassLoader loader) {
        this.factories = factories;
        this.loader = loader;
    }

    public Object next() throws NamingException {
        List list = this.factories;
        synchronized (list) {
            NamedWeakReference ref = (NamedWeakReference)this.factories.get(this.posn++);
            Object answer = ref.get();
            if (answer != null && !(answer instanceof Class)) {
                return answer;
            }
            String className = ref.getName();
            try {
                if (answer == null) {
                    answer = Class.forName(className, true, this.loader);
                }
                answer = ((Class)answer).newInstance();
                ref = new NamedWeakReference(answer, className);
                this.factories.set(this.posn - 1, ref);
                return answer;
            }
            catch (ClassNotFoundException e) {
                NamingException ne = new NamingException("No longer able to load " + className);
                ne.setRootCause(e);
                throw ne;
            }
            catch (InstantiationException e) {
                NamingException ne = new NamingException("Cannot instantiate " + answer);
                ne.setRootCause(e);
                throw ne;
            }
            catch (IllegalAccessException e) {
                NamingException ne = new NamingException("Cannot access " + answer);
                ne.setRootCause(e);
                throw ne;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMore() {
        List list = this.factories;
        synchronized (list) {
            return this.posn < this.factories.size();
        }
    }
}

